// CheckStyle: start generated
package com.oracle.graal.python.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import java.lang.invoke.VarHandle;

@GeneratedBy(MergedPropertyNames.class)
@SuppressWarnings("javadoc")
final class MergedPropertyNamesGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(MergedPropertyNames.class, new InteropLibraryExports());
    }

    private MergedPropertyNamesGen() {
    }

    @GeneratedBy(MergedPropertyNames.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, MergedPropertyNames.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof MergedPropertyNames;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof MergedPropertyNames;
            return new Cached();
        }

        @GeneratedBy(MergedPropertyNames.class)
        private static final class Cached extends InteropLibrary {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MergedPropertyNames#isArrayElementReadable(MergedPropertyNames, long, InteropLibrary)}
             *   1: SpecializationActive {@link MergedPropertyNames#readArrayElement(MergedPropertyNames, long, InteropLibrary)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link MergedPropertyNames#isArrayElementReadable}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child private InteropLibrary interop;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof MergedPropertyNames) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof MergedPropertyNames;
            }

            @Override
            public boolean hasArrayElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((MergedPropertyNames) receiver)).hasArrayElements();
            }

            @Override
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((MergedPropertyNames) receiver)).getArraySize();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link MergedPropertyNames#isArrayElementReadable(MergedPropertyNames, long, InteropLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                MergedPropertyNames arg0Value = ((MergedPropertyNames) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[MergedPropertyNames.isArrayElementReadable(MergedPropertyNames, long, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            return arg0Value.isArrayElementReadable(arg1Value, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableNode_AndSpecialize(MergedPropertyNames arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                InteropLibrary interop_;
                InteropLibrary interop__shared = this.interop;
                if (interop__shared != null) {
                    interop_ = interop__shared;
                } else {
                    interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    if (interop_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.interop == null) {
                    VarHandle.storeStoreFence();
                    this.interop = interop_;
                }
                state_0 = state_0 | 0b1 /* add SpecializationActive[MergedPropertyNames.isArrayElementReadable(MergedPropertyNames, long, InteropLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.isArrayElementReadable(arg1Value, interop_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link MergedPropertyNames#readArrayElement(MergedPropertyNames, long, InteropLibrary)}
             *     Activation probability: 0.50000
             *     With/without class size: 10/0 bytes
             * </pre>
             */
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                MergedPropertyNames arg0Value = ((MergedPropertyNames) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[MergedPropertyNames.readArrayElement(MergedPropertyNames, long, InteropLibrary)] */) {
                    {
                        InteropLibrary interop_ = this.interop;
                        if (interop_ != null) {
                            return arg0Value.readArrayElement(arg1Value, interop_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(MergedPropertyNames arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                int state_0 = this.state_0_;
                InteropLibrary interop_;
                InteropLibrary interop__shared = this.interop;
                if (interop__shared != null) {
                    interop_ = interop__shared;
                } else {
                    interop_ = this.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    if (interop_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.interop == null) {
                    VarHandle.storeStoreFence();
                    this.interop = interop_;
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[MergedPropertyNames.readArrayElement(MergedPropertyNames, long, InteropLibrary)] */;
                this.state_0_ = state_0;
                return arg0Value.readArrayElement(arg1Value, interop_);
            }

        }
        @GeneratedBy(MergedPropertyNames.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof MergedPropertyNames) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof MergedPropertyNames;
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((MergedPropertyNames) receiver) .hasArrayElements();
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((MergedPropertyNames) receiver) .getArraySize();
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                MergedPropertyNames arg0Value = ((MergedPropertyNames) arg0Value_);
                return arg0Value.isArrayElementReadable(arg1Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                MergedPropertyNames arg0Value = ((MergedPropertyNames) arg0Value_);
                return arg0Value.readArrayElement(arg1Value, (INTEROP_LIBRARY_.getUncached()));
            }

        }
    }
}
