// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.random;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes.GetObjectArrayNode;
import com.oracle.graal.python.builtins.objects.common.SequenceNodesFactory.GetObjectArrayNodeGen;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltins.GetRandBitsNode;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltins.GetStateNode;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltins.RandomNode;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltins.SeedNode;
import com.oracle.graal.python.builtins.objects.random.RandomBuiltins.SetStateNode;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNodeGen;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.List;
import java.util.Objects;

@GeneratedBy(RandomBuiltins.class)
@SuppressWarnings("javadoc")
public final class RandomBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(SeedNodeFactory.getInstance(), SetStateNodeFactory.getInstance(), GetStateNodeFactory.getInstance(), RandomNodeFactory.getInstance(), GetRandBitsNodeFactory.getInstance());
    }

    @GeneratedBy(SeedNode.class)
    public static final class SeedNodeFactory implements NodeFactory<SeedNode> {

        private static final SeedNodeFactory SEED_NODE_FACTORY_INSTANCE = new SeedNodeFactory();

        private SeedNodeFactory() {
        }

        @Override
        public Class<SeedNode> getNodeClass() {
            return SeedNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public SeedNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<SeedNode> getInstance() {
            return SEED_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SeedNode create(ReadArgumentNode[] arguments) {
            return new SeedNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SeedNode#seedNone}
         *     Activation probability: 0.38500
         *     With/without class size: 8/0 bytes
         *   Specialization {@link SeedNode#seedLong}
         *     Activation probability: 0.29500
         *     With/without class size: 7/0 bytes
         *   Specialization {@link SeedNode#seedBigInteger}
         *     Activation probability: 0.20500
         *     With/without class size: 6/0 bytes
         *   Specialization {@link SeedNode#seedGeneric}
         *     Activation probability: 0.11500
         *     With/without class size: 8/18 bytes
         * </pre>
         */
        @GeneratedBy(SeedNode.class)
        @SuppressWarnings("javadoc")
        public static final class SeedNodeGen extends SeedNode {

            private static final StateField SEED_GENERIC__SEED_NODE_SEED_GENERIC_STATE_0_UPDATER = StateField.create(SeedGenericData.lookup_(), "seedGeneric_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SeedNode#seedGeneric}
             *   Parameter: {@link PyObjectHashNode} hash
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre>
             */
            private static final PyObjectHashNode INLINED_SEED_GENERIC_HASH_ = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, SEED_GENERIC__SEED_NODE_SEED_GENERIC_STATE_0_UPDATER.subUpdater(0, 15), ReferenceField.create(SeedGenericData.lookup_(), "seedGeneric_hash__field1_", Node.class), ReferenceField.create(SeedGenericData.lookup_(), "seedGeneric_hash__field2_", Node.class), ReferenceField.create(SeedGenericData.lookup_(), "seedGeneric_hash__field3_", Node.class), ReferenceField.create(SeedGenericData.lookup_(), "seedGeneric_hash__field4_", Node.class)));

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SeedNode#seedNone}
             *   1: SpecializationActive {@link SeedNode#seedLong}
             *   2: SpecializationActive {@link SeedNode#seedBigInteger}
             *   3: SpecializationActive {@link SeedNode#seedGeneric}
             *   4-6: ImplicitCast[type=long, index=1]
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @Child private SeedGenericData seedGeneric_cache;

            private SeedNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state_0 & 0b1111) != 0 /* is SpecializationActive[RandomBuiltins.SeedNode.seedNone(PRandom, PNone)] || SpecializationActive[RandomBuiltins.SeedNode.seedLong(PRandom, long)] || SpecializationActive[RandomBuiltins.SeedNode.seedBigInteger(PRandom, PInt)] || SpecializationActive[RandomBuiltins.SeedNode.seedGeneric(VirtualFrame, PRandom, Object, Node, PyObjectHashNode)] */ && arguments0Value_ instanceof PRandom) {
                    PRandom arguments0Value__ = (PRandom) arguments0Value_;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[RandomBuiltins.SeedNode.seedNone(PRandom, PNone)] */ && arguments1Value_ instanceof PNone) {
                        PNone arguments1Value__ = (PNone) arguments1Value_;
                        return seedNone(arguments0Value__, arguments1Value__);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[RandomBuiltins.SeedNode.seedLong(PRandom, long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=long, index=1] */, arguments1Value_)) {
                        long arguments1Value__ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000) >>> 4 /* get-int ImplicitCast[type=long, index=1] */, arguments1Value_);
                        return SeedNode.seedLong(arguments0Value__, arguments1Value__);
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[RandomBuiltins.SeedNode.seedBigInteger(PRandom, PInt)] */ && arguments1Value_ instanceof PInt) {
                        PInt arguments1Value__ = (PInt) arguments1Value_;
                        return SeedNode.seedBigInteger(arguments0Value__, arguments1Value__);
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[RandomBuiltins.SeedNode.seedGeneric(VirtualFrame, PRandom, Object, Node, PyObjectHashNode)] */) {
                        SeedGenericData s3_ = this.seedGeneric_cache;
                        if (s3_ != null) {
                            if ((!(PGuards.canBeInteger(arguments1Value_))) && (!(PGuards.isPNone(arguments1Value_)))) {
                                Node inliningTarget__ = (s3_);
                                return SeedNode.seedGeneric(frameValue, arguments0Value__, arguments1Value_, inliningTarget__, INLINED_SEED_GENERIC_HASH_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_);
            }

            private PNone executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PRandom) {
                    PRandom arguments0Value_ = (PRandom) arguments0Value;
                    if (arguments1Value instanceof PNone) {
                        PNone arguments1Value_ = (PNone) arguments1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[RandomBuiltins.SeedNode.seedNone(PRandom, PNone)] */;
                        this.state_0_ = state_0;
                        return seedNone(arguments0Value_, arguments1Value_);
                    }
                    {
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arguments1Value)) != 0) {
                            long arguments1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arguments1Value);
                            state_0 = (state_0 | (longCast1 << 4) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[RandomBuiltins.SeedNode.seedLong(PRandom, long)] */;
                            this.state_0_ = state_0;
                            return SeedNode.seedLong(arguments0Value_, arguments1Value_);
                        }
                    }
                    if (arguments1Value instanceof PInt) {
                        PInt arguments1Value_ = (PInt) arguments1Value;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[RandomBuiltins.SeedNode.seedBigInteger(PRandom, PInt)] */;
                        this.state_0_ = state_0;
                        return SeedNode.seedBigInteger(arguments0Value_, arguments1Value_);
                    }
                    {
                        Node inliningTarget__ = null;
                        if ((!(PGuards.canBeInteger(arguments1Value))) && (!(PGuards.isPNone(arguments1Value)))) {
                            SeedGenericData s3_ = this.insert(new SeedGenericData());
                            inliningTarget__ = (s3_);
                            VarHandle.storeStoreFence();
                            this.seedGeneric_cache = s3_;
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[RandomBuiltins.SeedNode.seedGeneric(VirtualFrame, PRandom, Object, Node, PyObjectHashNode)] */;
                            this.state_0_ = state_0;
                            return SeedNode.seedGeneric(frameValue, arguments0Value_, arguments1Value, inliningTarget__, INLINED_SEED_GENERIC_HASH_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }

            @GeneratedBy(SeedNode.class)
            @DenyReplace
            private static final class SeedGenericData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-14: InlinedCache
                 *        Specialization: {@link SeedNode#seedGeneric}
                 *        Parameter: {@link PyObjectHashNode} hash
                 *        Inline method: {@link PyObjectHashNodeGen#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int seedGeneric_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SeedNode#seedGeneric}
                 *   Parameter: {@link PyObjectHashNode} hash
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node seedGeneric_hash__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SeedNode#seedGeneric}
                 *   Parameter: {@link PyObjectHashNode} hash
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node seedGeneric_hash__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SeedNode#seedGeneric}
                 *   Parameter: {@link PyObjectHashNode} hash
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node seedGeneric_hash__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link SeedNode#seedGeneric}
                 *   Parameter: {@link PyObjectHashNode} hash
                 *   Inline method: {@link PyObjectHashNodeGen#inline}
                 *   Inline field: {@link Node} field4</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node seedGeneric_hash__field4_;

                SeedGenericData() {
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(SetStateNode.class)
    public static final class SetStateNodeFactory implements NodeFactory<SetStateNode> {

        private static final SetStateNodeFactory SET_STATE_NODE_FACTORY_INSTANCE = new SetStateNodeFactory();

        private SetStateNodeFactory() {
        }

        @Override
        public Class<SetStateNode> getNodeClass() {
            return SetStateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public SetStateNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<SetStateNode> getInstance() {
            return SET_STATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SetStateNode create(ReadArgumentNode[] arguments) {
            return new SetStateNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
         *     Activation probability: 0.65000
         *     With/without class size: 35/29 bytes
         *   Specialization {@link SetStateNode#setstate(Object, Object, PRaiseNode)}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre>
         */
        @GeneratedBy(SetStateNode.class)
        @SuppressWarnings("javadoc")
        public static final class SetStateNodeGen extends SetStateNode {

            private static final StateField STATE_1_SetStateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            private static final StateField STATE_0_SetStateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link GetObjectArrayNode} getObjectArrayNode
             *   Inline method: {@link GetObjectArrayNodeGen#inline}</pre>
             */
            private static final GetObjectArrayNode INLINED_SETSTATE_GET_OBJECT_ARRAY_NODE_ = GetObjectArrayNodeGen.inline(InlineTarget.create(GetObjectArrayNode.class, STATE_1_SetStateNode_UPDATER.subUpdater(0, 31), ReferenceField.create(MethodHandles.lookup(), "setstate_getObjectArrayNode__field1_", Object.class), ReferenceField.create(MethodHandles.lookup(), "setstate_getObjectArrayNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "setstate_getObjectArrayNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "setstate_getObjectArrayNode__field4_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link CastToJavaUnsignedLongNode} castNode
             *   Inline method: {@link CastToJavaUnsignedLongNodeGen#inline}</pre>
             */
            private static final CastToJavaUnsignedLongNode INLINED_SETSTATE_CAST_NODE_ = CastToJavaUnsignedLongNodeGen.inline(InlineTarget.create(CastToJavaUnsignedLongNode.class, STATE_0_SetStateNode_UPDATER.subUpdater(2, 7), ReferenceField.create(MethodHandles.lookup(), "setstate_castNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_SETSTATE_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_SetStateNode_UPDATER.subUpdater(9, 1), ReferenceField.create(MethodHandles.lookup(), "setstate_raiseNode__field1_", Node.class)));

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   1: SpecializationActive {@link SetStateNode#setstate(Object, Object, PRaiseNode)}
             *   2-8: InlinedCache
             *        Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *        Parameter: {@link CastToJavaUnsignedLongNode} castNode
             *        Inline method: {@link CastToJavaUnsignedLongNodeGen#inline}
             *   9: InlinedCache
             *        Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-30: InlinedCache
             *        Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *        Parameter: {@link GetObjectArrayNode} getObjectArrayNode
             *        Inline method: {@link GetObjectArrayNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link GetObjectArrayNode} getObjectArrayNode
             *   Inline method: {@link GetObjectArrayNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object setstate_getObjectArrayNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link GetObjectArrayNode} getObjectArrayNode
             *   Inline method: {@link GetObjectArrayNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node setstate_getObjectArrayNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link GetObjectArrayNode} getObjectArrayNode
             *   Inline method: {@link GetObjectArrayNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node setstate_getObjectArrayNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link GetObjectArrayNode} getObjectArrayNode
             *   Inline method: {@link GetObjectArrayNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node setstate_getObjectArrayNode__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link CastToJavaUnsignedLongNode} castNode
             *   Inline method: {@link CastToJavaUnsignedLongNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node setstate_castNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node setstate_raiseNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setstate(Object, Object, PRaiseNode)}
             *   Parameter: {@link PRaiseNode} raiseNode</pre>
             */
            @Child private PRaiseNode fallback_raiseNode_;

            private SetStateNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arguments0Value, Object arguments1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[RandomBuiltins.SetStateNode.setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)] */) && arguments0Value instanceof PRandom && arguments1Value instanceof PTuple) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[RandomBuiltins.SetStateNode.setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)] || SpecializationActive[RandomBuiltins.SetStateNode.setstate(Object, Object, PRaiseNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[RandomBuiltins.SetStateNode.setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)] */ && arguments0Value_ instanceof PRandom) {
                        PRandom arguments0Value__ = (PRandom) arguments0Value_;
                        if (arguments1Value_ instanceof PTuple) {
                            PTuple arguments1Value__ = (PTuple) arguments1Value_;
                            {
                                Node inliningTarget__ = (this);
                                return SetStateNode.setstate(arguments0Value__, arguments1Value__, inliningTarget__, INLINED_SETSTATE_GET_OBJECT_ARRAY_NODE_, INLINED_SETSTATE_CAST_NODE_, INLINED_SETSTATE_RAISE_NODE_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[RandomBuiltins.SetStateNode.setstate(Object, Object, PRaiseNode)] */) {
                        {
                            PRaiseNode raiseNode__ = this.fallback_raiseNode_;
                            if (raiseNode__ != null) {
                                if (fallbackGuard_(state_0, arguments0Value_, arguments1Value_)) {
                                    return SetStateNode.setstate(arguments0Value_, arguments1Value_, raiseNode__);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_, arguments1Value_);
            }

            private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arguments0Value instanceof PRandom) {
                        PRandom arguments0Value_ = (PRandom) arguments0Value;
                        if (arguments1Value instanceof PTuple) {
                            PTuple arguments1Value_ = (PTuple) arguments1Value;
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[RandomBuiltins.SetStateNode.setstate(PRandom, PTuple, Node, GetObjectArrayNode, CastToJavaUnsignedLongNode, Lazy)] */;
                            this.state_0_ = state_0;
                            return SetStateNode.setstate(arguments0Value_, arguments1Value_, inliningTarget__, INLINED_SETSTATE_GET_OBJECT_ARRAY_NODE_, INLINED_SETSTATE_CAST_NODE_, INLINED_SETSTATE_RAISE_NODE_);
                        }
                    }
                }
                PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_raiseNode_ = raiseNode__;
                state_0 = state_0 | 0b10 /* add SpecializationActive[RandomBuiltins.SetStateNode.setstate(Object, Object, PRaiseNode)] */;
                this.state_0_ = state_0;
                return SetStateNode.setstate(arguments0Value, arguments1Value, raiseNode__);
            }

        }
    }
    @GeneratedBy(GetStateNode.class)
    public static final class GetStateNodeFactory implements NodeFactory<GetStateNode> {

        private static final GetStateNodeFactory GET_STATE_NODE_FACTORY_INSTANCE = new GetStateNodeFactory();

        private GetStateNodeFactory() {
        }

        @Override
        public Class<GetStateNode> getNodeClass() {
            return GetStateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public GetStateNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetStateNode> getInstance() {
            return GET_STATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetStateNode create(ReadArgumentNode[] arguments) {
            return new GetStateNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetStateNode#getstate}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(GetStateNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetStateNodeGen extends GetStateNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetStateNode#getstate}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetStateNode#getstate}
             *   Parameter: {@link PythonObjectFactory} factory</pre>
             */
            @Child private PythonObjectFactory factory_;

            private GetStateNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[RandomBuiltins.GetStateNode.getstate(PRandom, PythonObjectFactory)] */ && arguments0Value_ instanceof PRandom) {
                    PRandom arguments0Value__ = (PRandom) arguments0Value_;
                    {
                        PythonObjectFactory factory__ = this.factory_;
                        if (factory__ != null) {
                            return GetStateNode.getstate(arguments0Value__, factory__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private PTuple executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PRandom) {
                    PRandom arguments0Value_ = (PRandom) arguments0Value;
                    PythonObjectFactory factory__ = this.insert((PythonObjectFactory.create()));
                    Objects.requireNonNull(factory__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.factory_ = factory__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[RandomBuiltins.GetStateNode.getstate(PRandom, PythonObjectFactory)] */;
                    this.state_0_ = state_0;
                    return GetStateNode.getstate(arguments0Value_, factory__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(RandomNode.class)
    public static final class RandomNodeFactory implements NodeFactory<RandomNode> {

        private static final RandomNodeFactory RANDOM_NODE_FACTORY_INSTANCE = new RandomNodeFactory();

        private RandomNodeFactory() {
        }

        @Override
        public Class<RandomNode> getNodeClass() {
            return RandomNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        @Override
        public RandomNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<RandomNode> getInstance() {
            return RANDOM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RandomNode create(ReadArgumentNode[] arguments) {
            return new RandomNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RandomNode#random}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(RandomNode.class)
        @SuppressWarnings("javadoc")
        public static final class RandomNodeGen extends RandomNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RandomNode#random}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private RandomNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[RandomBuiltins.RandomNode.random(PRandom)] */ && arguments0Value_ instanceof PRandom) {
                    PRandom arguments0Value__ = (PRandom) arguments0Value_;
                    return random(arguments0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private double executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PRandom) {
                    PRandom arguments0Value_ = (PRandom) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[RandomBuiltins.RandomNode.random(PRandom)] */;
                    this.state_0_ = state_0;
                    return random(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

        }
    }
    @GeneratedBy(GetRandBitsNode.class)
    public static final class GetRandBitsNodeFactory implements NodeFactory<GetRandBitsNode> {

        private static final GetRandBitsNodeFactory GET_RAND_BITS_NODE_FACTORY_INSTANCE = new GetRandBitsNodeFactory();

        private GetRandBitsNodeFactory() {
        }

        @Override
        public Class<GetRandBitsNode> getNodeClass() {
            return GetRandBitsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetRandBitsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<GetRandBitsNode> getInstance() {
            return GET_RAND_BITS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetRandBitsNode create() {
            return new GetRandBitsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetRandBitsNode#negative}
         *     Activation probability: 0.27381
         *     With/without class size: 9/4 bytes
         *   Specialization {@link GetRandBitsNode#zero}
         *     Activation probability: 0.23095
         *     With/without class size: 6/0 bytes
         *   Specialization {@link GetRandBitsNode#genInt}
         *     Activation probability: 0.18810
         *     With/without class size: 6/0 bytes
         *   Specialization {@link GetRandBitsNode#gen32Bits}
         *     Activation probability: 0.14524
         *     With/without class size: 5/0 bytes
         *   Specialization {@link GetRandBitsNode#genLong}
         *     Activation probability: 0.10238
         *     With/without class size: 5/0 bytes
         *   Specialization {@link GetRandBitsNode#genBigInteger}
         *     Activation probability: 0.05952
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(GetRandBitsNode.class)
        @SuppressWarnings("javadoc")
        public static final class GetRandBitsNodeGen extends GetRandBitsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetRandBitsNode#negative}
             *   1: SpecializationActive {@link GetRandBitsNode#zero}
             *   2: SpecializationActive {@link GetRandBitsNode#genInt}
             *   3: SpecializationActive {@link GetRandBitsNode#gen32Bits}
             *   4: SpecializationActive {@link GetRandBitsNode#genLong}
             *   5: SpecializationActive {@link GetRandBitsNode#genBigInteger}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetRandBitsNode#negative}
             *   Parameter: {@link PRaiseNode} raiseNode</pre>
             */
            @Child private PRaiseNode negative_raiseNode_;

            private GetRandBitsNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.negative(PRandom, int, PRaiseNode)] || SpecializationActive[RandomBuiltins.GetRandBitsNode.zero(PRandom, int)] || SpecializationActive[RandomBuiltins.GetRandBitsNode.genInt(PRandom, int)] || SpecializationActive[RandomBuiltins.GetRandBitsNode.gen32Bits(PRandom, int)] || SpecializationActive[RandomBuiltins.GetRandBitsNode.genLong(PRandom, int)] || SpecializationActive[RandomBuiltins.GetRandBitsNode.genBigInteger(PRandom, int)] */ && arg0Value instanceof PRandom) {
                    PRandom arg0Value_ = (PRandom) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.negative(PRandom, int, PRaiseNode)] */) {
                            {
                                PRaiseNode raiseNode__ = this.negative_raiseNode_;
                                if (raiseNode__ != null) {
                                    if ((arg1Value_ < 0)) {
                                        return GetRandBitsNode.negative(arg0Value_, arg1Value_, raiseNode__);
                                    }
                                }
                            }
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.zero(PRandom, int)] */) {
                            if ((arg1Value_ == 0)) {
                                return GetRandBitsNode.zero(arg0Value_, arg1Value_);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.genInt(PRandom, int)] */) {
                            if ((arg1Value_ >= 1) && (arg1Value_ <= 31)) {
                                return GetRandBitsNode.genInt(arg0Value_, arg1Value_);
                            }
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.gen32Bits(PRandom, int)] */) {
                            if ((arg1Value_ == 32)) {
                                return GetRandBitsNode.gen32Bits(arg0Value_, arg1Value_);
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.genLong(PRandom, int)] */) {
                            if ((arg1Value_ >= 33) && (arg1Value_ <= 63)) {
                                return GetRandBitsNode.genLong(arg0Value_, arg1Value_);
                            }
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[RandomBuiltins.GetRandBitsNode.genBigInteger(PRandom, int)] */) {
                            if ((arg1Value_ >= 64)) {
                                return GetRandBitsNode.genBigInteger(arg0Value_, arg1Value_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PRandom) {
                    PRandom arg0Value_ = (PRandom) arg0Value;
                    if (arg1Value instanceof Integer) {
                        int arg1Value_ = (int) arg1Value;
                        if ((arg1Value_ < 0)) {
                            PRaiseNode raiseNode__ = this.insert((PRaiseNode.create()));
                            Objects.requireNonNull(raiseNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            VarHandle.storeStoreFence();
                            this.negative_raiseNode_ = raiseNode__;
                            state_0 = state_0 | 0b1 /* add SpecializationActive[RandomBuiltins.GetRandBitsNode.negative(PRandom, int, PRaiseNode)] */;
                            this.state_0_ = state_0;
                            return GetRandBitsNode.negative(arg0Value_, arg1Value_, raiseNode__);
                        }
                        if ((arg1Value_ == 0)) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[RandomBuiltins.GetRandBitsNode.zero(PRandom, int)] */;
                            this.state_0_ = state_0;
                            return GetRandBitsNode.zero(arg0Value_, arg1Value_);
                        }
                        if ((arg1Value_ >= 1) && (arg1Value_ <= 31)) {
                            state_0 = state_0 | 0b100 /* add SpecializationActive[RandomBuiltins.GetRandBitsNode.genInt(PRandom, int)] */;
                            this.state_0_ = state_0;
                            return GetRandBitsNode.genInt(arg0Value_, arg1Value_);
                        }
                        if ((arg1Value_ == 32)) {
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[RandomBuiltins.GetRandBitsNode.gen32Bits(PRandom, int)] */;
                            this.state_0_ = state_0;
                            return GetRandBitsNode.gen32Bits(arg0Value_, arg1Value_);
                        }
                        if ((arg1Value_ >= 33) && (arg1Value_ <= 63)) {
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[RandomBuiltins.GetRandBitsNode.genLong(PRandom, int)] */;
                            this.state_0_ = state_0;
                            return GetRandBitsNode.genLong(arg0Value_, arg1Value_);
                        }
                        if ((arg1Value_ >= 64)) {
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[RandomBuiltins.GetRandBitsNode.genBigInteger(PRandom, int)] */;
                            this.state_0_ = state_0;
                            return GetRandBitsNode.genBigInteger(arg0Value_, arg1Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
            }

        }
    }
}
