// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.modules.OperatorModuleBuiltins.CompareDigestNode;
import com.oracle.graal.python.builtins.modules.OperatorModuleBuiltins.GetItemNode;
import com.oracle.graal.python.builtins.modules.OperatorModuleBuiltins.IndexNode;
import com.oracle.graal.python.builtins.modules.OperatorModuleBuiltins.TruthNode;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyNumberIndexNodeGen;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetItemNodeGen;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNodeGen;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNodeGen;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(OperatorModuleBuiltins.class)
@SuppressWarnings("javadoc")
public final class OperatorModuleBuiltinsFactory {

    private static final LibraryFactory<PythonBufferAcquireLibrary> PYTHON_BUFFER_ACQUIRE_LIBRARY_ = LibraryFactory.resolve(PythonBufferAcquireLibrary.class);
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(TruthNodeFactory.getInstance(), GetItemNodeFactory.getInstance(), CompareDigestNodeFactory.getInstance(), IndexNodeFactory.getInstance());
    }

    @GeneratedBy(TruthNode.class)
    static final class TruthNodeFactory implements NodeFactory<TruthNode> {

        private static final TruthNodeFactory TRUTH_NODE_FACTORY_INSTANCE = new TruthNodeFactory();

        private TruthNodeFactory() {
        }

        @Override
        public Class<TruthNode> getNodeClass() {
            return TruthNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public TruthNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<TruthNode> getInstance() {
            return TRUTH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static TruthNode create() {
            return new TruthNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link TruthNode#doObject}
         *     Activation probability: 1.00000
         *     With/without class size: 36/14 bytes
         * </pre>
         */
        @GeneratedBy(TruthNode.class)
        @SuppressWarnings("javadoc")
        static final class TruthNodeGen extends TruthNode {

            private static final StateField STATE_0_TruthNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link TruthNode#doObject}
             *   Parameter: {@link PyObjectIsTrueNode} isTrueNode
             *   Inline method: {@link PyObjectIsTrueNodeGen#inline}</pre>
             */
            private static final PyObjectIsTrueNode INLINED_IS_TRUE_NODE_ = PyObjectIsTrueNodeGen.inline(InlineTarget.create(PyObjectIsTrueNode.class, STATE_0_TruthNode_UPDATER.subUpdater(0, 15), ReferenceField.create(MethodHandles.lookup(), "isTrueNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "isTrueNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "isTrueNode__field3_", Node.class)));

            /**
             * State Info: <pre>
             *   0-14: InlinedCache
             *        Specialization: {@link TruthNode#doObject}
             *        Parameter: {@link PyObjectIsTrueNode} isTrueNode
             *        Inline method: {@link PyObjectIsTrueNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TruthNode#doObject}
             *   Parameter: {@link PyObjectIsTrueNode} isTrueNode
             *   Inline method: {@link PyObjectIsTrueNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node isTrueNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TruthNode#doObject}
             *   Parameter: {@link PyObjectIsTrueNode} isTrueNode
             *   Inline method: {@link PyObjectIsTrueNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node isTrueNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link TruthNode#doObject}
             *   Parameter: {@link PyObjectIsTrueNode} isTrueNode
             *   Inline method: {@link PyObjectIsTrueNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node isTrueNode__field3_;

            private TruthNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return TruthNode.doObject(frameValue, arg0Value, inliningTarget__, INLINED_IS_TRUE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(GetItemNode.class)
    static final class GetItemNodeFactory implements NodeFactory<GetItemNode> {

        private static final GetItemNodeFactory GET_ITEM_NODE_FACTORY_INSTANCE = new GetItemNodeFactory();

        private GetItemNodeFactory() {
        }

        @Override
        public Class<GetItemNode> getNodeClass() {
            return GetItemNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public GetItemNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetItemNode> getInstance() {
            return GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetItemNode create() {
            return new GetItemNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetItemNode#doObject}
         *     Activation probability: 1.00000
         *     With/without class size: 40/17 bytes
         * </pre>
         */
        @GeneratedBy(GetItemNode.class)
        @SuppressWarnings("javadoc")
        static final class GetItemNodeGen extends GetItemNode {

            private static final StateField STATE_0_GetItemNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetItemNode#doObject}
             *   Parameter: {@link PyObjectGetItem} getItem
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}</pre>
             */
            private static final PyObjectGetItem INLINED_GET_ITEM_ = PyObjectGetItemNodeGen.inline(InlineTarget.create(PyObjectGetItem.class, STATE_0_GetItemNode_UPDATER.subUpdater(0, 4), ReferenceField.create(MethodHandles.lookup(), "getItem__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItem__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItem__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getItem__field4_", Node.class)));

            /**
             * State Info: <pre>
             *   0-3: InlinedCache
             *        Specialization: {@link GetItemNode#doObject}
             *        Parameter: {@link PyObjectGetItem} getItem
             *        Inline method: {@link PyObjectGetItemNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetItemNode#doObject}
             *   Parameter: {@link PyObjectGetItem} getItem
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetItemNode#doObject}
             *   Parameter: {@link PyObjectGetItem} getItem
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetItemNode#doObject}
             *   Parameter: {@link PyObjectGetItem} getItem
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetItemNode#doObject}
             *   Parameter: {@link PyObjectGetItem} getItem
             *   Inline method: {@link PyObjectGetItemNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field4_;

            private GetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                {
                    Node inliningTarget__ = (this);
                    return GetItemNode.doObject(frameValue, arg0Value, arg1Value, inliningTarget__, INLINED_GET_ITEM_);
                }
            }

        }
    }
    @GeneratedBy(CompareDigestNode.class)
    static final class CompareDigestNodeFactory implements NodeFactory<CompareDigestNode> {

        private static final CompareDigestNodeFactory COMPARE_DIGEST_NODE_FACTORY_INSTANCE = new CompareDigestNodeFactory();

        private CompareDigestNodeFactory() {
        }

        @Override
        public Class<CompareDigestNode> getNodeClass() {
            return CompareDigestNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public CompareDigestNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<CompareDigestNode> getInstance() {
            return COMPARE_DIGEST_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static CompareDigestNode create() {
            return new CompareDigestNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link CompareDigestNode#compare}
         *     Activation probability: 1.00000
         *     With/without class size: 44/21 bytes
         * </pre>
         */
        @GeneratedBy(CompareDigestNode.class)
        @SuppressWarnings("javadoc")
        static final class CompareDigestNodeGen extends CompareDigestNode {

            private static final StateField STATE_0_CompareDigestNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link CompareDigestNode#compare}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}</pre>
             */
            private static final Lazy INLINED_RAISE_NODE_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, STATE_0_CompareDigestNode_UPDATER.subUpdater(1, 1), ReferenceField.create(MethodHandles.lookup(), "raiseNode__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link CompareDigestNode#compare}
             *   1: InlinedCache
             *        Specialization: {@link CompareDigestNode#compare}
             *        Parameter: {@link Lazy} raiseNode
             *        Inline method: {@link LazyNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CompareDigestNode#compare}
             *   Parameter: {@link IndirectCallData} indirectCallData</pre>
             */
            @CompilationFinal private IndirectCallData indirectCallData_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CompareDigestNode#compare}
             *   Parameter: {@link CastToJavaStringNode} cast</pre>
             */
            @Child private CastToJavaStringNode cast_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CompareDigestNode#compare}
             *   Parameter: {@link PythonBufferAcquireLibrary} bufferAcquireLib</pre>
             */
            @Child private PythonBufferAcquireLibrary bufferAcquireLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CompareDigestNode#compare}
             *   Parameter: {@link PythonBufferAccessLibrary} bufferLib</pre>
             */
            @Child private PythonBufferAccessLibrary bufferLib_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link CompareDigestNode#compare}
             *   Parameter: {@link Lazy} raiseNode
             *   Inline method: {@link LazyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node raiseNode__field1_;

            private CompareDigestNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[OperatorModuleBuiltins.CompareDigestNode.compare(VirtualFrame, Object, Object, Node, IndirectCallData, CastToJavaStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, Lazy)] */) {
                    {
                        IndirectCallData indirectCallData__ = this.indirectCallData_;
                        if (indirectCallData__ != null) {
                            CastToJavaStringNode cast__ = this.cast_;
                            if (cast__ != null) {
                                PythonBufferAcquireLibrary bufferAcquireLib__ = this.bufferAcquireLib_;
                                if (bufferAcquireLib__ != null) {
                                    PythonBufferAccessLibrary bufferLib__ = this.bufferLib_;
                                    if (bufferLib__ != null) {
                                        Node inliningTarget__ = (this);
                                        return CompareDigestNode.compare(frameValue, arg0Value, arg1Value, inliningTarget__, indirectCallData__, cast__, bufferAcquireLib__, bufferLib__, INLINED_RAISE_NODE_);
                                    }
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    inliningTarget__ = (this);
                    IndirectCallData indirectCallData__ = (IndirectCallData.createFor(this));
                    Objects.requireNonNull(indirectCallData__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.indirectCallData_ = indirectCallData__;
                    CastToJavaStringNode cast__ = this.insert((CastToJavaStringNodeGen.create()));
                    Objects.requireNonNull(cast__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.cast_ = cast__;
                    PythonBufferAcquireLibrary bufferAcquireLib__ = this.insert((PYTHON_BUFFER_ACQUIRE_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(bufferAcquireLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.bufferAcquireLib_ = bufferAcquireLib__;
                    PythonBufferAccessLibrary bufferLib__ = this.insert((PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.bufferLib_ = bufferLib__;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[OperatorModuleBuiltins.CompareDigestNode.compare(VirtualFrame, Object, Object, Node, IndirectCallData, CastToJavaStringNode, PythonBufferAcquireLibrary, PythonBufferAccessLibrary, Lazy)] */;
                    this.state_0_ = state_0;
                    return CompareDigestNode.compare(frameValue, arg0Value, arg1Value, inliningTarget__, indirectCallData__, cast__, bufferAcquireLib__, bufferLib__, INLINED_RAISE_NODE_);
                }
            }

        }
    }
    @GeneratedBy(IndexNode.class)
    static final class IndexNodeFactory implements NodeFactory<IndexNode> {

        private static final IndexNodeFactory INDEX_NODE_FACTORY_INSTANCE = new IndexNodeFactory();

        private IndexNodeFactory() {
        }

        @Override
        public Class<IndexNode> getNodeClass() {
            return IndexNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        @Override
        public IndexNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<IndexNode> getInstance() {
            return INDEX_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IndexNode create() {
            return new IndexNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IndexNode#asIndex}
         *     Activation probability: 1.00000
         *     With/without class size: 44/21 bytes
         * </pre>
         */
        @GeneratedBy(IndexNode.class)
        @SuppressWarnings("javadoc")
        static final class IndexNodeGen extends IndexNode {

            private static final StateField STATE_0_IndexNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#asIndex}
             *   Parameter: {@link PyNumberIndexNode} index
             *   Inline method: {@link PyNumberIndexNodeGen#inline}</pre>
             */
            private static final PyNumberIndexNode INLINED_INDEX_ = PyNumberIndexNodeGen.inline(InlineTarget.create(PyNumberIndexNode.class, STATE_0_IndexNode_UPDATER.subUpdater(0, 6), ReferenceField.create(MethodHandles.lookup(), "index__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "index__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "index__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "index__field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "index__field5_", Node.class)));

            /**
             * State Info: <pre>
             *   0-5: InlinedCache
             *        Specialization: {@link IndexNode#asIndex}
             *        Parameter: {@link PyNumberIndexNode} index
             *        Inline method: {@link PyNumberIndexNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#asIndex}
             *   Parameter: {@link PyNumberIndexNode} index
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node index__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#asIndex}
             *   Parameter: {@link PyNumberIndexNode} index
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node index__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#asIndex}
             *   Parameter: {@link PyNumberIndexNode} index
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node index__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#asIndex}
             *   Parameter: {@link PyNumberIndexNode} index
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node index__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IndexNode#asIndex}
             *   Parameter: {@link PyNumberIndexNode} index
             *   Inline method: {@link PyNumberIndexNodeGen#inline}
             *   Inline field: {@link Node} field5</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node index__field5_;

            private IndexNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                {
                    Node inliningTarget__ = (this);
                    return IndexNode.asIndex(frameValue, arg0Value, inliningTarget__, INLINED_INDEX_);
                }
            }

        }
    }
}
