/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.ArrayBasedSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;

public final class BoolSequenceStorage
extends ArrayBasedSequenceStorage {
    private boolean[] values;

    public BoolSequenceStorage() {
        this.values = new boolean[0];
    }

    public BoolSequenceStorage(boolean[] elements) {
        this(elements, elements.length);
    }

    public BoolSequenceStorage(boolean[] elements, int length) {
        this.values = elements;
        this.capacity = this.values.length;
        this.length = length;
    }

    public BoolSequenceStorage(int capacity) {
        this.values = new boolean[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    private void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    public void ensureCapacity(int newCapacity) throws ArithmeticException {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (newCapacity > this.capacity ? 1 : 0) != 0)) {
            this.increaseCapacityExactWithCopy(BoolSequenceStorage.capacityFor(newCapacity));
        }
    }

    @Override
    public BoolSequenceStorage createEmpty(int newLength) {
        return new BoolSequenceStorage(newLength);
    }

    public void insertBoolItem(int idx, boolean value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = value;
        ++this.length;
    }

    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                boolean temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    public boolean[] getInternalBoolArray() {
        return this.values;
    }

    public boolean getBoolItemNormalized(int idx) {
        return this.values[idx];
    }

    public void setBoolItemNormalized(int idx, boolean value) {
        this.values[idx] = value;
    }

    @Override
    public Object getIndicativeValue() {
        return false;
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    public Object[] getCopyOfInternalArray() {
        Object[] boxed = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            boxed[i] = this.values[i];
        }
        return boxed;
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (boolean[])arrayObject;
    }

    @Override
    public SequenceStorage.StorageType getElementType() {
        return SequenceStorage.StorageType.Boolean;
    }
}

