/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.exception;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class, delegateTo="pythonException")
public final class PException
extends AbstractTruffleException {
    private static final long serialVersionUID = -6437116280384996361L;
    public static final PException NO_EXCEPTION = new PException(null, null);
    private String message = null;
    final transient Object pythonException;
    private transient PFrame.Reference frameInfo;
    private transient PBytecodeRootNode catchRootNode;
    private int catchBci;
    private boolean reified = false;
    private boolean skipFirstTracebackFrame;
    private int tracebackFrameCount;

    private PException(Object pythonException, Node node) {
        super(node);
        this.pythonException = pythonException;
    }

    private PException(Object pythonException, Node node, Throwable wrapped) {
        super(null, wrapped, -1, node);
        this.pythonException = pythonException;
        assert (PyExceptionInstanceCheckNode.executeUncached(pythonException));
    }

    public static PException fromObject(Object pythonException, Node node, boolean withJavaStacktrace) {
        RuntimeException wrapped = null;
        if (withJavaStacktrace) {
            wrapped = PException.createStacktraceCarrier();
        }
        return PException.fromObject(pythonException, node, wrapped);
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException createStacktraceCarrier() {
        return new RuntimeException();
    }

    public static PException fromObject(Object pythonException, Node node, Throwable wrapped) {
        PException pException = new PException(pythonException, node, wrapped);
        if (pythonException instanceof PBaseException) {
            PBaseException managedException = (PBaseException)pythonException;
            managedException.setException(pException);
        }
        return pException;
    }

    public static PException fromExceptionInfo(Object pythonException, boolean withJavaStacktrace) {
        RuntimeException wrapped = null;
        if (withJavaStacktrace) {
            wrapped = PException.createStacktraceCarrier();
        }
        PException pException = new PException(pythonException, null, wrapped);
        pException.reified = true;
        if (pythonException instanceof PBaseException) {
            PBaseException managedException = (PBaseException)pythonException;
            managedException.setException(pException);
        }
        return pException;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = this.pythonException.toString();
        }
        return this.message;
    }

    public void setMessage(Object object) {
        this.message = object.toString();
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        if (this == NO_EXCEPTION) {
            return "NO_EXCEPTION";
        }
        return this.getMessage();
    }

    public int getTracebackStartIndex() {
        return this.skipFirstTracebackFrame ? 1 : 0;
    }

    public void skipFirstTracebackFrame() {
        this.skipFirstTracebackFrame = true;
        this.tracebackFrameCount = -1;
    }

    public boolean catchingFrameWantedForTraceback() {
        return this.tracebackFrameCount >= 0 && this.catchRootNode != null && this.catchRootNode.frameIsVisibleToPython();
    }

    public PBytecodeRootNode getCatchRootNode() {
        return this.catchRootNode;
    }

    public int getCatchBci() {
        return this.catchBci;
    }

    public Object getUnreifiedException() {
        return this.pythonException;
    }

    public void expectUncached(PythonBuiltinClassType error) {
        if (!BuiltinClassProfiles.IsBuiltinObjectProfile.profileObjectUncached(this.getUnreifiedException(), error)) {
            throw this;
        }
    }

    public void expectCached(PythonBuiltinClassType error, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        this.expect(profile, error, profile);
    }

    public void expectIndexError(Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        this.expect(inliningTarget, PythonBuiltinClassType.IndexError, profile);
    }

    public void expectStopIteration(Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        this.expect(inliningTarget, PythonBuiltinClassType.StopIteration, profile);
    }

    public void expectAttributeError(Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        this.expect(inliningTarget, PythonBuiltinClassType.AttributeError, profile);
    }

    public boolean expectTypeOrOverflowError(Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        boolean ofError;
        boolean bl = ofError = !profile.profileException(inliningTarget, this, PythonBuiltinClassType.TypeError);
        if (ofError && !profile.profileException(inliningTarget, this, PythonBuiltinClassType.OverflowError)) {
            throw this;
        }
        return ofError;
    }

    public void expectOverflowError(Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        this.expect(inliningTarget, PythonBuiltinClassType.OverflowError, profile);
    }

    public void expectTypeError(Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        this.expect(inliningTarget, PythonBuiltinClassType.TypeError, profile);
    }

    public void expect(Node inliningTarget, PythonBuiltinClassType error, BuiltinClassProfiles.IsBuiltinObjectProfile profile) {
        if (!profile.profileException(inliningTarget, this, error)) {
            throw this;
        }
    }

    public void setCatchingFrameReference(Frame frame, PBytecodeRootNode catchLocation, int catchBci) {
        this.frameInfo = PArguments.getCurrentFrameInfo(frame);
        this.catchRootNode = catchLocation;
        this.catchBci = catchBci;
    }

    public void markEscaped() {
        this.markFrameEscaped();
        if (!(this.pythonException instanceof PBaseException)) {
            this.materializeNativeExceptionTraceback();
            this.reified = true;
        }
    }

    private void markFrameEscaped() {
        if (this.frameInfo != null) {
            this.frameInfo.markAsEscaped();
        }
    }

    public Object getEscapedException() {
        this.markEscaped();
        return this.pythonException;
    }

    public void ensureReified() {
        if (!this.reified) {
            this.markFrameEscaped();
            Object object = this.pythonException;
            if (object instanceof PBaseException) {
                PBaseException managedException = (PBaseException)object;
                managedException.internalReifyException(this.frameInfo);
            } else {
                this.materializeNativeExceptionTraceback();
            }
            this.reified = true;
        }
    }

    public int getTracebackFrameCount() {
        return this.tracebackFrameCount;
    }

    public void notifyAddedTracebackFrame(boolean visible) {
        if (visible) {
            ++this.tracebackFrameCount;
        }
    }

    public PException getExceptionForReraise(boolean rootNodeVisible) {
        this.ensureReified();
        PException pe = PException.fromObject(this.pythonException, this.getLocation(), false);
        if (rootNodeVisible) {
            pe.skipFirstTracebackFrame();
        }
        return pe;
    }

    @CompilerDirectives.TruffleBoundary
    private void materializeNativeExceptionTraceback() {
        LazyTraceback tb;
        PTraceback materializedTb;
        Object existingTraceback = ExceptionNodes.GetTracebackNode.executeUncached(this.pythonException);
        LazyTraceback nextChain = null;
        if (existingTraceback instanceof PTraceback) {
            PTraceback nextTraceback = (PTraceback)existingTraceback;
            nextChain = new LazyTraceback(nextTraceback);
        }
        ExceptionNodes.SetTracebackNode.executeUncached(this.pythonException, (materializedTb = MaterializeLazyTracebackNode.executeUncached(tb = new LazyTraceback(this.frameInfo, this, nextChain))) != null ? materializedTb : PNone.NONE);
    }

    @CompilerDirectives.TruffleBoundary
    public void printStack() {
        ExceptionUtils.printPythonLikeStackTrace((Throwable)((Object)this));
    }

    @ExportMessage
    boolean isException() {
        return true;
    }

    @ExportMessage
    ExceptionType getExceptionType(@CachedLibrary(limit="1") InteropLibrary lib) throws UnsupportedMessageException {
        return lib.getExceptionType(this.pythonException);
    }

    @ExportMessage
    RuntimeException throwException(@Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            throw this.getExceptionForReraise(false);
        }
        catch (Throwable throwable) {
            gil.release(mustRelease);
            throw throwable;
        }
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return this.getLocation() != null && this.getLocation().getEncapsulatingSourceSection() != null;
    }

    @ExportMessage(name="getSourceLocation")
    SourceSection getExceptionSourceLocation(@Bind(value="$node") Node inliningTarget, @Cached InlinedBranchProfile unsupportedProfile) throws UnsupportedMessageException {
        if (this.hasSourceLocation()) {
            return this.getLocation().getEncapsulatingSourceSection();
        }
        unsupportedProfile.enter(inliningTarget);
        throw UnsupportedMessageException.create();
    }
}

