/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.sst;

import com.oracle.graal.python.pegparser.ErrorCallback;
import com.oracle.graal.python.pegparser.FExprParser;
import com.oracle.graal.python.pegparser.PythonStringFactory;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public abstract class StringLiteralUtils {
    private static final ExprTy[] EMPTY_SST_ARRAY = new ExprTy[0];
    private static final String CANNOT_MIX_MESSAGE = "cannot mix bytes and nonbytes literals";
    private static final Map<String, Integer> CONTROL_CHAR_NAMES = new HashMap<String, Integer>(32);
    private static final String UNICODE_ERROR = "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d:";
    private static final String ILLEGAL_CHARACTER = "illegal Unicode character";
    private static final String TRAILING_S_IN_STR = "Trailing %s in string";
    private static final String MALFORMED_ERROR = " malformed \\N character escape";
    private static final String TRUNCATED_XXX_ERROR = "truncated \\xXX escape";
    private static final String TRUNCATED_UXXXX_ERROR = "truncated \\uXXXX escape";
    private static final String TRUNCATED_UXXXXXXXX_ERROR = "truncated \\UXXXXXXXX escape";
    private static final String UNKNOWN_UNICODE_ERROR = " unknown Unicode character name";
    private static final String INVALID_ESCAPE_AT = "invalid %s escape at position %d";

    /*
     * Enabled aggressive block sorting
     */
    public static <T> ExprTy createStringLiteral(String[] values, SourceRange[] sourceRanges, FExprParser exprParser, ErrorCallback errorCallback, PythonStringFactory<T> stringFactory, int featureVersion) {
        if (!$assertionsDisabled) {
            if (values.length != sourceRanges.length) throw new AssertionError();
            if (values.length <= 0) {
                throw new AssertionError();
            }
        }
        PythonStringFactory.PythonStringBuilder<T> sb = null;
        BytesBuilder bb = null;
        boolean isFormatString = false;
        ArrayList<ExprTy> formatStringParts = null;
        SourceRange sourceRange = sourceRanges[0].withEnd(sourceRanges[sourceRanges.length - 1]);
        SourceRange sbSourceRange = null;
        boolean hasUPrefix = false;
        int index = 0;
        while (true) {
            int i;
            int strEndIndex;
            int strStartIndex;
            boolean isFormat;
            boolean isBytes;
            boolean isRaw;
            String text;
            if (index < values.length) {
                text = values[index];
                isRaw = false;
                isBytes = false;
                isFormat = false;
                strStartIndex = 1;
                strEndIndex = text.length() - 1;
            } else {
                String string;
                if (bb != null) {
                    return new ExprTy.Constant(ConstantValue.ofBytes(bb.build()), null, sourceRange);
                }
                if (isFormatString) {
                    assert (formatStringParts != null);
                    if (sb != null && !sb.isEmpty()) {
                        formatStringParts.add(new ExprTy.Constant(ConstantValue.ofRaw(sb.build()), hasUPrefix ? "u" : null, sbSourceRange));
                    }
                    ExprTy[] formatParts = formatStringParts.toArray(EMPTY_SST_ARRAY);
                    return new ExprTy.JoinedStr(formatParts, sourceRange);
                }
                ConstantValue constantValue = ConstantValue.ofRaw(sb == null ? stringFactory.emptyString() : sb.build());
                if (hasUPrefix) {
                    string = "u";
                    return new ExprTy.Constant(constantValue, string, sourceRange);
                }
                string = null;
                return new ExprTy.Constant(constantValue, string, sourceRange);
            }
            block8: for (i = 0; i < 3; ++i) {
                char chr = Character.toLowerCase(text.charAt(i));
                switch (chr) {
                    case 'r': {
                        isRaw = true;
                        break;
                    }
                    case 'u': {
                        hasUPrefix = index == 0;
                        break;
                    }
                    case 'b': {
                        isBytes = true;
                        break;
                    }
                    case 'f': {
                        isFormat = true;
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        strStartIndex = i + 1;
                        break block8;
                    }
                }
            }
            if (isFormat && featureVersion < 6) {
                errorCallback.onError(ErrorCallback.ErrorType.Syntax, sourceRange, "Format strings are only supported in Python 3.6 and greater");
            }
            if (text.endsWith("'''") || text.endsWith("\"\"\"")) {
                strStartIndex += 2;
                strEndIndex -= 2;
            }
            text = text.substring(strStartIndex, strEndIndex);
            if (isBytes) {
                for (i = 0; i < text.length(); ++i) {
                    if (text.charAt(i) < '\u0080') continue;
                    errorCallback.onError(ErrorCallback.ErrorType.Syntax, sourceRange, "bytes can only contain ASCII literal characters");
                }
                if (sb != null || isFormatString) {
                    String string;
                    errorCallback.onError(sourceRange, CANNOT_MIX_MESSAGE, new Object[0]);
                    if (sb == null) {
                        if (bb == null) return new ExprTy.Constant(ConstantValue.ofBytes(text.getBytes()), null, sourceRange);
                        return new ExprTy.Constant(ConstantValue.ofBytes(bb.build()), null, sourceRange);
                    }
                    ConstantValue constantValue = ConstantValue.ofRaw(sb.build());
                    if (hasUPrefix) {
                        string = "u";
                        return new ExprTy.Constant(constantValue, string, sourceRange);
                    }
                    string = null;
                    return new ExprTy.Constant(constantValue, string, sourceRange);
                }
                if (bb == null) {
                    bb = new BytesBuilder();
                }
                if (isRaw) {
                    bb.append(text.getBytes());
                } else {
                    bb.append(StringLiteralUtils.decodeEscapeToBytes(errorCallback, text, sourceRange));
                }
            } else {
                if (bb != null) {
                    errorCallback.onError(sourceRange, CANNOT_MIX_MESSAGE, new Object[0]);
                    return new ExprTy.Constant(ConstantValue.ofBytes(bb.build()), null, sourceRange);
                }
                if (isFormat) {
                    isFormatString = true;
                    if (formatStringParts == null) {
                        formatStringParts = new ArrayList<ExprTy>();
                    }
                    if (sb != null && !sb.isEmpty()) {
                        formatStringParts.add(new ExprTy.Constant(ConstantValue.ofRaw(sb.build()), hasUPrefix ? "u" : null, sbSourceRange));
                        sb = null;
                    }
                    FormatStringParser.parse(formatStringParts, text, sourceRanges[index].shiftStartRight(strStartIndex), isRaw, exprParser, errorCallback, stringFactory, featureVersion, hasUPrefix);
                } else {
                    if (sb == null) {
                        sb = stringFactory.createBuilder(text.length());
                        sbSourceRange = sourceRanges[index];
                    }
                    if (!isRaw) {
                        sb.appendPythonString(StringLiteralUtils.unescapeString(sourceRanges[index], errorCallback, text, stringFactory));
                    } else {
                        sb.appendString(text);
                    }
                    sbSourceRange = sbSourceRange.withEnd(sourceRanges[index]);
                }
            }
            ++index;
        }
    }

    private static byte[] decodeEscapeToBytes(ErrorCallback errors, String string, SourceRange sourceRange) {
        StringBuilder sb = StringLiteralUtils.decodeEscapes(errors, string, sourceRange, false);
        byte[] bytes = new byte[sb.length()];
        for (int i = 0; i < sb.length(); ++i) {
            bytes[i] = (byte)sb.charAt(i);
        }
        return bytes;
    }

    public static StringBuilder decodeEscapes(ErrorCallback errors, String string, SourceRange sourceRange, boolean regexMode) {
        StringBuilder charList = new StringBuilder();
        int length = string.length();
        boolean wasDeprecationWarning = false;
        block17: for (int i = 0; i < length; ++i) {
            char chr = string.charAt(i);
            if (chr != '\\') {
                charList.append(chr);
                continue;
            }
            if (++i >= length) {
                errors.onError(ErrorCallback.ErrorType.Value, sourceRange, TRAILING_S_IN_STR, "\\");
                return charList;
            }
            chr = string.charAt(i);
            switch (chr) {
                case '\n': {
                    continue block17;
                }
                case '\\': {
                    if (regexMode) {
                        charList.append('\\');
                    }
                    charList.append('\\');
                    continue block17;
                }
                case '\'': {
                    charList.append('\'');
                    continue block17;
                }
                case '\"': {
                    charList.append('\"');
                    continue block17;
                }
                case 'b': {
                    charList.append('\b');
                    continue block17;
                }
                case 'f': {
                    charList.append('\f');
                    continue block17;
                }
                case 't': {
                    charList.append('\t');
                    continue block17;
                }
                case 'n': {
                    charList.append('\n');
                    continue block17;
                }
                case 'r': {
                    charList.append('\r');
                    continue block17;
                }
                case 'v': {
                    charList.append('\u000b');
                    continue block17;
                }
                case 'a': {
                    charList.append('\u0007');
                    continue block17;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (!regexMode) {
                        char nextChar;
                        int code = chr - 48;
                        if (i + 1 < length && '0' <= (nextChar = string.charAt(i + 1)) && nextChar <= '7') {
                            code = (code << 3) + nextChar - 48;
                            if (++i + 1 < length && '0' <= (nextChar = string.charAt(i + 1)) && nextChar <= '7') {
                                code = (code << 3) + nextChar - 48;
                                ++i;
                            }
                        }
                        charList.append((char)code);
                        continue block17;
                    }
                    charList.append('\\');
                    charList.append(chr);
                    continue block17;
                }
                case 'x': {
                    if (i + 2 < length) {
                        try {
                            int b = Integer.parseInt(string.substring(i + 1, i + 3), 16);
                            assert (b >= 0 && b <= 255);
                            charList.append((char)b);
                            i += 2;
                            continue block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    errors.onError(ErrorCallback.ErrorType.Value, sourceRange, INVALID_ESCAPE_AT, "\\x", i);
                    return charList;
                }
                default: {
                    if (regexMode) {
                        if (chr == 'g' || chr >= '0' && chr <= '9') {
                            charList.append('\\');
                            charList.append(chr);
                            continue block17;
                        }
                        errors.onError(ErrorCallback.ErrorType.Value, sourceRange, INVALID_ESCAPE_AT, "\\x", i);
                        return charList;
                    }
                    charList.append('\\');
                    charList.append(chr);
                    if (wasDeprecationWarning) continue block17;
                    wasDeprecationWarning = true;
                    StringLiteralUtils.warnInvalidEscapeSequence(errors, sourceRange, chr);
                }
            }
        }
        return charList;
    }

    private static <T> T unescapeString(SourceRange sourceRange, ErrorCallback errorCallback, String st, PythonStringFactory<T> stringFactory) {
        if (!st.contains("\\")) {
            return stringFactory.fromJavaString(st);
        }
        PythonStringFactory.PythonStringBuilder<T> sb = stringFactory.createBuilder(st.length());
        boolean wasDeprecationWarning = false;
        block18: for (int i = 0; i < st.length(); ++i) {
            int ch = st.charAt(i);
            if (ch == 92) {
                int nextChar;
                int n = nextChar = i == st.length() - 1 ? 92 : (int)st.charAt(i + 1);
                if (nextChar >= 48 && nextChar <= 55) {
                    String code = "" + (char)nextChar;
                    if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                        code = code + st.charAt(i + 1);
                        if (++i < st.length() - 1 && st.charAt(i + 1) >= '0' && st.charAt(i + 1) <= '7') {
                            code = code + st.charAt(i + 1);
                            ++i;
                        }
                    }
                    sb.appendCodePoint(Integer.parseInt(code, 8));
                    continue;
                }
                switch (nextChar) {
                    case 92: {
                        ch = 92;
                        break;
                    }
                    case 97: {
                        ch = 7;
                        break;
                    }
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 118: {
                        ch = 11;
                        break;
                    }
                    case 34: {
                        ch = 34;
                        break;
                    }
                    case 39: {
                        ch = 39;
                        break;
                    }
                    case 13: {
                        int n2 = nextChar = i == st.length() - 2 ? 92 : (int)st.charAt(i + 2);
                        if (nextChar == 10) {
                            ++i;
                        }
                        ++i;
                        continue block18;
                    }
                    case 10: {
                        ++i;
                        continue block18;
                    }
                    case 117: {
                        int code = StringLiteralUtils.getHexValue(st, sourceRange, i + 2, 4, errorCallback);
                        if (code < 0) {
                            return stringFactory.fromJavaString(st);
                        }
                        sb.appendCodePoint(code);
                        i += 5;
                        continue block18;
                    }
                    case 85: {
                        int code = StringLiteralUtils.getHexValue(st, sourceRange, i + 2, 8, errorCallback);
                        if (!Character.isValidCodePoint(code)) {
                            errorCallback.onError(ErrorCallback.ErrorType.Encoding, sourceRange, String.format("(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d:illegal Unicode character", i, i + 9));
                            return stringFactory.fromJavaString(st);
                        }
                        sb.appendCodePoint(code);
                        i += 9;
                        continue block18;
                    }
                    case 120: {
                        int code = StringLiteralUtils.getHexValue(st, sourceRange, i + 2, 2, errorCallback);
                        if (code < 0) {
                            return stringFactory.fromJavaString(st);
                        }
                        sb.appendCodePoint(code);
                        i += 3;
                        continue block18;
                    }
                    case 78: {
                        i = StringLiteralUtils.doCharacterName(st, sourceRange, sb, i + 2, errorCallback);
                        if (i >= 0) continue block18;
                        return stringFactory.fromJavaString(st);
                    }
                    default: {
                        if (!wasDeprecationWarning) {
                            wasDeprecationWarning = true;
                            StringLiteralUtils.warnInvalidEscapeSequence(errorCallback, sourceRange, (char)nextChar);
                        }
                        sb.appendCodePoint(ch);
                        sb.appendCodePoint(nextChar);
                        ++i;
                        continue block18;
                    }
                }
                ++i;
            }
            sb.appendCodePoint(ch);
        }
        return sb.build();
    }

    private static int getHexValue(String text, SourceRange sourceRange, int start, int len, ErrorCallback errorCb) {
        int result = 0;
        for (int index = start; index < start + len; ++index) {
            int digit;
            if (index < text.length()) {
                digit = Character.digit(text.charAt(index), 16);
                if (digit == -1) {
                    return StringLiteralUtils.createTruncatedError(sourceRange, start - 2, index - 1, len, errorCb);
                }
            } else {
                return StringLiteralUtils.createTruncatedError(sourceRange, start - 2, index - 1, len, errorCb);
            }
            result = result * 16 + digit;
        }
        return result;
    }

    private static int createTruncatedError(SourceRange sourceRange, int startIndex, int endIndex, int len, ErrorCallback errorCb) {
        String truncatedMessage = null;
        switch (len) {
            case 2: {
                truncatedMessage = TRUNCATED_XXX_ERROR;
                break;
            }
            case 4: {
                truncatedMessage = TRUNCATED_UXXXX_ERROR;
                break;
            }
            case 8: {
                truncatedMessage = TRUNCATED_UXXXXXXXX_ERROR;
            }
        }
        errorCb.onError(ErrorCallback.ErrorType.Encoding, sourceRange, UNICODE_ERROR + truncatedMessage, startIndex, endIndex);
        return -1;
    }

    private static int doCharacterName(String text, SourceRange sourceRange, PythonStringFactory.PythonStringBuilder<?> sb, int offset, ErrorCallback errorCallback) {
        if (offset >= text.length()) {
            errorCallback.onError(ErrorCallback.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: malformed \\N character escape", offset - 2, offset - 1);
            return -1;
        }
        char ch = text.charAt(offset);
        if (ch != '{') {
            errorCallback.onError(ErrorCallback.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: malformed \\N character escape", offset - 2, offset - 1);
            return -1;
        }
        int closeIndex = text.indexOf("}", offset + 1);
        if (closeIndex == -1) {
            errorCallback.onError(ErrorCallback.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: malformed \\N character escape", offset - 2, offset - 1);
            return -1;
        }
        String charName = text.substring(offset + 1, closeIndex).toUpperCase();
        int cp = StringLiteralUtils.getCodePoint(charName);
        if (cp < 0) {
            errorCallback.onError(ErrorCallback.ErrorType.Encoding, sourceRange, "(unicode error) 'unicodeescape' codec can't decode bytes in position %d-%d: unknown Unicode character name", offset - 2, closeIndex);
            return -1;
        }
        sb.appendCodePoint(cp);
        return closeIndex;
    }

    public static int getCodePoint(String charName) {
        int possibleChar = CONTROL_CHAR_NAMES.getOrDefault(charName.toUpperCase(Locale.ROOT), -1);
        if (possibleChar > -1) {
            return possibleChar;
        }
        possibleChar = UCharacter.getCharFromName((String)charName);
        if (possibleChar > -1) {
            return possibleChar;
        }
        possibleChar = UCharacter.getCharFromExtendedName((String)charName);
        if (possibleChar > -1) {
            return possibleChar;
        }
        possibleChar = UCharacter.getCharFromNameAlias((String)charName);
        if (possibleChar > -1) {
            return possibleChar;
        }
        return -1;
    }

    public static void warnInvalidEscapeSequence(ErrorCallback errorCallback, SourceRange sourceRange, char nextChar) {
        errorCallback.onWarning(ErrorCallback.WarningType.Deprecation, sourceRange, "invalid escape sequence '\\%c'", Character.valueOf(nextChar));
    }

    static {
        CONTROL_CHAR_NAMES.put("NULL", 0);
        CONTROL_CHAR_NAMES.put("START OF HEADING", 1);
        CONTROL_CHAR_NAMES.put("START OF TEXT", 2);
        CONTROL_CHAR_NAMES.put("END OF TEXT", 3);
        CONTROL_CHAR_NAMES.put("END OF TRANSMISSION", 4);
        CONTROL_CHAR_NAMES.put("ENQUIRY", 5);
        CONTROL_CHAR_NAMES.put("ACKNOWLEDGE", 6);
        CONTROL_CHAR_NAMES.put("BELL", 7);
        CONTROL_CHAR_NAMES.put("BACKSPACE", 8);
        CONTROL_CHAR_NAMES.put("CHARACTER TABULATION", 9);
        CONTROL_CHAR_NAMES.put("LINE FEED", 10);
        CONTROL_CHAR_NAMES.put("LINE TABULATION", 11);
        CONTROL_CHAR_NAMES.put("FORM FEED", 12);
        CONTROL_CHAR_NAMES.put("CARRIAGE RETURN", 13);
        CONTROL_CHAR_NAMES.put("SHIFT OUT", 14);
        CONTROL_CHAR_NAMES.put("SHIFT IN", 15);
        CONTROL_CHAR_NAMES.put("DATA LINK ESCAPE", 16);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL ONE", 17);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL TWO", 18);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL THREE", 19);
        CONTROL_CHAR_NAMES.put("DEVICE CONTROL FOUR", 20);
        CONTROL_CHAR_NAMES.put("NEGATIVE ACKNOWLEDGE", 21);
        CONTROL_CHAR_NAMES.put("SYNCHRONOUS IDLE", 22);
        CONTROL_CHAR_NAMES.put("END OF TRANSMISSION BLOCK", 23);
        CONTROL_CHAR_NAMES.put("CANCEL", 24);
        CONTROL_CHAR_NAMES.put("END OF MEDIUM", 25);
        CONTROL_CHAR_NAMES.put("SUBSTITUTE", 26);
        CONTROL_CHAR_NAMES.put("ESCAPE", 27);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR FOUR", 28);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR THREE", 29);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR TWO", 30);
        CONTROL_CHAR_NAMES.put("INFORMATION SEPARATOR ONE", 31);
        CONTROL_CHAR_NAMES.put("BYTE ORDER MARK", 65279);
    }

    private static class BytesBuilder {
        List<byte[]> bytes = new ArrayList<byte[]>();
        int len = 0;

        private BytesBuilder() {
        }

        void append(byte[] b) {
            this.len += b.length;
            this.bytes.add(b);
        }

        byte[] build() {
            byte[] output = new byte[this.len];
            int offset = 0;
            for (byte[] bs : this.bytes) {
                System.arraycopy(bs, 0, output, offset, bs.length);
                offset += bs.length;
            }
            return output;
        }
    }

    private static final class FormatStringParser {
        public static final String ERROR_MESSAGE_EMPTY_EXPRESSION = "f-string: empty expression not allowed";
        public static final String ERROR_MESSAGE_EXPRESSION_REQUIRED_BEFORE = "f-string: expression required before '%c'";
        public static final String ERROR_MESSAGE_NESTED_TOO_DEEPLY = "f-string: expressions nested too deeply";
        public static final String ERROR_MESSAGE_SINGLE_BRACE = "f-string: single '}' is not allowed";
        public static final String ERROR_MESSAGE_INVALID_CONVERSION = "f-string: invalid conversion character: expected 's', 'r', or 'a'";
        public static final String ERROR_MESSAGE_UNTERMINATED_STRING = "f-string: unterminated string";
        public static final String ERROR_MESSAGE_BACKSLASH_IN_EXPRESSION = "f-string expression part cannot include a backslash";
        public static final String ERROR_MESSAGE_HASH_IN_EXPRESSION = "f-string expression part cannot include '#'";
        public static final String ERROR_MESSAGE_CLOSING_PAR_DOES_NOT_MATCH = "f-string: closing parenthesis '%c' does not match opening parenthesis '%c'";
        public static final String ERROR_MESSAGE_UNMATCHED_PAR = "f-string: unmatched '%c'";
        public static final String ERROR_MESSAGE_TOO_MANY_NESTED_PARS = "f-string: too many nested parenthesis";
        public static final String ERROR_MESSAGE_EXPECTING_CLOSING_BRACE = "f-string: expecting '}'";
        public static final String ERROR_MESSAGE_SELF_DOCUMENTING_EXPRESSION = "f-string: self documenting expressions are only supported in Python 3.8 and greater";
        public static final byte TOKEN_TYPE_STRING = 1;
        public static final byte TOKEN_TYPE_EXPRESSION = 2;
        public static final byte TOKEN_TYPE_EXPRESSION_STR = 3;
        public static final byte TOKEN_TYPE_EXPRESSION_REPR = 4;
        public static final byte TOKEN_TYPE_EXPRESSION_ASCII = 5;
        private static final int STATE_TEXT = 1;
        private static final int STATE_AFTER_OPEN_BRACE = 2;
        private static final int STATE_AFTER_CLOSE_BRACE = 3;
        private static final int STATE_AFTER_EXCLAMATION = 4;
        private static final int STATE_AFTER_COLON = 5;
        private static final int STATE_EXPRESSION = 6;
        private static final int STATE_UNKNOWN = 7;
        private static final int MAX_PAR_NESTING = 200;

        private FormatStringParser() {
        }

        private static ExprTy createFormatStringLiteralSSTNodeFromToken(ArrayList<Token> tokens, int tokenIndex, String text, SourceRange textSourceRange, boolean isRawString, ErrorCallback errorCallback, FExprParser exprParser, PythonStringFactory<?> stringFactory, boolean hasUPrefix) {
            Token token = tokens.get(tokenIndex);
            Object code = text.substring(token.startIndex, token.endIndex);
            if (token.type == 1) {
                Object o = !isRawString ? StringLiteralUtils.unescapeString(token.getSourceRange(text, textSourceRange), errorCallback, (String)code, stringFactory) : stringFactory.fromJavaString((String)code);
                return new ExprTy.Constant(ConstantValue.ofRaw(o), hasUPrefix ? "u" : null, token.getSourceRange(text, textSourceRange));
            }
            int specTokensCount = token.formatTokensCount;
            ExprTy expression = exprParser.parse((String)(code = "(" + (String)code + ")"), token.getSourceRange(text, textSourceRange));
            if (expression == null) {
                errorCallback.onError(ErrorCallback.ErrorType.Syntax, textSourceRange, "invalid syntax");
                return null;
            }
            ExprTy.JoinedStr specifier = null;
            SourceRange specifierSourceRange = null;
            if (specTokensCount > 0) {
                int i;
                ExprTy[] specifierParts = new ExprTy[specTokensCount];
                int specifierTokenStartIndex = tokenIndex + 1;
                Token specToken = tokens.get(specifierTokenStartIndex);
                specifierSourceRange = specToken.getSourceRange(text, textSourceRange);
                int realCount = 0;
                for (i = 0; i < specTokensCount; ++i) {
                    specToken = tokens.get(specifierTokenStartIndex + i);
                    specifierParts[realCount++] = FormatStringParser.createFormatStringLiteralSSTNodeFromToken(tokens, specifierTokenStartIndex + i, text, textSourceRange, isRawString, errorCallback, exprParser, stringFactory, hasUPrefix);
                    i += specToken.formatTokensCount;
                }
                if (realCount < i) {
                    specifierParts = Arrays.copyOf(specifierParts, realCount);
                }
                specifierSourceRange = specifierSourceRange.withEnd(specToken.getSourceRange(text, textSourceRange));
                specifier = new ExprTy.JoinedStr(specifierParts, specifierSourceRange);
            }
            int conversionType = switch (token.type) {
                case 3 -> 115;
                case 4 -> 114;
                case 5 -> 97;
                default -> -1;
            };
            SourceRange range = token.getSourceRange(text, textSourceRange);
            if (specifierSourceRange != null) {
                range = range.withEnd(specifierSourceRange);
            }
            if (conversionType != -1) {
                range = range.shiftEndRight(2);
            }
            return new ExprTy.FormattedValue(expression, conversionType, specifier, range);
        }

        public static void parse(ArrayList<ExprTy> formatStringParts, String text, SourceRange textSourceRange, boolean isRawString, FExprParser exprParser, ErrorCallback errorCallback, PythonStringFactory<?> stringFactory, int featureVersion, boolean hasUPrefix) {
            char c;
            int estimatedTokensCount = 1;
            for (int i = 0; i < text.length() && ((c = text.charAt(i)) != '{' && c != '}' && c != ':' || ++estimatedTokensCount <= 32); ++i) {
            }
            ArrayList<Token> tokens = new ArrayList<Token>(estimatedTokensCount);
            if (FormatStringParser.createTokens(tokens, errorCallback, 0, text, textSourceRange, isRawString, 0, featureVersion) < 0) {
                return;
            }
            int tokenIndex = 0;
            while (tokenIndex < tokens.size()) {
                Token token = tokens.get(tokenIndex);
                ExprTy part = FormatStringParser.createFormatStringLiteralSSTNodeFromToken(tokens, tokenIndex, text, textSourceRange, isRawString, errorCallback, exprParser, stringFactory, hasUPrefix);
                formatStringParts.add(part);
                tokenIndex = tokenIndex + 1 + token.formatTokensCount;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static int createTokens(ArrayList<Token> tokens, ErrorCallback errorCallback, int startIndex, String text, SourceRange textSourceRange, boolean isRawString, int recursionLevel, int featureVersion) {
            int state = 1;
            int braceLevel = 0;
            int braceLevelInExpression = 0;
            char[] bracesInExpression = new char[200];
            int len = text.length();
            int index = startIndex;
            int start = startIndex;
            boolean toplevel = recursionLevel == 0;
            Token currentExpression = null;
            block40: while (index < len) {
                char ch = text.charAt(index);
                block0 : switch (state) {
                    case 1: {
                        switch (ch) {
                            case '\\': {
                                if (isRawString) break block0;
                                if (FormatStringParser.lookahead(text, index, len, '\\')) {
                                    ++index;
                                    break block0;
                                }
                                if (FormatStringParser.lookahead(text, index, len, '{')) {
                                    StringLiteralUtils.warnInvalidEscapeSequence(errorCallback, textSourceRange, text.charAt(index + 1));
                                    break block0;
                                }
                                if (!FormatStringParser.lookahead(text, index, len, 'N', '{')) break;
                                index += 2;
                                while (index < len && text.charAt(index) != '}') {
                                    ++index;
                                }
                                if (index < len) break;
                                index = len - 1;
                                break block40;
                            }
                            case '{': {
                                if (start < index) {
                                    tokens.add(new Token(1, start, index));
                                }
                                state = 2;
                                start = index + 1;
                                ++braceLevel;
                                break block0;
                            }
                            case '}': {
                                if (--braceLevel == -1 && !toplevel) break block40;
                                state = 3;
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (ch == '}') {
                            errorCallback.onError(textSourceRange, ERROR_MESSAGE_EMPTY_EXPRESSION, new Object[0]);
                            return -1;
                        }
                        if (ch == '=') {
                            errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPRESSION_REQUIRED_BEFORE, Character.valueOf('='));
                            return -1;
                        }
                        if (ch == '{' && toplevel) {
                            state = 1;
                            --braceLevel;
                            break;
                        }
                        if (recursionLevel == 2) {
                            errorCallback.onError(textSourceRange, ERROR_MESSAGE_NESTED_TOO_DEEPLY, new Object[0]);
                            return -1;
                        }
                        --index;
                        state = 6;
                        braceLevelInExpression = 0;
                        currentExpression = null;
                        break;
                    }
                    case 3: {
                        if (toplevel && ch == '}') {
                            if (start < index) {
                                tokens.add(new Token(1, start, index));
                            }
                            if (++braceLevel == 0) {
                                state = 1;
                            }
                            start = index + 1;
                            break;
                        }
                        errorCallback.onError(textSourceRange, ERROR_MESSAGE_SINGLE_BRACE, new Object[0]);
                        return -1;
                    }
                    case 6: {
                        if (index + 1 < len && (ch == '!' || ch == '<' || ch == '>' || ch == '=') && text.charAt(index + 1) == '=') {
                            index += 2;
                            continue block40;
                        }
                        switch (ch) {
                            case '(': 
                            case '[': 
                            case '{': {
                                bracesInExpression[braceLevelInExpression] = ch;
                                if (++braceLevelInExpression < 200) break;
                                errorCallback.onError(textSourceRange, ERROR_MESSAGE_TOO_MANY_NESTED_PARS, new Object[0]);
                                return -1;
                            }
                            case ')': 
                            case ']': {
                                char expected;
                                if (braceLevelInExpression == 0) {
                                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_UNMATCHED_PAR, Character.valueOf(ch));
                                    return -1;
                                }
                                char c = expected = ch == ')' ? (char)'(' : '[';
                                if (bracesInExpression[--braceLevelInExpression] == expected) break;
                                errorCallback.onError(textSourceRange, ERROR_MESSAGE_CLOSING_PAR_DOES_NOT_MATCH, Character.valueOf(ch), Character.valueOf(bracesInExpression[braceLevelInExpression]));
                                return -1;
                            }
                            case '}': {
                                if (braceLevelInExpression == 0) {
                                    Token t = FormatStringParser.createExpressionToken(errorCallback, text, textSourceRange, start, index);
                                    if (t == null) {
                                        return -1;
                                    }
                                    tokens.add(t);
                                    --braceLevel;
                                    state = 1;
                                    start = index + 1;
                                    break;
                                }
                                if (bracesInExpression[--braceLevelInExpression] == '{') break;
                                errorCallback.onError(textSourceRange, ERROR_MESSAGE_CLOSING_PAR_DOES_NOT_MATCH, Character.valueOf('}'), Character.valueOf(bracesInExpression[braceLevelInExpression]));
                                return -1;
                            }
                            case '=': {
                                if (braceLevelInExpression != 0) break;
                                if (featureVersion < 8) {
                                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_SELF_DOCUMENTING_EXPRESSION, new Object[0]);
                                    return -1;
                                }
                                int expressionEndIndex = index++;
                                while (index < len && Character.isWhitespace(text.charAt(index))) {
                                    ++index;
                                }
                                if (index >= len) {
                                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPECTING_CLOSING_BRACE, new Object[0]);
                                    return -1;
                                }
                                char endChar = text.charAt(index);
                                if (endChar != '}' && endChar != ':' && endChar != '!') {
                                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPECTING_CLOSING_BRACE, new Object[0]);
                                    return -1;
                                }
                                tokens.add(new Token(1, start, index));
                                currentExpression = FormatStringParser.createExpressionToken(errorCallback, text, textSourceRange, start, expressionEndIndex);
                                if (currentExpression == null) {
                                    return -1;
                                }
                                tokens.add(currentExpression);
                                if (endChar == '}') {
                                    currentExpression.type = (byte)4;
                                    --braceLevel;
                                    state = 1;
                                    start = index + 1;
                                    currentExpression = null;
                                    break;
                                }
                                if (endChar == '!') {
                                    state = 4;
                                    break;
                                }
                                start = index;
                                state = 5;
                                break;
                            }
                            case '\"': 
                            case '\'': {
                                index = FormatStringParser.skipString(errorCallback, text, textSourceRange, index, len, ch);
                                if (index >= 0) break;
                                return index;
                            }
                            case '!': {
                                state = 4;
                                currentExpression = FormatStringParser.createExpressionToken(errorCallback, text, textSourceRange, start, index);
                                if (currentExpression == null) {
                                    return -1;
                                }
                                tokens.add(currentExpression);
                                break;
                            }
                            case ':': {
                                if (braceLevelInExpression != 0) break;
                                currentExpression = FormatStringParser.createExpressionToken(errorCallback, text, textSourceRange, start, index);
                                if (currentExpression == null) {
                                    return -1;
                                }
                                tokens.add(currentExpression);
                                state = 5;
                                break;
                            }
                            case '#': {
                                errorCallback.onError(textSourceRange, ERROR_MESSAGE_HASH_IN_EXPRESSION, new Object[0]);
                                return -1;
                            }
                            case '\\': {
                                errorCallback.onError(textSourceRange, ERROR_MESSAGE_BACKSLASH_IN_EXPRESSION, new Object[0]);
                                return -1;
                            }
                        }
                        break;
                    }
                    case 4: {
                        assert (currentExpression != null);
                        switch (ch) {
                            case 's': {
                                currentExpression.type = (byte)3;
                                break;
                            }
                            case 'r': {
                                currentExpression.type = (byte)4;
                                break;
                            }
                            case 'a': {
                                currentExpression.type = (byte)5;
                                break;
                            }
                            default: {
                                errorCallback.onError(textSourceRange, ERROR_MESSAGE_INVALID_CONVERSION, new Object[0]);
                                return -1;
                            }
                        }
                        start = index + 2;
                        int next = ++index < len ? (int)text.charAt(index) : 65535;
                        switch (next) {
                            case 58: {
                                state = 5;
                                break block0;
                            }
                            case 125: {
                                state = 1;
                                --braceLevel;
                                break block0;
                            }
                        }
                        errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPECTING_CLOSING_BRACE, new Object[0]);
                        return -1;
                    }
                    case 5: {
                        assert (currentExpression != null);
                        int tokensSizeBefore = tokens.size();
                        if ((index = FormatStringParser.createTokens(tokens, errorCallback, index, text, textSourceRange, isRawString, recursionLevel + 1, featureVersion)) < 0) {
                            return -1;
                        }
                        currentExpression.formatTokensCount = tokens.size() - tokensSizeBefore;
                        if (index >= len || text.charAt(index) != '}') {
                            errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPECTING_CLOSING_BRACE, new Object[0]);
                            return -1;
                        }
                        --braceLevel;
                        state = 1;
                        start = index + 1;
                        break;
                    }
                    case 7: {
                        if (ch != '}') break;
                        state = 1;
                        start = index + 1;
                    }
                }
                ++index;
            }
            switch (state) {
                case 1: {
                    if (start >= index) return index;
                    tokens.add(new Token(1, start, index));
                    return index;
                }
                case 3: {
                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_SINGLE_BRACE, new Object[0]);
                    return -1;
                }
                case 2: 
                case 4: 
                case 5: {
                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPECTING_CLOSING_BRACE, new Object[0]);
                    return -1;
                }
                case 6: {
                    errorCallback.onError(textSourceRange, ERROR_MESSAGE_EXPECTING_CLOSING_BRACE, new Object[0]);
                    return -1;
                }
            }
            return index;
        }

        private static boolean lookahead(String text, int index, int len, char c1) {
            return index + 1 < len && text.charAt(index + 1) == c1;
        }

        private static boolean lookahead(String text, int index, int len, char c1, char c2) {
            return index + 2 < len && text.charAt(index + 1) == c1 && text.charAt(index + 2) == c2;
        }

        private static int skipString(ErrorCallback errorCallback, String text, SourceRange sourceRange, int startIndex, int len, char startq) {
            boolean triple = false;
            boolean inString = true;
            int index = startIndex + 1;
            if (index < len && startq == text.charAt(index)) {
                if (FormatStringParser.lookahead(text, index, len, startq)) {
                    triple = true;
                    index += 2;
                } else {
                    inString = false;
                }
            }
            if (inString) {
                while (index < len) {
                    char ch = text.charAt(index);
                    if (ch == '\\') {
                        errorCallback.onError(sourceRange, ERROR_MESSAGE_BACKSLASH_IN_EXPRESSION, new Object[0]);
                        return -1;
                    }
                    if (ch == startq) {
                        if (triple) {
                            if (FormatStringParser.lookahead(text, index, len, startq, startq)) {
                                inString = false;
                                break;
                            }
                        } else {
                            inString = false;
                            break;
                        }
                    }
                    ++index;
                }
                if (inString) {
                    errorCallback.onError(sourceRange, ERROR_MESSAGE_UNTERMINATED_STRING, new Object[0]);
                    return -1;
                }
            }
            return index;
        }

        private static Token createExpressionToken(ErrorCallback errorCallback, String text, SourceRange sourceRange, int start, int end) {
            int s;
            assert (start <= end);
            for (s = start; s < end && Character.isWhitespace(text.charAt(s)); ++s) {
            }
            if (s == end) {
                char c = text.charAt(s);
                if (c == '!' || c == ':' || c == '=') {
                    errorCallback.onError(sourceRange, ERROR_MESSAGE_EXPRESSION_REQUIRED_BEFORE, Character.valueOf(c));
                } else {
                    errorCallback.onError(sourceRange, ERROR_MESSAGE_EMPTY_EXPRESSION, new Object[0]);
                }
                return null;
            }
            return new Token(2, start, end);
        }

        public static final class Token {
            public byte type;
            public final int startIndex;
            public final int endIndex;
            public int formatTokensCount;

            public Token(byte type, int startIndex, int endIndex) {
                this.type = type;
                this.startIndex = startIndex;
                this.endIndex = endIndex;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder("Token(");
                sb.append("Type: ").append(this.type);
                sb.append(", [").append(this.startIndex).append(", ").append(this.endIndex).append("], Inner tokens: ");
                sb.append(this.formatTokensCount).append(')');
                return sb.toString();
            }

            SourceRange getSourceRange(String text, SourceRange textSourceRange) {
                int column = textSourceRange.startColumn;
                int line = textSourceRange.startLine;
                for (int i = 0; i < this.startIndex; ++i) {
                    if (text.charAt(i) == '\n') {
                        ++line;
                        column = 0;
                        continue;
                    }
                    ++column;
                }
                int startColumn = column;
                int startLine = line;
                for (int i = this.startIndex; i < this.endIndex; ++i) {
                    if (text.charAt(i) == '\n') {
                        ++line;
                        column = 0;
                        continue;
                    }
                    ++column;
                }
                return new SourceRange(startLine, startColumn, line, column);
            }
        }
    }
}

