/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.bytecode.UnpackSequenceNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(value=false)
public abstract class UnpackSequenceNode
extends PNodeWithContext {
    public abstract int execute(Frame var1, int var2, Object var3, int var4);

    @Specialization(guards={"isBuiltinSequence(sequence)"})
    @ExplodeLoop
    static int doUnpackSequence(VirtualFrame frame, int initialStackTop, PSequence sequence, int count, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
        int resultStackTop;
        CompilerAsserts.partialEvaluationConstant((int)count);
        int stackTop = resultStackTop = initialStackTop + count;
        SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, sequence);
        int len = storage.length();
        if (len == count) {
            for (int i = 0; i < count; ++i) {
                frame.setObject(stackTop--, getItemNode.execute(inliningTarget, storage, i));
            }
        } else {
            if (len < count) {
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK, count, len);
            }
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MANY_VALUES_TO_UNPACK, count);
        }
        return resultStackTop;
    }

    @ExplodeLoop
    @Fallback
    static int doUnpackIterable(Frame frame, int initialStackTop, Object collection, int count, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile notIterableProfile, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile1, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile2, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
        Object iterator;
        int resultStackTop;
        CompilerAsserts.partialEvaluationConstant((int)count);
        int stackTop = resultStackTop = initialStackTop + count;
        try {
            iterator = getIter.execute(frame, inliningTarget, collection);
        }
        catch (PException e) {
            e.expectTypeError(inliningTarget, notIterableProfile);
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_UNPACK_NON_ITERABLE, collection);
        }
        for (int i = 0; i < count; ++i) {
            try {
                Object item = getNextNode.execute(frame, iterator);
                frame.setObject(stackTop--, item);
                continue;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, stopIterationProfile1);
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.NOT_ENOUGH_VALUES_TO_UNPACK, count, i);
            }
        }
        try {
            getNextNode.execute(frame, iterator);
        }
        catch (PException e) {
            e.expectStopIteration(inliningTarget, stopIterationProfile2);
            return resultStackTop;
        }
        throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MANY_VALUES_TO_UNPACK, count);
    }

    public static UnpackSequenceNode create() {
        return UnpackSequenceNodeGen.create();
    }

    public static UnpackSequenceNode getUncached() {
        return UnpackSequenceNodeGen.getUncached();
    }
}

