/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class GetMethodsFlagsNode
extends Node {
    public abstract long execute(Node var1, Object var2);

    @Specialization
    protected static long pythonbuiltinclasstype(PythonManagedClass cls) {
        return cls.getMethodsFlags();
    }

    @Specialization
    protected static long pythonclasstype(PythonBuiltinClassType cls) {
        return cls.getMethodsFlags();
    }

    @CompilerDirectives.TruffleBoundary
    private static long populateMethodsFlags(PythonAbstractNativeObject cls) {
        Long flags = (Long)CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_GET_METHODS_FLAGS, cls.getPtr());
        HiddenAttr.WriteNode.executeUncached(cls, HiddenAttr.METHODS_FLAGS, flags);
        return flags;
    }

    protected static long getMethodsFlags(PythonAbstractNativeObject cls) {
        return GetMethodsFlagsNode.doNative(null, cls, HiddenAttr.ReadNode.getUncached());
    }

    protected static Assumption nativeAssumption(PythonAbstractNativeObject cls) {
        return PythonContext.get(null).getNativeClassStableAssumption(cls, true).getAssumption();
    }

    @Specialization(guards={"cachedCls == cls"}, limit="5", assumptions={"nativeAssumption(cachedCls)"})
    static long doNativeCached(PythonAbstractNativeObject cls, @Cached(value="cls") PythonAbstractNativeObject cachedCls, @Cached(value="getMethodsFlags(cls)") long flags) {
        return flags;
    }

    @Specialization(replaces={"doNativeCached"})
    static long doNative(Node inliningTarget, PythonAbstractNativeObject cls, @Cached HiddenAttr.ReadNode readFlagsNode) {
        Long flags = (Long)readFlagsNode.execute(inliningTarget, cls, HiddenAttr.METHODS_FLAGS, null);
        if (flags == null) {
            return GetMethodsFlagsNode.populateMethodsFlags(cls);
        }
        return flags;
    }

    @Fallback
    protected static long zero(Object cls) {
        return 0L;
    }
}

