/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class SourceMap {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] startLineMap;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] endLineMap;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] startColumnMap;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public final int[] endColumnMap;
    private static final byte EXTENDED_NUM = -128;
    private static final byte NEXT_LINE = -127;
    private static final byte NEXT_LINES = -126;
    private static final byte MIN_NUM = -125;
    private static final byte MULTIPLIER_NEGATIVE = -124;
    private static final byte MAX_NUM = 127;
    private static final byte MULTIPLIER_POSITIVE = 127;

    public SourceMap(byte[] code, byte[] srcTable, int startLine, int startColumn) {
        OpCodes op;
        CompilerAsserts.neverPartOfCompilation();
        this.startLineMap = new int[code.length];
        this.endLineMap = new int[code.length];
        this.startColumnMap = new int[code.length];
        this.endColumnMap = new int[code.length];
        ByteArrayInputStream stream = new ByteArrayInputStream(srcTable);
        int[] startLineAndColumn = new int[]{startLine, startColumn};
        for (int bci = 0; bci < code.length; bci += op.length()) {
            op = OpCodes.fromOpCode(code[bci]);
            SourceMap.readLineAndColumn(stream, startLineAndColumn);
            int[] endLineAndColumn = Arrays.copyOf(startLineAndColumn, 2);
            SourceMap.readLineAndColumn(stream, endLineAndColumn);
            Arrays.fill(this.startLineMap, bci, bci + op.length(), startLineAndColumn[0]);
            Arrays.fill(this.startColumnMap, bci, bci + op.length(), startLineAndColumn[1]);
            Arrays.fill(this.endLineMap, bci, bci + op.length(), endLineAndColumn[0]);
            Arrays.fill(this.endColumnMap, bci, bci + op.length(), endLineAndColumn[1]);
        }
    }

    private static void readLineAndColumn(ByteArrayInputStream stream, int[] pair) {
        stream.mark(1);
        byte value = (byte)stream.read();
        if (value == -127) {
            pair[0] = pair[0] + 1;
            pair[1] = 0;
        } else if (value == -126) {
            pair[0] = pair[0] + SourceMap.readNum(stream);
            pair[1] = 0;
        } else {
            stream.reset();
        }
        pair[1] = pair[1] + SourceMap.readNum(stream);
    }

    private static int readNum(ByteArrayInputStream offsets) {
        byte value;
        int extensions = 0;
        while (true) {
            int intValue = offsets.read();
            assert (intValue != -1);
            value = (byte)intValue;
            if (value != -128) break;
            ++extensions;
        }
        if (value < 0) {
            return extensions * -124 + value;
        }
        return extensions * 127 + value;
    }

    public static SourceSection getSourceSection(Source source, int startLine, int startColumn, int endLine, int endColumn) {
        if (!source.hasCharacters()) {
            return source.createUnavailableSection();
        }
        try {
            startColumn = Math.max(startColumn + 1, 1);
            endColumn = Math.max(endColumn + 1, 1);
            if (endColumn == source.getLineLength(endLine) + 1) {
                --endColumn;
            }
            return source.createSection(startLine, startColumn, endLine, endColumn);
        }
        catch (IllegalArgumentException e) {
            return source.createUnavailableSection();
        }
    }

    public SourceSection getSourceSection(Source source, int bci) {
        return SourceMap.getSourceSection(source, this.startLineMap[bci], this.startColumnMap[bci], this.endLineMap[bci], this.endColumnMap[bci]);
    }

    public static class Builder {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private int lastLine;
        private int lastColumn;

        public Builder(int startLine, int startColumn) {
            this.lastLine = startLine;
            this.lastColumn = startColumn;
        }

        private void writeNum(int offset) {
            while (offset > 127) {
                this.stream.write(-128);
                offset -= 127;
            }
            while (offset < -125) {
                this.stream.write(-128);
                offset += 124;
            }
            this.stream.write(offset);
        }

        private void writeLine(int lineDelta) {
            if (lineDelta == 1) {
                this.stream.write(-127);
            } else {
                this.stream.write(-126);
                this.writeNum(lineDelta);
            }
        }

        private void writeDeltas(int baseColumn, int column, int lineDelta) {
            if (lineDelta != 0) {
                this.writeLine(lineDelta);
                this.writeNum(column);
            } else {
                this.writeNum(column - baseColumn);
            }
        }

        public void appendLocation(int startLine, int startColumn, int endLine, int endColumn) {
            if (startColumn < 0) {
                startColumn = 0;
            }
            if (endColumn < 0) {
                endColumn = 0;
            }
            if (endLine == 0) {
                endLine = startLine;
            }
            assert (startLine >= 0 && endLine >= startLine && (startLine != endLine || endColumn >= startColumn));
            int lineDelta = startLine - this.lastLine;
            int lineSpan = endLine - startLine;
            this.writeDeltas(this.lastColumn, startColumn, lineDelta);
            this.writeDeltas(startColumn, endColumn, lineSpan);
            this.lastLine = startLine;
            this.lastColumn = startColumn;
        }

        public byte[] build() {
            return this.stream.toByteArray();
        }
    }
}

