/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

public class TpSlotSetAttr {

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class CallManagedSlotSetAttrNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, TpSlot.TpSlotManaged var3, Object var4, Object var5, Object var6);

        public abstract void execute(VirtualFrame var1, Node var2, TpSlot.TpSlotManaged var3, Object var4, TruffleString var5, Object var6);

        @Specialization(guards={"slot == cachedSlot"}, limit="3")
        static void callCachedBuiltin(VirtualFrame frame, TpSlotSetAttrBuiltin slot, Object self, TruffleString name, Object value, @Cached(value="slot") TpSlotSetAttrBuiltin cachedSlot, @Cached(value="cachedSlot.createSlotNode()") SetAttrBuiltinNode slotNode) {
            slotNode.executeSetAttr(frame, self, name, value);
        }

        @Specialization
        static void callPythonSimple(VirtualFrame frame, Node inliningTarget, TpSlotSetAttrPython slot, Object self, Object name, Object value, @Cached PRaiseNode.Lazy raiseNode, @Cached PythonDispatchers.TernaryOrBinaryPythonSlotDispatcherNode callPythonFun) {
            TruffleString funName;
            Object callable;
            boolean callDel = PGuards.isNoValue(value);
            if (callDel) {
                callable = slot.getDelattr();
                funName = SpecialMethodNames.T___DELATTR__;
            } else {
                callable = slot.getSetattr();
                funName = SpecialMethodNames.T___SETATTR__;
            }
            if (callable == null) {
                throw CallManagedSlotSetAttrNode.raiseAttributeError(inliningTarget, raiseNode, funName);
            }
            callPythonFun.execute(frame, inliningTarget, !callDel, callable, slot.getType(), self, name, value);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseAttributeError(Node inliningTarget, PRaiseNode.Lazy raiseNode, TruffleString attrName) {
            return raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, attrName);
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static void callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotSetAttrBuiltin slot, Object self, Object name, Object value, @Cached(inline=false) ExecutionContext.CallContext callContext, @Cached InlinedConditionProfile isNullFrameProfile, @Cached(inline=false) IndirectCallNode indirectCallNode) {
            Object[] arguments = PArguments.create(3);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, name);
            PArguments.setArgument(arguments, 2, value);
            BuiltinDispatchers.callGenericBuiltin(frame, inliningTarget, slot.callTargetIndex, arguments, callContext, isNullFrameProfile, indirectCallNode);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class CallNativeSlotSetAttrNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "tp_setattr");

        CallNativeSlotSetAttrNode() {
        }

        abstract void execute(VirtualFrame var1, TpSlots var2, TpSlot.TpSlotNative var3, Object var4, Object var5, Object var6);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static void callNative(VirtualFrame frame, TpSlots slots, TpSlot.TpSlotNative slot, Object self, Object name, Object value, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached InlinedConditionProfile isSetAttrProfile, @Cached CExtNodes.AsCharPointerNode asCharPointerNode, @Cached CStructAccess.FreeNode freeNode, @Cached CApiTransitions.PythonToNativeNode nameToNativeNode, @Cached CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached CApiTransitions.PythonToNativeNode valueToNativeNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached ExternalFunctionNodes.CheckInquiryResultNode checkResultNode) {
            Object result;
            assert (PyUnicodeCheckNode.executeUncached(name));
            boolean isSetAttr = isSetAttrProfile.profile(inliningTarget, slots.tp_setattr() == slot);
            Object nameArg = isSetAttr ? asCharPointerNode.execute(name) : nameToNativeNode.execute(name);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, null);
            try {
                result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___GETATTR__, slot.callable, selfToNativeNode.execute(self), nameArg, valueToNativeNode.execute(value));
            }
            finally {
                if (isSetAttr) {
                    freeNode.free(nameArg);
                }
            }
            checkResultNode.execute(threadState, SpecialMethodNames.T___GETATTR__, result);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotSetAttrONode
    extends Node {
        public final void execute(VirtualFrame frame, Node inliningTarget, TpSlots slots, Object self, Object name, Object value) {
            assert (slots.combined_tp_setattro_setattr() != null);
            this.executeImpl(frame, inliningTarget, slots, slots.combined_tp_setattro_setattr(), self, name, value);
        }

        abstract void executeImpl(VirtualFrame var1, Node var2, TpSlots var3, TpSlot var4, Object var5, Object var6, Object var7);

        @Specialization
        static void callManagedSlot(VirtualFrame frame, Node inliningTarget, TpSlots slots, TpSlot.TpSlotManaged slot, Object self, Object name, Object value, @Cached CallManagedSlotSetAttrNode slotNode) {
            slotNode.execute(frame, inliningTarget, slot, self, name, value);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void callNative(VirtualFrame frame, TpSlots slots, TpSlot.TpSlotNative slot, Object self, Object name, Object value, @Cached(inline=false) CallNativeSlotSetAttrNode callNativeSlot) {
            callNativeSlot.execute(frame, slots, slot, self, name, value);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotSetAttrNode
    extends Node {
        public final void execute(VirtualFrame frame, Node inliningTarget, TpSlots slots, Object self, TruffleString name, Object value) {
            assert (slots.combined_tp_setattro_setattr() != null);
            this.executeImpl(frame, inliningTarget, slots, slots.combined_tp_setattro_setattr(), self, name, value);
        }

        abstract void executeImpl(VirtualFrame var1, Node var2, TpSlots var3, TpSlot var4, Object var5, TruffleString var6, Object var7);

        @Specialization
        static void callManagedSlot(VirtualFrame frame, Node inliningTarget, TpSlots slots, TpSlot.TpSlotManaged slot, Object self, TruffleString name, Object value, @Cached CallManagedSlotSetAttrNode slotNode) {
            slotNode.execute(frame, inliningTarget, slot, self, name, value);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static void callNative(VirtualFrame frame, TpSlots slots, TpSlot.TpSlotNative slot, Object self, TruffleString name, Object value, @Cached(inline=false) CallNativeSlotSetAttrNode callNativeSlot) {
            callNativeSlot.execute(frame, slots, slot, self, name, value);
        }
    }

    public static final class TpSlotSetAttrPython
    extends TpSlot.TpSlotPython {
        private final TruffleWeakReference<Object> setattr;
        private final TruffleWeakReference<Object> delattr;
        private final TruffleWeakReference<Object> type;

        public TpSlotSetAttrPython(Object setattr, Object delattr, Object type) {
            this.setattr = TpSlotSetAttrPython.asWeakRef(setattr);
            this.delattr = TpSlotSetAttrPython.asWeakRef(delattr);
            this.type = new TruffleWeakReference(type);
        }

        public static TpSlotSetAttrPython create(Object[] callables, TruffleString[] callableNames, Object type) {
            assert (callables.length == 2);
            assert (callableNames == null || callableNames[0].equals((Object)SpecialMethodNames.T___SETATTR__) && callableNames[1].equals((Object)SpecialMethodNames.T___DELATTR__));
            return new TpSlotSetAttrPython(callables[0], callables[1], type);
        }

        @Override
        public TpSlot.TpSlotPython forNewType(Object klass) {
            Object newSet = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___SETATTR__);
            Object newDel = LookupAttributeInMRONode.Dynamic.getUncached().execute(klass, SpecialMethodNames.T___DELATTR__);
            if (newSet != this.getSetattr() || newDel != this.getDelattr()) {
                return new TpSlotSetAttrPython(newSet, newDel, this.getType());
            }
            return this;
        }

        public Object getSetattr() {
            return this.safeGet(this.setattr);
        }

        public Object getDelattr() {
            return this.safeGet(this.delattr);
        }

        public Object getType() {
            return this.safeGet(this.type);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class SetAttrBuiltinNode
    extends PythonTernaryBuiltinNode {
        public abstract void executeSetAttr(VirtualFrame var1, Object var2, TruffleString var3, Object var4);

        @Override
        public final Object execute(VirtualFrame frame, Object obj, Object nameObj, Object value) {
            this.executeVoid(frame, obj, nameObj, value);
            return PNone.NONE;
        }

        protected abstract void executeVoid(VirtualFrame var1, Object var2, Object var3, Object var4);
    }

    public static abstract class TpSlotSetAttrBuiltin<T extends SetAttrBuiltinNode>
    extends TpSlot.TpSlotSimpleBuiltinBase<T> {
        public static final BuiltinSlotWrapperSignature SET_SIGNATURE = BuiltinSlotWrapperSignature.of(BuiltinSlotWrapperSignature.J_DOLLAR_SELF, "name", "value");
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotSetAttrBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory, BuiltinSlotWrapperSignature.BINARY, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC);
        }

        final SetAttrBuiltinNode createSlotNode() {
            return (SetAttrBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotSetAttrBuiltin.createBuiltinCallTarget(language, SET_SIGNATURE, this.getNodeFactory(), "__setattr__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return switch (wrapper) {
                case ExternalFunctionNodes.PExternalFunctionWrapper.SETATTRO -> this.createBuiltin(core, type, SpecialMethodNames.T___SETATTR__, SET_SIGNATURE, wrapper, this.getNodeFactory());
                case ExternalFunctionNodes.PExternalFunctionWrapper.DELATTRO -> this.createBuiltin(core, type, SpecialMethodNames.T___DELATTR__, BuiltinSlotWrapperSignature.BINARY, wrapper, NodeFactoryUtils.BinaryToTernaryBuiltinNode.wrapFactory(this.getNodeFactory()));
                default -> null;
            };
        }
    }
}

