/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.set.BaseSetBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetStateNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSet, PythonBuiltinClassType.PFrozenSet})
public final class BaseSetBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BaseSetBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BaseSetBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class, SpecialMethodSlot.class})
    protected static abstract class ConvertKeyNode
    extends PNodeWithContext {
        protected ConvertKeyNode() {
        }

        public abstract Object execute(Node var1, Object var2);

        @Specialization(guards={"!isPSet(key)"})
        static Object doNotPSet(Object key) {
            return key;
        }

        @Specialization
        static Object doPSet(Node inliningTarget, PSet key, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached GetClassNode getClassNode, @Cached(parameters={"Hash"}, inline=false) LookupCallableSlotInMRONode lookupHash, @Cached PythonObjectFactory.Lazy factory) {
            Object hashDescr = lookupHash.execute(getClassNode.execute(inliningTarget, key));
            if (hashDescr instanceof PNone) {
                return factory.get(inliningTarget).createFrozenSet(copyNode.execute(inliningTarget, key.getDictStorage()));
            }
            return key;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseGreaterThanNode
    extends PythonBinaryBuiltinNode {
        protected BaseGreaterThanNode() {
        }

        @Specialization
        static boolean isGreaterThan(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen aLenNode, @Cached HashingStorageNodes.HashingStorageLen bLenNode, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys, @Cached InlinedConditionProfile sizeProfile) {
            int len2;
            int len1 = aLenNode.execute(inliningTarget, self.getDictStorage());
            if (sizeProfile.profile(inliningTarget, len1 <= (len2 = bLenNode.execute(inliningTarget, other.getDictStorage())))) {
                return false;
            }
            return BaseGreaterEqualNode.doGE(frame, self, other, inliningTarget, compareKeys);
        }

        @Fallback
        static PNotImplemented doNotImplemented(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseLessThanNode
    extends PythonBinaryBuiltinNode {
        protected BaseLessThanNode() {
        }

        @Specialization
        static boolean isLessThan(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenSelfNode, @Cached HashingStorageNodes.HashingStorageLen lenOtherNode, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys, @Cached InlinedConditionProfile sizeProfile) {
            int len2;
            int len1 = lenSelfNode.execute(inliningTarget, self.getDictStorage());
            if (sizeProfile.profile(inliningTarget, len1 >= (len2 = lenOtherNode.execute(inliningTarget, other.getDictStorage())))) {
                return false;
            }
            return BaseLessEqualNode.doLE(frame, self, other, inliningTarget, compareKeys);
        }

        @Fallback
        static PNotImplemented doNotImplemented(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseGreaterEqualNode
    extends PythonBinaryBuiltinNode {
        protected BaseGreaterEqualNode() {
        }

        @Specialization
        static boolean doGE(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys) {
            return compareKeys.execute((Frame)frame, inliningTarget, other.getDictStorage(), self.getDictStorage()) <= 0;
        }

        @Fallback
        static PNotImplemented doNotImplemented(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseLessEqualNode
    extends PythonBinaryBuiltinNode {
        protected BaseLessEqualNode() {
        }

        @Specialization
        static boolean doLE(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys) {
            return compareKeys.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage()) <= 0;
        }

        @Fallback
        static PNotImplemented doNotImplemented(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="isdisjoint", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseIsDisjointNode
    extends PythonBinaryBuiltinNode {
        protected BaseIsDisjointNode() {
        }

        @Specialization(guards={"self == other"})
        static boolean isDisjointSameObject(PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, self.getDictStorage()) == 0;
        }

        @Specialization(guards={"self != other", "isBuiltinAnySet(other)"})
        static boolean isDisjointFastPath(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageAreDisjoint disjointNode) {
            return disjointNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage());
        }

        @Fallback
        static boolean isDisjointGeneric(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetItem getHashingStorageItem, @Cached PyObjectGetIter getIter, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
            HashingStorage selfStorage = ((PBaseSet)self).getDictStorage();
            Object iterator = getIter.execute((Frame)frame, inliningTarget, other);
            try {
                Object nextValue;
                while (!getHashingStorageItem.hasKey((Frame)frame, inliningTarget, selfStorage, nextValue = getNextNode.execute((Frame)frame, iterator))) {
                }
                return false;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return true;
            }
        }
    }

    @Builtin(name="issuperset", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseIsSupersetNode
    extends PythonBinaryBuiltinNode {
        protected BaseIsSupersetNode() {
        }

        @Specialization
        static boolean isSuperSetGeneric(VirtualFrame frame, PBaseSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys) {
            HashingStorage otherStorage = getHashingStorageNode.execute(frame, inliningTarget, other);
            return compareKeys.execute((Frame)frame, inliningTarget, otherStorage, self.getDictStorage()) <= 0;
        }
    }

    @Builtin(name="issubset", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseIsSubsetNode
    extends PythonBinaryBuiltinNode {
        protected BaseIsSubsetNode() {
        }

        @Specialization
        static boolean isSubSetGeneric(VirtualFrame frame, PBaseSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys) {
            HashingStorage otherStorage = getHashingStorageNode.execute(frame, inliningTarget, other);
            return compareKeys.execute((Frame)frame, inliningTarget, self.getDictStorage(), otherStorage) <= 0;
        }
    }

    @Builtins(value={@Builtin(name="__sub__", minNumOfPositionalArgs=2), @Builtin(name="__rsub__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    static abstract class SubNode
    extends PythonBinaryBuiltinNode {
        SubNode() {
        }

        @Specialization
        static PBaseSet doPBaseSet(VirtualFrame frame, PBaseSet left, PBaseSet right, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile leftProfile, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached PythonObjectFactory factory) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left.getDictStorage(), getHashingStorageNode.execute(frame, inliningTarget, right));
            if (leftProfile.profile(inliningTarget, left instanceof PFrozenSet)) {
                return factory.createFrozenSet(storage);
            }
            return factory.createSet(storage);
        }

        @Fallback
        static Object doOther(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseContainsNode
    extends PythonBinaryBuiltinNode {
        protected BaseContainsNode() {
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PBaseSet self, Object key, @Bind(value="this") Node inliningTarget, @Cached ConvertKeyNode conv, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            return getItem.hasKey((Frame)frame, inliningTarget, self.getDictStorage(), conv.execute(inliningTarget, key));
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    protected static abstract class BaseEqNode
    extends PythonBinaryBuiltinNode {
        protected BaseEqNode() {
        }

        @Specialization
        static boolean doSetSameType(VirtualFrame frame, PBaseSet self, PBaseSet other, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCompareKeys compareKeys) {
            return compareKeys.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage()) == 0;
        }

        @Fallback
        static PNotImplemented doGeneric(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class BaseReduceNode
    extends PythonUnaryBuiltinNode {
        protected BaseReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, PBaseSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey getIterKey, @Cached GetClassNode getClassNode, @Cached PyObjectGetStateNode getStateNode, @Cached PythonObjectFactory factory) {
            HashingStorage storage = self.getDictStorage();
            int len = lenNode.execute(inliningTarget, storage);
            Object[] keysArray = new Object[len];
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            for (int i = 0; i < len; ++i) {
                boolean hasNext = iterNext.execute(inliningTarget, storage, it);
                assert (hasNext);
                keysArray[i] = getIterKey.execute(inliningTarget, storage, it);
            }
            PTuple contents = factory.createTuple(new Object[]{factory.createList(keysArray)});
            Object state = getStateNode.execute(frame, inliningTarget, self);
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), contents, state});
        }
    }

    @Slot(value=Slot.SlotKind.sq_length)
    @GenerateUncached
    @GenerateNodeFactory
    protected static abstract class BaseSetLenSlotNode
    extends TpSlotLen.LenBuiltinNode {
        protected BaseSetLenSlotNode() {
        }

        @Specialization
        public static int len(PBaseSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, self.getDictStorage());
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class BaseIterNode
    extends PythonUnaryBuiltinNode {
        protected BaseIterNode() {
        }

        @Specialization
        static Object doBaseSet(PBaseSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached PythonObjectFactory factory) {
            HashingStorage storage = self.getDictStorage();
            return factory.createBaseSetIterator(self, getIterator.execute(inliningTarget, storage), lenNode.execute(inliningTarget, storage));
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BaseReprNode
    extends PythonUnaryBuiltinNode {
        BaseReprNode() {
        }

        private static void fillItems(VirtualFrame frame, Node inliningTarget, HashingStorage storage, TruffleStringBuilder sb, PyObjectReprAsTruffleStringNode repr, HashingStorageNodes.HashingStorageGetIterator getIter, HashingStorageNodes.HashingStorageIteratorNext iterNext, HashingStorageNodes.HashingStorageIteratorKey iterKey, TruffleStringBuilder.AppendStringNode appendStringNode) {
            boolean first = true;
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LBRACE);
            HashingStorageNodes.HashingStorageIterator it = getIter.execute(inliningTarget, storage);
            while (iterNext.execute(inliningTarget, storage, it)) {
                if (first) {
                    first = false;
                } else {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                }
                appendStringNode.execute(sb, (AbstractTruffleString)repr.execute((Frame)frame, inliningTarget, iterKey.execute(inliningTarget, storage, it)));
            }
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RBRACE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static Object repr(VirtualFrame frame, PBaseSet self, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode repr, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetClassNode getClassNode, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getStorageIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext iteratorNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iteratorKey, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            Object clazz = getClassNode.execute(inliningTarget, self);
            PythonContext ctxt = PythonContext.get(getNameNode);
            int len = lenNode.execute(inliningTarget, self.getDictStorage());
            if (len == 0) {
                appendStringNode.execute(sb, (AbstractTruffleString)getNameNode.execute(inliningTarget, clazz));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_EMPTY_PARENS);
                return toStringNode.execute(sb);
            }
            if (!ctxt.reprEnter(self)) {
                appendStringNode.execute(sb, (AbstractTruffleString)getNameNode.execute(inliningTarget, clazz));
                appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_ELLIPSIS_IN_PARENS);
                return toStringNode.execute(sb);
            }
            try {
                boolean showType;
                boolean bl = showType = clazz != PythonBuiltinClassType.PSet;
                if (showType) {
                    appendStringNode.execute(sb, (AbstractTruffleString)getNameNode.execute(inliningTarget, clazz));
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
                }
                BaseReprNode.fillItems(frame, inliningTarget, self.getDictStorage(), sb, repr, getStorageIterator, iteratorNext, iteratorKey, appendStringNode);
                if (showType) {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
                }
                TruffleString truffleString = toStringNode.execute(sb);
                return truffleString;
            }
            finally {
                ctxt.reprLeave(self);
            }
        }
    }
}

