/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.iterator.PZip;
import com.oracle.graal.python.builtins.objects.iterator.PZipBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PZip})
public final class PZipBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PZipBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, PZip self, Object state, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            self.setStrict(isTrueNode.execute((Frame)frame, inliningTarget, state));
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PZip self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile strictProfile, @Cached GetClassNode getClass, @Cached PythonObjectFactory factory) {
            Object[] objectArray;
            Object type = getClass.execute(inliningTarget, self);
            PTuple tuple = factory.createTuple(self.getIterators());
            if (strictProfile.profile(inliningTarget, self.isStrict())) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = type;
                objectArray2[1] = tuple;
                objectArray = objectArray2;
                objectArray2[2] = true;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = type;
                objectArray = objectArray3;
                objectArray3[1] = tuple;
            }
            Object[] elements = objectArray;
            return factory.createTuple(elements);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doPZip(PZip self) {
            return self;
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isEmpty(self.getIterators())"})
        static Object doEmpty(PZip self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raiseStopIteration();
        }

        @Specialization(guards={"!isEmpty(self.getIterators())", "!self.isStrict()"})
        static Object doNext(VirtualFrame frame, PZip self, @Cached.Shared @Cached GetNextNode next, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object[] iterators = self.getIterators();
            Object[] tupleElements = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                tupleElements[i] = next.execute((Frame)frame, iterators[i]);
            }
            return factory.createTuple(tupleElements);
        }

        @Specialization(guards={"!isEmpty(self.getIterators())", "self.isStrict()"})
        static Object doNext(VirtualFrame frame, PZip self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetNextNode next, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile classProfile, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            int i;
            Object[] iterators = self.getIterators();
            Object[] tupleElements = new Object[iterators.length];
            try {
                for (i = 0; i < iterators.length; ++i) {
                    tupleElements[i] = next.execute((Frame)frame, iterators[i]);
                }
                return factory.createTuple(tupleElements);
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, classProfile);
                if (i > 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ZIP_ARG_D_IS_SHORTER_THEN_ARG_SD, i + 1, i == 1 ? " " : "s 1-", i);
                }
                for (i = 1; i < iterators.length; ++i) {
                    try {
                        next.execute((Frame)frame, iterators[i]);
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ZIP_ARG_D_IS_LONGER_THEN_ARG_SD, i + 1, i == 1 ? " " : "s 1-", i);
                    }
                    catch (PException e2) {
                        e2.expectStopIteration(inliningTarget, classProfile);
                        continue;
                    }
                }
                throw e;
            }
        }
    }
}

