/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;

public final class IntNodes {
    private IntNodes() {
    }

    @GenerateInline(inlineByDefault=true)
    public static abstract class PyLongFromByteArray
    extends Node {
        public abstract Object execute(Node var1, byte[] var2, boolean var3);

        public final Object executeCached(byte[] data, boolean bigEndian) {
            return this.execute(this, data, bigEndian);
        }

        protected static boolean fitsInLong(byte[] data) {
            return data.length <= 8;
        }

        protected static int asWellSizedData(int len) {
            switch (len) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return len;
                }
            }
            return -1;
        }

        @Specialization(guards={"data.length == cachedDataLen"}, limit="4")
        static Object doLong(byte[] data, boolean bigEndian, @Cached(value="asWellSizedData(data.length)") int cachedDataLen) {
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            return support.getLong(data, 0, cachedDataLen);
        }

        @Specialization(guards={"fitsInLong(data)"})
        static long doArbitraryBytesLong(byte[] data, boolean bigEndian) {
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            BigInteger integer = support.getBigInteger(data, 0);
            return PInt.longValue(integer);
        }

        @Specialization(guards={"!fitsInLong(data)"})
        static Object doPInt(byte[] data, boolean bigEndian, @Cached(inline=false) PythonObjectFactory factory) {
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            return factory.createInt(support.getBigInteger(data, 0));
        }
    }

    @GenerateInline(inlineByDefault=true)
    public static abstract class PyLongAsByteArray
    extends Node {
        public abstract byte[] execute(Node var1, Object var2, int var3, boolean var4);

        public final byte[] executeCached(Object value, int size, boolean bigEndian) {
            return this.execute(this, value, size, bigEndian);
        }

        protected static int asWellSizedData(int len) {
            switch (len) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return len;
                }
            }
            return -1;
        }

        @Specialization(guards={"size == cachedDataLen"}, limit="4")
        static byte[] doPrimitive(long value, int size, boolean bigEndian, @Cached(value="asWellSizedData(size)") int cachedDataLen) {
            byte[] bytes = new byte[size];
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            support.putLong(bytes, 0, value, cachedDataLen);
            return bytes;
        }

        @Specialization
        static byte[] doArbitraryBytesLong(Node inliningTarget, long value, int size, boolean bigEndian, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            byte[] bytes = new byte[size];
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            try {
                support.putBigInteger(bytes, 0, PInt.longToBigInteger(value), size);
            }
            catch (OverflowException oe) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_LARGE_TO_CONVERT, "int");
            }
            return bytes;
        }

        @Specialization
        static byte[] doPInt(Node inliningTarget, PInt value, int size, boolean bigEndian, @Cached.Shared(value="raiseNode") @Cached PRaiseNode.Lazy raiseNode) {
            byte[] bytes = new byte[size];
            NumericSupport support = bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
            try {
                support.putBigInteger(bytes, 0, value.getValue(), size);
            }
            catch (OverflowException oe) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.TOO_LARGE_TO_CONVERT, "int");
            }
            return bytes;
        }
    }

    @GenerateInline(value=false)
    public static abstract class PyLongNumBits
    extends Node {
        public abstract int execute(Object var1);

        @Specialization
        static int doInt(int value) {
            return 32 - Integer.numberOfLeadingZeros(Math.abs(value));
        }

        @Specialization
        static int doLong(long value) {
            return 64 - Long.numberOfLeadingZeros(Math.abs(value));
        }

        @Specialization
        static int doPInt(PInt value) {
            return value.bitLength();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PyLongSign
    extends Node {
        public abstract int execute(Object var1);

        @Specialization
        static int doInt(int value) {
            return Integer.compare(value, 0);
        }

        @Specialization
        static int doLong(long value) {
            return Long.compare(value, 0L);
        }

        @Specialization
        static int doPInt(PInt value) {
            return value.compareTo(0L);
        }
    }
}

