/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.function;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinFunctionBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.bytecode.ImportNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBuiltinFunction, PythonBuiltinClassType.WrapperDescriptor})
public final class BuiltinFunctionBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BuiltinFunctionBuiltinsFactory.getFactories();
    }

    @Builtin(name="__signature__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class SignatureNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doIt(PBuiltinFunction fun) {
            return SignatureNode.createInspectSignagure(fun.getSignature(), false);
        }

        @CompilerDirectives.TruffleBoundary
        public static Object createInspectSignagure(Signature signature, boolean skipSelf) {
            PythonModule inspect = ImportNode.importModule(PythonUtils.tsLiteral("inspect"));
            Object inspectSignature = PyObjectGetAttr.executeUncached(inspect, PythonUtils.tsLiteral("Signature"));
            Object inspectParameter = PyObjectGetAttr.executeUncached(inspect, PythonUtils.tsLiteral("Parameter"));
            Object[] parameterKinds = new Object[ParameterKinds.VALUES.length];
            TruffleString[] keywordNames = signature.getKeywordNames();
            boolean takesVarArgs = signature.takesVarArgs();
            boolean takesVarKeywordArgs = signature.takesVarKeywordArgs();
            TruffleString[] parameterNames = signature.getParameterIds();
            Object kind = ParameterKinds.POSITIONAL_ONLY.get(parameterKinds, inspectParameter);
            ArrayList<Object> parameters = new ArrayList<Object>();
            CallNode callNode = CallNode.getUncached();
            for (int i = 0; i < parameterNames.length; ++i) {
                TruffleString name;
                if (i == 0 && BuiltinFunctionRootNode.T_DOLLAR_DECL_TYPE.equalsUncached((AbstractTruffleString)parameterNames[i], PythonUtils.TS_ENCODING)) continue;
                if (skipSelf) {
                    skipSelf = false;
                    continue;
                }
                if (signature.getPositionalOnlyArgIndex() == i) {
                    kind = ParameterKinds.POSITIONAL_OR_KEYWORD.get(parameterKinds, inspectParameter);
                }
                if ((name = parameterNames[i]).codePointAtIndexUncached(0, PythonUtils.TS_ENCODING) == 36) {
                    name = name.substringUncached(1, name.codePointLengthUncached(PythonUtils.TS_ENCODING) - 1, PythonUtils.TS_ENCODING, true);
                }
                parameters.add(callNode.executeWithoutFrame(inspectParameter, name, kind));
            }
            if (takesVarArgs) {
                parameters.add(callNode.executeWithoutFrame(inspectParameter, StringLiterals.T_ARGS, ParameterKinds.VAR_POSITIONAL.get(parameterKinds, inspectParameter)));
            }
            for (TruffleString keywordName : keywordNames) {
                parameters.add(callNode.executeWithoutFrame(inspectParameter, keywordName, ParameterKinds.KEYWORD_ONLY.get(parameterKinds, inspectParameter)));
            }
            if (takesVarKeywordArgs) {
                parameters.add(callNode.executeWithoutFrame(inspectParameter, StringLiterals.T_KWARGS, ParameterKinds.VAR_KEYWORD.get(parameterKinds, inspectParameter)));
            }
            return callNode.executeWithoutFrame(inspectSignature, PythonObjectFactory.getUncached().createTuple(parameters.toArray()));
        }

        private static enum ParameterKinds {
            POSITIONAL_ONLY,
            POSITIONAL_OR_KEYWORD,
            VAR_POSITIONAL,
            KEYWORD_ONLY,
            VAR_KEYWORD;

            static final ParameterKinds[] VALUES;

            Object get(Object[] kinds, Object inspectParameter) {
                if (kinds[this.ordinal()] == null) {
                    kinds[this.ordinal()] = PyObjectGetAttr.executeUncached(inspectParameter, PythonUtils.toTruffleStringUncached(this.name()));
                }
                return kinds[this.ordinal()];
            }

            static {
                VALUES = ParameterKinds.values();
            }
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doBuiltinFunc(VirtualFrame frame, PBuiltinFunction func, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached PythonObjectFactory factory) {
            PythonModule builtins = this.getContext().getBuiltins();
            Object getattr = getAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_GETATTR);
            PTuple args = factory.createTuple(new Object[]{func.getEnclosingType(), func.getName()});
            return factory.createTuple(new Object[]{getattr, args});
        }
    }

    @Builtin(name="__objclass__", minNumOfPositionalArgs=1, isGetter=true)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class ObjclassNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getEnclosingType() == null"})
        static Object objclassMissing(PBuiltinFunction self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "builtin_function_or_method", "__objclass__");
        }

        @Specialization(guards={"self.getEnclosingType() != null"})
        static Object objclass(PBuiltinFunction self) {
            return self.getEnclosingType();
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class QualnameNode
    extends PythonBinaryBuiltinNode {
        QualnameNode() {
        }

        @Specialization(guards={"isNoValue(noValue)"})
        static TruffleString getQualname(PBuiltinFunction self, PNone noValue) {
            return self.getQualname();
        }

        @Specialization(guards={"!isNoValue(value)"})
        static TruffleString setQualname(PBuiltinFunction self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_IS_NOT_WRITABLE, "__qualname__", "builtin function");
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class NameNode
    extends PythonBinaryBuiltinNode {
        NameNode() {
        }

        @Specialization(guards={"isNoValue(noValue)"})
        static TruffleString getName(PBuiltinFunction self, PNone noValue) {
            return self.getName();
        }

        @Specialization(guards={"!isNoValue(value)"})
        static TruffleString setName(PBuiltinFunction self, Object value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.AttributeError, ErrorMessages.ATTR_S_OF_S_IS_NOT_WRITABLE, "__name__", "builtin function");
        }
    }
}

