/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.complex;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.lib.PyComplexCheckExactNode;
import com.oracle.graal.python.lib.PyComplexCheckNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyFloatCheckNode;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.ComplexFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingUtils;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PComplex})
public final class ComplexBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ComplexBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ComplexBuiltinsFactory.getFactories();
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends PythonUnaryBuiltinNode {
        ConjugateNode() {
        }

        @Specialization
        static PComplex hash(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PythonObjectFactory factory) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return factory.createComplex(c.getReal(), -c.getImag());
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long doPComplex(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            long realHash = PyObjectHashNode.hash(c.getReal());
            long imagHash = PyObjectHashNode.hash(c.getImag());
            return realHash + 1000003L * imagHash;
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static double get(PComplex self) {
            return self.getImag();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static double getNative(PythonAbstractNativeObject self, @Cached CStructAccess.ReadDoubleNode read) {
            return read.readFromObj(self, CFields.PyComplexObject__cval__imag);
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends PythonBuiltinNode {
        RealNode() {
        }

        @Specialization
        static double get(PComplex self) {
            return self.getReal();
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static double getNative(PythonAbstractNativeObject self, @Cached CStructAccess.ReadDoubleNode read) {
            return read.readFromObj(self, CFields.PyComplexObject__cval__real);
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends PythonUnaryBuiltinNode {
        GetNewArgsNode() {
        }

        @Specialization
        static PTuple get(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PythonObjectFactory factory) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return factory.createTuple(new Object[]{c.getReal(), c.getImag()});
        }
    }

    @Builtin(name="__pos__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class PosNode
    extends PythonUnaryBuiltinNode {
        PosNode() {
        }

        @Specialization
        static PComplex pos(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PythonObjectFactory factory) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return factory.createComplex(c.getReal(), c.getImag());
        }
    }

    @Builtin(name="__neg__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class NegNode
    extends PythonUnaryBuiltinNode {
        NegNode() {
        }

        @Specialization
        static PComplex neg(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PythonObjectFactory factory) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return factory.createComplex(-c.getReal(), -c.getImag());
        }
    }

    @Slot(value=Slot.SlotKind.nb_bool)
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class BoolNode
    extends TpSlotInquiry.NbBoolBuiltinNode {
        BoolNode() {
        }

        @Specialization
        static boolean bool(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return c.getReal() != 0.0 || c.getImag() != 0.0;
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ComplexBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static TruffleString format(Object self, TruffleString formatString, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            InternalFormat.Spec spec = InternalFormat.fromText(formatString, '\uffff', '>', inliningTarget);
            FormatNode.validateSpec(inliningTarget, spec, raiseNode);
            return FormatNode.doFormat(inliningTarget, c.getReal(), c.getImag(), spec);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString doFormat(Node raisingNode, double real, double imag, InternalFormat.Spec spec) {
            ComplexFormatter formatter = new ComplexFormatter(FormattingUtils.validateForFloat(spec, "complex", raisingNode), raisingNode);
            formatter.format(real, imag);
            return formatter.pad().getResult();
        }

        private static void validateSpec(Node inliningTarget, InternalFormat.Spec spec, PRaiseNode.Lazy raiseNode) {
            if (spec.getFill(' ') == '0') {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ZERO_PADDING_NOT_ALLOWED_FOR_COMPLEX_FMT);
            }
            char align = spec.getAlign('>');
            if (align == '=') {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.S_ALIGNMENT_FLAG_NOT_ALLOWED_FOR_COMPLEX_FMT, Character.valueOf(align));
            }
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static TruffleString repr(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode) {
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return ReprNode.doFormat(inliningTarget, c.getReal(), c.getImag());
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString doFormat(Node inliningTarget, double real, double imag) {
            ComplexFormatter formatter = new ComplexFormatter(new InternalFormat.Spec(-1, '\uffff'), inliningTarget);
            formatter.format(real, imag);
            return formatter.pad().getResult();
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        LtNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        GtNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }

        @Specialization
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }

        @Specialization
        static Object doComplex(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached ComplexEqNode complexEqNode) {
            Object res = complexEqNode.execute(inliningTarget, left, right);
            if (res == PNotImplemented.NOT_IMPLEMENTED) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return (Boolean)res == false;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        static Object doComplex(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached ComplexEqNode complexEqNode) {
            return complexEqNode.execute(inliningTarget, left, right);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ComplexEqNode
    extends Node {
        ComplexEqNode() {
        }

        public abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization
        static Object doComplex(PComplex left, PComplex right) {
            return left.getReal() == right.getReal() && left.getImag() == right.getImag();
        }

        @Specialization(guards={"check.execute(inliningTarget, rightObj)"}, limit="1")
        static Object doComplex(Node inliningTarget, Object leftObj, Object rightObj, @Cached PyComplexCheckNode check, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft, @Cached.Exclusive @Cached ToComplexValueNode toComplexRight) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            return left.getReal() == right.getReal() && left.getImag() == right.getImag();
        }

        @Specialization
        static boolean doComplexDouble(Node inliningTarget, Object leftObj, double right, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            return left.getImag() == 0.0 && left.getReal() == right;
        }

        @Specialization
        static boolean doComplexInt(Node inliningTarget, Object leftObj, long right, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft, @Cached InlinedConditionProfile longFitsToDoubleProfile) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            return left.getImag() == 0.0 && FloatBuiltins.ComparisonHelperNode.compareDoubleToLong(inliningTarget, left.getReal(), right, longFitsToDoubleProfile) == 0.0;
        }

        @Specialization
        static boolean doComplexInt(Node inliningTarget, Object leftObj, PInt right, @Cached.Exclusive @Cached ToComplexValueNode toComplexLeft) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            return left.getImag() == 0.0 && FloatBuiltins.ComparisonHelperNode.compareDoubleToLargeInt(left.getReal(), right) == 0.0;
        }

        @Fallback
        static PNotImplemented doNotImplemented(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rpow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, reverseOperation=true), @Builtin(name="__pow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class PowerNode
    extends PythonTernaryBuiltinNode {
        PowerNode() {
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(Object leftObj, Object rightObj, PNone mod, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached InlinedBranchProfile rightZeroProfile, @Cached InlinedBranchProfile leftZeroProfile, @Cached InlinedBranchProfile smallPositiveProfile, @Cached InlinedBranchProfile smallNegativeProfile, @Cached InlinedBranchProfile complexProfile, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PComplex result;
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (right.getReal() == 0.0 && right.getImag() == 0.0) {
                rightZeroProfile.enter(inliningTarget);
                result = factory.createComplex(1.0, 0.0);
            } else if (left.getReal() == 0.0 && left.getImag() == 0.0) {
                leftZeroProfile.enter(inliningTarget);
                if (right.getImag() != 0.0 || right.getReal() < 0.0) {
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.ZeroDivisionError, ErrorMessages.COMPLEX_ZERO_TO_NEGATIVE_POWER);
                }
                result = factory.createComplex(0.0, 0.0);
            } else if (right.getImag() == 0.0 && right.getReal() == (double)((int)right.getReal()) && right.getReal() < 100.0 && right.getReal() > -100.0) {
                if (right.getReal() >= 0.0) {
                    smallPositiveProfile.enter(inliningTarget);
                    result = PowerNode.complexToSmallPositiveIntPower(left, (int)right.getReal(), factory);
                } else {
                    smallNegativeProfile.enter(inliningTarget);
                    result = DivNode.doubleDivComplex(1.0, PowerNode.complexToSmallPositiveIntPower(left, -((int)right.getReal()), factory), factory);
                }
            } else {
                complexProfile.enter(inliningTarget);
                result = PowerNode.complexToComplexBoundary(left.getReal(), left.getImag(), right.getReal(), right.getImag(), factory);
            }
            if (Double.isInfinite(result.getReal()) || Double.isInfinite(result.getImag())) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.COMPLEX_EXPONENTIATION);
            }
            return result;
        }

        @Specialization(guards={"!isPNone(mod)"})
        @HostCompilerDirectives.InliningCutoff
        static Object error(Object left, Object right, Object mod, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.COMPLEX_MODULO);
        }

        private static PComplex complexToSmallPositiveIntPower(ComplexValue x, long n, PythonObjectFactory factory) {
            ComplexValue r = new ComplexValue(1.0, 0.0);
            ComplexValue p = x;
            for (long mask = 1L; mask > 0L && n >= mask; mask <<= 1) {
                if ((n & mask) != 0L) {
                    r = MulNode.multiply(r, p);
                }
                p = MulNode.multiply(p, p);
            }
            return factory.createComplex(r.getReal(), r.getImag());
        }

        @CompilerDirectives.TruffleBoundary
        private static PComplex complexToComplexBoundary(double leftRead, double leftImag, double rightReal, double rightImag, PythonObjectFactory factory) {
            double vabs = Math.hypot(leftRead, leftImag);
            double len = Math.pow(vabs, rightReal);
            double at = Math.atan2(leftImag, leftRead);
            double phase = at * rightReal;
            if (rightImag != 0.0) {
                len /= Math.exp(at * rightImag);
                phase += rightImag * Math.log(vabs);
            }
            PComplex result = factory.createComplex(len * Math.cos(phase), len * Math.sin(phase));
            return result;
        }
    }

    @Builtins(value={@Builtin(name="__rsub__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__sub__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class SubNode
    extends PythonBinaryBuiltinNode {
        SubNode() {
        }

        static PComplex doComplex(PComplex left, double right, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createComplex(left.getReal() - right, left.getImag());
        }

        @Specialization
        static PComplex doComplex(PComplex left, int right, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createComplex(left.getReal() - (double)right, left.getImag());
        }

        @Specialization
        static Object doComplex(Object leftObj, Object rightObj, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return factory.createComplex(left.getReal() - right.getReal(), left.getImag() - right.getImag());
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doComplex(Object leftObj, Object rightObj, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached PythonObjectFactory factory) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            ComplexValue res = MulNode.multiply(left, right);
            return factory.createComplex(res.getReal(), res.getImag());
        }

        static ComplexValue multiply(ComplexValue left, ComplexValue right) {
            double newReal = left.getReal() * right.getReal() - left.getImag() * right.getImag();
            double newImag = left.getReal() * right.getImag() + left.getImag() * right.getReal();
            return new ComplexValue(newReal, newImag);
        }
    }

    @Builtins(value={@Builtin(name="__rtruediv__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__truediv__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    public static abstract class DivNode
    extends PythonBinaryBuiltinNode {
        public abstract PComplex executeComplex(VirtualFrame var1, Object var2, Object var3);

        @NeverDefault
        public static DivNode create() {
            return ComplexBuiltinsFactory.DivNodeFactory.create();
        }

        @Specialization
        static Object doComplex(Object leftObj, Object rightObj, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached InlinedConditionProfile topConditionProfile, @Cached InlinedConditionProfile zeroDivisionProfile, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            double imag;
            double real;
            double absRightImag;
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            double absRightReal = right.getReal() < 0.0 ? -right.getReal() : right.getReal();
            if (topConditionProfile.profile(inliningTarget, absRightReal >= (absRightImag = right.getImag() < 0.0 ? -right.getImag() : right.getImag()))) {
                if (zeroDivisionProfile.profile(inliningTarget, absRightReal == 0.0)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_BY_ZERO, "complex");
                }
                double ratio = right.getImag() / right.getReal();
                double denom = right.getReal() + right.getImag() * ratio;
                real = (left.getReal() + left.getImag() * ratio) / denom;
                imag = (left.getImag() - left.getReal() * ratio) / denom;
            } else {
                double ratio = right.getReal() / right.getImag();
                double denom = right.getReal() * ratio + right.getImag();
                real = (left.getReal() * ratio + left.getImag()) / denom;
                imag = (left.getImag() * ratio - left.getReal()) / denom;
            }
            return factory.createComplex(real, imag);
        }

        static PComplex doubleDivComplex(double left, PComplex right, PythonObjectFactory factory) {
            double oprealSq = right.getReal() * right.getReal();
            double opimagSq = right.getImag() * right.getImag();
            double realPart = right.getReal() * left;
            double imagPart = right.getImag() * left;
            double denom = oprealSq + opimagSq;
            return factory.createComplex(realPart / denom, -imagPart / denom);
        }
    }

    @Builtins(value={@Builtin(name="__radd__", minNumOfPositionalArgs=2), @Builtin(name="__add__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        AddNode() {
        }

        @Specialization
        static PComplex doInt(PComplex left, int right, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createComplex(left.getReal() + (double)right, left.getImag());
        }

        @Specialization
        static PComplex doDouble(PComplex left, double right, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createComplex(left.getReal() + right, left.getImag());
        }

        @Specialization
        static Object doGeneric(Object leftObj, Object rightObj, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexLeft, @Cached ToComplexValueNode toComplexRight, @Cached InlinedConditionProfile notImplementedProfile, @Cached.Shared @Cached PythonObjectFactory factory) {
            ComplexValue left = toComplexLeft.execute(inliningTarget, leftObj);
            ComplexValue right = toComplexRight.execute(inliningTarget, rightObj);
            if (notImplementedProfile.profile(inliningTarget, left == null || right == null)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return factory.createComplex(left.getReal() + right.getReal(), left.getImag() + right.getImag());
        }
    }

    @Builtin(name="__abs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        private static final long MASK_NON_SIGN_LONG = Long.MAX_VALUE;

        public abstract double executeDouble(Object var1);

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static double abs(Object self, @Bind(value="this") Node inliningTarget, @Cached ToComplexValueNode toComplexValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            double scaledY;
            int expY;
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            double x = c.getReal();
            double y = c.getImag();
            if (Double.isInfinite(x) || Double.isInfinite(y)) {
                return Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(x) || Double.isNaN(y)) {
                return Double.NaN;
            }
            int expX = AbsNode.getExponent(x);
            if (expX > (expY = AbsNode.getExponent(y)) + 27) {
                return AbsNode.abs(x);
            }
            if (expY > expX + 27) {
                return AbsNode.abs(y);
            }
            int middleExp = (expX + expY) / 2;
            double scaledX = AbsNode.scalb(x, -middleExp);
            double scaledH = Math.sqrt(scaledX * scaledX + (scaledY = AbsNode.scalb(y, -middleExp)) * scaledY);
            double r = AbsNode.scalb(scaledH, middleExp);
            if (Double.isInfinite(r)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.ABSOLUTE_VALUE_TOO_LARGE);
            }
            return r;
        }

        static double abs(double x) {
            return Double.longBitsToDouble(Long.MAX_VALUE & Double.doubleToRawLongBits(x));
        }

        static double scalb(double d, int n) {
            if (n > -1023 && n < 1024) {
                return d * Double.longBitsToDouble((long)(n + 1023) << 52);
            }
            if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
                return d;
            }
            if (n < -2098) {
                return d > 0.0 ? 0.0 : -0.0;
            }
            if (n > 2097) {
                return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            long bits = Double.doubleToRawLongBits(d);
            long sign = bits & Long.MIN_VALUE;
            int exponent = (int)(bits >>> 52) & 0x7FF;
            long mantissa = bits & 0xFFFFFFFFFFFFFL;
            int scaledExponent = exponent + n;
            if (n < 0) {
                if (scaledExponent > 0) {
                    return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
                }
                if (scaledExponent > -53) {
                    long mostSignificantLostBit = (mantissa |= 0x10000000000000L) & 1L << -scaledExponent;
                    mantissa >>>= 1 - scaledExponent;
                    if (mostSignificantLostBit != 0L) {
                        ++mantissa;
                    }
                    return Double.longBitsToDouble(sign | mantissa);
                }
                return sign == 0L ? 0.0 : -0.0;
            }
            if (exponent == 0) {
                while (mantissa >>> 52 != 1L) {
                    mantissa <<= 1;
                    --scaledExponent;
                }
                mantissa &= 0xFFFFFFFFFFFFFL;
                if (++scaledExponent < 2047) {
                    return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
                }
                return sign == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
            if (scaledExponent < 2047) {
                return Double.longBitsToDouble(sign | (long)scaledExponent << 52 | mantissa);
            }
            return sign == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }

        static int getExponent(double d) {
            return (int)(Double.doubleToRawLongBits(d) >>> 52 & 0x7FFL) - 1023;
        }

        @NeverDefault
        public static AbsNode create() {
            return ComplexBuiltinsFactory.AbsNodeFactory.create();
        }
    }

    @Builtin(name="__complex__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ComplexNode
    extends PythonUnaryBuiltinNode {
        ComplexNode() {
        }

        @Specialization
        static Object complex(Object self, @Bind(value="this") Node inliningTarget, @Cached PyComplexCheckExactNode check, @Cached ToComplexValueNode toComplexValueNode, @Cached PythonObjectFactory.Lazy factory) {
            if (check.execute(inliningTarget, self)) {
                return self;
            }
            ComplexValue c = toComplexValueNode.execute(inliningTarget, self);
            return factory.get(inliningTarget).createComplex(c.real, c.imag);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class ToComplexValueNode
    extends Node {
        ToComplexValueNode() {
        }

        public abstract ComplexValue execute(Node var1, Object var2);

        @Specialization
        static ComplexValue doComplex(PComplex v) {
            return new ComplexValue(v.getReal(), v.getImag());
        }

        @Specialization(guards={"check.execute(inliningTarget, v)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static ComplexValue doNative(Node inliningTarget, PythonAbstractNativeObject v, @Cached PyComplexCheckNode check, @Cached(inline=false) CStructAccess.ReadDoubleNode read) {
            double real = read.readFromObj(v, CFields.PyComplexObject__cval__real);
            double imag = read.readFromObj(v, CFields.PyComplexObject__cval__imag);
            return new ComplexValue(real, imag);
        }

        @Specialization
        static ComplexValue doInt(int v) {
            return new ComplexValue(v, 0.0);
        }

        @Specialization
        static ComplexValue doDouble(double v) {
            return new ComplexValue(v, 0.0);
        }

        @Specialization(guards={"check.execute(inliningTarget, v)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static ComplexValue doIntGeneric(Node inliningTarget, Object v, @Cached PyLongCheckNode check, @Cached PyLongAsDoubleNode longAsDoubleNode) {
            return new ComplexValue(longAsDoubleNode.execute(inliningTarget, v), 0.0);
        }

        @Specialization(guards={"check.execute(inliningTarget, v)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static ComplexValue doFloatGeneric(Node inliningTarget, Object v, @Cached PyFloatCheckNode check, @Cached PyFloatAsDoubleNode floatAsDoubleNode) {
            return new ComplexValue(floatAsDoubleNode.execute(null, inliningTarget, v), 0.0);
        }

        @Fallback
        static ComplexValue doOther(Node inliningTarget, Object v) {
            return null;
        }
    }

    @CompilerDirectives.ValueType
    static final class ComplexValue {
        private final double real;
        private final double imag;

        ComplexValue(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        public double getReal() {
            return this.real;
        }

        public double getImag() {
            return this.imag;
        }
    }
}

