/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PyCFunctionWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.logging.Level;

public record PyMethodDefHelper(TruffleString name, Object meth, int flags, TruffleString doc) {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PyMethodDefHelper.class);

    private static Object getMethFromBuiltinFunction(CApiContext cApiContext, PBuiltinFunction object) {
        PKeyword[] kwDefaults = object.getKwDefaults();
        for (int i = 0; i < kwDefaults.length; ++i) {
            if (!ExternalFunctionNodes.KW_CALLABLE.equals((Object)kwDefaults[i].getName())) continue;
            LOGGER.warning("re-creating PyMethodDef for native function " + String.valueOf(object));
            return kwDefaults[i].getValue();
        }
        return PyCFunctionWrapper.createFromBuiltinFunction(cApiContext, object);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object create(CApiContext cApiContext, PBuiltinFunction builtinFunction) {
        TruffleString doc;
        Object docObj = builtinFunction.getAttribute(SpecialAttributeNames.T___DOC__);
        if (docObj instanceof PNone) {
            doc = null;
        } else {
            try {
                doc = CastToTruffleStringNode.executeUncached(docObj);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }
        PyMethodDefHelper pyMethodDef = new PyMethodDefHelper(builtinFunction.getName(), PyMethodDefHelper.getMethFromBuiltinFunction(cApiContext, builtinFunction), builtinFunction.getFlags(), doc);
        Object result = cApiContext.getOrAllocateNativePyMethodDef(pyMethodDef);
        HiddenAttr.WriteNode.executeUncached(builtinFunction, HiddenAttr.METHOD_DEF_PTR, result);
        return result;
    }

    public static Object create(CApiContext cApiContext, PBuiltinMethod builtinMethod) {
        return PyMethodDefHelper.create(cApiContext, builtinMethod.getBuiltinFunction());
    }

    @CompilerDirectives.TruffleBoundary
    Object allocate() {
        Object docWrapper;
        CArrayWrappers.CStringWrapper nameWrapper;
        CStructAccess.AllocateNode allocNode = CStructAccessFactory.AllocateNodeGen.getUncached();
        CStructAccess.WritePointerNode writePointerNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        CStructAccess.WriteIntNode writeIntNode = CStructAccessFactory.WriteIntNodeGen.getUncached();
        assert (this.name != null);
        try {
            nameWrapper = new CArrayWrappers.CStringWrapper(this.name);
        }
        catch (CannotCastException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
        }
        if (this.doc == null) {
            docWrapper = PythonContext.get(null).getNativeNull();
        } else {
            try {
                docWrapper = new CArrayWrappers.CStringWrapper(this.doc);
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }
        Object mem = allocNode.alloc(CStructs.PyMethodDef);
        writePointerNode.write(mem, CFields.PyMethodDef__ml_name, nameWrapper);
        writePointerNode.write(mem, CFields.PyMethodDef__ml_meth, this.meth);
        writeIntNode.write(mem, CFields.PyMethodDef__ml_flags, this.flags);
        writePointerNode.write(mem, CFields.PyMethodDef__ml_doc, docWrapper);
        LOGGER.fine(() -> String.format("Allocated PyMethodDef(%s, %s, %d, %s) at %s", this.name, this.meth, this.flags, this.doc, PythonUtils.formatPointer(mem)));
        return mem;
    }

    static void free(Object pointer) {
        CompilerAsserts.neverPartOfCompilation();
        CStructAccess.ReadPointerNode readPointerNode = CStructAccess.ReadPointerNode.getUncached();
        LOGGER.fine(() -> "Freeing PyMethodDef at " + PythonUtils.formatPointer(pointer));
        Object namePointer = readPointerNode.read(pointer, CFields.PyMethodDef__ml_name);
        Object docPointer = readPointerNode.read(pointer, CFields.PyMethodDef__ml_doc);
        if (LOGGER.isLoggable(Level.FINER)) {
            Object meth;
            CStructAccess.ReadI32Node readIntNode = CStructAccessFactory.ReadI32NodeGen.getUncached();
            assert (!PGuards.isNullOrZero(namePointer, InteropLibrary.getUncached()));
            TruffleString name = CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(namePointer, false);
            TruffleString doc = null;
            if (PGuards.isNullOrZero(namePointer, InteropLibrary.getUncached())) {
                doc = CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(docPointer, false);
            }
            int flags = readIntNode.read(pointer, CFields.PyMethodDef__ml_flags);
            Object methPointer = readPointerNode.read(pointer, CFields.PyMethodDef__ml_meth);
            InteropLibrary methPointerLib = InteropLibrary.getUncached((Object)methPointer);
            if (methPointerLib.isPointer(methPointer)) {
                try {
                    meth = PythonContext.get(null).getCApiContext().getClosureDelegate(methPointerLib.asPointer(methPointer));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            } else {
                assert (methPointer instanceof PythonNativeWrapper);
                meth = methPointer;
            }
            LOGGER.finer(String.format("PyMethodDef(%s, %s, %d, %s) at %s freed.", name, meth, flags, doc, PythonUtils.formatPointer(pointer)));
        }
        if (namePointer instanceof CArrayWrappers.CStringWrapper) {
            CArrayWrappers.CStringWrapper nameWrapper = (CArrayWrappers.CStringWrapper)namePointer;
            nameWrapper.free();
        } else {
            CStructAccess.FreeNode.executeUncached(namePointer);
        }
        if (docPointer instanceof CArrayWrappers.CStringWrapper) {
            CArrayWrappers.CStringWrapper docWrapper = (CArrayWrappers.CStringWrapper)docPointer;
            docWrapper.free();
        } else if (PGuards.isNullOrZero(docPointer, InteropLibrary.getUncached())) {
            CStructAccess.FreeNode.executeUncached(docPointer);
        }
        CStructAccess.FreeNode.executeUncached(pointer);
    }
}

