/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCApiAssertions;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinRegistry;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyCFunctionWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyDateTimeCAPIWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyMethodDefHelper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PyTruffleObjectFree;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.SlotMethodDef;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.thread.PLock;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.Function;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.Supplier;
import com.oracle.graal.python.util.WeakIdentityHashMap;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.VarHandle;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageInfo;
import sun.misc.Unsafe;

public final class CApiContext
extends CExtContext {
    public static final String LOGGER_CAPI_NAME = "capi";
    public static final int PY_NSMALLNEGINTS = 5;
    public static final int PY_NSMALLPOSINTS = 257;
    private static final Source MODINIT_SRC = Source.newBuilder((String)"nfi", (CharSequence)"():POINTER", (String)"modinit").build();
    public static final int DEFAULT_RECURSION_LIMIT = 1000;
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger("capi");
    private static final int MAX_COLLECTION_RETRIES = 17;
    private long allocatedMemory = 0L;
    private Map<Object, AllocInfo> allocatedNativeMemory;
    private TraceMallocDomain[] traceMallocDomains;
    private Map<Object, AllocInfo> freedNativeMemory;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PythonNativeWrapper.PythonAbstractObjectNativeWrapper[] singletonNativePtrs;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final PrimitiveNativeWrapper[] primitiveNativeWrapperCache;
    private Object nativeSmallIntsArray;
    private final HashMap<Pair<TruffleString, TruffleString>, PythonModule> extensions = new HashMap(4);
    private PDict internedUnicode;
    private final ArrayList<Object> modulesByIndex = new ArrayList(0);
    public final HashMap<Long, PLock> locks = new HashMap();
    public final AtomicLong lockId = new AtomicLong();
    private final ConcurrentHashMap<Long, ThreadLocal<Object>> tssStorage = new ConcurrentHashMap();
    private final AtomicLong nextTssKey = new AtomicLong();
    public Object timezoneType;
    private PyCapsule pyDateTimeCAPICapsule;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static Object[] nativeSymbolCacheSingleContext;
    private static boolean nativeSymbolCacheSingleContextUsed;
    private final Object[] nativeSymbolCache;
    private final HashMap<Object, ClosureInfo> callableClosureByExecutable = new HashMap();
    private final HashMap<Long, ClosureInfo> callableClosures = new HashMap();
    private final HashMap<PyMethodDefHelper, Object> methodDefinitions = new HashMap(4);
    private final List<Object> loadedExtensions = new LinkedList<Object>();
    private static AtomicBoolean nativeCAPILoaded;
    private static AtomicBoolean warnedSecondContexWithNativeCAPI;
    private Runnable nativeFinalizerRunnable;
    private Thread nativeFinalizerShutdownHook;
    private final WeakIdentityHashMap<PythonManagedClass, PyProcsWrapper[]> procWrappers = new WeakIdentityHashMap();
    private final ConcurrentHashMap<Object, PyCFunctionWrapper> pyCFunctionWrappers = new ConcurrentHashMap(4);

    public static TruffleLogger getLogger(Class<?> clazz) {
        return PythonLanguage.getLogger("capi." + clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CApiContext(PythonContext context, Object llvmLibrary, boolean useNativeBackend) {
        super(context, llvmLibrary, useNativeBackend);
        this.nativeSymbolCache = new Object[NativeCAPISymbol.values().length];
        Class<CApiContext> clazz = CApiContext.class;
        synchronized (CApiContext.class) {
            int i;
            if (!nativeSymbolCacheSingleContextUsed && context.getLanguage().isSingleContext()) {
                assert (nativeSymbolCacheSingleContext == null);
                assert (!ImageInfo.inImageBuildtimeCode());
                nativeSymbolCacheSingleContext = this.nativeSymbolCache;
            } else if (nativeSymbolCacheSingleContext != null) {
                assert (nativeSymbolCacheSingleContextUsed);
                nativeSymbolCacheSingleContext = null;
            }
            nativeSymbolCacheSingleContextUsed = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.singletonNativePtrs = new PythonNativeWrapper.PythonAbstractObjectNativeWrapper[PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS.length];
            for (i = 0; i < this.singletonNativePtrs.length; ++i) {
                assert (CApiGuards.isSpecialSingleton(PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS[i]));
                this.singletonNativePtrs[i] = new PythonObjectNativeWrapper(PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS[i]);
            }
            this.primitiveNativeWrapperCache = new PrimitiveNativeWrapper[262];
            for (i = 0; i < this.primitiveNativeWrapperCache.length; ++i) {
                int value = i - 5;
                assert (CApiGuards.isSmallInteger(value));
                this.primitiveNativeWrapperCache[i] = PrimitiveNativeWrapper.createInt(value);
            }
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    void addLoadedExtensionLibrary(Object nativeLibrary) {
        this.loadedExtensions.add(nativeLibrary);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object asHex(Object ptr) {
        if (ptr instanceof Number) {
            return "0x" + Long.toHexString(((Number)ptr).longValue());
        }
        return Objects.toString(ptr);
    }

    public PDict getInternedUnicode() {
        return this.internedUnicode;
    }

    public void setInternedUnicode(PDict internedUnicode) {
        this.internedUnicode = internedUnicode;
    }

    public static Object asPointer(Object ptr, InteropLibrary lib) {
        if (lib.isPointer(ptr)) {
            try {
                return lib.asPointer(ptr);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return ptr;
    }

    public TraceMallocDomain getTraceMallocDomain(int domainIdx) {
        return this.traceMallocDomains[domainIdx];
    }

    public int findOrCreateTraceMallocDomain(int id) {
        int oldLength;
        if (this.traceMallocDomains != null) {
            for (int i = 0; i < this.traceMallocDomains.length; ++i) {
                if (this.traceMallocDomains[i].id != id) continue;
                return i;
            }
            oldLength = this.traceMallocDomains.length;
            this.traceMallocDomains = Arrays.copyOf(this.traceMallocDomains, this.traceMallocDomains.length + 1);
        } else {
            oldLength = 0;
            this.traceMallocDomains = new TraceMallocDomain[1];
        }
        this.traceMallocDomains[oldLength] = new TraceMallocDomain(id);
        return oldLength;
    }

    public long nextTssKey() {
        return this.nextTssKey.incrementAndGet();
    }

    @CompilerDirectives.TruffleBoundary
    public Object tssGet(long key) {
        ThreadLocal<Object> local = this.tssStorage.get(key);
        if (local != null) {
            return local.get();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void tssSet(long key, Object object) {
        this.tssStorage.computeIfAbsent(key, k -> new ThreadLocal()).set(object);
    }

    @CompilerDirectives.TruffleBoundary
    public void tssDelete(long key) {
        this.tssStorage.remove(key);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    static int getSingletonNativeWrapperIdx(Object obj) {
        for (int i = 0; i < PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS.length; ++i) {
            if (PythonLanguage.CONTEXT_INSENSITIVE_SINGLETONS[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public PythonNativeWrapper.PythonAbstractObjectNativeWrapper getSingletonNativeWrapper(PythonAbstractObject obj) {
        int singletonNativePtrIdx = CApiContext.getSingletonNativeWrapperIdx(obj);
        if (singletonNativePtrIdx != -1) {
            return this.singletonNativePtrs[singletonNativePtrIdx];
        }
        return null;
    }

    private void freeSingletonNativeWrappers(CApiTransitions.HandleContext handleContext) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().ownsGil());
        for (int i = 0; i < this.singletonNativePtrs.length; ++i) {
            PythonNativeWrapper.PythonAbstractObjectNativeWrapper singletonNativeWrapper = this.singletonNativePtrs[i];
            this.singletonNativePtrs[i] = null;
            assert (singletonNativeWrapper != null);
            assert (CApiContext.getSingletonNativeWrapperIdx(singletonNativeWrapper.getDelegate()) != -1);
            assert (!singletonNativeWrapper.isNative() || singletonNativeWrapper.getRefCount() == 0x3FFFFFFFFFFFFFFFL);
            if (singletonNativeWrapper.ref != null) {
                CApiTransitions.nativeStubLookupRemove(handleContext, singletonNativeWrapper.ref);
            }
            PyTruffleObjectFree.releaseNativeWrapperUncached(singletonNativeWrapper);
        }
    }

    public PrimitiveNativeWrapper getCachedPrimitiveNativeWrapper(int i) {
        assert (CApiGuards.isSmallInteger(i));
        PrimitiveNativeWrapper primitiveNativeWrapper = this.primitiveNativeWrapperCache[i + 5];
        assert (primitiveNativeWrapper.getRefCount() > 0L);
        return primitiveNativeWrapper;
    }

    public PrimitiveNativeWrapper getCachedPrimitiveNativeWrapper(long l) {
        assert (CApiGuards.isSmallLong(l));
        return this.getCachedPrimitiveNativeWrapper((int)l);
    }

    Object getOrCreateSmallInts() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().ownsGil());
        if (this.nativeSmallIntsArray == null) {
            assert (CConstants._PY_NSMALLNEGINTS.intValue() == 5);
            assert (CConstants._PY_NSMALLPOSINTS.intValue() == 257);
            Object smallInts = CStructAccess.AllocateNode.callocUncached(262L, 8L);
            for (int i = 0; i < 262; ++i) {
                CStructAccessFactory.WriteObjectNewRefNodeGen.getUncached().writeArrayElement(smallInts, i, i - 5);
            }
            this.nativeSmallIntsArray = smallInts;
        }
        return this.nativeSmallIntsArray;
    }

    private void freeSmallInts(CApiTransitions.HandleContext handleContext) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getContext().ownsGil());
        if (this.nativeSmallIntsArray != null) {
            assert (this.verifyNativeSmallInts());
            CStructAccess.FreeNode.executeUncached(this.nativeSmallIntsArray);
            this.nativeSmallIntsArray = null;
        }
        for (PrimitiveNativeWrapper wrapper : this.primitiveNativeWrapperCache) {
            assert (wrapper.isIntLike() && CApiGuards.isSmallLong(wrapper.getLong()));
            assert (!wrapper.isNative() || wrapper.getRefCount() == 0x3FFFFFFFFFFFFFFFL);
            if (wrapper.ref != null) {
                CApiTransitions.nativeStubLookupRemove(handleContext, wrapper.ref);
            }
            PyTruffleObjectFree.releaseNativeWrapperUncached(wrapper);
        }
    }

    private boolean verifyNativeSmallInts() {
        assert (this.getContext().ownsGil());
        for (int i = 0; i < 262; ++i) {
            Object elementPtr = CStructAccess.ReadPointerNode.getUncached().readArrayElement(this.nativeSmallIntsArray, i);
            PythonNativeWrapper wrapper = CApiTransitions.ToPythonWrapperNode.executeUncached(elementPtr, false);
            if (wrapper != this.primitiveNativeWrapperCache[i]) {
                return false;
            }
            if (!this.primitiveNativeWrapperCache[i].isNative() || this.primitiveNativeWrapperCache[i].getRefCount() == 0x3FFFFFFFFFFFFFFFL) continue;
            return false;
        }
        return true;
    }

    public Object getModuleByIndex(int i) {
        if (i < this.modulesByIndex.size()) {
            return this.modulesByIndex.get(i);
        }
        return null;
    }

    private static Object[] getSymbolCache(Node caller) {
        Object[] nativeSymbolCacheSingleContext = CApiContext.nativeSymbolCacheSingleContext;
        if (nativeSymbolCacheSingleContext != null) {
            return nativeSymbolCacheSingleContext;
        }
        return PythonContext.get((Node)caller).getCApiContext().nativeSymbolCache;
    }

    public static Object getNativeSymbol(Node caller, NativeCAPISymbol symbol) {
        Object[] nativeSymbolCache = CApiContext.getSymbolCache(caller);
        Object result = nativeSymbolCache[symbol.ordinal()];
        if (result == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            result = CApiContext.lookupNativeSymbol(nativeSymbolCache, symbol);
        }
        assert (result != null);
        return result;
    }

    private static Object lookupNativeSymbol(Object[] nativeSymbolCache, NativeCAPISymbol symbol) {
        CompilerAsserts.neverPartOfCompilation();
        String name = symbol.getName();
        try {
            Object nativeSymbol = InteropLibrary.getUncached().readMember(PythonContext.get(null).getCApiContext().getLLVMLibrary(), name);
            nativeSymbol = CExtContext.ensureExecutable(nativeSymbol, symbol);
            VarHandle.storeStoreFence();
            Object object = nativeSymbol;
            nativeSymbolCache[symbol.ordinal()] = object;
            return object;
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public AllocInfo traceFree(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
        AllocInfo allocatedValue;
        AllocInfo freedValue;
        if (this.allocatedNativeMemory == null) {
            this.allocatedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        if (this.freedNativeMemory == null) {
            this.freedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        if ((freedValue = this.freedNativeMemory.put(ptr, allocatedValue = this.allocatedNativeMemory.remove(ptr))) != null) {
            LOGGER.severe(PythonUtils.formatJString("freeing memory that was already free'd %s (double-free)", CApiContext.asHex(ptr)));
        } else if (allocatedValue == null) {
            LOGGER.info(PythonUtils.formatJString("freeing non-allocated memory %s (maybe a double-free or we didn't trace the allocation)", CApiContext.asHex(ptr)));
        }
        return allocatedValue;
    }

    @CompilerDirectives.TruffleBoundary
    public void traceAlloc(Object ptr, PFrame.Reference curFrame, TruffleString clazzName, long size) {
        if (this.allocatedNativeMemory == null) {
            this.allocatedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        AllocInfo value = this.allocatedNativeMemory.put(ptr, new AllocInfo(clazzName, curFrame, size));
        if (this.freedNativeMemory != null) {
            this.freedNativeMemory.remove(ptr);
        }
        assert (value == null) : "native memory allocator reserved same memory twice";
    }

    public void trackObject(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
    }

    public void untrackObject(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
    }

    @CompilerDirectives.TruffleBoundary
    public void traceStaticMemory(Object ptr, PFrame.Reference curFrame, TruffleString clazzName) {
        if (this.allocatedNativeMemory == null) {
            this.allocatedNativeMemory = new HashMap<Object, AllocInfo>();
        }
        if (this.freedNativeMemory != null) {
            this.freedNativeMemory.remove(ptr);
        }
        this.allocatedNativeMemory.put(ptr, new AllocInfo(curFrame, clazzName));
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isAllocated(Object ptr) {
        if (this.freedNativeMemory != null && this.freedNativeMemory.containsKey(ptr)) {
            assert (!this.allocatedNativeMemory.containsKey(ptr));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseMemoryPressure(VirtualFrame frame, Node inliningTarget, PythonContext.GetThreadStateNode getThreadStateNode, IndirectCallData indirectCallData, long size) {
        PythonContext context = this.getContext();
        if (this.allocatedMemory + size <= context.getOption(PythonOptions.MaxNativeMemory)) {
            this.allocatedMemory += size;
            return;
        }
        PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, context);
        Object savedState = ExecutionContext.IndirectCallContext.enter(frame, threadState, indirectCallData);
        try {
            this.triggerGC(context, size, inliningTarget);
        }
        finally {
            ExecutionContext.IndirectCallContext.exit(frame, threadState, savedState);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void triggerGC(PythonContext context, long size, Node caller) {
        long delay = 0L;
        for (int retries = 0; retries < 17; ++retries) {
            CApiContext.doGc(delay += 50L);
            CApiTransitions.pollReferenceQueue();
            PythonContext.triggerAsyncActions(caller);
            if (this.allocatedMemory + size > context.getOption(PythonOptions.MaxNativeMemory)) continue;
            this.allocatedMemory += size;
            return;
        }
        throw new OutOfMemoryError("native memory");
    }

    public void reduceMemoryPressure(long size) {
        this.allocatedMemory -= size;
    }

    @CompilerDirectives.TruffleBoundary
    private static void doGc(long millis) {
        LOGGER.fine("full GC due to native memory");
        PythonUtils.forceFullGC();
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    public void checkAccess(Object pointerObject, InteropLibrary lib) {
        Object ptrVal;
        if (this.getContext().getOption(PythonOptions.TraceNativeMemory).booleanValue() && !this.isAllocated(ptrVal = CApiContext.asPointer(pointerObject, lib))) {
            LOGGER.severe(() -> "Access to invalid memory at " + String.valueOf(CApiContext.asHex(ptrVal)));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded() {
        try {
            return CApiContext.ensureCapiWasLoaded(null, PythonContext.get(null), StringLiterals.T_EMPTY_STRING, StringLiterals.T_EMPTY_STRING);
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CApiContext ensureCapiWasLoaded(Node node, PythonContext context, TruffleString name, TruffleString path) throws IOException, LoadCExtException.ImportException, LoadCExtException.ApiInitException {
        if (!context.hasCApiContext()) {
            TruffleLanguage.Env env = context.getEnv();
            InteropLibrary U = InteropLibrary.getUncached();
            TruffleFile homePath = env.getInternalTruffleFile(context.getCAPIHome().toJavaStringUncached());
            String libName = context.getLLVMSupportExt("python");
            TruffleFile capiFile = homePath.resolve(libName).getCanonicalFile(new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
            try {
                Source.SourceBuilder capiSrcBuilder;
                boolean useNative;
                if (((Boolean)PythonOptions.NativeModules.getValue(env.getOptions())).booleanValue()) {
                    useNative = nativeCAPILoaded.compareAndSet(false, true);
                    if (!useNative && warnedSecondContexWithNativeCAPI.compareAndSet(false, true)) {
                        LOGGER.warning("GraalPy option 'NativeModules' is set to true, but only one context in the process can use native modules, second and other contexts fallback to NativeModules=false and will use LLVM bitcode execution via GraalVM LLVM.");
                    }
                } else {
                    useNative = false;
                }
                if (useNative) {
                    context.ensureNFILanguage(node, "NativeModules", "true");
                    capiSrcBuilder = Source.newBuilder((String)"nfi", (CharSequence)("load(RTLD_GLOBAL) \"" + capiFile.getPath() + "\""), (String)"<libpython>");
                } else {
                    context.ensureLLVMLanguage(node);
                    capiSrcBuilder = Source.newBuilder((String)"llvm", (TruffleFile)capiFile);
                }
                if (!context.getLanguage().getEngineOption(PythonOptions.ExposeInternalSources).booleanValue()) {
                    capiSrcBuilder.internal(true);
                }
                LOGGER.config(() -> "loading CAPI from " + String.valueOf(capiFile) + " as " + (useNative ? "native" : "bitcode"));
                CallTarget capiLibraryCallTarget = context.getEnv().parseInternal(capiSrcBuilder.build(), new String[0]);
                Object capiLibrary = capiLibraryCallTarget.call(new Object[0]);
                Object initFunction = U.readMember(capiLibrary, "initialize_graal_capi");
                CApiContext cApiContext = new CApiContext(context, capiLibrary, useNative);
                context.setCApiContext(cApiContext);
                try (BuiltinArrayWrapper builtinArrayWrapper = new BuiltinArrayWrapper();){
                    if (useNative) {
                        Object signature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"(ENV,(SINT32):POINTER):VOID", (String)"exec").build(), new String[0]).call(new Object[0]);
                        initFunction = SignatureLibrary.getUncached().bind(signature, initFunction);
                        U.execute(initFunction, new Object[]{builtinArrayWrapper});
                    } else {
                        assert (U.isExecutable(initFunction));
                        U.execute(initFunction, new Object[]{NativePointer.createNull(), builtinArrayWrapper});
                    }
                }
                assert (PythonCApiAssertions.assertBuiltins(capiLibrary));
                cApiContext.pyDateTimeCAPICapsule = PyDateTimeCAPIWrapper.initWrapper(context, cApiContext);
                context.runCApiHooks();
                if (useNative) {
                    Object finalizeFunction = U.readMember(capiLibrary, "GraalPy_get_finalize_capi_pointer");
                    Object finalizeSignature = env.parseInternal(Source.newBuilder((String)"nfi", (CharSequence)"():POINTER", (String)"exec").build(), new String[0]).call(new Object[0]);
                    Object finalizingPointer = SignatureLibrary.getUncached().call(finalizeSignature, finalizeFunction, new Object[0]);
                    try {
                        cApiContext.addNativeFinalizer(env, finalizingPointer);
                    }
                    catch (RuntimeException e) {
                        LOGGER.warning(() -> "didn't register a native finalizer due to: " + e.getMessage());
                    }
                }
                return cApiContext;
            }
            catch (PException e) {
                throw e;
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e) {
                if (!libName.contains("managed") && !context.isNativeAccessAllowed()) {
                    throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.NATIVE_ACCESS_NOT_ALLOWED, new Object[0]);
                }
                throw new LoadCExtException.ApiInitException((Exception)e);
            }
        }
        return context.getCApiContext();
    }

    private void addNativeFinalizer(TruffleLanguage.Env env, Object finalizingPointerObj) {
        Unsafe unsafe = this.getContext().getUnsafe();
        InteropLibrary lib = InteropLibrary.getUncached((Object)finalizingPointerObj);
        if (!lib.isNull(finalizingPointerObj) && lib.isPointer(finalizingPointerObj)) {
            try {
                long finalizingPointer = lib.asPointer(finalizingPointerObj);
                this.nativeFinalizerRunnable = () -> unsafe.putInt(finalizingPointer, 1);
                this.nativeFinalizerShutdownHook = env.newTruffleThreadBuilder(this.nativeFinalizerRunnable).build();
                Runtime.getRuntime().addShutdownHook(this.nativeFinalizerShutdownHook);
            }
            catch (UnsupportedMessageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void exitCApiContext() {
        CompilerAsserts.neverPartOfCompilation();
        CApiTransitions.pollReferenceQueue();
        try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
            CApiTransitions.deallocateNativeWeakRefs(this.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeCApi() {
        CompilerAsserts.neverPartOfCompilation();
        CApiTransitions.HandleContext handleContext = this.getContext().nativeContext;
        CApiTransitions.disableReferenceQueuePolling(handleContext);
        TruffleSafepoint sp = TruffleSafepoint.getCurrent();
        boolean prev = sp.setAllowActions(false);
        try {
            try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
                this.freeSmallInts(handleContext);
                this.freeSingletonNativeWrappers(handleContext);
                CApiTransitions.freeNativeObjectStubs(handleContext);
                CApiTransitions.freeClassReplacements(handleContext);
                CApiTransitions.freeNativeStorages(handleContext);
            }
            if (this.pyDateTimeCAPICapsule != null) {
                PyDateTimeCAPIWrapper.destroyWrapper(this.pyDateTimeCAPICapsule);
            }
            for (Object pyMethodDefPointer : this.methodDefinitions.values()) {
                PyMethodDefHelper.free(pyMethodDefPointer);
            }
        }
        finally {
            sp.setAllowActions(prev);
        }
        if (this.nativeFinalizerShutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.nativeFinalizerShutdownHook);
                this.nativeFinalizerRunnable.run();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.pyCFunctionWrappers.clear();
        Class<CApiContext> clazz = CApiContext.class;
        synchronized (CApiContext.class) {
            if (nativeSymbolCacheSingleContext != null) {
                nativeSymbolCacheSingleContext = null;
                nativeSymbolCacheSingleContextUsed = false;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object initCApiModule(Node location, Object sharedLibrary, TruffleString initFuncName, CExtContext.ModuleSpec spec, InteropLibrary llvmInteropLib, CExtCommonNodes.CheckFunctionResultNode checkFunctionResultNode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, LoadCExtException.ImportException {
        Object nativeResult;
        Object pyinitFunc;
        PythonContext context = this.getContext();
        CApiContext cApiContext = context.getCApiContext();
        try {
            pyinitFunc = llvmInteropLib.readMember(sharedLibrary, initFuncName.toJavaStringUncached());
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e1) {
            throw new LoadCExtException.ImportException(null, spec.name, spec.path, ErrorMessages.NO_FUNCTION_FOUND, "", initFuncName, spec.path);
        }
        try {
            nativeResult = InteropLibrary.getUncached().execute(pyinitFunc, new Object[0]);
        }
        catch (UnsupportedMessageException e) {
            Object signature = context.getEnv().parseInternal(MODINIT_SRC, new String[0]).call(new Object[0]);
            nativeResult = SignatureLibrary.getUncached().call(signature, pyinitFunc, new Object[0]);
        }
        catch (ArityException e) {
            Object[] arguments = new Object[e.getExpectedMinArity()];
            Arrays.fill(arguments, PNone.NO_VALUE);
            nativeResult = InteropLibrary.getUncached().execute(pyinitFunc, arguments);
        }
        checkFunctionResultNode.execute(context, initFuncName, nativeResult);
        Object result = CApiTransitions.NativeToPythonNode.executeUncached(nativeResult);
        if (!(result instanceof PythonModule)) {
            Object clazz = GetClassNode.executeUncached(result);
            if (clazz == PNone.NO_VALUE) {
                throw PRaiseNode.raiseUncached(location, PythonBuiltinClassType.SystemError, ErrorMessages.INIT_FUNC_RETURNED_UNINT_OBJ, initFuncName);
            }
            return CExtNodesFactory.CreateModuleNodeGen.getUncached().execute(cApiContext, spec, result, sharedLibrary);
        }
        PythonModule module = (PythonModule)result;
        module.setAttribute(SpecialAttributeNames.T___FILE__, spec.path);
        module.setAttribute(SpecialAttributeNames.T___LIBRARY__, sharedLibrary);
        this.addLoadedExtensionLibrary(sharedLibrary);
        PDict sysModules = context.getSysModules();
        sysModules.setItem(spec.name, result);
        Object moduleDef = module.getNativeModuleDef();
        int mIndex = PythonUtils.toIntError(CStructAccess.ReadI64Node.getUncached().read(moduleDef, CFields.PyModuleDef_Base__m_index));
        while (this.modulesByIndex.size() <= mIndex) {
            this.modulesByIndex.add(null);
        }
        this.modulesByIndex.set(mIndex, module);
        this.extensions.put((Pair<TruffleString, TruffleString>)Pair.create((Object)spec.path, (Object)spec.name), module);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public PythonModule findExtension(TruffleString filename, TruffleString name) {
        return this.extensions.get(Pair.create((Object)filename, (Object)name));
    }

    public long getClosurePointer(Object executable) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosureByExecutable.get(executable);
        return info == null ? -1L : info.pointer;
    }

    public Object getClosureForExecutable(Object executable) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosureByExecutable.get(executable);
        return info == null ? null : info.closure;
    }

    public Object getClosureDelegate(long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosures.get(pointer);
        return info == null ? null : info.delegate;
    }

    public Object getClosureExecutable(long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = this.callableClosures.get(pointer);
        return info == null ? null : info.executable;
    }

    public void setClosurePointer(Object closure, Object delegate, Object executable, long pointer) {
        CompilerAsserts.neverPartOfCompilation();
        ClosureInfo info = new ClosureInfo(closure, delegate, executable, pointer);
        this.callableClosureByExecutable.put(executable, info);
        this.callableClosures.put(pointer, info);
        LOGGER.finer(() -> PythonUtils.formatJString("new NFI closure: (%s, %s) -> %d 0x%x", executable.getClass().getSimpleName(), delegate, pointer, pointer));
    }

    private static Source buildNFISource(Object srcObj) {
        return Source.newBuilder((String)"nfi", (CharSequence)((String)srcObj), (String)"exec").build();
    }

    public long registerClosure(String nfiSignature, Object executable, Object delegate, SignatureLibrary signatureLibrary) {
        CompilerAsserts.neverPartOfCompilation();
        PythonContext context = this.getContext();
        boolean panama = context.getOption(PythonOptions.UsePanama);
        String srcString = (panama ? "with panama " : "") + nfiSignature;
        Source nfiSource = context.getLanguage().getOrCreateSource(CApiContext::buildNFISource, srcString);
        Object signature = context.getEnv().parseInternal(nfiSource, new String[0]).call(new Object[0]);
        Object closure = signatureLibrary.createClosure(signature, executable);
        long pointer = PythonUtils.coerceToLong(closure, InteropLibrary.getUncached());
        this.setClosurePointer(closure, delegate, executable, pointer);
        return pointer;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrCreateProcWrapper(PythonManagedClass owner, SlotMethodDef slot, Supplier<PyProcsWrapper> supplier) {
        int idx;
        PyProcsWrapper[] slotWrappers = this.procWrappers.computeIfAbsent(owner, key -> new PyProcsWrapper[SlotMethodDef.values().length]);
        PyProcsWrapper wrapper = slotWrappers[idx = slot.ordinal()];
        if (wrapper == null) {
            slotWrappers[idx] = wrapper = (PyProcsWrapper)supplier.get();
        }
        return wrapper;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getOrAllocateNativePyMethodDef(PyMethodDefHelper pyMethodDef) {
        Object pyMethodDefPointer = this.methodDefinitions.computeIfAbsent(pyMethodDef, PyMethodDefHelper::allocate);
        assert (CApiContext.isPointerObject(pyMethodDefPointer));
        return pyMethodDefPointer;
    }

    @CompilerDirectives.TruffleBoundary
    public PyCFunctionWrapper getOrCreatePyCFunctionWrapper(BuiltinMethodDescriptor builtinMethodDescriptor, Function<BuiltinMethodDescriptor, PyCFunctionWrapper> cons) {
        return this.pyCFunctionWrappers.computeIfAbsent(builtinMethodDescriptor, k -> (PyCFunctionWrapper)cons.apply((BuiltinMethodDescriptor)k));
    }

    @CompilerDirectives.TruffleBoundary
    public PyCFunctionWrapper getOrCreatePyCFunctionWrapper(RootCallTarget ct, Function<RootCallTarget, PyCFunctionWrapper> cons) {
        return this.pyCFunctionWrappers.computeIfAbsent(ct, k -> (PyCFunctionWrapper)cons.apply((RootCallTarget)k));
    }

    public static boolean isPointerObject(Object object) {
        return object.getClass() == NativePointer.class || object.getClass().getSimpleName().contains("NFIPointer") || object.getClass().getSimpleName().contains("LLVMPointer");
    }

    static {
        nativeCAPILoaded = new AtomicBoolean();
        warnedSecondContexWithNativeCAPI = new AtomicBoolean();
    }

    public static final class TraceMallocDomain {
        private final int id;
        private final EconomicMap<Object, Long> allocatedMemory;

        public TraceMallocDomain(int id) {
            this.id = id;
            this.allocatedMemory = EconomicMap.create();
        }

        @CompilerDirectives.TruffleBoundary
        public void track(Object pointerObject, long size) {
            this.allocatedMemory.put(pointerObject, (Object)size);
        }

        @CompilerDirectives.TruffleBoundary
        public long untrack(Object pointerObject) {
            Long value = (Long)this.allocatedMemory.removeKey(pointerObject);
            if (value != null) {
                return value;
            }
            return 0L;
        }

        public int getId() {
            return this.id;
        }
    }

    public static final class AllocInfo {
        public final TruffleString typeName;
        public final PFrame.Reference allocationSite;
        public final long size;

        public AllocInfo(TruffleString typeName, PFrame.Reference allocationSite, long size) {
            this.typeName = typeName;
            this.allocationSite = allocationSite;
            this.size = size;
        }

        public AllocInfo(PFrame.Reference allocationSite, TruffleString typeName) {
            this(typeName, allocationSite, -1L);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class BuiltinArrayWrapper
    implements TruffleObject,
    AutoCloseable {
        private long pointer;

        BuiltinArrayWrapper() {
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return PythonCextBuiltinRegistry.builtins.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return 0L <= index && index < (long)PythonCextBuiltinRegistry.builtins.length;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (!this.isArrayElementReadable(index)) {
                throw InvalidArrayIndexException.create((long)index);
            }
            return BuiltinArrayWrapper.getCAPIBuiltinExecutable((int)index);
        }

        private static PythonCextBuiltins.CApiBuiltinExecutable getCAPIBuiltinExecutable(int id) {
            CompilerAsserts.neverPartOfCompilation();
            try {
                PythonCextBuiltins.CApiBuiltinExecutable builtin = PythonCextBuiltinRegistry.builtins[id];
                assert (builtin.call() == PythonCextBuiltins.CApiCallPath.Direct || !BuiltinArrayWrapper.isAvailable(builtin)) : "name clash in builtin vs. CAPI library: " + builtin.name();
                LOGGER.finer("CApiContext.BuiltinArrayWrapper.get " + id + " / " + builtin.name());
                return builtin;
            }
            catch (Throwable e) {
                e.printStackTrace(new PrintStream(PythonContext.get(null).getEnv().err()));
                throw new RuntimeException(e);
            }
        }

        @ExportMessage
        boolean isPointer() {
            return this.pointer != 0L;
        }

        @ExportMessage
        long asPointer() throws UnsupportedMessageException {
            if (this.pointer != 0L) {
                return this.pointer;
            }
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void toNative() {
            if (this.pointer == 0L) {
                assert (PythonContext.get(null).isNativeAccessAllowed());
                Object ptr = CStructAccess.AllocateNode.callocUncached((long)PythonCextBuiltinRegistry.builtins.length, 8L);
                this.pointer = CExtCommonNodes.CoerceNativePointerToLongNode.executeUncached(ptr);
                if (this.pointer != 0L) {
                    InteropLibrary lib = null;
                    for (int i = 0; i < PythonCextBuiltinRegistry.builtins.length; ++i) {
                        PythonCextBuiltins.CApiBuiltinExecutable capiBuiltinExecutable = BuiltinArrayWrapper.getCAPIBuiltinExecutable(i);
                        if (lib == null || !lib.accepts((Object)capiBuiltinExecutable)) {
                            lib = InteropLibrary.getUncached((Object)capiBuiltinExecutable);
                        }
                        assert (lib.accepts((Object)capiBuiltinExecutable));
                        lib.toNative((Object)capiBuiltinExecutable);
                        try {
                            CStructAccess.WritePointerNode.writeArrayElementUncached(this.pointer, i, lib.asPointer((Object)capiBuiltinExecutable));
                            continue;
                        }
                        catch (UnsupportedMessageException e) {
                            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                        }
                    }
                }
            }
        }

        @Override
        public void close() {
            if (this.pointer != 0L) {
                CStructAccess.FreeNode.executeUncached(this.pointer);
            }
        }

        private static boolean isAvailable(PythonCextBuiltins.CApiBuiltinExecutable builtin) {
            CApiContext cApiContext = PythonContext.get(null).getCApiContext();
            if (cApiContext == null) {
                return false;
            }
            Object llvmLibrary = cApiContext.getLLVMLibrary();
            InteropLibrary lib = InteropLibrary.getUncached((Object)llvmLibrary);
            if (!lib.isMemberReadable(llvmLibrary, builtin.name())) {
                return false;
            }
            try {
                lib.readMember(llvmLibrary, builtin.name());
                return true;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            catch (UnknownIdentifierException e) {
                return false;
            }
        }
    }

    private record ClosureInfo(Object closure, Object delegate, Object executable, long pointer) {
    }
}

