/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyBytesCheckExactNode;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBytes})
public class BytesBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = BytesBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BytesBuiltinsFactory.getFactories();
    }

    @Builtin(name="__bytes__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BytesNode
    extends PythonUnaryBuiltinNode {
        BytesNode() {
        }

        @Specialization
        static Object bytes(Object self, @Bind(value="this") Node inliningTarget, @Cached PyBytesCheckExactNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached PythonObjectFactory.Lazy factory) {
            if (check.execute(inliningTarget, self)) {
                return self;
            }
            return factory.get(inliningTarget).createBytes(getBytesStorage.execute(inliningTarget, self));
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }

        @Specialization
        static Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode) {
            return helperNode.execute(inliningTarget, self, other, ComparisonOp.GE);
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        GtNode() {
        }

        @Specialization
        static Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode) {
            return helperNode.execute(inliningTarget, self, other, ComparisonOp.GT);
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }

        @Specialization
        static Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode) {
            return helperNode.execute(inliningTarget, self, other, ComparisonOp.LE);
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        LtNode() {
        }

        @Specialization
        static Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode) {
            return helperNode.execute(inliningTarget, self, other, ComparisonOp.LT);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode) {
            return helperNode.execute(inliningTarget, self, other, ComparisonOp.NE);
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object cmp(Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode) {
            return helperNode.execute(inliningTarget, self, other, ComparisonOp.EQ);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ComparisonHelperNode
    extends Node {
        ComparisonHelperNode() {
        }

        abstract Object execute(Node var1, Object var2, Object var3, ComparisonOp var4);

        @Specialization
        static boolean cmp(Node inliningTarget, PBytes self, PBytes other, ComparisonOp op, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray) {
            SequenceStorage selfStorage = self.getSequenceStorage();
            SequenceStorage otherStorage = other.getSequenceStorage();
            return BytesNodes.compareByteArrays(op, getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
        }

        @Fallback
        static Object cmp(Node inliningTarget, Object self, Object other, ComparisonOp op, @Cached PyBytesCheckNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray, @Cached PRaiseNode.Lazy raiseNode) {
            if (check.execute(inliningTarget, self)) {
                if (check.execute(inliningTarget, other)) {
                    SequenceStorage selfStorage = getBytesStorage.execute(inliningTarget, self);
                    SequenceStorage otherStorage = getBytesStorage.execute(inliningTarget, other);
                    return BytesNodes.compareByteArrays(op, getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
                }
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, op.builtinName, "bytes", self);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true, numOfPositionalOnlyArgs=2, parameterNames={"$cls", "string"})
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class FromHexNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization(guards={"isBuiltinBytesType(inliningTarget, cls, isSameType)"})
        static PBytes doBytes(Object cls, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameType, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBytes(cls, hexStringToBytesNode.execute(str));
        }

        @Specialization(guards={"!isBuiltinBytesType(inliningTarget, cls, isSameType)"})
        static Object doGeneric(VirtualFrame frame, Object cls, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameType, @Cached CallNode callNode, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PBytes bytes = factory.createBytes(hexStringToBytesNode.execute(str));
            return callNode.execute((Frame)frame, cls, bytes);
        }

        protected static boolean isBuiltinBytesType(Node inliningTarget, Object cls, TypeNodes.IsSameTypeNode isSameTypeNode) {
            return isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PBytes, cls);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BytesBuiltinsClinicProviders.FromHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="translate", minNumOfPositionalArgs=2, parameterNames={"self", "table", "delete"})
    @GenerateNodeFactory
    public static abstract class TranslateNode
    extends BytesNodes.BaseTranslateNode {
        @Specialization(guards={"isNoValue(delete)", "checkExactNode.execute(this, self)"})
        static PBytes translate(PBytes self, PNone table, PNone delete, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode) {
            return self;
        }

        @Specialization(guards={"isNoValue(delete)", "!checkExactNode.execute(this, self)"})
        static PBytes translate(Object self, PNone table, PNone delete, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBytes(toBytesNode.execute(null, self));
        }

        @Specialization(guards={"!isNone(table)"})
        static Object translate(VirtualFrame frame, Object self, Object table, PNone delete, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="profile") @Cached InlinedConditionProfile isLenTable256Profile, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            byte[] bTable = toBytesNode.execute(frame, table);
            TranslateNode.checkLengthOfTable(inliningTarget, bTable, isLenTable256Profile, raiseNode);
            byte[] bSelf = toBytesNode.execute(null, self);
            BytesNodes.BaseTranslateNode.Result result = TranslateNode.translate(bSelf, bTable);
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return factory.createBytes(result.array);
            }
            return self;
        }

        @Specialization(guards={"isNone(table)"})
        static Object delete(VirtualFrame frame, Object self, PNone table, Object delete, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            byte[] bSelf = toBytesNode.execute(null, self);
            byte[] bDelete = toBytesNode.execute(frame, delete);
            BytesNodes.BaseTranslateNode.Result result = TranslateNode.delete(bSelf, bDelete);
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return factory.createBytes(result.array);
            }
            return self;
        }

        @Specialization(guards={"!isPNone(table)", "!isPNone(delete)"})
        static Object translateAndDelete(VirtualFrame frame, Object self, Object table, Object delete, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyBytesCheckExactNode checkExactNode, @Cached.Shared(value="profile") @Cached InlinedConditionProfile isLenTable256Profile, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            byte[] bTable = toBytesNode.execute(frame, table);
            TranslateNode.checkLengthOfTable(inliningTarget, bTable, isLenTable256Profile, raiseNode);
            byte[] bDelete = toBytesNode.execute(frame, delete);
            byte[] bSelf = toBytesNode.execute(null, self);
            BytesNodes.BaseTranslateNode.Result result = TranslateNode.translateAndDelete(bSelf, bTable, bDelete);
            if (result.changed || !checkExactNode.execute(inliningTarget, self)) {
                return factory.createBytes(result.array);
            }
            return self;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        public static TruffleString repr(Object self, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage store = getBytesStorage.execute(inliningTarget, self);
            byte[] bytes = getBytes.execute(inliningTarget, store);
            int len = store.length();
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            BytesUtils.reprLoop(sb, bytes, len, appendCodePointNode);
            return toStringNode.execute(sb);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class BytesSubcript
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        BytesSubcript() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object idx, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile validProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode.Lazy raiseNode, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.SequenceStorageMpSubscriptNode subscriptNode) {
            if (!validProfile.profile(inliningTarget, SequenceStorageNodes.SequenceStorageMpSubscriptNode.isValidIndex(inliningTarget, idx, indexCheckNode))) {
                throw BytesSubcript.raiseNonIntIndex(inliningTarget, raiseNode, idx);
            }
            return subscriptNode.execute(frame, inliningTarget, getBytesStorage.execute(inliningTarget, self), idx, ErrorMessages.LIST_INDEX_OUT_OF_RANGE, PythonObjectFactory::createBytes);
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseNonIntIndex(Node inliningTarget, PRaiseNode.Lazy raiseNode, Object index) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "byte", index);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class GetitemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        GetitemNode() {
        }

        @Specialization
        static Object doInt(Object self, int key, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached PRaiseNode.Lazy raiseNode, @Cached SequenceStorageNodes.SequenceStorageSqItemNode sqItemNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode) {
            SequenceStorage storage = getBytesStorage.execute(inliningTarget, self);
            return sqItemNode.execute(inliningTarget, storage, key, ErrorMessages.BYTES_OUT_OF_BOUNDS);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            return PNone.NONE;
        }

        @Specialization
        static Object byteDone(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) {
            return PNone.NONE;
        }
    }
}

