/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.array;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class), @ExportLibrary(value=InteropLibrary.class)})
public final class PArray
extends PythonBuiltinObject {
    private final BufferFormat format;
    private final TruffleString formatString;
    private SequenceStorage storage;
    private final AtomicLong exports = new AtomicLong();

    public PArray(Object clazz, Shape instanceShape, TruffleString formatString, BufferFormat format) {
        super(clazz, instanceShape);
        this.formatString = formatString;
        this.format = format;
        this.storage = new ByteSequenceStorage(PythonUtils.EMPTY_BYTE_ARRAY);
    }

    public PArray(Object clazz, Shape instanceShape, TruffleString formatString, BufferFormat format, int length) throws OverflowException {
        super(clazz, instanceShape);
        this.formatString = formatString;
        this.format = format;
        this.storage = new ByteSequenceStorage(new byte[PythonUtils.multiplyExact(length, format.bytesize)]);
    }

    public BufferFormat getFormat() {
        return this.format;
    }

    @ExportMessage.Ignore
    public TruffleString getFormatString() {
        return this.formatString;
    }

    @ExportMessage(name="getFormatString")
    public TruffleString getFormatStringForBuffer() {
        if (BufferFormat.T_UNICODE_TYPE_CODE_U.equalsUncached((AbstractTruffleString)this.formatString, PythonUtils.TS_ENCODING)) {
            return BufferFormat.T_UNICODE_TYPE_CODE_W;
        }
        return this.formatString;
    }

    public Object getBuffer() {
        return this.storage;
    }

    public SequenceStorage getSequenceStorage() {
        return this.storage;
    }

    public void setSequenceStorage(SequenceStorage storage) {
        assert (storage instanceof ByteSequenceStorage || storage instanceof NativeByteSequenceStorage);
        this.storage = storage;
    }

    public int getLength() {
        assert (PythonUtils.isDivisible(this.storage.length(), this.format.shift));
        return this.storage.length() >> this.format.shift;
    }

    public int getBytesLength() {
        return this.storage.length();
    }

    public AtomicLong getExports() {
        return this.exports;
    }

    public void checkCanResize(Node inliningTarget, PRaiseNode.Lazy raiseNode) {
        if (this.exports.get() != 0L) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.BufferError, ErrorMessages.EXPORTS_CANNOT_RESIZE);
        }
    }

    public int getItemSizeShift() {
        return this.format.shift;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength() {
        return this.storage.length();
    }

    @ExportMessage
    Object acquire(int flags) {
        return this;
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    int getItemSize() {
        return this.format.bytesize;
    }

    @ExportMessage
    boolean hasInternalByteArray(@Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.hasInternalByteArray(this.storage);
    }

    @ExportMessage
    byte[] getInternalByteArray(@Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.getInternalByteArray(this.storage);
    }

    @ExportMessage
    byte readByte(int byteOffset, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readByte(this.storage, byteOffset);
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeByte(this.storage, byteOffset, value);
    }

    @ExportMessage
    short readShortByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readShortByteOrder(this.storage, byteOffset, byteOrder);
    }

    @ExportMessage
    void writeShortByteOrder(int byteOffset, short value, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeShortByteOrder(this.storage, byteOffset, value, byteOrder);
    }

    @ExportMessage
    int readIntByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readIntByteOrder(this.storage, byteOffset, byteOrder);
    }

    @ExportMessage
    void writeIntByteOrder(int byteOffset, int value, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeIntByteOrder(this.storage, byteOffset, value, byteOrder);
    }

    @ExportMessage
    long readLongByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readLongByteOrder(this.storage, byteOffset, byteOrder);
    }

    @ExportMessage
    void writeLongByteOrder(int byteOffset, long value, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeLongByteOrder(this.storage, byteOffset, value, byteOrder);
    }

    @ExportMessage
    float readFloatByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readFloatByteOrder(this.storage, byteOffset, byteOrder);
    }

    @ExportMessage
    void writeFloatByteOrder(int byteOffset, float value, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeFloatByteOrder(this.storage, byteOffset, value, byteOrder);
    }

    @ExportMessage
    double readDoubleByteOrder(int byteOffset, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.readDoubleByteOrder(this.storage, byteOffset, byteOrder);
    }

    @ExportMessage
    void writeDoubleByteOrder(int byteOffset, double value, ByteOrder byteOrder, @Cached.Shared @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
        bufferLib.writeDoubleByteOrder(this.storage, byteOffset, value, byteOrder);
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return this.storage.length();
    }

    @ExportMessage
    public Object readArrayElement(long index, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemScalarNode getItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            Object object = getItem.execute(inliningTarget, this.storage, PInt.intValueExact(index));
            return object;
        }
        catch (OverflowException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw InvalidArrayIndexException.create((long)index);
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void writeArrayElement(long index, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.SetItemScalarNode setItem, @Cached.Exclusive @Cached PForeignToPTypeNode convert, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                setItem.execute(inliningTarget, this.storage, PInt.intValueExact(index), convert.executeConvert(value));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeArrayElement(long index, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.DeleteItemNode delItem, @Cached.Exclusive @Cached GilNode gil) throws InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            try {
                delItem.execute(inliningTarget, this.storage, PInt.intValueExact(index));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InvalidArrayIndexException.create((long)index);
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    private boolean isInBounds(long idx) {
        return 0L <= idx && idx < (long)this.storage.length();
    }

    @ExportMessage
    public boolean isArrayElementReadable(long idx) {
        return this.isInBounds(idx);
    }

    @ExportMessage
    public boolean isArrayElementModifiable(long idx) {
        return this.isInBounds(idx);
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long idx) {
        return !this.isInBounds(idx);
    }

    @ExportMessage
    public boolean isArrayElementRemovable(long idx) {
        return this.isInBounds(idx);
    }

    @ExportMessage
    boolean isNative() {
        return this.storage instanceof NativeByteSequenceStorage;
    }

    @ExportMessage
    Object getNativePointer(@Bind(value="$node") Node inliningTarget, @Cached PySequenceArrayWrapper.ToNativeStorageNode toNativeStorageNode) {
        NativeSequenceStorage newStorage = toNativeStorageNode.execute(inliningTarget, this.storage, true);
        this.setSequenceStorage(newStorage);
        return newStorage.getPtr();
    }

    public static final class MachineFormat
    extends Enum<MachineFormat> {
        public static final /* enum */ MachineFormat UNSIGNED_INT8 = new MachineFormat(0, BufferFormat.UINT_8, null);
        public static final /* enum */ MachineFormat SIGNED_INT8 = new MachineFormat(1, BufferFormat.INT_8, null);
        public static final /* enum */ MachineFormat UNSIGNED_INT16_LE = new MachineFormat(2, BufferFormat.UINT_16, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT16_BE = new MachineFormat(3, BufferFormat.UINT_16, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT16_LE = new MachineFormat(4, BufferFormat.INT_16, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT16_BE = new MachineFormat(5, BufferFormat.INT_16, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT32_LE = new MachineFormat(6, BufferFormat.UINT_32, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT32_BE = new MachineFormat(7, BufferFormat.UINT_32, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT32_LE = new MachineFormat(8, BufferFormat.INT_32, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT32_BE = new MachineFormat(9, BufferFormat.INT_32, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT64_LE = new MachineFormat(10, BufferFormat.UINT_64, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT64_BE = new MachineFormat(11, BufferFormat.UINT_64, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT64_LE = new MachineFormat(12, BufferFormat.INT_64, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT64_BE = new MachineFormat(13, BufferFormat.INT_64, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_FLOAT_LE = new MachineFormat(14, BufferFormat.FLOAT, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_FLOAT_BE = new MachineFormat(15, BufferFormat.FLOAT, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_DOUBLE_LE = new MachineFormat(16, BufferFormat.DOUBLE, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_DOUBLE_BE = new MachineFormat(17, BufferFormat.DOUBLE, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat UTF32_LE = new MachineFormat(20, BufferFormat.UNICODE, ByteOrder.LITTLE_ENDIAN, PythonUtils.tsLiteral("utf-32-le"));
        public static final /* enum */ MachineFormat UTF32_BE = new MachineFormat(21, BufferFormat.UNICODE, ByteOrder.BIG_ENDIAN, PythonUtils.tsLiteral("utf-32-be"));
        public static final /* enum */ MachineFormat UTF16_LE = new MachineFormat(18, BufferFormat.UNICODE, ByteOrder.LITTLE_ENDIAN, PythonUtils.tsLiteral("utf-16-le"));
        public static final /* enum */ MachineFormat UTF16_BE = new MachineFormat(19, BufferFormat.UNICODE, ByteOrder.BIG_ENDIAN, PythonUtils.tsLiteral("utf-16-be"));
        public final int code;
        public final BufferFormat format;
        public final ByteOrder order;
        public final TruffleString unicodeEncoding;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final MachineFormat[] BY_BUFFER_FORMAT;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final MachineFormat[] BY_CODE;
        private static final /* synthetic */ MachineFormat[] $VALUES;

        public static MachineFormat[] values() {
            return (MachineFormat[])$VALUES.clone();
        }

        public static MachineFormat valueOf(String name) {
            return Enum.valueOf(MachineFormat.class, name);
        }

        private MachineFormat(int code, BufferFormat format, ByteOrder order) {
            this(code, format, order, null);
        }

        private MachineFormat(int code, BufferFormat format, ByteOrder order, TruffleString unicodeEncoding) {
            this.code = code;
            this.format = format;
            this.order = order;
            this.unicodeEncoding = unicodeEncoding;
        }

        public static MachineFormat forFormat(BufferFormat format) {
            return BY_BUFFER_FORMAT[format.ordinal()];
        }

        public static MachineFormat fromCode(int code) {
            return code >= 0 && code < BY_CODE.length ? BY_CODE[code] : null;
        }

        private static /* synthetic */ MachineFormat[] $values() {
            return new MachineFormat[]{UNSIGNED_INT8, SIGNED_INT8, UNSIGNED_INT16_LE, UNSIGNED_INT16_BE, SIGNED_INT16_LE, SIGNED_INT16_BE, UNSIGNED_INT32_LE, UNSIGNED_INT32_BE, SIGNED_INT32_LE, SIGNED_INT32_BE, UNSIGNED_INT64_LE, UNSIGNED_INT64_BE, SIGNED_INT64_LE, SIGNED_INT64_BE, IEEE_754_FLOAT_LE, IEEE_754_FLOAT_BE, IEEE_754_DOUBLE_LE, IEEE_754_DOUBLE_BE, UTF32_LE, UTF32_BE, UTF16_LE, UTF16_BE};
        }

        static {
            $VALUES = MachineFormat.$values();
            BY_BUFFER_FORMAT = new MachineFormat[BufferFormat.values().length];
            BY_CODE = new MachineFormat[MachineFormat.values().length];
            for (MachineFormat machineFormat : MachineFormat.values()) {
                BufferFormat bufferFormat = machineFormat.format;
                if (BY_BUFFER_FORMAT[bufferFormat.ordinal()] != null || machineFormat.order != null && machineFormat.order != ByteOrder.nativeOrder()) continue;
                MachineFormat.BY_BUFFER_FORMAT[bufferFormat.ordinal()] = machineFormat;
            }
            for (MachineFormat machineFormat : MachineFormat.values()) {
                assert (BY_CODE[machineFormat.code] == null);
                MachineFormat.BY_CODE[machineFormat.code] = machineFormat;
            }
        }
    }
}

