/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObjectFactory;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.lib.PySequenceDelItemNode;
import com.oracle.graal.python.lib.PySequenceGetItemNode;
import com.oracle.graal.python.lib.PySequenceSetItemNode;
import com.oracle.graal.python.lib.PySequenceSizeNode;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupInheritedAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallVarargsMethodNode;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNode;
import com.oracle.graal.python.nodes.interop.GetInteropBehaviorNode;
import com.oracle.graal.python.nodes.interop.GetInteropBehaviorValueNode;
import com.oracle.graal.python.nodes.interop.InteropBehavior;
import com.oracle.graal.python.nodes.interop.InteropBehaviorMethod;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToJavaByteNode;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaShortNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashSet;

@ExportLibrary(value=InteropLibrary.class)
@ImportStatic(value={SpecialMethodNames.class})
public abstract class PythonAbstractObject
extends DynamicObject
implements TruffleObject,
Comparable<Object> {
    private static final TruffleString T_PRIVATE_PREFIX = PythonUtils.tsLiteral("__");
    private static final int PRIVATE_PREFIX_LENGTH = T_PRIVATE_PREFIX.codePointLengthUncached(PythonUtils.TS_ENCODING);
    private PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper;
    protected static final SpecialMethodSlot Iter = SpecialMethodSlot.Iter;
    protected static final SpecialMethodSlot Next = SpecialMethodSlot.Next;
    protected static final Shape ABSTRACT_SHAPE = Shape.newBuilder().build();
    private Object[] indexedSlots;

    protected PythonAbstractObject(Shape shape) {
        super(shape);
    }

    protected PythonAbstractObject() {
        super(ABSTRACT_SHAPE);
    }

    public final PythonNativeWrapper.PythonAbstractObjectNativeWrapper getNativeWrapper() {
        return this.nativeWrapper;
    }

    public final void setNativeWrapper(PythonNativeWrapper.PythonAbstractObjectNativeWrapper nativeWrapper) {
        assert (this.nativeWrapper == null);
        assert (!CApiGuards.isSpecialSingleton(this));
        this.nativeWrapper = nativeWrapper;
    }

    public final void clearNativeWrapper() {
        this.nativeWrapper = null;
    }

    public Object[] getIndexedSlots() {
        return this.indexedSlots;
    }

    public void setIndexedSlots(Object[] indexedSlots) {
        this.indexedSlots = indexedSlots;
    }

    @ExportMessage
    public void writeMember(String key, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared @Cached PForeignToPTypeNode convert, @Cached.Exclusive @Cached PyObjectSetAttr setAttributeNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, UnknownIdentifierException {
        boolean mustRelease = gil.acquire();
        try {
            setAttributeNode.execute(null, inliningTarget, this, fromJavaStringNode.execute(key, PythonUtils.TS_ENCODING), convert.executeConvert(value));
        }
        catch (PException e) {
            e.expectAttributeError(inliningTarget, attrErrorProfile);
            throw UnknownIdentifierException.create((String)key);
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object readMember(String key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached PyObjectLookupAttr lookup, @Cached.Exclusive @Cached GilNode gil) throws UnknownIdentifierException {
        Object value;
        boolean mustRelease = gil.acquire();
        try {
            value = lookup.execute(null, inliningTarget, this, fromJavaStringNode.execute(key, PythonUtils.TS_ENCODING));
        }
        finally {
            gil.release(mustRelease);
        }
        if (value != PNone.NO_VALUE) {
            return value;
        }
        throw UnknownIdentifierException.create((String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasArrayElements(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached TpSlots.GetObjectSlotsNode getSlotsNode, @Cached.Exclusive @Cached PySequenceCheckNode sequenceCheck, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.has_array_elements;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = sequenceCheck.execute(inliningTarget, this) && getSlotsNode.execute(inliningTarget, this).combined_sq_mp_length() != null;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object readArrayElement(long key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached PySequenceGetItemNode sequenceGetItem, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, InvalidArrayIndexException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.read_array_element;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object object = getValue.execute(inliningTarget, behavior, method, this, key);
                return object;
            }
            Object object = sequenceGetItem.execute(this, PInt.intValueExact(key));
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void writeArrayElement(long key, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Shared @Cached PForeignToPTypeNode convert, @Cached PySequenceSetItemNode sequenceSetItemNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, InvalidArrayIndexException {
        block7: {
            boolean mustRelease = gil.acquire();
            try {
                value = convert.executeConvert(value);
                InteropBehaviorMethod method = InteropBehaviorMethod.write_array_element;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    getValue.execute(inliningTarget, behavior, method, this, key, value);
                    break block7;
                }
                try {
                    sequenceSetItemNode.execute(this, PInt.intValueExact(key), value);
                }
                catch (OverflowException cce) {
                    throw InvalidArrayIndexException.create((long)key);
                }
                catch (PException pe) {
                    throw UnsupportedMessageException.create();
                }
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeArrayElement(long key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached PySequenceDelItemNode sequenceDelItemNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, InvalidArrayIndexException {
        block7: {
            boolean mustRelease = gil.acquire();
            try {
                InteropBehaviorMethod method = InteropBehaviorMethod.remove_array_element;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    getValue.execute(inliningTarget, behavior, method, this, key);
                    break block7;
                }
                try {
                    sequenceDelItemNode.execute(this, PInt.intValueExact(key));
                }
                catch (OverflowException cce) {
                    throw InvalidArrayIndexException.create((long)key);
                }
                catch (PException pe) {
                    throw UnsupportedMessageException.create();
                }
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    @ExportMessage
    public long getArraySize(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached PySequenceSizeNode sequenceSizeNode, @Cached.Exclusive @Cached PySequenceCheckNode sequenceCheck, @Cached.Exclusive @Cached CastToJavaLongExactNode toLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.get_array_size;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                long l = getValue.executeLong(inliningTarget, behavior, method, toLongNode, raiseNode, this, new Object[0]);
                return l;
            }
            if (!sequenceCheck.execute(inliningTarget, this)) {
                throw UnsupportedMessageException.create();
            }
            try {
                long l = sequenceSizeNode.execute(null, inliningTarget, this);
                return l;
            }
            catch (PException pe) {
                throw UnsupportedMessageException.create();
            }
        }
        finally {
            gil.release(mustRelease);
        }
    }

    private boolean isInBounds(Node inliningTarget, long idx, PySequenceSizeNode sequenceSizeNode) {
        long length = sequenceSizeNode.execute(null, inliningTarget, this);
        return 0L <= idx && idx < length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementReadable(long idx, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached PySequenceSizeNode sequenceSizeNode, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_array_element_readable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, idx);
                return bl;
            }
            boolean bl = this.isInBounds(inliningTarget, idx, sequenceSizeNode);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementModifiable(long idx, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached PySequenceSizeNode sequenceSizeNode, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_array_element_modifiable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, idx);
                return bl;
            }
            boolean bl = this.isInBounds(inliningTarget, idx, sequenceSizeNode);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementInsertable(long idx, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached PySequenceSizeNode sequenceSizeNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_array_element_insertable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, idx);
                return bl;
            }
            boolean bl = !this.isInBounds(inliningTarget, idx, sequenceSizeNode);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isArrayElementRemovable(long idx, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached PySequenceSizeNode sequenceSizeNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_array_element_removable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, idx);
                return bl;
            }
            boolean bl = this.isInBounds(inliningTarget, idx, sequenceSizeNode);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public boolean hasMembers() {
        return true;
    }

    @ExportMessage
    public boolean isMemberReadable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 1);
    }

    @ExportMessage
    public boolean isMemberModifiable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 8);
    }

    @ExportMessage
    public boolean isMemberInsertable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 64);
    }

    @ExportMessage
    public boolean isMemberInvocable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 32);
    }

    @ExportMessage
    public boolean isMemberRemovable(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 16);
    }

    @ExportMessage
    public boolean hasMemberReadSideEffects(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 2);
    }

    @ExportMessage
    public boolean hasMemberWriteSideEffects(String member, @Cached.Shared(value="js2ts") @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Shared(value="keyInfoNode") @Cached PKeyInfoNode keyInfoNode) {
        return keyInfoNode.execute(this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object invokeMember(String member, Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached LookupInheritedAttributeNode.Dynamic lookupGetattributeNode, @Cached.Exclusive @Cached CallBinaryMethodNode callGetattributeNode, @Cached.Exclusive @Cached PExecuteNode executeNode2, @Cached.Exclusive @Cached InlinedConditionProfile profileGetattribute, @Cached.Exclusive @Cached InlinedConditionProfile profileMember, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attributeErrorProfile, @Cached.Exclusive @Cached GilNode gil) throws UnknownIdentifierException, UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            Object memberObj;
            try {
                Object attrGetattribute = lookupGetattributeNode.execute(inliningTarget, this, SpecialMethodNames.T___GETATTRIBUTE__);
                if (profileGetattribute.profile(inliningTarget, attrGetattribute == PNone.NO_VALUE)) {
                    throw UnknownIdentifierException.create((String)member);
                }
                memberObj = callGetattributeNode.executeObject(attrGetattribute, this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING));
                if (profileMember.profile(inliningTarget, memberObj == PNone.NO_VALUE)) {
                    throw UnknownIdentifierException.create((String)member);
                }
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonBuiltinClassType.AttributeError, attributeErrorProfile);
                throw UnknownIdentifierException.create((String)member);
            }
            Object object = executeNode2.execute(memberObj, arguments);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isExecutable(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached PyCallableCheckNode callableCheck, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_executable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = callableCheck.execute(inliningTarget, this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached PExecuteNode executeNode2, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.execute;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object object = getValue.execute(inliningTarget, behavior, method, this, arguments);
                return object;
            }
            Object object = executeNode2.execute(this, arguments);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public Object getMembers(boolean includeInternal, @Bind(value="$node") Node inliningTarget, @Cached CastToListExpressionNode.CastToListInteropNode castToList, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClass, @Cached PyMappingCheckNode checkMapping, @Cached.Exclusive @Cached PyObjectLookupAttr lookupKeys, @Cached CallNode callKeys, @Cached PyObjectGetItem getItemNode, @Cached SequenceNodes.LenNode lenNode, @Cached TypeNodes.GetMroNode getMroNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.RegionEqualNode regionEqualNode, @Cached TruffleString.ConcatNode concatNode, @Cached StringNodes.StringMaterializeNode materializeNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object object;
            HashSet<TruffleString> keys = new HashSet<TruffleString>();
            Object klass = getClass.executeCached(this);
            for (PythonAbstractClass o : getMroNode.execute(inliningTarget, klass)) {
                if (!(o instanceof PythonManagedClass)) continue;
                PythonAbstractObject.addKeysFromObject(keys, (PythonManagedClass)o, includeInternal, codePointLengthNode, regionEqualNode);
            }
            if (this instanceof PythonObject) {
                PythonAbstractObject.addKeysFromObject(keys, (PythonObject)this, includeInternal, codePointLengthNode, regionEqualNode);
            }
            if (includeInternal && checkMapping.execute(inliningTarget, this) && (object = lookupKeys.execute(null, inliningTarget, this, SpecialMethodNames.T_KEYS)) != PNone.NO_VALUE) {
                PList mapKeys = castToList.executeWithGlobalState(callKeys.executeWithoutFrame(object, new Object[0]));
                int len = lenNode.execute(inliningTarget, mapKeys);
                for (int i = 0; i < len; ++i) {
                    Object key = getItemNode.execute(null, inliningTarget, mapKeys, i);
                    TruffleString tsKey = null;
                    if (key instanceof TruffleString) {
                        tsKey = (TruffleString)key;
                    } else if (TruffleStringMigrationHelpers.isJavaString(key)) {
                        tsKey = PythonUtils.toTruffleStringUncached((String)key);
                    } else if (key instanceof PString) {
                        tsKey = materializeNode.execute(inliningTarget, (PString)key);
                    }
                    if (tsKey == null) continue;
                    keys.add(concatNode.execute((AbstractTruffleString)tsKey, (AbstractTruffleString)StringLiterals.T_LBRACKET, PythonUtils.TS_ENCODING, false));
                }
            }
            Keys keys2 = new Keys(keys.toArray(PythonUtils.EMPTY_TRUFFLESTRING_ARRAY));
            return keys2;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public void removeMember(String member, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PyObjectSetAttr deleteAttributeNode, @Cached.Exclusive @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile attrErrorProfile, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException, UnknownIdentifierException {
        boolean mustRelease = gil.acquire();
        try {
            deleteAttributeNode.delete(null, inliningTarget, this, fromJavaStringNode.execute(member, PythonUtils.TS_ENCODING));
        }
        catch (PException e) {
            e.expectAttributeError(inliningTarget, attrErrorProfile);
            throw UnknownIdentifierException.create((String)member);
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isInstantiable(@Bind(value="$node") Node inliningTarget, @Cached(inline=false) TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isTypeNode.execute(inliningTarget, this);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object instantiate(Object[] arguments, @CachedLibrary(value="this") InteropLibrary interopLib, @Cached.Exclusive @Cached PExecuteNode executeNode2, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (!interopLib.isInstantiable((Object)this)) {
                throw UnsupportedMessageException.create();
            }
            Object object = executeNode2.execute(this, arguments);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    private static void addKeysFromObject(HashSet<TruffleString> keys, PythonObject o, boolean includeInternal, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.RegionEqualNode regionEqualNode) {
        PDict dict = GetDictIfExistsNode.getUncached().execute(o);
        HashingStorage dictStorage = dict != null ? dict.getDictStorage() : new DynamicObjectStorage(o);
        HashingStorageNodes.HashingStorageIterator it = HashingStorageNodes.HashingStorageGetIterator.executeUncached(dictStorage);
        while (HashingStorageNodes.HashingStorageIteratorNext.executeUncached(dictStorage, it)) {
            TruffleString strKey;
            Object key = HashingStorageNodes.HashingStorageIteratorKey.executeUncached(dictStorage, it);
            if (key instanceof TruffleString) {
                strKey = (TruffleString)key;
            } else {
                if (!TruffleStringMigrationHelpers.isJavaString(key)) continue;
                strKey = PythonUtils.toTruffleStringUncached((String)key);
            }
            if (!includeInternal && PythonAbstractObject.startsWithPrivatePrefix(strKey, codePointLengthNode, regionEqualNode)) continue;
            keys.add(strKey);
        }
    }

    private static boolean startsWithPrivatePrefix(TruffleString strKey, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.RegionEqualNode regionEqualNode) {
        int strLen = codePointLengthNode.execute((AbstractTruffleString)strKey, PythonUtils.TS_ENCODING);
        return strLen >= PRIVATE_PREFIX_LENGTH && regionEqualNode.execute((AbstractTruffleString)strKey, 0, (AbstractTruffleString)T_PRIVATE_PREFIX, 0, PRIVATE_PREFIX_LENGTH, PythonUtils.TS_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isDate(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_date;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public LocalDate asDate(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode, @Cached.Exclusive @Cached PyTupleSizeNode pyTupleSizeNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_date;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object value = getValue.execute(inliningTarget, behavior, method, this);
                if (value instanceof PTuple) {
                    PTuple tuple = (PTuple)value;
                    if (pyTupleSizeNode.execute(inliningTarget, tuple) != 3) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_MUST_BE_A_S_TUPLE, "return value", "3");
                    }
                    SequenceStorage storage = tuple.getSequenceStorage();
                    int year = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 0), raiseNode);
                    int month = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 1), raiseNode);
                    int day = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 2), raiseNode);
                    try {
                        LocalDate localDate = PythonAbstractObject.createLocalDate(year, month, day);
                        return localDate;
                    }
                    catch (Exception e) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, e);
                    }
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_TYPE_A_NOT_TYPE_B, "return value", "tuple", value);
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isTime(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_time;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public LocalTime asTime(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode, @Cached.Exclusive @Cached PyTupleSizeNode pyTupleSizeNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_time;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object value = getValue.execute(inliningTarget, behavior, method, this);
                if (value instanceof PTuple) {
                    PTuple tuple = (PTuple)value;
                    if (pyTupleSizeNode.execute(inliningTarget, tuple) != 4) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_MUST_BE_A_S_TUPLE, "return value", "4");
                    }
                    SequenceStorage storage = tuple.getSequenceStorage();
                    int hour = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 0), raiseNode);
                    int min = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 1), raiseNode);
                    int sec = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 2), raiseNode);
                    int micro = castToIntNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 3), raiseNode);
                    try {
                        LocalTime localTime = PythonAbstractObject.createLocalTime(hour, min, sec, micro);
                        return localTime;
                    }
                    catch (Exception e) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, e);
                    }
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_TYPE_A_NOT_TYPE_B, "return value", "tuple", value);
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isTimeZone(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_time_zone;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public ZoneId asTimeZone(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaIntExactNode castToIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_time_zone;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object value;
                block10: {
                    value = getValue.execute(inliningTarget, behavior, method, this);
                    try {
                        if (!(value instanceof TruffleString)) break block10;
                        TruffleString tsValue = (TruffleString)value;
                        String tmZone = toJavaStringNode.execute((AbstractTruffleString)tsValue);
                        ZoneId zoneId = PythonAbstractObject.createZoneId(tmZone);
                        return zoneId;
                    }
                    catch (Exception e) {
                        try {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, e);
                        }
                        catch (CannotCastException cce) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_TYPE_A_NOT_TYPE_B, "return value", "str or int", value);
                        }
                    }
                }
                int utcDeltaInSeconds = castToIntNode.execute(inliningTarget, value);
                ZoneId zoneId = PythonAbstractObject.createZoneId(utcDeltaInSeconds);
                return zoneId;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static ZoneId createZoneId(int utcDeltaInSeconds) {
        return ZoneId.ofOffset("UTC", ZoneOffset.ofTotalSeconds(utcDeltaInSeconds));
    }

    @CompilerDirectives.TruffleBoundary
    private static ZoneId createZoneId(String zone) {
        return ZoneId.of(zone);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalTime createLocalTime(int hour, int min, int sec, int micro) {
        return LocalTime.of(hour, min, sec, micro * 1000);
    }

    @CompilerDirectives.TruffleBoundary
    private static LocalDate createLocalDate(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isDuration(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_duration;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Duration asDuration(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaLongExactNode castToLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached SequenceStorageNodes.GetItemDynamicNode getItemNode, @Cached.Exclusive @Cached PyTupleSizeNode pyTupleSizeNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_duration;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object value = getValue.execute(inliningTarget, behavior, method, this);
                if (value instanceof PTuple) {
                    PTuple tuple = (PTuple)value;
                    if (pyTupleSizeNode.execute(inliningTarget, tuple) != 2) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_MUST_BE_A_S_TUPLE, "return value", "2");
                    }
                    SequenceStorage storage = tuple.getSequenceStorage();
                    long sec = castToLongNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 0), raiseNode);
                    long nano = castToLongNode.executeWithThrowSystemError(inliningTarget, getItemNode.execute(inliningTarget, storage, 1), raiseNode);
                    try {
                        Duration duration = PythonAbstractObject.createDuration(sec, nano);
                        return duration;
                    }
                    catch (Exception e) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, e);
                    }
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_TYPE_A_NOT_TYPE_B, "return value", "tuple", value);
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Duration createDuration(long seconds, long nanoAdjustment) {
        return Duration.ofSeconds(seconds, nanoAdjustment);
    }

    public String toString() {
        return "<an abstract python object>";
    }

    @ExportMessage
    public boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    public Class<? extends TruffleLanguage<?>> getLanguage() {
        return PythonLanguage.class;
    }

    @CompilerDirectives.TruffleBoundary
    final TruffleString toStringBoundary() {
        return PythonUtils.toTruffleStringUncached(this.toString());
    }

    @ExportMessage
    public boolean hasMetaObject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public Object getMetaObject(@Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClass, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object object = getClass.executeCached(this);
            return object;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasMetaParents(@Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached TypeNodes.GetBaseClassesNode getBaseClassNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = isTypeNode.execute(inliningTarget, this) && getBaseClassNode.execute(inliningTarget, this).length > 0;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object getMetaParents(@Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Exclusive @Cached TypeNodes.GetBaseClassesNode getBaseClassNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            Object[] bases;
            if (isTypeNode.execute(inliningTarget, this) && (bases = getBaseClassNode.execute(inliningTarget, this)).length > 0) {
                PTuple pTuple = factory.createTuple(bases);
                return pTuple;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public int identityHashCode(@Bind(value="$node") Node inliningTarget, @Cached ObjectNodes.GetIdentityHashNode getIdentityHashNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            int n = getIdentityHashNode.execute(inliningTarget, this);
            return n;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static int systemHashCode(Object value) {
        return System.identityHashCode(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static String systemHashCodeAsHexString(Object value) {
        return Integer.toHexString(System.identityHashCode(value));
    }

    @CompilerDirectives.TruffleBoundary
    public static int objectHashCode(Object value) {
        return value.hashCode();
    }

    @CompilerDirectives.TruffleBoundary
    public static String objectHashCodeAsHexString(Object value) {
        return Integer.toHexString(value.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public TriState isIdenticalOrUndefined(Object otherInterop, @Cached.Shared @Cached PForeignToPTypeNode convert, @Cached.Exclusive @CachedLibrary(limit="3") InteropLibrary otherLib, @Cached IsNode isNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object other = convert.executeConvert(otherInterop);
            if (this == other) {
                TriState triState = TriState.TRUE;
                return triState;
            }
            if (otherLib.hasIdentity(other)) {
                TriState triState = isNode.execute(this, other) ? TriState.TRUE : TriState.FALSE;
                return triState;
            }
            TriState triState = TriState.UNDEFINED;
            return triState;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasIterator(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached(parameters={"Iter"}) LookupCallableSlotInMRONode lookupIter, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.has_iterator;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = !(lookupIter.execute(getClassNode.executeCached(this)) instanceof PNone);
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object getIterator(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached GilNode gil, @CachedLibrary(value="this") InteropLibrary lib) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (lib.hasIterator((Object)this)) {
                InteropBehaviorMethod method = InteropBehaviorMethod.get_iterator;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    Object object = getValue.execute(inliningTarget, behavior, method, this);
                    return object;
                }
                Object object = getIter.execute(null, inliningTarget, this);
                return object;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isIterator(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="getClass") @Cached(inline=false) GetClassNode getClassNode, @Cached(parameters={"Next"}) LookupCallableSlotInMRONode lookupNext, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_iterator;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = lookupNext.execute(getClassNode.executeCached(this)) != PNone.NO_VALUE;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public boolean hasIteratorNextElement(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached GetNextNode getNextNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile exceptionProfile, @Cached.Exclusive @Cached GilNode gil, @CachedLibrary(value="this") InteropLibrary ilib, @Cached.Exclusive @Cached HiddenAttr.ReadNode readHiddenAttrNode, @Cached.Exclusive @Cached HiddenAttr.WriteNode writeHiddenAttrNode) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (ilib.isIterator((Object)this)) {
                InteropBehaviorMethod method = InteropBehaviorMethod.has_iterator_next_element;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                    return bl;
                }
                Object nextElement = readHiddenAttrNode.execute(inliningTarget, this, HiddenAttr.NEXT_ELEMENT, null);
                if (nextElement != null) {
                    boolean bl = true;
                    return bl;
                }
                nextElement = getNextNode.execute(null, this);
                writeHiddenAttrNode.execute(inliningTarget, this, HiddenAttr.NEXT_ELEMENT, nextElement);
                boolean bl = true;
                return bl;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object getIteratorNextElement(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @CachedLibrary(value="this") InteropLibrary ilib, @Cached.Exclusive @Cached HiddenAttr.ReadNode readHiddenAttrNode, @Cached.Exclusive @Cached HiddenAttr.WriteNode writeHiddenAttrNode, @Cached.Exclusive @Cached GilNode gil) throws StopIterationException, UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (ilib.hasIteratorNextElement((Object)this)) {
                InteropBehaviorMethod method = InteropBehaviorMethod.get_iterator_next_element;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    Object object = getValue.execute(inliningTarget, behavior, method, this);
                    return object;
                }
                Object nextElement = readHiddenAttrNode.execute(inliningTarget, this, HiddenAttr.NEXT_ELEMENT, null);
                writeHiddenAttrNode.execute(inliningTarget, this, HiddenAttr.NEXT_ELEMENT, null);
                Object object = nextElement;
                return object;
            }
            throw StopIterationException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isBoolean(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_boolean;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isNumber(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_number;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isString(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_string;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInByte(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_byte;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInShort(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_short;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInInt(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_int;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInLong(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_long;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInFloat(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_float;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInDouble(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_double;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean fitsInBigInteger(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.fits_in_big_integer;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public boolean asBoolean(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_boolean;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public byte asByte(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaByteNode toByteNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_byte;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                byte by = getValue.executeByte(inliningTarget, behavior, method, toByteNode, raiseNode, this, new Object[0]);
                return by;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public short asShort(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaShortNode toShortNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_short;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                short s = getValue.executeShort(inliningTarget, behavior, method, toShortNode, raiseNode, this, new Object[0]);
                return s;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public int asInt(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_int;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                int n = getValue.executeInt(inliningTarget, behavior, method, toIntNode, raiseNode, this, new Object[0]);
                return n;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public long asLong(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaLongExactNode toLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_long;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                long l = getValue.executeLong(inliningTarget, behavior, method, toLongNode, raiseNode, this, new Object[0]);
                return l;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public float asFloat(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaDoubleNode toDoubleNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_float;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                float f = (float)getValue.executeDouble(inliningTarget, behavior, method, toDoubleNode, raiseNode, this, new Object[0]);
                return f;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public double asDouble(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaDoubleNode toDoubleNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_double;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                double d = getValue.executeDouble(inliningTarget, behavior, method, toDoubleNode, raiseNode, this, new Object[0]);
                return d;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public BigInteger asBigInteger(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached CastToJavaBigIntegerNode toBigIntegerNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_big_integer;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object value = getValue.execute(inliningTarget, behavior, method, this);
                BigInteger bigInteger = toBigIntegerNode.execute(inliningTarget, value);
                return bigInteger;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public String asString(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached CastToJavaStringNode toStringNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.as_string;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                String string = getValue.executeString(inliningTarget, behavior, method, toStringNode, raiseNode, this, new Object[0]);
                return string;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean hasHashEntries(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.has_hash_entries;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, new Object[0]);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public long getHashSize(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaLongExactNode toLongNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.get_hash_size;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                long l = getValue.executeLong(inliningTarget, behavior, method, toLongNode, raiseNode, this, new Object[0]);
                return l;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object getHashEntriesIterator(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.get_hash_entries_iterator;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object object = getValue.execute(inliningTarget, behavior, method, this);
                return object;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object getHashKeysIterator(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.get_hash_entries_iterator;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object object = getValue.execute(inliningTarget, behavior, method, this);
                return object;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object getHashValuesIterator(@Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.get_hash_values_iterator;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object object = getValue.execute(inliningTarget, behavior, method, this);
                return object;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    public Object readHashValue(Object key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.read_hash_value;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                Object object = getValue.execute(inliningTarget, behavior, method, this, key);
                return object;
            }
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isHashEntryReadable(Object key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_hash_entry_readable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isHashEntryRemovable(Object key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_hash_entry_removable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void removeHashEntry(Object key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        block4: {
            boolean mustRelease = gil.acquire();
            try {
                InteropBehaviorMethod method = InteropBehaviorMethod.remove_hash_entry;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    getValue.execute(inliningTarget, behavior, method, this, key);
                    break block4;
                }
                throw UnsupportedMessageException.create();
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isHashEntryModifiable(Object key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_hash_entry_modifiable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public boolean isHashEntryInsertable(Object key, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaBooleanNode toBooleanNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            InteropBehaviorMethod method = InteropBehaviorMethod.is_hash_entry_insertable;
            InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
            if (behavior != null) {
                boolean bl = getValue.executeBoolean(inliningTarget, behavior, method, toBooleanNode, raiseNode, this, key);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    public void writeHashEntry(Object key, Object value, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="getBehavior") @Cached GetInteropBehaviorNode getBehavior, @Cached.Shared(value="getValue") @Cached GetInteropBehaviorValueNode getValue, @Cached.Exclusive @Cached GilNode gil) throws UnsupportedMessageException {
        block4: {
            boolean mustRelease = gil.acquire();
            try {
                InteropBehaviorMethod method = InteropBehaviorMethod.write_hash_entry;
                InteropBehavior behavior = getBehavior.execute(inliningTarget, this, method);
                if (behavior != null) {
                    getValue.execute(inliningTarget, behavior, method, this, key, value);
                    break block4;
                }
                throw UnsupportedMessageException.create();
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    @ExportMessage
    public boolean hasBufferElements(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) {
        return bufferLib.isBuffer(this);
    }

    @ExportMessage
    public boolean isBufferWritable(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException {
        if (bufferLib.isBuffer(this)) {
            return !bufferLib.isReadonly(this);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public long getBufferSize(@Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException {
        if (bufferLib.isBuffer(this)) {
            return bufferLib.getBufferLength(this);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public byte readBufferByte(long byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            return bufferLib.readByte(this, offset);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public void writeBufferByte(long byteOffset, byte value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (!bufferLib.isBuffer(this)) {
            throw UnsupportedMessageException.create();
        }
        int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
        bufferLib.writeByte(this, offset, value);
    }

    @ExportMessage
    public short readBufferShort(ByteOrder order, long byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            return bufferLib.readShortByteOrder(this, offset, order);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public void writeBufferShort(ByteOrder order, long byteOffset, short value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (!bufferLib.isBuffer(this)) {
            throw UnsupportedMessageException.create();
        }
        int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
        bufferLib.writeShortByteOrder(this, offset, value, order);
    }

    @ExportMessage
    public int readBufferInt(ByteOrder order, long byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            return bufferLib.readIntByteOrder(this, offset, order);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public void writeBufferInt(ByteOrder order, long byteOffset, int value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (!bufferLib.isBuffer(this)) {
            throw UnsupportedMessageException.create();
        }
        int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
        bufferLib.writeIntByteOrder(this, offset, value, order);
    }

    @ExportMessage
    public long readBufferLong(ByteOrder order, long byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            return bufferLib.readLongByteOrder(this, offset, order);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public void writeBufferLong(ByteOrder order, long byteOffset, long value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (!bufferLib.isBuffer(this)) {
            throw UnsupportedMessageException.create();
        }
        int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
        bufferLib.writeLongByteOrder(this, offset, value, order);
    }

    @ExportMessage
    public float readBufferFloat(ByteOrder order, long byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            return bufferLib.readFloatByteOrder(this, offset, order);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public void writeBufferFloat(ByteOrder order, long byteOffset, float value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (!bufferLib.isBuffer(this)) {
            throw UnsupportedMessageException.create();
        }
        int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
        bufferLib.writeFloatByteOrder(this, offset, value, order);
    }

    @ExportMessage
    public double readBufferDouble(ByteOrder order, long byteOffset, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            return bufferLib.readDoubleByteOrder(this, offset, order);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public void writeBufferDouble(ByteOrder order, long byteOffset, double value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (!bufferLib.isBuffer(this)) {
            throw UnsupportedMessageException.create();
        }
        int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
        bufferLib.writeDoubleByteOrder(this, offset, value, order);
    }

    @ExportMessage
    public void readBuffer(long byteOffset, byte[] destination, int destinationOffset, int length, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CastToJavaIntExactNode toIntNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode, @Cached.Shared(value="bufferLib") @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib) throws UnsupportedMessageException, InvalidBufferOffsetException {
        if (bufferLib.isBuffer(this)) {
            if (length < 0 || destination.length - destinationOffset > length) {
                throw InvalidBufferOffsetException.create((long)byteOffset, (long)length);
            }
            int offset = toIntNode.executeWithThrow(inliningTarget, byteOffset, raiseNode, PythonBuiltinClassType.OverflowError);
            for (int i = 0; i < length; ++i) {
                destination[destinationOffset + i] = bufferLib.readByte(this, offset + i);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateUncached
    public static abstract class PKeyInfoNode
    extends Node {
        private static final int READABLE = 1;
        private static final int READ_SIDE_EFFECTS = 2;
        private static final int WRITE_SIDE_EFFECTS = 4;
        private static final int MODIFIABLE = 8;
        private static final int REMOVABLE = 16;
        private static final int INVOCABLE = 32;
        private static final int INSERTABLE = 64;

        public abstract boolean execute(Object var1, TruffleString var2, int var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static boolean access(Object object, TruffleString attrKeyName, int type, @Bind(value="this") Node inliningTarget, @Cached(value="createForceType()") ReadAttributeFromObjectNode readTypeAttrNode, @Cached ReadAttributeFromObjectNode readObjectAttrNode, @Cached PyCallableCheckNode callableCheck, @Cached LookupInheritedAttributeNode.Dynamic getGetNode, @Cached LookupInheritedAttributeNode.Dynamic getSetNode, @Cached LookupInheritedAttributeNode.Dynamic getDeleteNode, @Cached GetClassNode getClassNode, @Cached IsImmutable isImmutable, @Cached TypeNodes.GetMroNode getMroNode, @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                Object owner = object;
                Object attr = PNone.NO_VALUE;
                Object klass = getClassNode.execute(inliningTarget, object);
                for (PythonAbstractClass c : getMroNode.execute(inliningTarget, klass)) {
                    attr = readTypeAttrNode.execute(c, attrKeyName);
                    if (attr == PNone.NO_VALUE) continue;
                    owner = c;
                    break;
                }
                if (attr == PNone.NO_VALUE) {
                    attr = readObjectAttrNode.execute(owner, attrKeyName);
                }
                switch (type) {
                    case 1: {
                        boolean bl = attr != PNone.NO_VALUE;
                        return bl;
                    }
                    case 64: {
                        boolean bl = attr == PNone.NO_VALUE && !isImmutable.execute(inliningTarget, object);
                        return bl;
                    }
                    case 16: {
                        boolean bl = attr != PNone.NO_VALUE && !isImmutable.execute(inliningTarget, owner);
                        return bl;
                    }
                    case 8: {
                        if (attr != PNone.NO_VALUE) {
                            if (owner == object) {
                                boolean bl = !isImmutable.execute(inliningTarget, owner);
                                return bl;
                            }
                            if (getSetNode.execute(inliningTarget, attr, SpecialMethodNames.T___SET__) == PNone.NO_VALUE) {
                                boolean bl = !isImmutable.execute(inliningTarget, object);
                                return bl;
                            }
                            if (getSetNode.execute(inliningTarget, attr, SpecialMethodNames.T___SET__) != PNone.NO_VALUE) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 32: {
                        if (attr != PNone.NO_VALUE) {
                            if (owner != object) {
                                if (attr instanceof PFunction || attr instanceof PBuiltinFunction) {
                                    boolean bl = true;
                                    return bl;
                                }
                                if (getGetNode.execute(inliningTarget, attr, SpecialMethodNames.T___GET__) != PNone.NO_VALUE) {
                                    boolean bl = false;
                                    return bl;
                                }
                            }
                            boolean bl = callableCheck.execute(inliningTarget, attr);
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 2: {
                        if (attr != PNone.NO_VALUE && owner != object && !(attr instanceof PFunction) && !(attr instanceof PBuiltinFunction)) {
                            boolean bl = getGetNode.execute(inliningTarget, attr, SpecialMethodNames.T___GET__) != PNone.NO_VALUE;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case 4: {
                        if (attr != PNone.NO_VALUE && owner != object && !(attr instanceof PFunction) && !(attr instanceof PBuiltinFunction)) {
                            boolean bl = getSetNode.execute(inliningTarget, attr, SpecialMethodNames.T___SET__) != PNone.NO_VALUE || getDeleteNode.execute(inliningTarget, attr, SpecialMethodNames.T___DELETE__) != PNone.NO_VALUE;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    @GenerateUncached
    @ReportPolymorphism
    public static abstract class PExecuteNode
    extends Node {
        public abstract Object execute(Object var1, Object[] var2) throws UnsupportedMessageException;

        @Specialization(guards={"isBuiltinFunctionOrMethod(receiver)"})
        Object doVarargsBuiltinMethod(Object receiver, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached CallVarargsMethodNode callVarargsMethodNode, @Cached.Exclusive @Cached ArgumentsFromForeignNode convertArgsNode) {
            Object[] convertedArgs = convertArgsNode.execute(inliningTarget, arguments);
            return callVarargsMethodNode.execute(null, receiver, convertedArgs, PKeyword.EMPTY_KEYWORDS);
        }

        @Specialization(replaces={"doVarargsBuiltinMethod"})
        static Object doExecute(Object receiver, Object[] arguments, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck, @Cached.Exclusive @Cached CallNode callNode, @Cached.Exclusive @Cached ArgumentsFromForeignNode convertArgsNode) throws UnsupportedMessageException {
            if (!callableCheck.execute(inliningTarget, receiver)) {
                throw UnsupportedMessageException.create();
            }
            Object[] convertedArgs = convertArgsNode.execute(inliningTarget, arguments);
            return callNode.execute((Frame)null, receiver, convertedArgs, PKeyword.EMPTY_KEYWORDS);
        }

        static boolean isBuiltinFunctionOrMethod(Object object) {
            return object instanceof PBuiltinMethod || object instanceof PBuiltinFunction;
        }

        public static PExecuteNode getUncached() {
            return PythonAbstractObjectFactory.PExecuteNodeGen.getUncached();
        }

        public Node copy() {
            return PythonAbstractObjectFactory.PExecuteNodeGen.create();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class Keys
    implements TruffleObject {
        private final Object[] keys;

        public Keys(Object[] keys) {
            this.keys = keys;
        }

        @ExportMessage
        Object readArrayElement(long index, @Cached InlinedBranchProfile outOfBoundsProfile, @Bind(value="$node") Node inliningTarget) throws InvalidArrayIndexException {
            if (Long.compareUnsigned(index, this.keys.length) < 0) {
                return this.keys[(int)index];
            }
            outOfBoundsProfile.enter(inliningTarget);
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        long getArraySize(@Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                long l = this.keys.length;
                return l;
            }
            finally {
                gil.release(mustRelease);
            }
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return index >= 0L && index < (long)this.keys.length;
        }
    }

    @ExportMessage
    public static class ToDisplayString {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"allowSideEffects"})
        public static TruffleString doSideEffecting(PythonAbstractObject receiver, boolean allowSideEffects, @Bind(value="$node") Node inliningTarget, @Cached ToDisplaySideEffectingNode toDisplayCallNode, @Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                TruffleString truffleString = toDisplayCallNode.execute(inliningTarget, receiver);
                return truffleString;
            }
            finally {
                gil.release(mustRelease);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!allowSideEffects"})
        public static TruffleString doNonSideEffecting(PythonAbstractObject receiver, boolean allowSideEffects, @Cached.Exclusive @Cached GilNode gil) {
            boolean mustRelease = gil.acquire();
            try {
                TruffleString truffleString = receiver.toStringBoundary();
                return truffleString;
            }
            finally {
                gil.release(mustRelease);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ToDisplaySideEffectingNode
    extends Node {
        public abstract TruffleString execute(Node var1, PythonAbstractObject var2);

        @Specialization
        public static TruffleString doDefault(Node inliningTarget, PythonAbstractObject receiver, @Cached(inline=false) ReadAttributeFromObjectNode readStr, @Cached(inline=false) CallNode callNode, @Cached CastToTruffleStringNode castStr, @Cached InlinedConditionProfile toStringUsed) {
            PythonContext context = PythonContext.get(inliningTarget);
            TruffleString names = context.getOption(PythonOptions.UseReprForPrintString) != false ? BuiltinNames.T_REPR : BuiltinNames.T_STR;
            TruffleString result = null;
            PythonModule builtins = context.getBuiltins();
            if (toStringUsed.profile(inliningTarget, builtins != null)) {
                Object toStrAttr = readStr.execute(builtins, names);
                try {
                    result = castStr.execute(inliningTarget, callNode.executeWithoutFrame(toStrAttr, receiver));
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
            }
            if (toStringUsed.profile(inliningTarget, result != null)) {
                return result;
            }
            return receiver.toStringBoundary();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ArgumentsFromForeignNode
    extends Node {
        public abstract Object[] execute(Node var1, Object[] var2);

        @Specialization(guards={"arguments.length == cachedLen", "cachedLen < 6"}, limit="3")
        @ExplodeLoop
        static Object[] cached(Object[] arguments, @Cached.Shared @Cached(inline=false) PForeignToPTypeNode fromForeign, @Cached(value="arguments.length") int cachedLen) {
            Object[] convertedArgs = new Object[cachedLen];
            for (int i = 0; i < cachedLen; ++i) {
                convertedArgs[i] = fromForeign.executeConvert(arguments[i]);
            }
            return convertedArgs;
        }

        @Specialization(replaces={"cached"})
        static Object[] generic(Object[] arguments, @Cached.Shared @Cached(inline=false) PForeignToPTypeNode fromForeign) {
            Object[] convertedArgs = new Object[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                convertedArgs[i] = fromForeign.executeConvert(arguments[i]);
            }
            return convertedArgs;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class IsImmutable
    extends Node {
        public abstract boolean execute(Node var1, Object var2);

        @Specialization
        public static boolean isImmutable(Node inliningTarget, Object object, @Cached GetClassNode getClassNode) {
            if (object instanceof PythonBuiltinClass || object instanceof PythonBuiltinObject || PGuards.isNativeClass(object) || PGuards.isNativeObject(object)) {
                return true;
            }
            if (object instanceof PythonClass || object instanceof PythonModule) {
                return false;
            }
            Object klass = getClassNode.execute(inliningTarget, object);
            return klass instanceof PythonBuiltinClassType || klass instanceof PythonBuiltinClass || PGuards.isNativeClass(object);
        }
    }
}

