/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.FileIOBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.FileIOBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.OwnFD;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.lib.PyErrChainExceptions;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayOutputStream;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PFileIO})
public final class FileIOBuiltins
extends PythonBuiltins {
    private static final int MAX_SIZE = Integer.MAX_VALUE;
    public static final int READ_MAX = Integer.MAX_VALUE;
    private static final int SMALLCHUNK = 8192;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FileIOBuiltinsFactory.getFactories();
    }

    static void internalClose(VirtualFrame frame, PFileIO self, PosixModuleBuiltins.CloseNode posixClose) {
        int fd = self.getFD();
        if (fd >= 0) {
            self.setClosed();
            posixClose.execute(frame, fd);
        }
    }

    static void deallocWarn(VirtualFrame frame, PFileIO self, WarningsModuleBuiltins.WarnNode warn) {
        if (self.getFD() >= 0 && self.isCloseFD()) {
            try {
                warn.resourceWarning((Frame)frame, self, 1, ErrorMessages.UNCLOSED_FILE, self);
            }
            catch (PException pException) {
                // empty catch block
            }
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString T_CLOSED = PythonUtils.tsLiteral("<_io.FileIO [closed]>");

        ReprNode() {
        }

        @Specialization(guards={"self.isClosed()"})
        static TruffleString doit(PFileIO self) {
            return T_CLOSED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isClosed()"})
        static TruffleString doit(VirtualFrame frame, PFileIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupName, @Cached(value="create(Repr)") LookupAndCallUnaryNode repr, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString mode = ModeNode.modeString(self);
            TruffleString closefd = self.isCloseFD() ? StringLiterals.T_TRUE : StringLiterals.T_FALSE;
            Object nameobj = lookupName.execute((Frame)frame, inliningTarget, self, IONodes.T_NAME);
            if (nameobj instanceof PNone) {
                return simpleTruffleStringFormatNode.format("<_io.FileIO fd=%d mode='%s' closefd=%s>", self.getFD(), mode, closefd);
            }
            if (!PythonContext.get(inliningTarget).reprEnter(self)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.RuntimeError, ErrorMessages.REENTRANT_CALL_INSIDE_P_REPR, self);
            }
            try {
                TruffleString name = castToTruffleStringNode.execute(inliningTarget, repr.executeObject(frame, nameobj));
                TruffleString truffleString = simpleTruffleStringFormatNode.format("<_io.FileIO name=%s mode='%s' closefd=%s>", name, mode, closefd);
                return truffleString;
            }
            finally {
                PythonContext.get(inliningTarget).reprLeave(self);
            }
        }
    }

    @Builtin(name="_finalizing", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class FinalizingNode
    extends PythonBinaryBuiltinNode {
        FinalizingNode() {
        }

        @Specialization(guards={"isNoValue(v)"})
        static Object doit(PFileIO self, PNone v) {
            return self.isFinalizing();
        }

        @Specialization(guards={"!isNoValue(v)"})
        static Object doit(VirtualFrame frame, PFileIO self, Object v, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            self.setFinalizing(isTrueNode.execute((Frame)frame, inliningTarget, v));
            return PNone.NONE;
        }
    }

    @Builtin(name="_blksize", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class BlksizeNode
    extends PythonBinaryBuiltinNode {
        BlksizeNode() {
        }

        @Specialization(guards={"isNoValue(v)"})
        static Object doit(PFileIO self, PNone v) {
            return self.getBlksize();
        }

        @Specialization(guards={"!isNoValue(v)"})
        static Object doit(VirtualFrame frame, PFileIO self, Object v, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            self.setBlksize(asSizeNode.executeExact((Frame)frame, inliningTarget, v));
            return PNone.NONE;
        }
    }

    @Builtin(name="mode", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ModeNode
    extends PythonUnaryBuiltinNode {
        public static final TruffleString T_XB = PythonUtils.tsLiteral("xb");
        public static final TruffleString T_XBP = PythonUtils.tsLiteral("xb+");
        public static final TruffleString T_AB = PythonUtils.tsLiteral("ab");
        public static final TruffleString T_ABP = PythonUtils.tsLiteral("ab+");
        public static final TruffleString T_RB = PythonUtils.tsLiteral("rb");
        public static final TruffleString T_RBP = PythonUtils.tsLiteral("rb+");
        public static final TruffleString T_WB = PythonUtils.tsLiteral("wb");

        ModeNode() {
        }

        static TruffleString modeString(PFileIO self) {
            if (self.isCreated()) {
                return self.isReadable() ? T_XBP : T_XB;
            }
            if (self.isAppending()) {
                return self.isReadable() ? T_ABP : T_AB;
            }
            if (self.isReadable()) {
                return self.isWritable() ? T_RBP : T_RB;
            }
            return T_WB;
        }

        @Specialization
        static TruffleString doit(PFileIO self) {
            return ModeNode.modeString(self);
        }
    }

    @Builtin(name="closefd", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class CloseFDNode
    extends PythonUnaryBuiltinNode {
        CloseFDNode() {
        }

        @Specialization
        static Object doit(PFileIO self) {
            return self.isCloseFD();
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization
        static Object doit(PFileIO self) {
            return self.getFD() < 0;
        }
    }

    @Builtin(name="_dealloc_warn", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DeallocWarnNode
    extends PythonUnaryBuiltinNode {
        DeallocWarnNode() {
        }

        @Specialization
        static Object deallocWarn(VirtualFrame frame, PFileIO self, @Cached WarningsModuleBuiltins.WarnNode warnNode) {
            FileIOBuiltins.deallocWarn(frame, self, warnNode);
            return PNone.NONE;
        }
    }

    @Builtin(name="isatty", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsattyNode
    extends PythonUnaryBuiltinNode {
        IsattyNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isClosed()"})
        boolean isatty(PFileIO self, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil) {
            gil.release(true);
            try {
                boolean bl = posixLib.isatty(this.getPosixSupport(), self.getFD());
                return bl;
            }
            finally {
                gil.acquire();
            }
        }

        @Specialization(guards={"self.isClosed()"})
        static boolean closedError(PFileIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="fileno", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FilenoNode
    extends PythonBuiltinNode {
        FilenoNode() {
        }

        @Specialization(guards={"!self.isClosed()"})
        static Object fileno(PFileIO self) {
            return self.getFD();
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends PythonUnaryBuiltinNode {
        WritableNode() {
        }

        @Specialization(guards={"!self.isClosed()"})
        static Object writable(PFileIO self) {
            return self.isWritable();
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends PythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"!self.isClosed()"})
        static Object readable(PFileIO self) {
            return self.isReadable();
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends PythonUnaryBuiltinNode {
        SeekableNode() {
        }

        protected static boolean isUnknown(PFileIO self) {
            return self.getSeekable() < 0;
        }

        @Specialization(guards={"!self.isClosed()", "isUnknown(self)"})
        Object unknown(PFileIO self, @CachedLibrary(limit="1") PosixSupportLibrary posixLib) {
            try {
                posixLib.lseek(this.getPosixSupport(), self.getFD(), 0L, PosixModuleBuiltins.mapPythonSeekWhenceToPosix(1));
                self.setSeekable(1);
                return true;
            }
            catch (PosixSupportLibrary.PosixException e) {
                self.setSeekable(0);
                return false;
            }
        }

        @Specialization(guards={"!self.isClosed()", "!isUnknown(self)"})
        static Object known(PFileIO self) {
            return self.getSeekable() == 1;
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization(guards={"!self.isCloseFD()"})
        static Object simple(VirtualFrame frame, PFileIO self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callClose) {
            try {
                callClose.execute((Frame)frame, inliningTarget, PythonContext.get(inliningTarget).lookupType(PythonBuiltinClassType.PRawIOBase), IONodes.T_CLOSE, self);
            }
            catch (PException e) {
                self.setClosed();
                throw e;
            }
            self.setClosed();
            return PNone.NONE;
        }

        @Specialization(guards={"self.isCloseFD()", "!self.isFinalizing()"})
        static Object common(VirtualFrame frame, PFileIO self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="c") @Cached PosixModuleBuiltins.CloseNode posixClose, @Cached.Shared(value="l") @Cached PyObjectCallMethodObjArgs callSuperClose, @Cached.Shared @Cached PyErrChainExceptions chainExceptions) {
            try {
                callSuperClose.execute((Frame)frame, inliningTarget, PythonContext.get(inliningTarget).lookupType(PythonBuiltinClassType.PRawIOBase), IONodes.T_CLOSE, self);
            }
            catch (PException e) {
                try {
                    FileIOBuiltins.internalClose(frame, self, posixClose);
                }
                catch (PException ee) {
                    throw chainExceptions.execute(inliningTarget, ee, e);
                }
                throw e;
            }
            FileIOBuiltins.internalClose(frame, self, posixClose);
            return PNone.NONE;
        }

        @Specialization(guards={"self.isCloseFD()", "self.isFinalizing()"})
        static Object slow(VirtualFrame frame, PFileIO self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="c") @Cached PosixModuleBuiltins.CloseNode posixClose, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached.Shared(value="l") @Cached PyObjectCallMethodObjArgs callSuperClose, @Cached.Shared @Cached PyErrChainExceptions chainExceptions) {
            PException rawIOException = null;
            PythonContext context = PythonContext.get(inliningTarget);
            try {
                callSuperClose.execute((Frame)frame, inliningTarget, context.lookupType(PythonBuiltinClassType.PRawIOBase), IONodes.T_CLOSE, self);
            }
            catch (PException e) {
                rawIOException = e;
            }
            FileIOBuiltins.deallocWarn(frame, self, warnNode);
            try {
                FileIOBuiltins.internalClose(frame, self, posixClose);
            }
            catch (PException ee) {
                if (rawIOException != null) {
                    throw chainExceptions.execute(inliningTarget, ee, rawIOException);
                }
                throw ee;
            }
            if (rawIOException != null) {
                throw rawIOException;
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"$self", "size"})
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends PythonBinaryBuiltinNode {
        TruncateNode() {
        }

        @Specialization(guards={"!self.isClosed()", "self.isWritable()", "!isPNone(posobj)"})
        static Object num(VirtualFrame frame, PFileIO self, Object posobj, @Cached.Shared(value="ft") @Cached PosixModuleBuiltins.FtruncateNode posixTruncate) {
            posixTruncate.execute(frame, self.getFD(), posobj);
            return posobj;
        }

        @Specialization(guards={"!self.isClosed()", "self.isWritable()"})
        static Object none(VirtualFrame frame, PFileIO self, PNone posobj, @Cached.Shared(value="ft") @Cached PosixModuleBuiltins.FtruncateNode posixTruncate, @Cached PosixModuleBuiltins.LseekNode posixSeek) {
            Object pos = posixSeek.execute(frame, self.getFD(), 0, 1);
            posixTruncate.execute(frame, self.getFD(), pos);
            return pos;
        }

        @Specialization(guards={"!self.isClosed()", "!self.isWritable()"})
        static Object notWritable(PFileIO self, Object posobj, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.FILE_NOT_OPEN_FOR_S, "writing");
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, Object posobj, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class TellNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object tell(VirtualFrame frame, PFileIO self, @Cached SeekNode seekNode) {
            return seekNode.execute(frame, self, 0, 1);
        }

        static long internalTell(PFileIO self, Object posixSupport, PosixSupportLibrary posixLib) throws PosixSupportLibrary.PosixException {
            return SeekNode.internalSeek(self, 0L, 1, posixSupport, posixLib);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "pos", "whence"})
    @ArgumentsClinic(value={@ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedIOUtil.SEEK_SET", useDefaultForNone=true), @ArgumentClinic(name="pos", conversion=ArgumentClinic.ClinicConversion.Long)})
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FileIOBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isClosed()"})
        Object seek(VirtualFrame frame, PFileIO self, long pos, int whence, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            Long l;
            gil.release(true);
            try {
                l = SeekNode.internalSeek(self, pos, whence, this.getPosixSupport(), posixLib);
                gil.acquire();
            }
            catch (Throwable throwable) {
                try {
                    gil.acquire();
                    throw throwable;
                }
                catch (PosixSupportLibrary.PosixException e) {
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
            }
            return l;
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, Object pos, int whence, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static long internalSeek(PFileIO self, long pos, int whence, Object posixSupport, PosixSupportLibrary posixLib) throws PosixSupportLibrary.PosixException {
            try {
                long res = posixLib.lseek(posixSupport, self.getFD(), pos, PosixModuleBuiltins.mapPythonSeekWhenceToPosix(whence));
                if (self.getSeekable() < 0) {
                    self.setSeekable(1);
                }
                long l = res;
                return l;
            }
            finally {
                if (self.getSeekable() < 0) {
                    self.setSeekable(0);
                }
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class GetBytesToWriteNode
    extends Node {
        GetBytesToWriteNode() {
        }

        abstract byte[] execute(VirtualFrame var1, Node var2, PFileIO var3, Object var4);

        @Specialization(guards={"!self.isUTF8Write()"})
        static byte[] doBytes(VirtualFrame frame, PFileIO self, Object data, @Cached(inline=false) BytesNodes.ToBytesNode toBytes) {
            return toBytes.execute(frame, data);
        }

        @Specialization(guards={"self.isUTF8Write()"})
        static byte[] doUtf8(Node inliningTarget, PFileIO self, Object data, @Cached(inline=false) CodecsModuleBuiltins.CodecsEncodeToJavaBytesNode encode, @Cached CastToTruffleStringNode castStr) {
            return encode.execute(castStr.execute(inliningTarget, data), StringLiterals.T_UTF8, StringLiterals.T_STRICT);
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class WriteNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"!self.isClosed()", "self.isWritable()"})
        static Object write(VirtualFrame frame, PFileIO self, Object data, @Bind(value="this") Node inliningTarget, @Cached GetBytesToWriteNode getBytesToWriteNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile errorProfile, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            byte[] bytes = getBytesToWriteNode.execute(frame, inliningTarget, self, data);
            try {
                return PosixModuleBuiltins.WriteNode.write(self.getFD(), bytes, bytes.length, inliningTarget, posixLib, errorProfile, gil);
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (e.getErrorCode() == OSErrorEnum.EAGAIN.getNumber()) {
                    return PNone.NONE;
                }
                errorProfile.enter(inliningTarget);
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Specialization(guards={"!self.isClosed()", "!self.isWritable()"})
        static Object notWritable(PFileIO self, Object buf, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.FILE_NOT_OPEN_FOR_S, "writing");
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, Object buf, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="readinto", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.WritableBuffer)
    @GenerateNodeFactory
    static abstract class ReadintoNode
    extends PythonBinaryClinicBuiltinNode {
        ReadintoNode() {
        }

        @Specialization(guards={"!self.isClosed()", "self.isReadable()"})
        static Object readinto(VirtualFrame frame, PFileIO self, Object buffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PosixModuleBuiltins.ReadNode posixRead, @Cached InlinedBranchProfile readErrorProfile, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            try {
                int size = bufferLib.getBufferLength(buffer);
                if (size == 0) {
                    Integer n = 0;
                    return n;
                }
                PBytes data = posixRead.read(self.getFD(), size, inliningTarget, posixLib, readErrorProfile, gil, factory);
                int n = bufferLib.getBufferLength(data);
                bufferLib.readIntoBuffer(data, 0, buffer, 0, n, bufferLib);
                Integer n2 = n;
                return n2;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Specialization(guards={"!self.isClosed()", "!self.isReadable()"})
        static Object notReadable(PFileIO self, Object buffer, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.FILE_NOT_OPEN_FOR_S, "reading");
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, Object buffer, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FileIOBuiltinsClinicProviders.ReadintoNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="readall", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadallNode
    extends PythonUnaryBuiltinNode {
        ReadallNode() {
        }

        @Specialization(guards={"!self.isClosed()"})
        static Object readall(VirtualFrame frame, PFileIO self, @Bind(value="this") Node inliningTarget, @Cached PosixModuleBuiltins.ReadNode posixRead, @Cached InlinedBranchProfile readErrorProfile, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached InlinedBranchProfile multipleReadsProfile, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PBytes b;
            int bufsize = 8192;
            boolean mayBeQuick = false;
            try {
                PosixSupport posixSupport = PosixSupport.get(inliningTarget);
                long pos = posixLib.lseek(posixSupport, self.getFD(), 0L, PosixModuleBuiltins.mapPythonSeekWhenceToPosix(1));
                long[] status = posixLib.fstat(posixSupport, self.getFD());
                long end = status[6];
                if (end > 0L && end >= pos && pos >= 0L && end - pos < Integer.MAX_VALUE) {
                    bufsize = (int)(end - pos + 1L);
                    mayBeQuick = true;
                }
            }
            catch (PosixSupportLibrary.PosixException posixSupport) {
                // empty catch block
            }
            int bytesRead = 0;
            try {
                b = posixRead.read(self.getFD(), bufsize, inliningTarget, posixLib, readErrorProfile, gil, factory);
                bytesRead = b.getSequenceStorage().length();
                if (bytesRead == 0 || mayBeQuick && bytesRead == bufsize - 1) {
                    return b;
                }
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (e.getErrorCode() == OSErrorEnum.EAGAIN.getNumber()) {
                    return PNone.NONE;
                }
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            multipleReadsProfile.enter(inliningTarget);
            byte[] buffer = getBytes.execute(inliningTarget, b.getSequenceStorage());
            ByteArrayOutputStream result = BytesUtils.createOutputStream();
            BytesUtils.append(result, buffer, bytesRead);
            while (true) {
                int n;
                if (bytesRead >= bufsize && (bufsize = bytesRead + Math.max(8192, bytesRead + 256)) <= 0) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.UNBOUNDED_READ_RETURNED_MORE_BYTES);
                }
                try {
                    b = posixRead.read(self.getFD(), bufsize - bytesRead, inliningTarget, posixLib, readErrorProfile, gil, factory);
                    buffer = getBytes.execute(inliningTarget, b.getSequenceStorage());
                    n = b.getSequenceStorage().length();
                    if (n == 0) {
                        break;
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    if (e.getErrorCode() == OSErrorEnum.EAGAIN.getNumber()) {
                        if (bytesRead > 0) break;
                        return PNone.NONE;
                    }
                    throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                }
                BytesUtils.append(result, buffer, n);
                bytesRead += n;
            }
            return factory.createBytes(BytesUtils.toByteArray(result));
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends PythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FileIOBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!self.isClosed()", "self.isReadable()", "size < 0"})
        static Object readall(VirtualFrame frame, PFileIO self, int size, @Cached ReadallNode readallNode) {
            return readallNode.execute(frame, self);
        }

        @Specialization(guards={"!self.isClosed()", "self.isReadable()", "size == 0"})
        static Object none(PFileIO self, int size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createEmptyBytes();
        }

        @Specialization(guards={"!self.isClosed()", "self.isReadable()", "size >= 0"})
        static Object read(VirtualFrame frame, PFileIO self, int size, @Bind(value="this") Node inliningTarget, @Cached PosixModuleBuiltins.ReadNode posixRead, @Cached InlinedBranchProfile readErrorProfile, @Cached InlinedBranchProfile readErrorProfile2, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached GilNode gil, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                return posixRead.read(self.getFD(), size, inliningTarget, posixLib, readErrorProfile, gil, factory);
            }
            catch (PosixSupportLibrary.PosixException e) {
                if (e.getErrorCode() == OSErrorEnum.EAGAIN.getNumber()) {
                    readErrorProfile2.enter(inliningTarget);
                    return PNone.NONE;
                }
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
        }

        @Specialization(guards={"!self.isClosed()", "!self.isReadable()"})
        static Object notReadable(PFileIO self, int size, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.FILE_NOT_OPEN_FOR_S, "reading");
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PFileIO self, int size, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, parameterNames={"$self", "name", "mode", "closefd", "opener"})
    @ArgumentsClinic(value={@ArgumentClinic(name="mode", conversionClass=IONodes.CreateIOModeNode.class, args={"false"}), @ArgumentClinic(name="closefd", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="true", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FileIOBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone doInit(VirtualFrame frame, PFileIO self, Object nameobj, IONodes.IOMode mode, boolean closefd, Object opener, @Bind(value="this") Node inliningTarget, @Cached FileIOInit fileIOInit) {
            fileIOInit.execute(frame, inliningTarget, self, nameobj, mode, closefd, opener);
            return PNone.NONE;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FileIOInit
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, PFileIO var3, Object var4, IONodes.IOMode var5, boolean var6, Object var7);

        private static void errorCleanup(VirtualFrame frame, PFileIO self, boolean fdIsOwn, PosixModuleBuiltins.CloseNode posixClose) {
            if (!fdIsOwn) {
                self.setClosed();
            } else {
                FileIOBuiltins.internalClose(frame, self, posixClose);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int open(VirtualFrame frame, TruffleString name, int flags, int mode, PythonContext ctxt, Node inliningTarget, PosixSupportLibrary posixLib, GilNode gil, InlinedBranchProfile errorProfile, PRaiseNode.Lazy raiseNode, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            Object path = posixLib.createPathFromString(ctxt.getPosixSupport(), name);
            if (path == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_BYTE);
            }
            while (true) {
                int n;
                gil.release(true);
                try {
                    n = posixLib.openat(ctxt.getPosixSupport(), PosixConstants.AT_FDCWD.value, path, flags, mode);
                    gil.acquire();
                }
                catch (Throwable throwable) {
                    try {
                        gil.acquire();
                        throw throwable;
                    }
                    catch (PosixSupportLibrary.PosixException e) {
                        errorProfile.enter(inliningTarget);
                        if (e.getErrorCode() != OSErrorEnum.EINTR.getNumber()) throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e, name);
                        PythonContext.triggerAsyncActions(inliningTarget);
                    }
                }
                return n;
            }
        }

        public static boolean isInvalidMode(IONodes.IOMode mode) {
            return mode.isInvalid || mode.text || mode.universal;
        }

        public static boolean isBadMode(IONodes.IOMode mode) {
            return mode.isBad || mode.xrwa != 1;
        }

        private static int processMode(PFileIO self, IONodes.IOMode mode) {
            int flags = 0;
            if (mode.creating) {
                self.setCreated();
                self.setWritable();
                flags |= PosixConstants.O_EXCL.value | PosixConstants.O_CREAT.value;
            } else if (mode.reading) {
                self.setReadable();
            } else if (mode.writing) {
                self.setWritable();
                flags |= PosixConstants.O_CREAT.value | PosixConstants.O_TRUNC.value;
            } else if (mode.appending) {
                self.setWritable();
                self.setAppending();
                flags |= PosixConstants.O_APPEND.value | PosixConstants.O_CREAT.value;
            }
            if (mode.updating) {
                self.setWritable();
                self.setReadable();
            }
            flags = self.isReadable() && self.isWritable() ? (flags |= PosixConstants.O_RDWR.value) : (flags |= self.isReadable() ? PosixConstants.O_RDONLY.value : PosixConstants.O_WRONLY.value);
            return flags;
        }

        public static void internalInit(PFileIO self, TruffleString name, int fd, IONodes.IOMode mode) {
            self.setCloseFD(false);
            self.setFD(fd, null);
            FileIOInit.processMode(self, mode);
            self.setBlksize(8192);
            WriteAttributeToObjectNode.getUncached().execute(self, IONodes.T_NAME, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isBadMode(mode)", "!isInvalidMode(mode)"})
        static void doInit(VirtualFrame frame, Node inliningTarget, PFileIO self, Object nameobj, IONodes.IOMode mode, boolean closefd, Object opener, @CachedLibrary(limit="1") PosixSupportLibrary posixLib, @Cached(inline=false) CallNode callOpener, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached(inline=false) IONodes.CastOpenNameNode castOpenNameNode, @Cached(inline=false) PosixModuleBuiltins.CloseNode posixClose, @Cached PyObjectSetAttr setAttr, @Cached SysModuleBuiltins.AuditNode auditNode, @Cached InlinedBranchProfile exceptionProfile, @Cached InlinedBranchProfile exceptionProfile1, @Cached InlinedBranchProfile exceptionProfile2, @Cached InlinedBranchProfile exceptionProfile3, @Cached InlinedConditionProfile errorProfile, @Cached(inline=false) GilNode gil, @Cached(inline=false) TruffleString.FromLongNode fromLongNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            block29: {
                if (self.getFD() >= 0 && self.isCloseFD()) {
                    FileIOBuiltins.internalClose(frame, self, posixClose);
                }
                self.setClosed();
                int fd = -1;
                TruffleString name = null;
                Object o = castOpenNameNode.execute(frame, nameobj);
                if (o instanceof TruffleString) {
                    name = (TruffleString)o;
                } else {
                    fd = (Integer)o;
                }
                int flags = FileIOInit.processMode(self, mode);
                auditNode.audit(inliningTarget, "open", nameobj, mode.mode, flags);
                try {
                    PythonContext ctxt;
                    boolean fdIsOwn;
                    block28: {
                        fdIsOwn = false;
                        ctxt = PythonContext.get(inliningTarget);
                        if (fd >= 0) {
                            self.setCloseFD(closefd);
                            self.setFD(fd, ctxt);
                        } else {
                            self.setCloseFD(true);
                            if (errorProfile.profile(inliningTarget, !closefd)) {
                                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CANNOT_USE_CLOSEFD);
                            }
                            if (opener instanceof PNone) {
                                self.setFD(FileIOInit.open(frame, name, flags, 438, ctxt, inliningTarget, posixLib, gil, exceptionProfile, raiseNode, constructAndRaiseNode), ctxt);
                            } else {
                                Object fdobj = callOpener.execute((Frame)frame, opener, nameobj, flags);
                                if (!indexCheckNode.execute(inliningTarget, fdobj)) {
                                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.EXPECTED_INT_FROM_OPENER);
                                }
                                self.setFD(asSizeNode.executeExact((Frame)frame, inliningTarget, fdobj), ctxt);
                                if (self.getFD() < 0) {
                                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.OPENER_RETURNED_D, self.getFD());
                                }
                            }
                            try {
                                posixLib.setInheritable(ctxt.getPosixSupport(), self.getFD(), false);
                            }
                            catch (PosixSupportLibrary.PosixException e) {
                                exceptionProfile1.enter(inliningTarget);
                                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                            }
                            fdIsOwn = true;
                        }
                        self.setBlksize(8192);
                        try {
                            long[] fstatResult;
                            gil.release(true);
                            try {
                                fstatResult = posixLib.fstat(ctxt.getPosixSupport(), self.getFD());
                            }
                            finally {
                                gil.acquire();
                            }
                            if (errorProfile.profile(inliningTarget, PosixSupportLibrary.isDIR(fstatResult[0]))) {
                                FileIOInit.errorCleanup(frame, self, fdIsOwn, posixClose);
                                TruffleString fname = name == null ? fromLongNode.execute((long)fd, PythonUtils.TS_ENCODING, false) : name;
                                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, OSErrorEnum.EISDIR, fname);
                            }
                        }
                        catch (PosixSupportLibrary.PosixException e) {
                            exceptionProfile2.enter(inliningTarget);
                            if (e.getErrorCode() != OSErrorEnum.EBADF.getNumber()) break block28;
                            FileIOInit.errorCleanup(frame, self, fdIsOwn, posixClose);
                            throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                        }
                    }
                    setAttr.execute((Frame)frame, inliningTarget, self, IONodes.T_NAME, nameobj);
                    if (!self.isAppending()) break block29;
                    try {
                        gil.release(true);
                        try {
                            long res = posixLib.lseek(ctxt.getPosixSupport(), self.getFD(), 0L, PosixModuleBuiltins.mapPythonSeekWhenceToPosix(2));
                            self.setSeekable(res >= 0L ? 1 : 0);
                        }
                        finally {
                            gil.acquire();
                        }
                    }
                    catch (PosixSupportLibrary.PosixException e) {
                        exceptionProfile3.enter(inliningTarget);
                        if (self.getSeekable() < 0) {
                            self.setSeekable(0);
                        }
                        if (e.getErrorCode() != OSErrorEnum.ESPIPE.getNumber()) {
                            FileIOInit.errorCleanup(frame, self, fdIsOwn, posixClose);
                            throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
                        }
                    }
                }
                catch (PException e) {
                    self.setClosed();
                    throw e;
                }
            }
        }

        @Specialization(guards={"isInvalidMode(mode)"})
        static void invalidMode(PFileIO self, Object nameobj, IONodes.IOMode mode, boolean closefd, Object opener, @Cached.Shared @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_MODE_S, mode.mode);
        }

        @Specialization(guards={"isBadMode(mode)"})
        static void badMode(PFileIO self, Object nameobj, IONodes.IOMode mode, boolean closefd, Object opener, @Cached.Shared @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.BAD_MODE);
        }
    }

    static final class FDReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final OwnFD fd;

        public FDReleaseCallback(OwnFD fd) {
            this.fd = fd;
        }

        @Override
        public void execute(PythonContext context) {
            if (this.fd.isReleased()) {
                return;
            }
            try {
                this.fd.doRelease();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

