/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextUnicodeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.codecs.ErrorHandlers;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.UnicodeObjectNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyUnicodeCheckExactNode;
import com.oracle.graal.python.lib.PyUnicodeFromEncodedObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class PythonCextUnicodeBuiltins {
    static TruffleString convertEncoding(Object obj) {
        return obj == PNone.NO_VALUE ? StringLiterals.T_UTF8 : (TruffleString)obj;
    }

    static TruffleString convertErrors(Object obj) {
        return obj == PNone.NO_VALUE ? StringLiterals.T_STRICT : (TruffleString)obj;
    }

    static boolean isStringSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PString);
    }

    static boolean isAnyString(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return PGuards.isString(obj) || PythonCextUnicodeBuiltins.isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode);
    }

    static abstract class PyUnicode_Count
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyUnicode_Count() {
        }

        @Specialization
        long count(Object string, Object sub, long start, long end, @Cached StringBuiltins.CountNode countNode) {
            return countNode.execute(string, sub, CastToJavaIntLossyNode.castLong(start), CastToJavaIntLossyNode.castLong(end));
        }
    }

    static abstract class PyTruffle_PyUnicode_Find
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyTruffle_PyUnicode_Find() {
        }

        @Specialization(guards={"direction > 0"})
        long find(Object string, Object sub, long start, long end, int direction, @Cached StringBuiltins.FindNode findNode) {
            return PyTruffle_PyUnicode_Find.convertResult(findNode.execute(string, sub, CastToJavaIntLossyNode.castLong(start), CastToJavaIntLossyNode.castLong(end)));
        }

        @Specialization(guards={"direction <= 0"})
        long find(Object string, Object sub, long start, long end, int direction, @Cached StringBuiltins.RFindNode rFindNode) {
            return PyTruffle_PyUnicode_Find.convertResult(rFindNode.execute(string, sub, CastToJavaIntLossyNode.castLong(start), CastToJavaIntLossyNode.castLong(end)));
        }

        private static int convertResult(int result) {
            return result >= 0 ? result : -2;
        }
    }

    static abstract class PyUnicodeDecodeError_Create
    extends PythonCextBuiltins.CApi6BuiltinNode {
        PyUnicodeDecodeError_Create() {
        }

        @Specialization
        static Object doit(Object encoding, Object object, int length, int start, int end, Object reason, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CallNode callNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            PBytes bytes;
            try {
                bytes = factory.createBytes(getByteArrayNode.execute(inliningTarget, object, length));
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
            return callNode.executeWithoutFrame((Object)PythonBuiltinClassType.UnicodeDecodeError, encoding, bytes, start, end, reason);
        }
    }

    static abstract class _Py_GetErrorHandler
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _Py_GetErrorHandler() {
        }

        @Specialization
        static Object doGeneric(TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached ErrorHandlers.GetErrorHandlerNode getErrorHandlerNode) {
            return getErrorHandlerNode.execute(inliningTarget, errors).getNativeValue();
        }

        @Specialization
        static Object doNull(PNone noValue) {
            return ErrorHandlers.ErrorHandler.STRICT.getNativeValue();
        }
    }

    static abstract class PyTruffle_Unicode_FromFormat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Unicode_FromFormat() {
        }

        @Specialization
        static Object doGeneric(TruffleString format, Object vaList, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.UnicodeFromFormatNode unicodeFromFormatNode) {
            return unicodeFromFormatNode.execute(inliningTarget, format, vaList);
        }
    }

    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class PyTruffle_Unicode_AsWideChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Unicode_AsWideChar() {
        }

        @Specialization
        static Object doUnicode(Object s, long elementSize, @Bind(value="this") Node inliningTarget, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode, @Cached CastToTruffleStringNode castStr, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PBytes wchars = asWideCharNode.executeLittleEndian(inliningTarget, castStr.execute(inliningTarget, s), elementSize);
                if (wchars != null) {
                    return wchars;
                }
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_SIZE_WAS, "wchar", elementSize);
            }
            catch (IllegalArgumentException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.LookupError, ErrorMessages.M, e);
            }
        }
    }

    static abstract class PyTruffleUnicode_FillUnicode
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleUnicode_FillUnicode() {
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject s, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode cast, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CStructAccess.AllocateNode allocateNode, @Cached CStructAccess.WriteByteNode writeByteNode) {
            int wcharSize = CStructs.wchar_t.size();
            PBytes bytes = asWideCharNode.executeNativeOrder(inliningTarget, cast.castKnownString(inliningTarget, s), wcharSize);
            int len = bufferLib.getBufferLength(bytes);
            Object mem = allocateNode.alloc(len + wcharSize, true);
            writeByteNode.writeByteArray(mem, bufferLib.getInternalOrCopiedByteArray(bytes), len, 0, 0);
            writePointerNode.writeToObj(s, CFields.PyASCIIObject__wstr, mem);
            writeLongNode.writeToObject(s, CFields.PyCompactUnicodeObject__wstr_length, len / wcharSize);
            return 0;
        }
    }

    static abstract class PyTruffleUnicode_AsUnicodeAndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleUnicode_AsUnicodeAndSize() {
        }

        @Specialization
        static Object doUnicode(PString s, Object sizePtr, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary lib, @Cached InlinedConditionProfile hasSizeProfile, @Cached InlinedConditionProfile hasUnicodeProfile, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode) {
            int wcharSize = CStructs.wchar_t.size();
            if (hasUnicodeProfile.profile(inliningTarget, s.getWCharBytes() == null)) {
                PBytes bytes = asWideCharNode.executeNativeOrder(inliningTarget, s, wcharSize);
                s.setWCharBytes(bytes);
            }
            if (hasSizeProfile.profile(inliningTarget, !lib.isNull(sizePtr))) {
                writeLongNode.write(sizePtr, s.getWCharBytes().getSequenceStorage().length() / wcharSize);
            }
            return PySequenceArrayWrapper.ensureNativeSequence(s.getWCharBytes());
        }

        @Fallback
        static Object doError(Object s, Object sizePtr, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    static abstract class PyTruffleUnicode_FillUtf8
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleUnicode_FillUtf8() {
        }

        @Specialization
        static Object doNative(PythonAbstractNativeObject s, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached _PyUnicode_AsUTF8String asUTF8String, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached CStructAccess.WritePointerNode writePointerNode, @Cached CStructAccess.AllocateNode allocateNode, @Cached CStructAccess.WriteByteNode writeByteNode) {
            PBytes bytes = (PBytes)asUTF8String.execute(s, StringLiterals.T_STRICT);
            int len = bufferLib.getBufferLength(bytes);
            Object mem = allocateNode.alloc(len + 1, true);
            writeByteNode.writeByteArray(mem, bufferLib.getInternalOrCopiedByteArray(bytes), len, 0, 0);
            writePointerNode.writeToObj(s, CFields.PyCompactUnicodeObject__utf8, mem);
            writeLongNode.writeToObject(s, CFields.PyCompactUnicodeObject__utf8_length, len);
            return 0;
        }
    }

    static abstract class PyTruffleUnicode_AsUTF8AndSize
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffleUnicode_AsUTF8AndSize() {
        }

        @Specialization
        static Object doUnicode(PString s, Object sizePtr, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary lib, @Cached InlinedConditionProfile hasSizeProfile, @Cached InlinedConditionProfile hasUtf8Profile, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached _PyUnicode_AsUTF8String asUTF8String) {
            if (hasUtf8Profile.profile(inliningTarget, s.getUtf8Bytes() == null)) {
                PBytes bytes = (PBytes)asUTF8String.execute(s, StringLiterals.T_STRICT);
                s.setUtf8Bytes(bytes);
            }
            if (hasSizeProfile.profile(inliningTarget, !lib.isNull(sizePtr))) {
                writeLongNode.write(sizePtr, s.getUtf8Bytes().getSequenceStorage().length());
            }
            return PySequenceArrayWrapper.ensureNativeSequence(s.getUtf8Bytes());
        }

        @Fallback
        static Object doError(Object s, Object sizePtr, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    static abstract class _PyUnicode_AsUTF8String
    extends NativeEncoderNode {
        protected _PyUnicode_AsUTF8String() {
            super(StandardCharsets.UTF_8);
        }

        @NeverDefault
        public static _PyUnicode_AsUTF8String create() {
            return PythonCextUnicodeBuiltinsFactory._PyUnicode_AsUTF8StringNodeGen.create();
        }
    }

    static abstract class _PyUnicode_AsASCIIString
    extends NativeEncoderNode {
        protected _PyUnicode_AsASCIIString() {
            super(StandardCharsets.US_ASCII);
        }
    }

    static abstract class _PyUnicode_AsLatin1String
    extends NativeEncoderNode {
        protected _PyUnicode_AsLatin1String() {
            super(StandardCharsets.ISO_8859_1);
        }
    }

    static abstract class NativeEncoderNode
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        private final Charset charset;

        protected NativeEncoderNode(Charset charset) {
            this.charset = charset;
        }

        @Specialization(guards={"isNoValue(errors)"})
        Object doUnicode(Object s, PNone errors, @Cached.Shared(value="encodeNode") @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return this.doUnicode(s, StringLiterals.T_STRICT, encodeNativeStringNode, factory);
        }

        @Specialization
        Object doUnicode(Object s, TruffleString errors, @Cached.Shared(value="encodeNode") @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBytes(encodeNativeStringNode.execute(this.charset, s, errors));
        }

        @Fallback
        static Object doUnicode(Object s, Object errors, @Cached PRaiseNode raiseNode) {
            return raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    static abstract class PyUnicode_FromWideChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_FromWideChar() {
        }

        @Specialization
        Object doInt(Object arr, long size, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.ReadUnicodeArrayNode readArray, @Cached TruffleString.FromIntArrayUTF32Node fromArray, @Cached PythonObjectFactory factory) {
            assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32) : "needs switch_encoding otherwise";
            return factory.createString(fromArray.execute(readArray.execute(inliningTarget, arr, this.castToInt(size), CStructs.wchar_t.size())));
        }
    }

    static abstract class PyUnicode_EncodeFSDefault
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_EncodeFSDefault() {
        }

        @Specialization
        static PBytes fromObject(Object s, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached CExtCommonNodes.EncodeNativeStringNode encode, @Cached PythonObjectFactory factory) {
            byte[] array = encode.execute(StandardCharsets.UTF_8, castStr.execute(inliningTarget, s), StringLiterals.T_REPLACE);
            return factory.createBytes(array);
        }
    }

    static abstract class PyTruffleUnicode_Decode
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleUnicode_Decode() {
        }

        @Specialization
        static Object doDecode(PMemoryView mv, TruffleString encoding, TruffleString errors, @Cached CodecsModuleBuiltins.DecodeNode decodeNode) {
            return decodeNode.executeWithStrings(null, mv, encoding, errors);
        }
    }

    static abstract class PyTruffleUnicode_DecodeUTF32Stateful
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyTruffleUnicode_DecodeUTF32Stateful() {
        }

        @Specialization
        static Object decode(Object cByteArray, long size, TruffleString errors, int byteorder, int reportConsumed, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PBytes bytes = factory.createBytes(getByteArrayNode.execute(inliningTarget, cByteArray, size));
                TruffleString encoding = byteorder == 0 ? CodecsModuleBuiltins.T_UTF_32 : (byteorder < 0 ? CodecsModuleBuiltins.T_UTF_32_LE : CodecsModuleBuiltins.T_UTF_32_BE);
                return decode.call(null, bytes, encoding, errors, reportConsumed == 0);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }
    }

    static abstract class PyTruffleUnicode_DecodeUTF16Stateful
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyTruffleUnicode_DecodeUTF16Stateful() {
        }

        @Specialization
        static Object decode(Object cByteArray, long size, TruffleString errors, int byteorder, int reportConsumed, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PBytes bytes = factory.createBytes(getByteArrayNode.execute(inliningTarget, cByteArray, size));
                TruffleString encoding = byteorder == 0 ? CodecsModuleBuiltins.T_UTF_16 : (byteorder < 0 ? CodecsModuleBuiltins.T_UTF_16_LE : CodecsModuleBuiltins.T_UTF_16_BE);
                return decode.call(null, bytes, encoding, errors, reportConsumed == 0);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }
    }

    static abstract class PyTruffleUnicode_DecodeUTF8Stateful
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyTruffleUnicode_DecodeUTF8Stateful() {
        }

        @Specialization
        static Object doUtf8Decode(Object cByteArray, long size, TruffleString errors, int reportConsumed, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CodecsModuleBuiltins.CodecsDecodeNode decode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                PBytes bytes = factory.createBytes(getByteArrayNode.execute(inliningTarget, cByteArray, size));
                return decode.call(null, bytes, StringLiterals.T_UTF8, errors, reportConsumed == 0);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }
    }

    static abstract class PyUnicode_Split
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_Split() {
        }

        @Specialization
        static Object split(Object string, Object sep, Object maxsplit, @Cached StringBuiltins.SplitNode splitNode) {
            return splitNode.execute(null, string, sep, maxsplit);
        }
    }

    static abstract class PyUnicode_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Contains() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Cached StringBuiltins.ContainsNode containsNode) {
            return containsNode.executeBool(haystack, needle) ? 1 : 0;
        }
    }

    static abstract class PyUnicode_FromString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromString() {
        }

        @Specialization
        static PString run(TruffleString str, @Cached PythonObjectFactory factory) {
            return factory.createString(str);
        }

        @Specialization
        static PString run(PString str) {
            return str;
        }
    }

    static abstract class PyTruffleUnicode_FromUTF
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleUnicode_FromUTF() {
        }

        private static TruffleString.Encoding encodingFromKind(Node inliningTarget, int kind, PRaiseNode.Lazy raiseNode) throws PException {
            return switch (kind) {
                case 1 -> TruffleString.Encoding.UTF_8;
                case 2 -> TruffleString.Encoding.UTF_16LE;
                case 4 -> TruffleString.Encoding.UTF_32LE;
                default -> throw raiseNode.get(inliningTarget).raiseBadInternalCall();
            };
        }

        private static PString asPString(TruffleString ts, TruffleString.SwitchEncodingNode switchEncodingNode, PythonObjectFactory factory) {
            return factory.createString(switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
        }

        @Specialization(guards={"ptrLib.isPointer(ptr)"})
        static Object doNative(Object ptr, long byteLength, int kind, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int iByteLength = PInt.intValueExact(byteLength);
                TruffleString.Encoding srcEncoding = PyTruffleUnicode_FromUTF.encodingFromKind(inliningTarget, kind, raiseNode);
                TruffleString ts = fromNativePointerNode.execute(ptr, 0, iByteLength, srcEncoding, true);
                return PyTruffleUnicode_FromUTF.asPString(ts, switchEncodingNode, factory);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"!ptrLib.isPointer(ptr)"})
        static Object doManaged(Object ptr, long byteLength, int kind, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                TruffleString.Encoding srcEncoding = PyTruffleUnicode_FromUTF.encodingFromKind(inliningTarget, kind, raiseNode);
                byte[] ucsBytes = getByteArrayNode.execute(inliningTarget, ptr, byteLength);
                TruffleString ts = fromByteArrayNode.execute(ucsBytes, srcEncoding);
                return PyTruffleUnicode_FromUTF.asPString(ts, switchEncodingNode, factory);
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
        }
    }

    static abstract class PyTruffleUnicode_FromUCS
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleUnicode_FromUCS() {
        }

        private static TruffleString.Encoding encodingFromKind(Node inliningTarget, int kind, PRaiseNode.Lazy raiseNode) throws PException {
            return switch (kind) {
                case 1 -> TruffleString.Encoding.ISO_8859_1;
                case 2 -> TruffleString.Encoding.UTF_16;
                case 4 -> PythonUtils.TS_ENCODING;
                default -> throw raiseNode.get(inliningTarget).raiseBadInternalCall();
            };
        }

        private static PString asPString(TruffleString ts, TruffleString.SwitchEncodingNode switchEncodingNode, PythonObjectFactory factory) {
            return factory.createString(switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
        }

        @Specialization(guards={"ptrLib.isPointer(ptr)"})
        static Object doNative(Object ptr, long byteLength, int kind, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int iByteLength = PInt.intValueExact(byteLength);
                TruffleString.Encoding srcEncoding = PyTruffleUnicode_FromUCS.encodingFromKind(inliningTarget, kind, raiseNode);
                TruffleString ts = fromNativePointerNode.execute(ptr, 0, iByteLength, srcEncoding, true);
                return PyTruffleUnicode_FromUCS.asPString(ts, switchEncodingNode, factory);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"!ptrLib.isPointer(ptr)"})
        static Object doManaged(Object ptr, long byteLength, int kind, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                TruffleString.Encoding srcEncoding = PyTruffleUnicode_FromUCS.encodingFromKind(inliningTarget, kind, raiseNode);
                byte[] ucsBytes = getByteArrayNode.execute(inliningTarget, ptr, byteLength);
                TruffleString ts = fromByteArrayNode.execute(ucsBytes, srcEncoding);
                return PyTruffleUnicode_FromUCS.asPString(ts, switchEncodingNode, factory);
            }
            catch (InteropException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.MemoryError);
            }
        }
    }

    static abstract class PyTruffleUnicode_New
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyTruffleUnicode_New() {
        }

        @Specialization
        static Object doGeneric(Object ptr, long elements, long elementSize, int isAscii, @Cached PythonObjectFactory factory) {
            return factory.createString(new NativeCharSequence(ptr, (int)elements, (int)elementSize, isAscii != 0));
        }
    }

    static abstract class PyUnicode_ReadChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_ReadChar() {
        }

        @Specialization
        static int doGeneric(Object type, long lindex, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode codepointAtIndexNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                TruffleString s = castToStringNode.execute(inliningTarget, type);
                int index = PInt.intValueExact(lindex);
                if (index < 0 || index >= lengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
                }
                return codepointAtIndexNode.execute((AbstractTruffleString)s, index, PythonUtils.TS_ENCODING);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            catch (OverflowException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_AsUnicodeEscapeString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_AsUnicodeEscapeString() {
        }

        @Specialization(guards={"isString(s)"})
        static Object escape(Object s, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached.Shared @Cached PyTupleGetItem getItemNode) {
            return getItemNode.execute(inliningTarget, encodeNode.execute(null, s, CodecsModuleBuiltins.T_UNICODE_ESCAPE, PNone.NO_VALUE), 0);
        }

        @Specialization(guards={"!isString(s)", "isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)"})
        static Object escape(Object s, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PyTupleGetItem getItemNode) {
            return PyUnicode_AsUnicodeEscapeString.escape(s, inliningTarget, encodeNode, getItemNode);
        }

        @Specialization(guards={"!isString(obj)", "!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object escape(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Replace
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyUnicode_Replace() {
        }

        @Specialization(guards={"isString(s)", "isString(substr)", "isString(replstr)"})
        static Object replace(Object s, Object substr, Object replstr, long count, @Cached.Shared @Cached StringBuiltins.ReplaceNode replaceNode) {
            return replaceNode.execute(null, s, substr, replstr, count);
        }

        @Specialization(guards={"!isString(s)", "!isString(substr)", "!isString(replstr)", "isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)", "isStringSubtype(inliningTarget, substr, getClassNode, isSubtypeNode)", "isStringSubtype(inliningTarget, replstr, getClassNode, isSubtypeNode)"})
        static Object replace(Object s, Object substr, Object replstr, long count, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached StringBuiltins.ReplaceNode replaceNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return PyUnicode_Replace.replace(s, substr, replstr, count, replaceNode);
        }

        @Specialization(guards={"!isString(s)", "!isString(substr)", "!isString(replstr)", "!isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)", "!isStringSubtype(inliningTarget, substr, getClassNode, isSubtypeNode)", "!isStringSubtype(inliningTarget, replstr, getClassNode, isSubtypeNode)"})
        static Object replace(Object s, Object substr, Object replstr, long count, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return PyUnicode_Replace.getNativeNull(inliningTarget);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_AsEncodedString
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_AsEncodedString() {
        }

        @Specialization(guards={"isString(obj) || isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object encode(Object obj, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EncodeNode encodeNode) {
            return encodeNode.execute(null, obj, PythonCextUnicodeBuiltins.convertEncoding(encoding), PythonCextUnicodeBuiltins.convertErrors(errors));
        }

        @Specialization(guards={"!isString(obj)", "!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object encode(Object obj, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Tailmatch
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyUnicode_Tailmatch() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, string, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)", "direction > 0"})
        static int tailmatch(Object string, Object substring, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectLookupAttr lookupAttrNode, @Cached.Shared @Cached PySliceNew sliceNode, @Cached.Shared @Cached CallNode callNode, @Cached StringBuiltins.EndsWithNode endsWith, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, string, SpecialMethodNames.T___GETITEM__);
            Object slice = callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
            return (Boolean)endsWith.execute(null, slice, substring, start, end) != false ? 1 : 0;
        }

        @Specialization(guards={"isAnyString(inliningTarget, string, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)", "direction <= 0"})
        static int tailmatch(Object string, Object substring, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyObjectLookupAttr lookupAttrNode, @Cached.Shared @Cached PySliceNew sliceNode, @Cached.Shared @Cached CallNode callNode, @Cached StringBuiltins.StartsWithNode startsWith, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, string, SpecialMethodNames.T___GETITEM__);
            Object slice = callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
            return (Boolean)startsWith.execute(null, slice, substring, start, end) != false ? 1 : 0;
        }

        @Specialization(guards={"!isAnyString(inliningTarget, string, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)"})
        static Object find(Object string, Object substring, Object start, Object end, Object direction, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, string);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Compare
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Compare() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, left, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EqNode eqNode, @Cached StringBuiltins.LtNode ltNode, @Cached InlinedConditionProfile eqProfile) {
            if (eqProfile.profile(inliningTarget, ((Boolean)eqNode.execute(null, left, right)).booleanValue())) {
                return 0;
            }
            return (Boolean)ltNode.execute(null, left, right) != false ? -1 : 1;
        }

        @Specialization(guards={"!isAnyString(inliningTarget, left, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, left, right);
        }
    }

    static abstract class PyUnicode_CompareWithASCIIString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_CompareWithASCIIString() {
        }

        @Specialization
        static int compare(TruffleString left, TruffleString right, @Cached TruffleString.CompareIntsUTF32Node compare) {
            return compare.execute((AbstractTruffleString)left, (AbstractTruffleString)right);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class _PyUnicode_EqualToASCIIString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyUnicode_EqualToASCIIString() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, left, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EqNode eqNode, @Cached PyObjectIsTrueNode isTrue) {
            return PInt.intValue(isTrue.execute(null, inliningTarget, eqNode.execute(null, left, right)));
        }

        @Specialization(guards={"!isAnyString(inliningTarget, left, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, left, right);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Join
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Join() {
        }

        @Specialization(guards={"isString(separator) || isStringSubtype(inliningTarget, separator, getClassNode, isSubtypeNode)"})
        static Object find(Object separator, Object seq, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.JoinNode joinNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return joinNode.execute(null, separator, seq);
        }

        @Specialization(guards={"!isTruffleString(separator)", "isStringSubtype(inliningTarget, separator, getClassNode, isSubtypeNode)"})
        static Object find(Object separator, Object seq, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, separator);
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Substring
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_Substring() {
        }

        @Specialization(guards={"isString(s) || isStringSubtype(s, inliningTarget, getClassNode, isSubtypeNode)"}, limit="1")
        static Object doString(Object s, long start, long end, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profile, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            if (profile.profile(inliningTarget, start < 0L || end < 0L)) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, s, SpecialMethodNames.T___GETITEM__);
            return callNode.executeWithoutFrame(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
        }

        @Specialization(guards={"!isTruffleString(s)", "isStringSubtype(s, inliningTarget, getClassNode, isSubtypeNode)"}, limit="1")
        static Object doError(Object s, Object start, Object end, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, s);
        }

        protected static boolean isStringSubtype(Object obj, Node n, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(n, obj), (Object)PythonBuiltinClassType.PString);
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FindChar
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyUnicode_FindChar() {
        }

        @Specialization(guards={"isString(string) || isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)", "direction > 0"})
        static Object find(Object string, Object c, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinFunctions.ChrNode chrNode, @Cached StringBuiltins.FindNode findNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return findNode.execute(null, string, chrNode.execute(null, c), start, end);
        }

        @Specialization(guards={"isString(string) || isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)", "direction <= 0"})
        static Object find(Object string, Object c, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached BuiltinFunctions.ChrNode chrNode, @Cached StringBuiltins.RFindNode rFindNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return rFindNode.execute(null, string, chrNode.execute(null, c), start, end);
        }

        @Specialization(guards={"!isTruffleString(string)", "!isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)"})
        static Object find(Object string, Object c, Object start, Object end, Object direction, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, string);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Format
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Format() {
        }

        @Specialization(guards={"isString(format) || isStringSubtype(inliningTarget, format, getClassNode, isSubtypeNode)"})
        static Object find(Object format, Object args, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.ModNode modNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PyUnicode_Format.checkNonNullArg(inliningTarget, format, args, raiseNode);
            return modNode.execute(null, format, args);
        }

        @Specialization(guards={"!isTruffleString(format)", "isStringSubtype(inliningTarget, format, getClassNode, isSubtypeNode)"})
        static Object find(Object format, Object args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PyUnicode_Format.checkNonNullArg(inliningTarget, format, args, raiseNode);
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, format);
        }
    }

    static abstract class PyTruffleUnicode_LookupAndIntern
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleUnicode_LookupAndIntern() {
        }

        @Specialization
        static Object withPString(PString str, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeCheckExactNode unicodeCheckExactNode, @Cached CastToTruffleStringNode cast, @Cached StringNodes.IsInternedStringNode isInternedStringNode, @Cached StringNodes.InternStringNode internNode, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached PythonObjectFactory.Lazy factory) {
            Object interned;
            if (!unicodeCheckExactNode.execute(inliningTarget, str)) {
                return PyTruffleUnicode_LookupAndIntern.getNativeNull(inliningTarget);
            }
            boolean isInterned = isInternedStringNode.execute(inliningTarget, str);
            if (isInterned) {
                return str;
            }
            TruffleString ts = cast.execute(inliningTarget, str);
            PDict dict = PyTruffleUnicode_LookupAndIntern.getCApiContext(inliningTarget).getInternedUnicode();
            if (dict == null) {
                dict = factory.get(inliningTarget).createDict();
                PyTruffleUnicode_LookupAndIntern.getCApiContext(inliningTarget).setInternedUnicode(dict);
            }
            if ((interned = getItem.execute(inliningTarget, dict.getDictStorage(), ts)) == null) {
                interned = internNode.execute(inliningTarget, str);
                dict.setDictStorage(setItem.execute(inliningTarget, dict.getDictStorage(), ts, interned));
            }
            return interned;
        }

        @Fallback
        Object nil(Object obj) {
            return this.getNativeNull();
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FromEncodedObject
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_FromEncodedObject() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object encodingObj, Object errorsObj, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile encodingProfile, @Cached InlinedExactClassProfile errorsProfile, @Cached InlinedConditionProfile nullProfile, @Cached PyUnicodeFromEncodedObject decodeNode) {
            TruffleString errors;
            TruffleString encoding;
            Object encodingObjProfiled = encodingProfile.profile(inliningTarget, encodingObj);
            if (encodingObjProfiled == PNone.NO_VALUE) {
                encoding = StringLiterals.T_UTF8;
            } else {
                assert (encodingObjProfiled instanceof TruffleString);
                encoding = (TruffleString)encodingObjProfiled;
            }
            Object errorsObjProfiled = errorsProfile.profile(inliningTarget, errorsObj);
            if (errorsObjProfiled == PNone.NO_VALUE) {
                errors = StringLiterals.T_STRICT;
            } else {
                assert (errorsObjProfiled instanceof TruffleString);
                errors = (TruffleString)errorsObjProfiled;
            }
            if (nullProfile.profile(inliningTarget, obj == PNone.NO_VALUE)) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            return decodeNode.execute(null, inliningTarget, obj, encoding, errors);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Concat() {
        }

        @Specialization(guards={"isString(left) || isStringSubtype(inliningTarget, left, getClassNode, isSubtypeNode)", "isString(right) || isStringSubtype(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object concat(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.AddNode addNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return addNode.execute(null, left, right);
        }

        @Specialization(guards={"!isString(left)", "!isStringSubtype(inliningTarget, left, getClassNode, isSubtypeNode)"})
        static Object leftNotString(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, left);
        }

        @Specialization(guards={"!isString(right)", "!isStringSubtype(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object rightNotString(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, right);
        }
    }

    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FromObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromObject() {
        }

        @Specialization
        static TruffleString fromObject(TruffleString s) {
            return s;
        }

        @Specialization(guards={"isPStringType(inliningTarget, s, getClassNode)"})
        static PString fromObject(PString s, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode) {
            return s;
        }

        @Specialization(guards={"!isPStringType(inliningTarget, obj, getClassNode)", "isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object fromObject(Object obj, @Bind(value="this") Node inliningTarget, @Cached BuiltinConstructors.StrNode strNode, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            return strNode.executeWith(obj);
        }

        @Specialization(guards={"!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object fromObject(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_CONVERT_TO_STR_IMPLICITLY, obj);
        }

        protected boolean isPStringType(Node inliningTarget, Object obj, GetClassNode getClassNode) {
            return getClassNode.execute(inliningTarget, obj) == PythonBuiltinClassType.PString;
        }
    }

    static abstract class PyUnicode_FromOrdinal
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromOrdinal() {
        }

        @Specialization
        static Object chr(int value, @Cached BuiltinFunctions.ChrNode chrNode) {
            return chrNode.execute(null, value);
        }
    }
}

