/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextCodeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNode;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextTracebackBuiltins {

    static abstract class PyTraceBack_Here
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTraceBack_Here() {
        }

        @Specialization
        static int tbHere(PFrame frame, @Bind(value="this") Node inliningTarget, @Cached MaterializeLazyTracebackNode materializeLazyTracebackNode, @Cached PythonObjectFactory factory) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext.PythonThreadState threadState = PythonContext.get(inliningTarget).getThreadState(language);
            PException currentException = threadState.getCurrentException();
            if (currentException != null) {
                PTraceback currentTraceback = null;
                if (threadState.getCurrentTraceback() != null) {
                    currentTraceback = materializeLazyTracebackNode.execute(inliningTarget, threadState.getCurrentTraceback());
                }
                PTraceback newTraceback = factory.createTraceback(frame, frame.getLine(), currentTraceback);
                threadState.setCurrentTraceback(new LazyTraceback(newTraceback));
            }
            return 0;
        }
    }

    static abstract class _PyTraceback_Add
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyTraceback_Add() {
        }

        @Specialization
        static Object tbHere(TruffleString funcname, TruffleString filename, int lineno, @Cached PythonCextCodeBuiltins.PyCode_NewEmpty newCode, @Cached PyTraceBack_Here pyTraceBackHereNode, @Cached PythonObjectFactory factory) {
            PFrame frame = factory.createPFrame(null, newCode.execute(filename, funcname, lineno), factory.createDict(), factory.createDict());
            pyTraceBackHereNode.execute(frame);
            return PNone.NONE;
        }
    }
}

