/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsuleNameMatchesNode;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextCapsuleBuiltins {

    static abstract class PyCapsule_Import
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_Import() {
        }

        @Specialization
        static Object doGeneric(TruffleString name, int noBlock, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.IndexOfStringNode indexOfStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached ReadAttributeFromObjectNode getAttrNode, @Cached PRaiseNode.Lazy raiseNode) {
            PyCapsule capsule;
            TruffleString trace = name;
            Object object = null;
            while (trace != null) {
                int traceLen = codePointLengthNode.execute((AbstractTruffleString)trace, PythonUtils.TS_ENCODING);
                int dotIdx = indexOfStringNode.execute((AbstractTruffleString)trace, (AbstractTruffleString)StringLiterals.T_DOT, 0, traceLen, PythonUtils.TS_ENCODING);
                TruffleString dot = null;
                if (dotIdx >= 0) {
                    dot = substringNode.execute((AbstractTruffleString)trace, dotIdx + 1, traceLen - dotIdx - 1, PythonUtils.TS_ENCODING, false);
                    trace = substringNode.execute((AbstractTruffleString)trace, 0, dotIdx, PythonUtils.TS_ENCODING, false);
                }
                object = object == null ? AbstractImportNode.importModule(trace) : getAttrNode.execute(object, trace);
                trace = dot;
            }
            PyCapsule pyCapsule = capsule = object instanceof PyCapsule ? (PyCapsule)object : null;
            if (capsule != null && PyCapsule_IsValid.doCapsule(capsule, name, inliningTarget, nameMatchesNode) == 1) {
                return capsule.getPointer();
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID, name);
        }
    }

    static abstract class PyCapsule_SetContext
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetContext() {
        }

        @Specialization
        static int doCapsule(PyCapsule o, Object context, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetContext");
            }
            o.setContext(context);
            return 0;
        }

        @Fallback
        static Object doError(Object o, Object name, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetContext");
        }
    }

    static abstract class PyCapsule_SetDestructor
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetDestructor() {
        }

        @Specialization
        static int doCapsule(PyCapsule o, Object destructor, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="1") InteropLibrary lib, @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetDestructor");
            }
            o.registerDestructor(lib.isNull(destructor) ? null : destructor);
            return 0;
        }

        @Fallback
        static Object doError(Object o, Object name, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetDestructor");
        }
    }

    static abstract class PyCapsule_SetName
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetName() {
        }

        @Specialization
        static int doCapsuleTruffleString(PyCapsule o, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetName");
            }
            o.setName(name);
            return 0;
        }

        @Specialization(guards={"isNoValue(name)"})
        static int doCapsuleNone(PyCapsule o, PNone name, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetName");
            }
            o.setName(null);
            return 0;
        }

        @Fallback
        static Object doError(Object o, Object name, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetName");
        }
    }

    static abstract class PyCapsule_SetPointer
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_SetPointer() {
        }

        @Specialization
        static int doCapsule(PyCapsule o, Object pointer, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary interopLibrary, @Cached PRaiseNode.Lazy raiseNode) {
            if (interopLibrary.isNull(pointer)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID);
            }
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetPointer");
            }
            o.setPointer(pointer);
            return 0;
        }

        @Fallback
        static Object doError(Object o, Object name, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_SetPointer");
        }
    }

    static abstract class PyCapsule_GetContext
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCapsule_GetContext() {
        }

        @Specialization
        Object doCapsule(PyCapsule o, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetContext");
            }
            if (o.getContext() == null) {
                return this.getNULL();
            }
            return o.getContext();
        }

        @Fallback
        static Object doError(Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
        }
    }

    static abstract class PyCapsule_GetDestructor
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCapsule_GetDestructor() {
        }

        @Specialization
        Object doCapsule(PyCapsule o, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetDestructor");
            }
            if (o.getDestructor() == null) {
                return this.getNULL();
            }
            return o.getDestructor();
        }

        @Fallback
        static Object doError(Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
        }
    }

    static abstract class PyCapsule_GetName
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyCapsule_GetName() {
        }

        private static void checkLegalCapsule(Node inliningTarget, PyCapsule capsule, PRaiseNode.Lazy raiseNode) {
            if (capsule.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetName");
            }
        }

        private static Object tsToNative(TruffleString tname, TruffleString.GetInternalNativePointerNode getInternalNativePointerNode) {
            if (tname.isNative()) {
                return getInternalNativePointerNode.execute((AbstractTruffleString)tname, TruffleString.Encoding.UTF_8);
            }
            return new CArrayWrappers.CStringWrapper(tname);
        }

        @Specialization(guards={"isTruffleString(name)"})
        static Object doTruffleString(PyCapsule o, @Bind(value="this") Node inliningTarget, @Bind(value="o.getName()") Object name, @Cached.Shared(value="a") @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PyCapsule_GetName.checkLegalCapsule(inliningTarget, o, raiseNode);
            return PyCapsule_GetName.tsToNative((TruffleString)name, getInternalNativePointerNode);
        }

        @Specialization(replaces={"doTruffleString"})
        Object doGeneric(PyCapsule o, @Bind(value="this") Node inliningTarget, @Bind(value="o.getName()") Object name, @Cached.Shared(value="a") @Cached TruffleString.GetInternalNativePointerNode getInternalNativePointerNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            PyCapsule_GetName.checkLegalCapsule(inliningTarget, o, raiseNode);
            if (name == null) {
                return this.getNULL();
            }
            if (name instanceof TruffleString) {
                return PyCapsule_GetName.tsToNative((TruffleString)name, getInternalNativePointerNode);
            }
            return name;
        }

        @Fallback
        static Object doit(Object o, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetName");
        }
    }

    static abstract class PyCapsule_GetPointer
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyCapsule_GetPointer() {
        }

        @Specialization
        static Object doCapsule(PyCapsule o, Object name, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (o.getPointer() == null) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
            }
            if (!nameMatchesNode.execute(inliningTarget, name, o.getName())) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.PY_CAPSULE_IMPORT_S_IS_NOT_VALID);
            }
            return o.getPointer();
        }

        @Fallback
        static Object doError(Object o, Object name, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT, "PyCapsule_GetPointer");
        }
    }

    public static abstract class PyCapsule_IsValid
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        @Specialization
        public static int doCapsule(PyCapsule o, TruffleString name, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode) {
            if (o.getPointer() == null) {
                return 0;
            }
            if (!nameMatchesNode.execute(inliningTarget, name, o.getName())) {
                return 0;
            }
            return 1;
        }

        @Fallback
        static Object doError(Object o, Object name) {
            return 0;
        }
    }

    static abstract class PyCapsule_New
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyCapsule_New() {
        }

        @Specialization
        static Object doGeneric(Object pointer, Object name, Object destructor, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") InteropLibrary interopLibrary, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (interopLibrary.isNull(pointer)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.CALLED_WITH_INVALID_PY_CAPSULE_OBJECT);
            }
            Object n = interopLibrary.isNull(name) ? null : name;
            PyCapsule capsule = factory.createCapsule(pointer, n);
            if (!interopLibrary.isNull(destructor)) {
                capsule.registerDestructor(destructor);
            }
            return capsule;
        }
    }
}

