/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.ImpModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ImpModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.module.FrozenModules;
import com.oracle.graal.python.builtins.objects.module.PythonFrozenModule;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="_imp", isEager=true)
public final class ImpModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString T_ORIGIN = PythonUtils.tsLiteral("origin");
    static final String J__IMP = "_imp";
    public static final TruffleString T__IMP = PythonUtils.tsLiteral("_imp");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ImpModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonContext context = core.getContext();
        PythonModule mod = core.lookupBuiltinModule(T__IMP);
        mod.setAttribute(PythonUtils.tsLiteral("check_hash_based_pycs"), context.getOption(PythonOptions.CheckHashPycsMode));
    }

    @CompilerDirectives.TruffleBoundary
    public static PythonModule importFrozenModuleObject(Python3Core core, TruffleString name, boolean doRaise) {
        return ImpModuleBuiltins.importFrozenModuleObject(core, name, doRaise, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static PythonModule importFrozenModuleObject(Python3Core core, TruffleString name, boolean doRaise, PythonModule globals) {
        PythonModule module;
        FrozenResult result = ImpModuleBuiltins.findFrozen(core.getContext(), name, TruffleString.EqualNode.getUncached());
        FrozenStatus status = result.status;
        FrozenInfo info = result.info;
        switch (status.ordinal()) {
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        if (doRaise) {
            ImpModuleBuiltins.raiseFrozenError(null, status, name, PConstructAndRaiseNode.getUncached());
        } else if (status != FrozenStatus.FROZEN_OKAY) {
            return null;
        }
        PCode code = (PCode)MarshalModuleBuiltins.Marshal.load(info.data, info.size);
        PythonModule pythonModule = module = globals == null ? core.factory().createPythonModule(name) : globals;
        if (info.isPackage) {
            WriteAttributeToPythonObjectNode.getUncached().execute(module, SpecialAttributeNames.T___PATH__, core.factory().createList());
        }
        RootCallTarget callTarget = CodeNodes.GetCodeCallTargetNode.executeUncached(code);
        GenericInvokeNode.getUncached().execute(callTarget, PArguments.withGlobals(module));
        PNone origName = info.origName == null ? PNone.NONE : info.origName;
        WriteAttributeToPythonObjectNode.getUncached().execute(module, SpecialAttributeNames.T___ORIGNAME__, origName);
        return module;
    }

    private static FrozenResult findFrozen(PythonContext context, TruffleString name, TruffleString.EqualNode equalNode) {
        TriState override = context.getOverrideFrozenModules();
        if (override == TriState.FALSE || override == TriState.UNDEFINED && context.getOption(PythonOptions.DisableFrozenModules).booleanValue()) {
            return new FrozenResult(FrozenStatus.FROZEN_DISABLED);
        }
        PythonFrozenModule module = FrozenModules.lookup(name.toJavaStringUncached());
        if (module == null) {
            return new FrozenResult(FrozenStatus.FROZEN_NOT_FOUND);
        }
        boolean isAlias = module.getOriginalName() == null || !equalNode.execute((AbstractTruffleString)name, (AbstractTruffleString)module.getOriginalName(), PythonUtils.TS_ENCODING);
        FrozenInfo info = new FrozenInfo(name, module.getCode(), module.getSize(), module.isPackage(), module.getOriginalName(), !isAlias);
        if (module.getCode() == null) {
            return new FrozenResult(FrozenStatus.FROZEN_EXCLUDED, info);
        }
        if (module.getCode()[0] == 0 || module.getSize() == 0) {
            return new FrozenResult(FrozenStatus.FROZEN_INVALID, info);
        }
        return new FrozenResult(FrozenStatus.FROZEN_OKAY, info);
    }

    private static void raiseFrozenError(VirtualFrame frame, FrozenStatus status, TruffleString moduleName, PConstructAndRaiseNode raiseNode) {
        if (status == FrozenStatus.FROZEN_OKAY) {
            return;
        }
        TruffleString message = switch (status.ordinal()) {
            case 1, 2 -> ErrorMessages.NO_SUCH_FROZEN_OBJECT;
            case 3 -> ErrorMessages.FROZEN_DISABLED;
            case 4 -> ErrorMessages.FROZEN_EXCLUDED;
            case 5 -> ErrorMessages.FROZEN_INVALID;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"unknown frozen status");
        };
        throw raiseNode.raiseImportErrorWithModule((Frame)frame, moduleName, PNone.NONE, message, moduleName);
    }

    private static class FrozenResult {
        final FrozenStatus status;
        final FrozenInfo info;

        FrozenResult(FrozenStatus status) {
            this(status, null);
        }

        FrozenResult(FrozenStatus status, FrozenInfo info) {
            this.status = status;
            this.info = info;
        }
    }

    static enum FrozenStatus {
        FROZEN_OKAY,
        FROZEN_BAD_NAME,
        FROZEN_NOT_FOUND,
        FROZEN_DISABLED,
        FROZEN_EXCLUDED,
        FROZEN_INVALID;

    }

    private static class FrozenInfo {
        final TruffleString name;
        final byte[] data;
        final int size;
        final boolean isPackage;
        final TruffleString origName;
        final boolean isAlias;

        FrozenInfo(byte[] data, int size) {
            this(null, data, size, false, null, false);
        }

        FrozenInfo(TruffleString name, byte[] data, int size, boolean isPackage, TruffleString origName, boolean isAlias) {
            this.name = name;
            this.data = data;
            this.size = size;
            this.isPackage = isPackage;
            this.origName = origName;
            this.isAlias = isAlias;
        }
    }

    @Builtin(name="_override_frozen_modules_for_tests", minNumOfPositionalArgs=1, parameterNames={"override"})
    @ArgumentClinic(name="override", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class OverrideFrozenModulesForTests
    extends PythonUnaryClinicBuiltinNode {
        OverrideFrozenModulesForTests() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object set(int override) {
            TriState value = TriState.UNDEFINED;
            if (override > 0) {
                value = TriState.TRUE;
            } else if (override < 0) {
                value = TriState.FALSE;
            }
            PythonContext.get(null).setOverrideFrozenModules(value);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.OverrideFrozenModulesForTestsClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="create_dynamic", minNumOfPositionalArgs=1, parameterNames={"moduleSpec", "fileName"})
    @GenerateNodeFactory
    public static abstract class CreateDynamicNode
    extends PythonBinaryBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object run(VirtualFrame frame, PythonObject moduleSpec, Object fileNameIn, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile fileNameIsNoValueProfile, @Cached PyObjectLookupAttr lookupAttr, @Cached PyObjectStrAsTruffleStringNode asStringNode, @Cached CreateDynamic createDynamicNode) {
            Object fileName = fileNameIsNoValueProfile.profile(inliningTarget, PGuards.isNoValue(fileNameIn)) ? PNone.NONE : fileNameIn;
            PythonContext ctx = this.getContext();
            TruffleString oldPackageContext = ctx.getPyPackageContext();
            ctx.setPyPackageContext(asStringNode.execute((Frame)frame, inliningTarget, lookupAttr.execute((Frame)frame, inliningTarget, moduleSpec, StringLiterals.T_NAME)));
            try {
                Object object = createDynamicNode.execute(frame, moduleSpec, fileName);
                return object;
            }
            finally {
                ctx.setPyPackageContext(oldPackageContext);
            }
        }
    }

    @Builtin(name="extension_suffixes")
    @GenerateNodeFactory
    public static abstract class ExtensionSuffixesNode
    extends PythonBuiltinNode {
        @Specialization
        Object run(@Cached PythonObjectFactory factory) {
            return factory.createList(new Object[]{PythonContext.get(this).getSoAbi(), StringLiterals.T_EXT_SO, StringLiterals.T_EXT_PYD});
        }
    }

    @Builtin(name="_fix_co_filename", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class FixCoFilename
    extends PythonBinaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object run(PCode code, PString path, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode) {
            code.setFilename(castToStringNode.execute(inliningTarget, path));
            return PNone.NONE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object run(PCode code, TruffleString path) {
            code.setFilename(path);
            return PNone.NONE;
        }
    }

    @Builtin(name="source_hash", minNumOfPositionalArgs=2, parameterNames={"key", "source"})
    @ArgumentsClinic(value={@ArgumentClinic(name="key", conversion=ArgumentClinic.ClinicConversion.Long), @ArgumentClinic(name="source", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)})
    @GenerateNodeFactory
    public static abstract class SourceHashNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static PBytes run(long magicNumber, Object sourceBuffer, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.HashBufferNode hashBufferNode, @Cached PythonObjectFactory factory) {
            long sourceHash = hashBufferNode.execute(inliningTarget, sourceBuffer);
            return factory.createBytes(SourceHashNode.computeHash(magicNumber, sourceHash));
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] computeHash(long magicNumber, long sourceHash) {
            byte[] hash = new byte[8];
            long hashCode = magicNumber ^ sourceHash;
            for (int i = 0; i < hash.length; ++i) {
                hash[i] = (byte)(hashCode << 8 * i);
            }
            return hash;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.SourceHashNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="init_frozen", parameterNames={"name"}, minNumOfPositionalArgs=1, doc="init_frozen($module, name, /)\n--\n\nInitializes a frozen module.")
    @GenerateNodeFactory
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class InitFrozen
    extends PythonUnaryClinicBuiltinNode {
        InitFrozen() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.InitFrozenClinicProviderGen.INSTANCE;
        }

        @Specialization
        PythonModule run(TruffleString name) {
            return ImpModuleBuiltins.importFrozenModuleObject(this.getContext(), name, true);
        }
    }

    @Builtin(name="find_frozen", parameterNames={"name", "withData"}, minNumOfPositionalArgs=1, isPublic=false, doc="find_frozen($module, name, /, *, withdata=False)\n--\n\nReturn info about the corresponding frozen module (if there is one) or None.\n\nThe returned info (a 3-tuple):\n\n * data         the raw marshalled bytes\n * is_package   whether or not it is a package\n * origname     the originally frozen module's name, or None if not\n                a stdlib module (this will usually be the same as\n                the module's current name)")
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="withData", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false", useDefaultForNone=true)})
    static abstract class FindFrozen
    extends PythonBinaryClinicBuiltinNode {
        FindFrozen() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.FindFrozenClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object run(VirtualFrame frame, TruffleString name, boolean withData, @Cached BuiltinConstructors.MemoryViewNode memoryViewNode, @Cached TruffleString.EqualNode equalNode, @Cached PConstructAndRaiseNode constructAndRaiseNode, @Cached PythonObjectFactory factory) {
            FrozenResult result = ImpModuleBuiltins.findFrozen(this.getContext(), name, equalNode);
            FrozenStatus status = result.status;
            FrozenInfo info = result.info;
            switch (status.ordinal()) {
                case 1: 
                case 2: 
                case 3: {
                    return PNone.NONE;
                }
            }
            ImpModuleBuiltins.raiseFrozenError(frame, status, name, constructAndRaiseNode);
            PMemoryView data = null;
            if (withData) {
                data = memoryViewNode.execute(frame, factory.createBytes(info.data));
            }
            Object[] returnValues = new Object[]{data == null ? PNone.NONE : data, info.isPackage, info.origName == null ? PNone.NONE : info.origName};
            return factory.createTuple(returnValues);
        }
    }

    @Builtin(name="get_frozen_object", parameterNames={"name", "data"}, minNumOfPositionalArgs=1, doc="get_frozen_object($module, name, data=None, /)\n--\n\nCreate a code object for a frozen module.")
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer, defaultValue="PNone.NONE", useDefaultForNone=true)})
    static abstract class GetFrozenObject
    extends PythonBinaryClinicBuiltinNode {
        GetFrozenObject() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.GetFrozenObjectClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object run(VirtualFrame frame, TruffleString name, Object dataObj, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached TruffleString.EqualNode equalNode, @Cached InlinedConditionProfile isCodeObjectProfile, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode, @Cached PRaiseNode.Lazy raiseNode) {
            FrozenInfo info;
            if (dataObj != PNone.NONE) {
                try {
                    info = new FrozenInfo(bufferLib.getInternalOrCopiedByteArray(dataObj), bufferLib.getBufferLength(dataObj));
                }
                finally {
                    bufferLib.release(dataObj, frame, indirectCallData);
                }
                if (info.size == 0) {
                    ImpModuleBuiltins.raiseFrozenError(frame, FrozenStatus.FROZEN_INVALID, name, constructAndRaiseNode.get(inliningTarget));
                }
            } else {
                FrozenResult result = ImpModuleBuiltins.findFrozen(PythonContext.get(inliningTarget), name, equalNode);
                FrozenStatus status = result.status;
                info = result.info;
                ImpModuleBuiltins.raiseFrozenError(frame, status, name, constructAndRaiseNode.get(inliningTarget));
            }
            Object code = null;
            try {
                code = MarshalModuleBuiltins.Marshal.load(info.data, info.size);
            }
            catch (MarshalModuleBuiltins.Marshal.MarshalError | NumberFormatException e) {
                ImpModuleBuiltins.raiseFrozenError(frame, FrozenStatus.FROZEN_INVALID, name, constructAndRaiseNode.get(inliningTarget));
            }
            if (!isCodeObjectProfile.profile(inliningTarget, code instanceof PCode)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.NOT_A_CODE_OBJECT, name);
            }
            return code;
        }
    }

    @Builtin(name="is_frozen_package", parameterNames={"name"}, minNumOfPositionalArgs=1, doc="is_frozen_package($module, name, /)\n--\n\nReturns True if the module name is of a frozen package.")
    @GenerateNodeFactory
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class IsFrozenPackage
    extends PythonUnaryClinicBuiltinNode {
        IsFrozenPackage() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.IsFrozenClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean run(VirtualFrame frame, TruffleString name, @Cached PConstructAndRaiseNode constructAndRaiseNode, @Cached TruffleString.EqualNode equalNode) {
            FrozenResult result = ImpModuleBuiltins.findFrozen(this.getContext(), name, equalNode);
            if (result.status != FrozenStatus.FROZEN_EXCLUDED) {
                ImpModuleBuiltins.raiseFrozenError(frame, result.status, name, constructAndRaiseNode);
            }
            return result.info.isPackage;
        }
    }

    @Builtin(name="is_frozen", parameterNames={"name"}, minNumOfPositionalArgs=1, doc="is_frozen($module, name, /)\\n\"\n--\n\nReturns True if the module name corresponds to a frozen module.")
    @GenerateNodeFactory
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    static abstract class IsFrozen
    extends PythonUnaryClinicBuiltinNode {
        IsFrozen() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ImpModuleBuiltinsClinicProviders.IsFrozenClinicProviderGen.INSTANCE;
        }

        @Specialization
        boolean run(TruffleString name, @Cached TruffleString.EqualNode equalNode) {
            return ImpModuleBuiltins.findFrozen((PythonContext)this.getContext(), (TruffleString)name, (TruffleString.EqualNode)equalNode).status == FrozenStatus.FROZEN_OKAY;
        }
    }

    @Builtin(name="exec_builtin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ExecBuiltin
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object exec(PythonModule pythonModule) {
            PythonContext core = this.getContext();
            if (!ImageInfo.inImageBuildtimeCode()) {
                PythonBuiltins builtins = pythonModule.getBuiltins();
                assert (builtins != null);
                if (!builtins.isInitialized()) {
                    ExecBuiltin.doPostInit(core, builtins);
                    builtins.setInitialized(true);
                }
            }
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doPostInit(Python3Core core, PythonBuiltins builtins) {
            builtins.postInitialize(core);
        }
    }

    @Builtin(name="create_builtin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CreateBuiltin
    extends PythonBuiltinNode {
        public static final TruffleString T_LOADER = PythonUtils.tsLiteral("loader");

        @Specialization
        static Object run(VirtualFrame frame, PythonObject moduleSpec, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode toStringNode, @Cached PyObjectSetAttr setAttributeNode, @Cached PyObjectLookupAttr lookup) {
            Object name = lookup.execute((Frame)frame, inliningTarget, moduleSpec, StringLiterals.T_NAME);
            PythonModule builtinModule = PythonContext.get(inliningTarget).lookupBuiltinModule(toStringNode.execute(inliningTarget, name));
            if (builtinModule != null) {
                Object loader = lookup.execute((Frame)frame, inliningTarget, moduleSpec, T_LOADER);
                if (loader != PNone.NO_VALUE) {
                    setAttributeNode.execute((Frame)frame, inliningTarget, builtinModule, SpecialAttributeNames.T___LOADER__, loader);
                }
                return builtinModule;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.NotImplementedError, PythonUtils.toTruffleStringUncached("_imp.create_builtin"));
        }
    }

    @Builtin(name="is_builtin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsBuiltin
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public int run(TruffleString name) {
            if (this.getContext().lookupBuiltinModule(name) != null) {
                return -1;
            }
            return 0;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public int run(PString name, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode toString) {
            try {
                return this.run(toString.execute(inliningTarget, name));
            }
            catch (CannotCastException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }

        @Fallback
        public int run(Object noName) {
            return 0;
        }
    }

    @Builtin(name="exec_dynamic", minNumOfPositionalArgs=1, doc="exec_dynamic($module, mod, /)\n--\n\nInitialize an extension module.")
    @GenerateNodeFactory
    public static abstract class ExecDynamicNode
    extends PythonBuiltinNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static int doPythonModule(VirtualFrame frame, PythonModule extensionModule, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="1") InteropLibrary lib, @Cached CExtNodes.ExecModuleNode execModuleNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object nativeModuleDef = extensionModule.getNativeModuleDef();
            if (nativeModuleDef == null) {
                return 0;
            }
            Object mdState = extensionModule.getNativeModuleState();
            if (mdState != null && !lib.isNull(mdState)) {
                return 0;
            }
            PythonContext context = PythonContext.get(inliningTarget);
            if (!context.hasCApiContext()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.CAPI_NOT_YET_INITIALIZED);
            }
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                int n = execModuleNode.execute(context.getCApiContext(), extensionModule, nativeModuleDef);
                return n;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @Fallback
        static int doOther(Object extensionModule) {
            return 0;
        }
    }

    @Builtin(name="__create_dynamic__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class CreateDynamic
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private CExtCommonNodes.CheckFunctionResultNode checkResultNode;

        public abstract Object execute(VirtualFrame var1, PythonObject var2, Object var3);

        @Specialization
        Object run(VirtualFrame frame, PythonObject moduleSpec, Object filename, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached ReadAttributeFromPythonObjectNode readNameNode, @Cached ReadAttributeFromPythonObjectNode readOriginNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            TruffleString name = castToTruffleStringNode.execute(inliningTarget, readNameNode.execute(moduleSpec, StringLiterals.T_NAME));
            TruffleString path = castToTruffleStringNode.execute(inliningTarget, readOriginNode.execute(moduleSpec, T_ORIGIN));
            PythonContext context = this.getContext();
            PythonLanguage language = this.getLanguage();
            Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
            try {
                Object object = this.run(context, new CExtContext.ModuleSpec(name, path, moduleSpec));
                return object;
            }
            catch (LoadCExtException.ApiInitException ie) {
                throw ie.reraise(frame, inliningTarget, constructAndRaiseNode);
            }
            catch (LoadCExtException.ImportException ie) {
                throw ie.reraise(frame, inliningTarget, constructAndRaiseNode);
            }
            catch (IOException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private Object run(PythonContext context, CExtContext.ModuleSpec spec) throws IOException, LoadCExtException.ApiInitException, LoadCExtException.ImportException {
            PythonModule existingModule = this.findExtension(context, spec);
            if (existingModule != null) {
                return existingModule;
            }
            return CExtContext.loadCExtModule(this, context, spec, this.getCheckResultNode());
        }

        private PythonModule findExtension(PythonContext context, CExtContext.ModuleSpec spec) {
            CApiContext cApiContext = context.getCApiContext();
            if (cApiContext == null) {
                return null;
            }
            return cApiContext.findExtension(spec.path, spec.name);
        }

        private CExtCommonNodes.CheckFunctionResultNode getCheckResultNode() {
            if (this.checkResultNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkResultNode = (CExtCommonNodes.CheckFunctionResultNode)this.insert(ExternalFunctionNodesFactory.DefaultCheckFunctionResultNodeGen.create());
            }
            return this.checkResultNode;
        }
    }

    @Builtin(name="get_magic")
    @GenerateNodeFactory
    public static abstract class GetMagic
    extends PythonBuiltinNode {
        static final int MAGIC_NUMBER = 21290;
        static final byte[] MAGIC_NUMBER_BYTES = new byte[4];
        @Node.Child
        PythonObjectFactory factory = PythonObjectFactory.create();

        @Specialization(guards={"isSingleContext()"})
        PBytes runCachedSingleContext(@Cached(value="getMagicNumberPBytes()", weak=true) PBytes magicBytes) {
            return magicBytes;
        }

        @Specialization(replaces={"runCachedSingleContext"})
        PBytes run() {
            return this.factory.createBytes(MAGIC_NUMBER_BYTES);
        }

        protected PBytes getMagicNumberPBytes() {
            return this.factory.createBytes(MAGIC_NUMBER_BYTES);
        }

        static {
            ByteArraySupport.littleEndian().putInt(MAGIC_NUMBER_BYTES, 0, 21290);
            GetMagic.MAGIC_NUMBER_BYTES[2] = 13;
            GetMagic.MAGIC_NUMBER_BYTES[3] = 10;
        }
    }

    @Builtin(name="lock_held")
    @GenerateNodeFactory
    public static abstract class LockHeld
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public boolean run() {
            ReentrantLock importLock = this.getContext().getImportLock();
            return importLock.isHeldByCurrentThread();
        }
    }

    @Builtin(name="release_lock")
    @GenerateNodeFactory
    public static abstract class ReleaseLockNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object run() {
            ReentrantLock importLock = this.getContext().getImportLock();
            if (importLock.isHeldByCurrentThread()) {
                importLock.unlock();
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="acquire_lock")
    @GenerateNodeFactory
    public static abstract class AcquireLock
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object run(@Cached GilNode gil) {
            gil.release(true);
            try {
                this.getContext().getImportLock().lock();
            }
            finally {
                gil.acquire();
            }
            return PNone.NONE;
        }
    }
}

