/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.SequenceStoreException;
import com.oracle.truffle.api.CompilerAsserts;

public abstract class SequenceStorage {
    protected int length;
    protected int capacity;

    protected SequenceStorage() {
    }

    protected SequenceStorage(int length, int capacity) {
        this.length = length;
        this.capacity = capacity;
    }

    public final int length() {
        return this.length;
    }

    public void setNewLength(int length) {
        this.length = length;
    }

    protected final void incLength() {
        ++this.length;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public abstract SequenceStorage copy();

    public abstract SequenceStorage createEmpty(int var1);

    public abstract Object getInternalArrayObject();

    public abstract ListStorageType getElementType();

    public abstract Object[] getInternalArray();

    public abstract Object[] getCopyOfInternalArray();

    public abstract Object getItemNormalized(int var1);

    public abstract void setItemNormalized(int var1, Object var2) throws SequenceStoreException;

    public abstract void insertItem(int var1, Object var2) throws SequenceStoreException;

    public abstract SequenceStorage getSliceInBound(int var1, int var2, int var3, int var4);

    public abstract void reverse();

    public abstract boolean equals(SequenceStorage var1);

    public abstract SequenceStorage generalizeFor(Object var1, SequenceStorage var2);

    public abstract Object getIndicativeValue();

    public abstract void ensureCapacity(int var1);

    public abstract void copyItem(int var1, int var2);

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getClass().getSimpleName() + this.toString(true);
    }

    public String toString(boolean isList) {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder str = new StringBuilder(isList ? "[" : "(");
        int len = this.length > 10 ? 10 : this.length;
        for (int i = 0; i < len; ++i) {
            str.append(i == 0 ? "" : ", ");
            str.append(this.getItemNormalized(i));
        }
        if (this.length > 10) {
            str.append("...").append('(').append(this.length).append(')');
        }
        return str.append(isList ? (char)']' : ')').toString();
    }

    public static enum ListStorageType {
        Uninitialized,
        Empty,
        Boolean,
        Byte,
        Int,
        Long,
        Double,
        Generic;


        public boolean generalizesFrom(ListStorageType other) {
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    return false;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    return other == Uninitialized || other == Empty || other == Byte;
                }
                case 5: {
                    return other == Uninitialized || other == Empty || other == Byte || other == Int;
                }
            }
            return true;
        }
    }
}

