/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;

@ExportLibrary(value=PosixSupportLibrary.class)
public class LoggingPosixSupport
extends PosixSupport {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(LoggingPosixSupport.class);
    private static final Level DEFAULT_LEVEL = Level.FINER;
    protected final PosixSupport delegate;

    public LoggingPosixSupport(PosixSupport delegate) {
        this.delegate = delegate;
        LOGGER.log(Level.INFO, "Using " + String.valueOf(delegate.getClass()));
    }

    public static boolean isEnabled() {
        return LOGGER.isLoggable(DEFAULT_LEVEL);
    }

    @Override
    public void setEnv(TruffleLanguage.Env env) {
        this.delegate.setEnv(env);
    }

    @ExportMessage
    final TruffleString getBackend(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter(Level.FINEST, "getBackend", "", new Object[0]);
        return LoggingPosixSupport.logExit(Level.FINEST, "getBackend", "%s", lib.getBackend(this.delegate));
    }

    @ExportMessage
    final TruffleString strerror(int errorCode, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter(Level.FINEST, "strerror", "%d", errorCode);
        return LoggingPosixSupport.logExit(Level.FINEST, "strerror", "%s", lib.strerror(this.delegate, errorCode));
    }

    @ExportMessage
    final long getpid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("getpid", "", new Object[0]);
        return LoggingPosixSupport.logExit("getpid", "%d", lib.getpid(this.delegate));
    }

    @ExportMessage
    final int umask(int mask, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("umask", "0%o", mask);
        try {
            return LoggingPosixSupport.logExit("umask", "0%o", lib.umask(this.delegate, mask));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("umask", e);
        }
    }

    @ExportMessage
    final int openat(int dirFd, Object pathname, int flags, int mode, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("openAt", "%d, %s, 0x%x, 0%o", dirFd, pathname, flags, mode);
        try {
            return LoggingPosixSupport.logExit("openAt", "%d", lib.openat(this.delegate, dirFd, pathname, flags, mode));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("openAt", e);
        }
    }

    @ExportMessage
    final int close(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("close", "%d", fd);
        try {
            return lib.close(this.delegate, fd);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("close", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.Buffer read(int fd, long length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("read", "%d, %d", fd, length);
        try {
            PosixSupportLibrary.Buffer retVal = lib.read(this.delegate, fd, length);
            LoggingPosixSupport.logExit("read", "%d", retVal.length);
            return retVal;
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("read", e);
        }
    }

    @ExportMessage
    final long write(int fd, PosixSupportLibrary.Buffer data, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("write", "%d, %d", fd, data.length);
        try {
            return LoggingPosixSupport.logExit("write", "%d", lib.write(this.delegate, fd, data));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("write", e);
        }
    }

    @ExportMessage
    final int dup(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("dup", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("dup", "%d", lib.dup(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("dup", e);
        }
    }

    @ExportMessage
    final int dup2(int fd, int fd2, boolean inheritable, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("dup2", "%d, %d, %b", fd, fd2, inheritable);
        try {
            return LoggingPosixSupport.logExit("dup2", "%d", lib.dup2(this.delegate, fd, fd2, inheritable));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("dup2", e);
        }
    }

    @ExportMessage
    final boolean getInheritable(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getInheritable", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("getInheritable", "%b", lib.getInheritable(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getInheritable", e);
        }
    }

    @ExportMessage
    final void setInheritable(int fd, boolean inheritable, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("setInheritable", "%d, %b", fd, inheritable);
        try {
            lib.setInheritable(this.delegate, fd, inheritable);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("setInheritable", e);
        }
    }

    @ExportMessage
    final int[] pipe(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("pipe", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("pipe", "%s", lib.pipe(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("pipe", e);
        }
    }

    @ExportMessage
    public PosixSupportLibrary.SelectResult select(int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("select", "%s %s %s %s", readfds, writefds, errorfds, timeout);
        try {
            return LoggingPosixSupport.logExit("select", "%s", lib.select(this.delegate, readfds, writefds, errorfds, timeout));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("select", e);
        }
    }

    @ExportMessage
    final long lseek(int fd, long offset, int how, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("lseek", "%d, %d, %d", fd, offset, how);
        try {
            return LoggingPosixSupport.logExit("lseek", "%d", lib.lseek(this.delegate, fd, offset, how));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("lseek", e);
        }
    }

    @ExportMessage
    final void ftruncate(int fd, long length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("ftruncate", "%d, %d", fd, length);
        try {
            lib.ftruncate(this.delegate, fd, length);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("ftruncate", e);
        }
    }

    @ExportMessage
    final void fsync(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fsync", "%d", fd);
        try {
            lib.fsync(this.delegate, fd);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fsync", e);
        }
    }

    @ExportMessage
    final void flock(int fd, int operation, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("flock", "%d %d", fd, operation);
        try {
            lib.flock(this.delegate, fd, operation);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("flock", e);
        }
    }

    @ExportMessage
    final void fcntlLock(int fd, boolean blocking, int lockType, int whence, long start, long length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fcntlLock", "%d %s %d %d %d %d", fd, blocking, lockType, whence, start, length);
        try {
            lib.fcntlLock(this.delegate, fd, blocking, lockType, whence, start, length);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fcntlLock", e);
        }
    }

    @ExportMessage
    final boolean getBlocking(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getBlocking", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("getBlocking", "%b", lib.getBlocking(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getBlocking", e);
        }
    }

    @ExportMessage
    final void setBlocking(int fd, boolean blocking, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("setBlocking", "%d, %b", fd, blocking);
        try {
            lib.setBlocking(this.delegate, fd, blocking);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("setBlocking", e);
        }
    }

    @ExportMessage
    final int[] getTerminalSize(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getTerminalSize", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("getTerminalSize", "%s", lib.getTerminalSize(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getTerminalSize", e);
        }
    }

    @ExportMessage
    final long[] fstatat(int dirFd, Object pathname, boolean followSymlinks, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fstatAt", "%d, %s, %b", dirFd, pathname, followSymlinks);
        try {
            return LoggingPosixSupport.logExit("fstatAt", "%s", lib.fstatat(this.delegate, dirFd, pathname, followSymlinks));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fstatAt", e);
        }
    }

    @ExportMessage
    final long[] fstat(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fstat", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("fstat", "%s", lib.fstat(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fstat", e);
        }
    }

    @ExportMessage
    final long[] statvfs(Object path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("statvfs", "%s", path);
        try {
            return LoggingPosixSupport.logExit("statvfs", "%s", lib.statvfs(this.delegate, path));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("statvfs", e);
        }
    }

    @ExportMessage
    final long[] fstatvfs(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fstatvfs", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("fstatvfs", "%s", lib.fstatvfs(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fstatvfs", e);
        }
    }

    @ExportMessage
    final Object[] uname(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("uname", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("uname", "%s", lib.uname(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("uname", e);
        }
    }

    @ExportMessage
    final void unlinkat(int dirFd, Object pathname, boolean rmdir, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("unlinkAt", "%d, %s, %b", dirFd, pathname, rmdir);
        try {
            lib.unlinkat(this.delegate, dirFd, pathname, rmdir);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("unlinkAt", e);
        }
    }

    @ExportMessage
    final void linkat(int oldFdDir, Object oldPath, int newFdDir, Object newPath, int flags, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("linkAt", "%d, %s, %d, %s, %d", oldFdDir, oldPath, newFdDir, newPath, flags);
        try {
            lib.linkat(this.delegate, oldFdDir, oldPath, newFdDir, newPath, flags);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("symlinkAt", e);
        }
    }

    @ExportMessage
    final void symlinkat(Object target, int linkpathDirFd, Object linkpath, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("symlinkAt", "%s, %d, %s", target, linkpathDirFd, linkpath);
        try {
            lib.symlinkat(this.delegate, target, linkpathDirFd, linkpath);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("symlinkAt", e);
        }
    }

    @ExportMessage
    final void mkdirat(int dirFd, Object pathname, int mode, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mkdirAt", "%d, %s, 0%o", dirFd, pathname, mode);
        try {
            lib.mkdirat(this.delegate, dirFd, pathname, mode);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mkdirAt", e);
        }
    }

    @ExportMessage
    final Object getcwd(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getcwd", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("getcwd", "%s", lib.getcwd(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getcwd", e);
        }
    }

    @ExportMessage
    final void chdir(Object path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("chdir", "%s", path);
        try {
            lib.chdir(this.delegate, path);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("chdir", e);
        }
    }

    @ExportMessage
    final void fchdir(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fchdir", "%d", fd);
        try {
            lib.fchdir(this.delegate, fd);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fchdir", e);
        }
    }

    @ExportMessage
    final boolean isatty(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("isatty", "%d", fd);
        return LoggingPosixSupport.logExit("isatty", "%b", lib.isatty(this.delegate, fd));
    }

    @ExportMessage
    final Object opendir(Object path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("opendir", "%s", path);
        try {
            return LoggingPosixSupport.logExit("opendir", "%s", lib.opendir(this.delegate, path));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("opendir", e);
        }
    }

    @ExportMessage
    final Object fdopendir(int fd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fdopendir", "%d", fd);
        try {
            return LoggingPosixSupport.logExit("fdopendir", "%s", lib.fdopendir(this.delegate, fd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fdopendir", e);
        }
    }

    @ExportMessage
    final void closedir(Object dirStream, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("closedir", "%s", dirStream);
        try {
            lib.closedir(this.delegate, dirStream);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("closedir", e);
        }
    }

    @ExportMessage
    final Object readdir(Object dirStream, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("readdir", "%s", dirStream);
        try {
            return LoggingPosixSupport.logExit("readdir", "%s", lib.readdir(this.delegate, dirStream));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("readdir", e);
        }
    }

    @ExportMessage
    final void rewinddir(Object dirStream, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("rewinddir", "%s", dirStream);
        lib.rewinddir(this.delegate, dirStream);
    }

    @ExportMessage
    final Object dirEntryGetName(Object dirEntry, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("dirEntryGetName", "%s", dirEntry);
        try {
            return LoggingPosixSupport.logExit("dirEntryGetName", "%s", lib.dirEntryGetName(this.delegate, dirEntry));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("dirEntryGetName", e);
        }
    }

    @ExportMessage
    final Object dirEntryGetPath(Object dirEntry, Object scandirPath, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("dirEntryGetPath", "%s, %s", dirEntry, scandirPath);
        try {
            return LoggingPosixSupport.logExit("dirEntryGetPath", "%s", lib.dirEntryGetPath(this.delegate, dirEntry, scandirPath));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("dirEntryGetPath", e);
        }
    }

    @ExportMessage
    final long dirEntryGetInode(Object dirEntry, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("dirEntryGetInode", "%s", dirEntry);
        try {
            return LoggingPosixSupport.logExit("dirEntryGetInode", "%d", lib.dirEntryGetInode(this.delegate, dirEntry));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("dirEntryGetInode", e);
        }
    }

    @ExportMessage
    final int dirEntryGetType(Object dirEntry, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("dirEntryGetType", "%s", dirEntry);
        return LoggingPosixSupport.logExit("dirEntryGetType", "%d", lib.dirEntryGetType(this.delegate, dirEntry));
    }

    @ExportMessage
    final void utimensat(int dirFd, Object pathname, long[] timespec, boolean followSymlinks, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("utimeNsAt", "%d, %s, %s, %b", dirFd, pathname, timespec, followSymlinks);
        try {
            lib.utimensat(this.delegate, dirFd, pathname, timespec, followSymlinks);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("utimeNsAt", e);
        }
    }

    @ExportMessage
    final void futimens(int fd, long[] timespec, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("futimeNs", "%d, %s", fd, timespec);
        try {
            lib.futimens(this.delegate, fd, timespec);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("futimeNs", e);
        }
    }

    @ExportMessage
    final void futimes(int fd, PosixSupportLibrary.Timeval[] timeval, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("futimes", "%d, %s", fd, timeval);
        try {
            lib.futimes(this.delegate, fd, timeval);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("futimes", e);
        }
    }

    @ExportMessage
    final void lutimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("lutimes", "%s, %s", filename, timeval);
        try {
            lib.lutimes(this.delegate, filename, timeval);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("lutimes", e);
        }
    }

    @ExportMessage
    final void utimes(Object filename, PosixSupportLibrary.Timeval[] timeval, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("utimes", "%s, %s", filename, timeval);
        try {
            lib.utimes(this.delegate, filename, timeval);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("utimes", e);
        }
    }

    @ExportMessage
    final void renameat(int oldDirFd, Object oldPath, int newDirFd, Object newPath, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("renameAt", "%d, %s, %d, %s", oldDirFd, oldPath, newDirFd, newPath);
        try {
            lib.renameat(this.delegate, oldDirFd, oldPath, newDirFd, newPath);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("renameAt", e);
        }
    }

    @ExportMessage
    final boolean faccessat(int dirFd, Object path, int mode, boolean effectiveIds, boolean followSymlinks, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("faccessAt", "%d, %s, 0%o, %b, %b", dirFd, path, mode, effectiveIds, followSymlinks);
        return LoggingPosixSupport.logExit("faccessAt", "%b", lib.faccessat(this.delegate, dirFd, path, mode, effectiveIds, followSymlinks));
    }

    @ExportMessage
    final void fchmodat(int dirFd, Object path, int mode, boolean followSymlinks, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fchmodat", "%d, %s, 0%o, %b", dirFd, path, mode, followSymlinks);
        try {
            lib.fchmodat(this.delegate, dirFd, path, mode, followSymlinks);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fchmodat", e);
        }
    }

    @ExportMessage
    final void fchmod(int fd, int mode, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fchmod", "%d, 0%o", fd, mode);
        try {
            lib.fchmod(this.delegate, fd, mode);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fchmod", e);
        }
    }

    @ExportMessage
    final void fchownat(int dirFd, Object path, long owner, long group, boolean followSymlinks, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fchownat", "%d, %s, %d, %d, %b", dirFd, path, owner, group, followSymlinks);
        try {
            lib.fchownat(this.delegate, dirFd, path, owner, group, followSymlinks);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fchownat", e);
        }
    }

    @ExportMessage
    final void fchown(int fd, long owner, long group, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("fchown", "%d, %d, %d", fd, owner, group);
        try {
            lib.fchown(this.delegate, fd, owner, group);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("fchown", e);
        }
    }

    @ExportMessage
    final Object readlinkat(int dirFd, Object path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("readlinkat", "%d, %s", dirFd, path);
        try {
            return LoggingPosixSupport.logExit("readlinkat", "%s", lib.readlinkat(this.delegate, dirFd, path));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("readlinkat", e);
        }
    }

    @ExportMessage
    final void kill(long pid, int signal, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("kill", "%d, %d", pid, signal);
        try {
            lib.kill(this.delegate, pid, signal);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("kill", e);
        }
    }

    @ExportMessage
    final void killpg(long pgid, int signal, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("killpg", "%d, %d", pgid, signal);
        try {
            lib.killpg(this.delegate, pgid, signal);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("killpg", e);
        }
    }

    @ExportMessage
    public Object mmap(long length, int prot, int flags, int fd, long offset, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmap", "%d, %d, %d, %d, %d", length, prot, flags, fd, offset);
        try {
            return LoggingPosixSupport.logExit("mmap", "%s", lib.mmap(this.delegate, length, prot, flags, fd, offset));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmap", e);
        }
    }

    @ExportMessage
    final long[] waitpid(long pid, int options, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("waitpid", "%d, %d", pid, options);
        try {
            return LoggingPosixSupport.logExit("waitpid", "%s", lib.waitpid(this.delegate, pid, options));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("waitpid", e);
        }
    }

    @ExportMessage
    public byte mmapReadByte(Object mmap, long index, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmapReadByte", "%s, %d", mmap, index);
        try {
            return LoggingPosixSupport.logExit("mmapReadByte", "%s", lib.mmapReadByte(this.delegate, mmap, index));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmapReadByte", e);
        }
    }

    @ExportMessage
    public void mmapWriteByte(Object mmap, long index, byte value, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmapWriteByte", "%s, %d, %d", mmap, index, value);
        try {
            lib.mmapWriteByte(this.delegate, mmap, index, value);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmapWriteByte", e);
        }
    }

    @ExportMessage
    final void abort(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("abort", "", new Object[0]);
        lib.abort(this.delegate);
    }

    @ExportMessage
    final boolean wcoredump(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wcoredump", "%d", status);
        return LoggingPosixSupport.logExit("wcoredump", "%b", lib.wcoredump(this.delegate, status));
    }

    @ExportMessage
    final boolean wifcontinued(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wifcontinued", "%d", status);
        return LoggingPosixSupport.logExit("wifcontinued", "%b", lib.wifcontinued(this.delegate, status));
    }

    @ExportMessage
    final boolean wifstopped(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wifstopped", "%d", status);
        return LoggingPosixSupport.logExit("wifstopped", "%b", lib.wifstopped(this.delegate, status));
    }

    @ExportMessage
    final boolean wifsignaled(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wifsignaled", "%d", status);
        return LoggingPosixSupport.logExit("wifsignaled", "%b", lib.wifsignaled(this.delegate, status));
    }

    @ExportMessage
    final boolean wifexited(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wifexited", "%d", status);
        return LoggingPosixSupport.logExit("wifexited", "%b", lib.wifexited(this.delegate, status));
    }

    @ExportMessage
    final int wexitstatus(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wexitstatus", "%d", status);
        return LoggingPosixSupport.logExit("wexitstatus", "%d", lib.wexitstatus(this.delegate, status));
    }

    @ExportMessage
    final int wtermsig(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wtermsig", "%d", status);
        return LoggingPosixSupport.logExit("wtermsig", "%d", lib.wtermsig(this.delegate, status));
    }

    @ExportMessage
    final int wstopsig(int status, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("wstopsig", "%d", status);
        return LoggingPosixSupport.logExit("wstopsig", "%d", lib.wstopsig(this.delegate, status));
    }

    @ExportMessage
    final long getuid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("getuid", "", new Object[0]);
        return LoggingPosixSupport.logExit("getuid", "%d", lib.getuid(this.delegate));
    }

    @ExportMessage
    final long geteuid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("geteuid", "", new Object[0]);
        return LoggingPosixSupport.logExit("geteuid", "%d", lib.geteuid(this.delegate));
    }

    @ExportMessage
    final long getgid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("getgid", "", new Object[0]);
        return LoggingPosixSupport.logExit("getgid", "%d", lib.getgid(this.delegate));
    }

    @ExportMessage
    final long getppid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("getppid", "", new Object[0]);
        return LoggingPosixSupport.logExit("getppid", "%d", lib.getppid(this.delegate));
    }

    @ExportMessage
    final long getpgid(long pid, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getpgid", "%d", pid);
        try {
            return LoggingPosixSupport.logExit("getpgid", "%d", lib.getpgid(this.delegate, pid));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getpgid", e);
        }
    }

    @ExportMessage
    final void setpgid(long pid, long pgid, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("setpgid", "%d, %d", pid, pgid);
        try {
            lib.setpgid(this.delegate, pid, pgid);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("setpgid", e);
        }
    }

    @ExportMessage
    final long getpgrp(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("getpgrp", "", new Object[0]);
        return LoggingPosixSupport.logExit("getpgrp", "%d", lib.getpgrp(this.delegate));
    }

    @ExportMessage
    final long getsid(long pid, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getsid", "%d", pid);
        try {
            return LoggingPosixSupport.logExit("getsid", "%d", lib.getsid(this.delegate, pid));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getsid", e);
        }
    }

    @ExportMessage
    final long setsid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("setsid", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("getsid", "%d", lib.setsid(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("setsid", e);
        }
    }

    @ExportMessage
    final long[] getgroups(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getgroups", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("getgroups", "%s", lib.getgroups(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getgroups", e);
        }
    }

    @ExportMessage
    public int mmapReadBytes(Object mmap, long index, byte[] bytes, int length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmapReadBytes", "%s, %d, %d", mmap, index, length);
        try {
            return LoggingPosixSupport.logExit("mmapReadBytes", "%s", lib.mmapReadBytes(this.delegate, mmap, index, bytes, length));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmapReadBytes", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.OpenPtyResult openpty(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("openpty", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("openpty", "%s", lib.openpty(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("openpty", e);
        }
    }

    @ExportMessage
    final TruffleString ctermid(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("ctermid", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("ctermid", "%s", lib.ctermid(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("ctermid", e);
        }
    }

    @ExportMessage
    final void setenv(Object name, Object value, boolean overwrite, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("setenv", "%s, %s, %b", name, value, overwrite);
        try {
            lib.setenv(this.delegate, name, value, overwrite);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("setenv", e);
        }
    }

    @ExportMessage
    final void unsetenv(Object name, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("unsetenv", "%s", name);
        try {
            lib.unsetenv(this.delegate, name);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("unsetenv", e);
        }
    }

    @ExportMessage
    public void mmapWriteBytes(Object mmap, long index, byte[] bytes, int length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmapWriteBytes", "%s, %d, %d", mmap, index, length);
        try {
            lib.mmapWriteBytes(this.delegate, mmap, index, bytes, length);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmapWriteBytes", e);
        }
    }

    @ExportMessage
    final int forkExec(Object[] executables, Object[] args, Object cwd, Object[] env, int stdinReadFd, int stdinWriteFd, int stdoutReadFd, int stdoutWriteFd, int stderrReadFd, int stderrWriteFd, int errPipeReadFd, int errPipeWriteFd, boolean closeFds, boolean restoreSignals, boolean callSetsid, int[] fdsToKeep, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("forkExec", "%s, %s, %s, %s, %d, %d, %d, %d, %d, %d, %d, %d, %b, %b, %b, %s", executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep);
        try {
            return LoggingPosixSupport.logExit("forkExec", "%d", lib.forkExec(this.delegate, executables, args, cwd, env, stdinReadFd, stdinWriteFd, stdoutReadFd, stdoutWriteFd, stderrReadFd, stderrWriteFd, errPipeReadFd, errPipeWriteFd, closeFds, restoreSignals, callSetsid, fdsToKeep));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("forkExec", e);
        }
    }

    @ExportMessage
    public void mmapFlush(Object mmap, long offset, long length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmapFlush", "%s, %d, %d", mmap, offset, length);
        try {
            lib.mmapFlush(this.delegate, mmap, offset, length);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmapFlush", e);
        }
    }

    @ExportMessage
    public long mmapGetPointer(Object mmap, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("mmapGetPointer", "%s", mmap);
        return lib.mmapGetPointer(this.delegate, mmap);
    }

    @ExportMessage
    final void execv(Object pathname, Object[] args, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("execv", "%s, %s", pathname, args);
        try {
            lib.execv(this.delegate, pathname, args);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("execv", e);
        }
    }

    @ExportMessage
    public void mmapUnmap(Object mmap, long length, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("mmapUnmap", "%s %d", mmap, length);
        try {
            lib.mmapUnmap(this.delegate, mmap, length);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("mmapUnmap", e);
        }
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult getpwuid(long uid, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getpwuid", "%d", uid);
        try {
            return LoggingPosixSupport.logExit("getpwuid", "%s", lib.getpwuid(this.delegate, uid));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getpwuid", e);
        }
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult getpwnam(Object name, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getpwnam", "%s", name);
        try {
            return LoggingPosixSupport.logExit("getpwnam", "%s", lib.getpwnam(this.delegate, name));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getpwnam", e);
        }
    }

    @ExportMessage
    public boolean hasGetpwentries(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        return LoggingPosixSupport.logExit("hasGetpwentries", "%b", lib.hasGetpwentries(this.delegate));
    }

    @ExportMessage
    public PosixSupportLibrary.PwdResult[] getpwentries(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getpwentries", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("getpwentries", "%s", lib.getpwentries(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getpwentries", e);
        }
    }

    @ExportMessage
    final int system(Object command, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("system", "%s", command);
        return LoggingPosixSupport.logExit("system", "%d", lib.system(this.delegate, command));
    }

    @ExportMessage
    final int socket(int domain, int type, int protocol, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("socket", "%d, %d, %d", domain, type, protocol);
        try {
            return LoggingPosixSupport.logExit("socket", "%d", lib.socket(this.delegate, domain, type, protocol));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("socket", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.AcceptResult accept(int sockfd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("accept", "%d", sockfd);
        try {
            return LoggingPosixSupport.logExit("accept", "%s", lib.accept(this.delegate, sockfd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("accept", e);
        }
    }

    @ExportMessage
    final void bind(int sockfd, PosixSupportLibrary.UniversalSockAddr addr, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("bind", "%d, %s", sockfd, addr);
        try {
            lib.bind(this.delegate, sockfd, addr);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("bind", e);
        }
    }

    @ExportMessage
    final void connect(int sockfd, PosixSupportLibrary.UniversalSockAddr addr, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("connect", "%d, %s", sockfd, addr);
        try {
            lib.connect(this.delegate, sockfd, addr);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("connect", e);
        }
    }

    @ExportMessage
    final void listen(int sockfd, int backlog, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("listen", "%d, %d", sockfd, backlog);
        try {
            lib.listen(this.delegate, sockfd, backlog);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("listen", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr getpeername(int sockfd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getpeername", "%d", sockfd);
        try {
            return LoggingPosixSupport.logExit("getpeername", "%s", lib.getpeername(this.delegate, sockfd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getpeername", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr getsockname(int sockfd, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getsockname", "%d", sockfd);
        try {
            return LoggingPosixSupport.logExit("getsockname", "%s", lib.getsockname(this.delegate, sockfd));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getsockname", e);
        }
    }

    @ExportMessage
    final int send(int sockfd, byte[] buf, int offset, int len, int flags, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("send", "%d, %d, %d, %d", sockfd, offset, len, flags);
        try {
            return LoggingPosixSupport.logExit("send", "%d", lib.send(this.delegate, sockfd, buf, offset, len, flags));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("send", e);
        }
    }

    @ExportMessage
    final int sendto(int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("sendto", "%d, %d, %d, %d, %s", sockfd, offset, len, flags, destAddr);
        try {
            return LoggingPosixSupport.logExit("sendto", "%d", lib.sendto(this.delegate, sockfd, buf, offset, len, flags, destAddr));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("sendto", e);
        }
    }

    @ExportMessage
    final int recv(int sockfd, byte[] buf, int offset, int len, int flags, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("recv", "%d, %d, %d, %d", sockfd, offset, len, flags);
        try {
            return LoggingPosixSupport.logExit("recv", "%d", lib.recv(this.delegate, sockfd, buf, offset, len, flags));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("recv", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.RecvfromResult recvfrom(int sockfd, byte[] buf, int offset, int len, int flags, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("recvfrom", "%d, %d, %d, %d", sockfd, offset, len, flags);
        try {
            return LoggingPosixSupport.logExit("recvfrom", "%s", lib.recvfrom(this.delegate, sockfd, buf, offset, len, flags));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("recvfrom", e);
        }
    }

    @ExportMessage
    final void shutdown(int sockfd, int how, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("shutdown", "%d, %d", sockfd, how);
        try {
            lib.shutdown(this.delegate, sockfd, how);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("shutdown", e);
        }
    }

    @ExportMessage
    final int getsockopt(int sockfd, int level, int optname, byte[] optval, int optlen, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("getsockopt", "%d, %d, %d, %s, %d", sockfd, level, optname, optval, optlen);
        try {
            return LoggingPosixSupport.logExit("getsockopt", "%d", lib.getsockopt(this.delegate, sockfd, level, optname, optval, optlen));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("getsockopt", e);
        }
    }

    @ExportMessage
    final void setsockopt(int sockfd, int level, int optname, byte[] optval, int optlen, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("setsockopt", "%d, %d, %d, %s, %d", sockfd, level, optname, optval, optlen);
        try {
            lib.setsockopt(this.delegate, sockfd, level, optname, optval, optlen);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("setsockopt", e);
        }
    }

    @ExportMessage
    final int inet_addr(Object src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("inet_addr", "%s", src);
        return LoggingPosixSupport.logExit("inet_addr", "%d", lib.inet_addr(this.delegate, src));
    }

    @ExportMessage
    final int inet_aton(Object src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.InvalidAddressException {
        LoggingPosixSupport.logEnter("inet_aton", "%s", src);
        try {
            return LoggingPosixSupport.logExit("inet_aton", "%d", lib.inet_aton(this.delegate, src));
        }
        catch (PosixSupportLibrary.InvalidAddressException e) {
            throw LoggingPosixSupport.logException("inet_aton", e);
        }
    }

    @ExportMessage
    final Object inet_ntoa(int address, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("inet_ntoa", "%d", address);
        return LoggingPosixSupport.logExit("inet_ntoa", "%s", lib.inet_ntoa(this.delegate, address));
    }

    @ExportMessage
    final byte[] inet_pton(int family, Object src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
        LoggingPosixSupport.logEnter("inet_pton", "%d, %s", family, src);
        try {
            return LoggingPosixSupport.logExit("inet_pton", "%s", lib.inet_pton(this.delegate, family, src));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("inet_pton", e);
        }
        catch (PosixSupportLibrary.InvalidAddressException e) {
            throw LoggingPosixSupport.logException("inet_pton", e);
        }
    }

    @ExportMessage
    final Object inet_ntop(int family, byte[] src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("inet_ntop", "%d, %s", family, src);
        try {
            return LoggingPosixSupport.logExit("inet_ntop", "%s", lib.inet_ntop(this.delegate, family, src));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("inet_ntop", e);
        }
    }

    @ExportMessage
    final Object gethostname(@CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("gethostname", "", new Object[0]);
        try {
            return LoggingPosixSupport.logExit("gethostname", "%s", lib.gethostname(this.delegate));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("gethostname", e);
        }
    }

    @ExportMessage
    final Object[] getnameinfo(PosixSupportLibrary.UniversalSockAddr addr, int flags, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.GetAddrInfoException {
        LoggingPosixSupport.logEnter("getnameinfo", "%s, %d", addr, flags);
        try {
            return LoggingPosixSupport.logExit("getnameinfo", "%s", lib.getnameinfo(this.delegate, addr, flags));
        }
        catch (PosixSupportLibrary.GetAddrInfoException e) {
            throw LoggingPosixSupport.logException("getnameinfo", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object node, Object service, int family, int sockType, int protocol, int flags, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.GetAddrInfoException {
        LoggingPosixSupport.logEnter("getaddrinfo", "%s, %s, %d, %d, %d, %d", node, service, family, sockType, protocol, flags);
        try {
            return LoggingPosixSupport.logExit("getaddrinfo", "%s", lib.getaddrinfo(this.delegate, node, service, family, sockType, protocol, flags));
        }
        catch (PosixSupportLibrary.GetAddrInfoException e) {
            throw LoggingPosixSupport.logException("getaddrinfo", e);
        }
    }

    @ExportMessage
    final TruffleString crypt(TruffleString word, TruffleString salt, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("crypt", "%s, %s", word, salt);
        try {
            return LoggingPosixSupport.logExit("crypt", "%s", lib.crypt(this.delegate, word, salt));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("crypt", e);
        }
    }

    @ExportMessage
    final long semOpen(Object name, int openFlags, int mode, int value, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semOpen", "%s %d %d %d", name, openFlags, mode, value);
        try {
            return LoggingPosixSupport.logExit("semOpen", "0x%x", lib.semOpen(this.delegate, name, openFlags, mode, value));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semOpen", e);
        }
    }

    @ExportMessage
    final void semClose(long handle, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semClose", "0x%x", handle);
        try {
            lib.semClose(this.delegate, handle);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semClose", e);
        }
    }

    @ExportMessage
    final void semUnlink(Object name, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semUnlink", "%s", name);
        try {
            lib.semUnlink(this.delegate, name);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semUnlink", e);
        }
    }

    @ExportMessage
    final int semGetValue(long handle, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semGetValue", "0x%x", handle);
        try {
            return LoggingPosixSupport.logExit("semGetValue", "%d", lib.semGetValue(this.delegate, handle));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semGetValue", e);
        }
    }

    @ExportMessage
    final void semPost(long handle, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semPost", "0x%x", handle);
        try {
            lib.semPost(this.delegate, handle);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semPost", e);
        }
    }

    @ExportMessage
    final void semWait(long handle, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semWait", "0x%x", handle);
        try {
            lib.semWait(this.delegate, handle);
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semWait", e);
        }
    }

    @ExportMessage
    final boolean semTryWait(long handle, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semTryWait", "0x%x", handle);
        try {
            return LoggingPosixSupport.logExit("semTryWait", "%b", lib.semTryWait(this.delegate, handle));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semTryWait", e);
        }
    }

    @ExportMessage
    final boolean semTimedWait(long handle, long deadlineNs, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.PosixException {
        LoggingPosixSupport.logEnter("semTimedWait", "0x%x %d", handle, deadlineNs);
        try {
            return LoggingPosixSupport.logExit("semTimedWait", "%b", lib.semTimedWait(this.delegate, handle, deadlineNs));
        }
        catch (PosixSupportLibrary.PosixException e) {
            throw LoggingPosixSupport.logException("semTimedWait", e);
        }
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(PosixSupportLibrary.Inet4SockAddr src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("createUniversalSockAddrInet4", "%s", src);
        return LoggingPosixSupport.logExit("createUniversalSockAddrInet4", "%s", lib.createUniversalSockAddrInet4(this.delegate, src));
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(PosixSupportLibrary.Inet6SockAddr src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter("createUniversalSockAddrInet6", "%s", src);
        return LoggingPosixSupport.logExit("createUniversalSockAddrInet6", "%s", lib.createUniversalSockAddrInet6(this.delegate, src));
    }

    @ExportMessage
    final PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(PosixSupportLibrary.UnixSockAddr src, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) throws PosixSupportLibrary.InvalidUnixSocketPathException {
        LoggingPosixSupport.logEnter("createUniversalSockAddrUnix", "%s", src);
        try {
            return LoggingPosixSupport.logExit("createUniversalSockAddrUnix", "%s", lib.createUniversalSockAddrUnix(this.delegate, src));
        }
        catch (PosixSupportLibrary.InvalidUnixSocketPathException e) {
            throw LoggingPosixSupport.logException("createUniversalSockAddrUnix", e);
        }
    }

    @ExportMessage
    final Object createPathFromString(TruffleString path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter(Level.FINEST, "createPathFromString", "%s", path);
        return LoggingPosixSupport.logExit(Level.FINEST, "createPathFromString", "%s", lib.createPathFromString(this.delegate, path));
    }

    @ExportMessage
    final Object createPathFromBytes(byte[] path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter(Level.FINEST, "createPathFromBytes", "%s", new Object[]{path});
        return LoggingPosixSupport.logExit(Level.FINEST, "createPathFromBytes", "%s", lib.createPathFromBytes(this.delegate, path));
    }

    @ExportMessage
    final TruffleString getPathAsString(Object path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter(Level.FINEST, "getPathAsString", "%s", path);
        return LoggingPosixSupport.logExit(Level.FINEST, "getPathAsString", "%s", lib.getPathAsString(this.delegate, path));
    }

    @ExportMessage
    final PosixSupportLibrary.Buffer getPathAsBytes(Object path, @CachedLibrary(value="this.delegate") PosixSupportLibrary lib) {
        LoggingPosixSupport.logEnter(Level.FINEST, "getPathAsBytes", "%s", path);
        return LoggingPosixSupport.logExit(Level.FINEST, "getPathAsBytes", "%s", lib.getPathAsBytes(this.delegate, path));
    }

    @CompilerDirectives.TruffleBoundary
    private static void logEnter(Level level, String msg, String argFmt, Object ... args) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, msg + "(" + String.format(argFmt, LoggingPosixSupport.fixLogArgs(args)) + ")");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LoggingPosixSupport.logStackTrace(Level.FINEST, 0, 5);
            }
        }
    }

    private static void logEnter(String msg, String argFmt, Object ... args) {
        LoggingPosixSupport.logEnter(DEFAULT_LEVEL, msg, argFmt, args);
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T logExit(Level level, String msg, String argFmt, T retVal) {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, msg + " -> return " + String.format(argFmt, LoggingPosixSupport.fixLogArg(retVal)));
        }
        return retVal;
    }

    private static <T> T logExit(String msg, String argFmt, T retVal) {
        return LoggingPosixSupport.logExit(DEFAULT_LEVEL, msg, argFmt, retVal);
    }

    @CompilerDirectives.TruffleBoundary
    private static PosixSupportLibrary.PosixException logException(Level level, String msg, PosixSupportLibrary.PosixException e) throws PosixSupportLibrary.PosixException {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, msg + String.format(" -> throw errno=%d, msg=%s", LoggingPosixSupport.fixLogArgs(e.getErrorCode(), e.getMessage())));
        }
        throw e;
    }

    @CompilerDirectives.TruffleBoundary
    private static PosixSupportLibrary.GetAddrInfoException logException(Level level, String msg, PosixSupportLibrary.GetAddrInfoException e) throws PosixSupportLibrary.GetAddrInfoException {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, msg + String.format(" -> throw error code=%d, msg=%s", LoggingPosixSupport.fixLogArgs(e.getErrorCode(), e.getMessage())));
        }
        throw e;
    }

    @CompilerDirectives.TruffleBoundary
    private static PosixSupportLibrary.InvalidAddressException logException(Level level, String msg, PosixSupportLibrary.InvalidAddressException e) throws PosixSupportLibrary.InvalidAddressException {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, msg + " -> throw InvalidAddressException");
        }
        throw e;
    }

    @CompilerDirectives.TruffleBoundary
    private static PosixSupportLibrary.InvalidUnixSocketPathException logException(Level level, String msg, PosixSupportLibrary.InvalidUnixSocketPathException e) throws PosixSupportLibrary.InvalidUnixSocketPathException {
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, msg + " -> throw InvalidUnixSocketPathException");
        }
        throw e;
    }

    private static PosixSupportLibrary.PosixException logException(String msg, PosixSupportLibrary.PosixException e) throws PosixSupportLibrary.PosixException {
        throw LoggingPosixSupport.logException(DEFAULT_LEVEL, msg, e);
    }

    private static PosixSupportLibrary.GetAddrInfoException logException(String msg, PosixSupportLibrary.GetAddrInfoException e) throws PosixSupportLibrary.GetAddrInfoException {
        throw LoggingPosixSupport.logException(DEFAULT_LEVEL, msg, e);
    }

    private static PosixSupportLibrary.InvalidAddressException logException(String msg, PosixSupportLibrary.InvalidAddressException e) throws PosixSupportLibrary.InvalidAddressException {
        throw LoggingPosixSupport.logException(DEFAULT_LEVEL, msg, e);
    }

    private static PosixSupportLibrary.InvalidUnixSocketPathException logException(String msg, PosixSupportLibrary.InvalidUnixSocketPathException e) throws PosixSupportLibrary.InvalidUnixSocketPathException {
        throw LoggingPosixSupport.logException(DEFAULT_LEVEL, msg, e);
    }

    private static Object fixLogArg(Object arg) {
        if (arg instanceof String || arg instanceof TruffleString) {
            return "'" + String.valueOf(arg) + "'";
        }
        if (arg instanceof PosixSupportLibrary.Buffer) {
            PosixSupportLibrary.Buffer b = (PosixSupportLibrary.Buffer)arg;
            return "Buffer{" + LoggingPosixSupport.asString(b.data, 0, (int)b.length) + "}";
        }
        if (arg instanceof PosixSupportLibrary.Timeval) {
            PosixSupportLibrary.Timeval t = (PosixSupportLibrary.Timeval)arg;
            return "Timeval{" + t.getSeconds() + ", " + t.getMicroseconds() + "}";
        }
        if (arg instanceof byte[]) {
            byte[] bytes = (byte[])arg;
            return LoggingPosixSupport.asString(bytes, 0, bytes.length);
        }
        if (arg instanceof int[]) {
            return Arrays.toString((int[])arg);
        }
        if (arg instanceof long[]) {
            return Arrays.toString((long[])arg);
        }
        if (arg instanceof Object[]) {
            Object[] src = (Object[])arg;
            Object[] res = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                res[i] = LoggingPosixSupport.fixLogArg(src[i]);
            }
            return Arrays.toString(res);
        }
        return arg;
    }

    private static Object[] fixLogArgs(Object ... args) {
        Object[] fixed = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            fixed[i] = LoggingPosixSupport.fixLogArg(args[i]);
        }
        return fixed;
    }

    @CompilerDirectives.TruffleBoundary
    private static String asString(byte[] bytes, int offset, int length) {
        return "b'" + new String(bytes, offset, length) + "'";
    }

    @CompilerDirectives.TruffleBoundary
    private static void logStackTrace(Level level, int first, int depth) {
        ArrayList stack = new ArrayList();
        Truffle.getRuntime().iterateFrames(frameInstance -> {
            String str = LoggingPosixSupport.formatFrame(frameInstance);
            if (str != null) {
                stack.add(str);
            }
            return null;
        });
        int cnt = Math.min(stack.size(), depth);
        for (int i = first; i < cnt; ++i) {
            LOGGER.log(level, (String)stack.get(i));
        }
    }

    private static String formatFrame(FrameInstance frameInstance) {
        RootNode rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
        String rootName = rootNode.getQualifiedName();
        Node location = frameInstance.getCallNode();
        if (location == null) {
            location = rootNode;
        }
        SourceSection sourceSection = null;
        while (location != null && sourceSection == null) {
            sourceSection = location.getSourceSection();
            location = location.getParent();
        }
        if (rootName == null && sourceSection == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("    .");
        sb.append(rootName == null ? "???" : rootName);
        if (sourceSection != null) {
            sb.append(" (");
            sb.append(sourceSection.getSource().getName());
            sb.append(':');
            sb.append(sourceSection.getStartLine());
            sb.append(')');
        }
        return sb.toString();
    }
}

