/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.nodes.call.InvokeNode;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.TruffleWeakReference;

public final class IndirectCallData {
    private static final IndirectCallData UNCACHED = new IndirectCallData();
    private final TruffleWeakReference<Node> nodeRef;
    @CompilerDirectives.CompilationFinal
    private Assumption nativeCodeDoesntNeedExceptionState;
    @CompilerDirectives.CompilationFinal
    private Assumption nativeCodeDoesntNeedMyFrame;

    private IndirectCallData() {
        this.nodeRef = new TruffleWeakReference(null);
        this.nativeCodeDoesntNeedMyFrame = Assumption.ALWAYS_VALID;
        this.nativeCodeDoesntNeedExceptionState = Assumption.ALWAYS_VALID;
    }

    public IndirectCallData(Node node) {
        assert (node != null);
        this.nodeRef = new TruffleWeakReference((Object)node);
    }

    public boolean isUncached() {
        assert (this.nodeRef.get() == null == (this == UNCACHED));
        return this == UNCACHED;
    }

    public Node getNode() {
        assert (!this.isUncached());
        return (Node)this.nodeRef.get();
    }

    public boolean calleeNeedsCallerFrame() {
        return !this.needNotPassFrameAssumption().isValid();
    }

    public boolean calleeNeedsExceptionState() {
        return !this.needNotPassExceptionAssumption().isValid();
    }

    public void setCalleeNeedsCallerFrame() {
        this.needNotPassFrameAssumption().invalidate();
    }

    public void setCalleeNeedsExceptionState() {
        this.needNotPassExceptionAssumption().invalidate();
    }

    public static boolean setEncapsulatingNeedsToPassCallerFrame(Node callNode) {
        for (Node pythonCallNode = callNode; pythonCallNode != null; pythonCallNode = pythonCallNode.getParent()) {
            if (pythonCallNode instanceof InvokeNode) {
                return true;
            }
            IndirectCallData data = PythonLanguage.lookupIndirectCallData(pythonCallNode);
            if (data == null) continue;
            data.setCalleeNeedsCallerFrame();
            return true;
        }
        return false;
    }

    public static void setEncapsulatingNeedsToPassExceptionState(Node callNode) {
        for (Node pythonCallNode = callNode; pythonCallNode != null && !(pythonCallNode instanceof InvokeNode); pythonCallNode = pythonCallNode.getParent()) {
            IndirectCallData data = PythonLanguage.lookupIndirectCallData(pythonCallNode);
            if (data == null) continue;
            data.setCalleeNeedsExceptionState();
            break;
        }
    }

    private Assumption needNotPassFrameAssumption() {
        if (this.nativeCodeDoesntNeedMyFrame == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCodeDoesntNeedMyFrame = Truffle.getRuntime().createAssumption();
        }
        return this.nativeCodeDoesntNeedMyFrame;
    }

    private Assumption needNotPassExceptionAssumption() {
        if (this.nativeCodeDoesntNeedExceptionState == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeCodeDoesntNeedExceptionState = Truffle.getRuntime().createAssumption();
        }
        return this.nativeCodeDoesntNeedExceptionState;
    }

    @NeverDefault
    public static IndirectCallData createFor(Node node) {
        return PythonLanguage.createIndirectCallData(node);
    }

    @NeverDefault
    public static IndirectCallData getUncached() {
        return UNCACHED;
    }
}

