/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;

public abstract class GilNode
extends Node {
    @CompilerDirectives.TruffleBoundary
    private final void yieldGil() {
        this.release(true);
        Thread.yield();
        this.acquire();
    }

    public final boolean acquire() {
        return this.acquire(this);
    }

    public final boolean acquire(PythonContext context) {
        return this.acquire(context, this);
    }

    public abstract boolean acquire(Node var1);

    public abstract boolean acquire(PythonContext var1, Node var2);

    public abstract void release(boolean var1);

    public abstract void release(PythonContext var1, boolean var2);

    public abstract boolean tryRelease();

    @NeverDefault
    public static GilNode create() {
        return new Cached();
    }

    public static UncachedRelease uncachedRelease() {
        assert (PythonContext.get(UncachedRelease.INSTANCE).ownsGil());
        UncachedRelease.INSTANCE.release(true);
        return UncachedRelease.INSTANCE;
    }

    public static UncachedAcquire uncachedAcquire() {
        boolean wasAcquired = UncachedAcquire.INSTANCE_WITH_RELEASE.acquire();
        if (wasAcquired) {
            return UncachedAcquire.INSTANCE_WITH_RELEASE;
        }
        return UncachedAcquire.INSTANCE_WITHOUT_RELEASE;
    }

    public static GilNode getUncached() {
        return UncachedRelease.INSTANCE;
    }

    private static final class Cached
    extends GilNode {
        private final ConditionProfile binaryProfile = ConditionProfile.create();

        private Cached() {
        }

        public boolean isAdoptable() {
            return true;
        }

        @Override
        public void release(boolean wasAcquired) {
            this.release(PythonContext.get(this), wasAcquired);
        }

        @Override
        public boolean acquire(Node location) {
            return this.acquire(PythonContext.get(this), location);
        }

        @Override
        public void release(PythonContext context, boolean wasAcquired) {
            if (this.binaryProfile.profile(wasAcquired)) {
                context.releaseGil();
            }
        }

        @Override
        public boolean acquire(PythonContext context, Node location) {
            if (this.binaryProfile.profile(!context.ownsGil())) {
                TruffleSafepoint.setBlockedThreadInterruptible((Node)location, PythonContext::acquireGil, (Object)context);
                return true;
            }
            return false;
        }

        @Override
        public final boolean tryRelease() {
            PythonContext context = PythonContext.get(this);
            if (this.binaryProfile.profile(context.ownsGil())) {
                context.releaseGil();
                return true;
            }
            return false;
        }
    }

    public static final class UncachedRelease
    extends Uncached {
        private static final UncachedRelease INSTANCE = new UncachedRelease();

        private UncachedRelease() {
        }

        @Override
        public final void close() {
            this.acquire();
        }
    }

    public static final class UncachedAcquire
    extends Uncached {
        private static final UncachedAcquire INSTANCE_WITH_RELEASE = new UncachedAcquire();
        private static final UncachedAcquire INSTANCE_WITHOUT_RELEASE = new UncachedAcquire();

        private UncachedAcquire() {
        }

        @Override
        public final void close() {
            if (PythonContext.get(this).ownsGil()) {
                this.release(this == INSTANCE_WITH_RELEASE);
            }
        }
    }

    private static abstract class Uncached
    extends GilNode
    implements AutoCloseable {
        private Uncached() {
        }

        public boolean isAdoptable() {
            return false;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final boolean acquire(Node location) {
            return this.acquire(PythonContext.get(this), location);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final void release(boolean wasAcquired) {
            this.release(PythonContext.get(this), wasAcquired);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final boolean acquire(PythonContext context, Node location) {
            if (!context.ownsGil()) {
                if (!context.tryAcquireGil()) {
                    TruffleSafepoint.setBlockedThreadInterruptible((Node)location, PythonContext::acquireGil, (Object)context);
                }
                return true;
            }
            return false;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final void release(PythonContext context, boolean wasAcquired) {
            if (wasAcquired) {
                context.releaseGil();
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final boolean tryRelease() {
            PythonContext context = PythonContext.get(this);
            if (context.ownsGil()) {
                context.releaseGil();
                return true;
            }
            return false;
        }

        @Override
        public abstract void close();
    }
}

