/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.expression.BinaryOp;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.object.IsNodeGen;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@GenerateUncached
public abstract class IsNode
extends Node
implements BinaryOp {
    protected abstract boolean executeInternal(Object var1, Object var2);

    protected abstract boolean executeInternal(boolean var1, Object var2);

    @Override
    public final Object executeObject(VirtualFrame frame, Object left, Object right) {
        return this.execute(left, right);
    }

    public final boolean execute(Object left, Object right) {
        return left == right || this.executeInternal(left, right);
    }

    public boolean isTrue(Object object) {
        return this.executeInternal(true, object);
    }

    public boolean isFalse(Object object) {
        return this.executeInternal(false, object);
    }

    @Specialization
    static boolean doBB(boolean left, boolean right) {
        return left == right;
    }

    @Specialization
    boolean doBP(boolean left, PInt right) {
        PythonContext core = PythonContext.get(this);
        if (left) {
            return right == core.getTrue();
        }
        return right == core.getFalse();
    }

    @Specialization
    static boolean doII(int left, int right) {
        return left == right;
    }

    @Specialization
    static boolean doIL(int left, long right) {
        return (long)left == right;
    }

    @Specialization
    static boolean doIP(int left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, right)) {
            try {
                return right.intValueExact() == left;
            }
            catch (OverflowException e) {
                return false;
            }
        }
        return false;
    }

    @Specialization
    static boolean doLI(long left, int right) {
        return left == (long)right;
    }

    @Specialization
    static boolean doLL(long left, long right) {
        return left == right;
    }

    @Specialization
    static boolean doLP(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        if (isBuiltin.profileIsAnyBuiltinObject(inliningTarget, right)) {
            try {
                return left == right.longValueExact();
            }
            catch (OverflowException e) {
                return false;
            }
        }
        return false;
    }

    @Specialization
    static boolean doDD(double left, double right) {
        return left == right || Double.isNaN(left) && Double.isNaN(right);
    }

    @Specialization
    boolean doPB(PInt left, boolean right) {
        return this.doBP(right, left);
    }

    @Specialization
    static boolean doPI(PInt left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        return IsNode.doIP(right, left, inliningTarget, isBuiltin);
    }

    @Specialization
    static boolean doPL(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isBuiltin") @Cached BuiltinClassProfiles.IsAnyBuiltinObjectProfile isBuiltin) {
        return IsNode.doLP(right, left, inliningTarget, isBuiltin);
    }

    @Specialization
    static boolean doCT(PythonBuiltinClass left, PythonBuiltinClassType right) {
        return left.getType() == right;
    }

    @Specialization
    static boolean doTC(PythonBuiltinClassType left, PythonBuiltinClass right) {
        return right.getType() == left;
    }

    @Specialization
    static boolean doNative(PythonAbstractNativeObject left, PythonAbstractNativeObject right, @Cached CExtNodes.PointerCompareNode isNode) {
        return isNode.execute(SpecialMethodNames.T___EQ__, left, right);
    }

    @Specialization
    static boolean doCode(PCode left, PCode right, @Bind(value="this") Node inliningTarget, @Cached CodeNodes.GetCodeCallTargetNode getCt) {
        if (left != right) {
            RootCallTarget leftCt = getCt.execute(inliningTarget, left);
            RootCallTarget rightCt = getCt.execute(inliningTarget, right);
            if (leftCt != null && rightCt != null) {
                RootNode leftRootNode = leftCt.getRootNode();
                RootNode rightRootNode = rightCt.getRootNode();
                if (leftRootNode instanceof PBytecodeGeneratorFunctionRootNode) {
                    leftRootNode = ((PBytecodeGeneratorFunctionRootNode)leftRootNode).getBytecodeRootNode();
                }
                if (rightRootNode instanceof PBytecodeGeneratorFunctionRootNode) {
                    rightRootNode = ((PBytecodeGeneratorFunctionRootNode)rightRootNode).getBytecodeRootNode();
                }
                if (leftRootNode instanceof PBytecodeRootNode && rightRootNode instanceof PBytecodeRootNode) {
                    return ((PBytecodeRootNode)leftRootNode).getCodeUnit() == ((PBytecodeRootNode)rightRootNode).getCodeUnit();
                }
                return leftRootNode == rightRootNode;
            }
            return false;
        }
        return true;
    }

    @Specialization
    static boolean doObjectPNone(Object left, PNone right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObjectNode, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        if (left == right) {
            return true;
        }
        if (isForeignObjectNode.execute(inliningTarget, left)) {
            return lib.isNull(left);
        }
        return false;
    }

    @Specialization
    static boolean doPNoneObject(PNone left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObjectNode, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        return IsNode.doObjectPNone(right, left, inliningTarget, isForeignObjectNode, lib);
    }

    @Specialization
    static boolean doPString(PString left, PString right, @Bind(value="this") Node inliningTarget, @Cached StringNodes.StringMaterializeNode materializeNode, @Cached StringNodes.IsInternedStringNode isInternedStringNode, @Cached TruffleString.EqualNode equalNode) {
        if (isInternedStringNode.execute(inliningTarget, left) && isInternedStringNode.execute(inliningTarget, right)) {
            return equalNode.execute((AbstractTruffleString)materializeNode.execute(inliningTarget, left), (AbstractTruffleString)materializeNode.execute(inliningTarget, right), PythonUtils.TS_ENCODING);
        }
        return left == right;
    }

    @Fallback
    static boolean doOther(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached IsForeignObjectNode isForeignObjectNode, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
        if (left == right) {
            return true;
        }
        if (isForeignObjectNode.execute(inliningTarget, left)) {
            return lib.isIdentical(left, right, lib);
        }
        return false;
    }

    @NeverDefault
    public static IsNode create() {
        return IsNodeGen.create();
    }

    public static IsNode getUncached() {
        return IsNodeGen.getUncached();
    }
}

