/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.interop;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.PolyglotModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.interop.GetInteropBehaviorNodeGen;
import com.oracle.graal.python.nodes.interop.InteropBehavior;
import com.oracle.graal.python.nodes.interop.InteropBehaviorMethod;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;

@GenerateUncached
@GenerateInline
public abstract class GetInteropBehaviorNode
extends PNodeWithContext {
    public abstract InteropBehavior execute(Node var1, PythonAbstractObject var2, InteropBehaviorMethod var3);

    @Specialization
    static InteropBehavior getInteropBehavior(Node inliningTarget, PythonAbstractObject receiver, InteropBehaviorMethod method, @Cached GetClassNode getClassNode, @CachedLibrary(limit="1") DynamicObjectLibrary dylib) {
        InteropBehavior behavior;
        Object value;
        Object klass = getClassNode.execute(inliningTarget, receiver);
        if (klass instanceof PythonBuiltinClassType) {
            PythonBuiltinClassType pythonBuiltinClassType = (PythonBuiltinClassType)((Object)klass);
            klass = PythonContext.get(getClassNode).lookupType(pythonBuiltinClassType);
        }
        if ((value = dylib.getOrDefault((DynamicObject)klass, (Object)PolyglotModuleBuiltins.RegisterInteropBehaviorNode.HOST_INTEROP_BEHAVIOR, null)) instanceof InteropBehavior && (behavior = (InteropBehavior)value).isDefined(method)) {
            return behavior;
        }
        return null;
    }

    @NeverDefault
    public static GetInteropBehaviorNode create() {
        return GetInteropBehaviorNodeGen.create();
    }

    public static GetInteropBehaviorNode getUncached() {
        return GetInteropBehaviorNodeGen.getUncached();
    }
}

