/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.classes;

import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.classes.AbstractObjectGetBasesNode;
import com.oracle.graal.python.nodes.classes.AbstractObjectIsSubclassNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;

@NodeInfo(shortName="cpython://Objects/abstract.c/abstract_issubclass")
@GenerateUncached
@ImportStatic(value={PythonOptions.class})
public abstract class AbstractObjectIsSubclassNode
extends PNodeWithContext {
    static final int MAX_RECURSION = 3;

    @NeverDefault
    public static AbstractObjectIsSubclassNode create() {
        return AbstractObjectIsSubclassNodeGen.create();
    }

    protected abstract boolean executeInternal(Frame var1, Object var2, Object var3, int var4);

    public final boolean execute(VirtualFrame frame, Object derived, Object cls) {
        return this.executeInternal((Frame)frame, derived, cls, 0);
    }

    public final boolean execute(Object derived, Object cls) {
        return this.execute(null, derived, cls);
    }

    @Specialization(guards={"isSameMetaObject(inliningTarget, isSameTypeNode, derived, cls)"})
    static boolean doSameClass(Object derived, Object cls, int depth, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameTypeNode) {
        return true;
    }

    protected static int[] observedSize() {
        int[] ary = new int[]{0};
        return ary;
    }

    @Specialization(guards={"depth < MAX_RECURSION", "!isSameMetaObject(inliningTarget, isSameTypeNode, derived, cls)", "derived == cachedDerived", "cls == cachedCls"}, limit="getCallSiteInlineCacheMaxDepth()")
    static boolean doSubclass(VirtualFrame frame, Object derived, Object cls, int depth, @Bind(value="this") Node inliningTarget, @Cached(value="observedSize()", dimensions=1) int[] observedSizeArray, @Cached(value="derived") Object cachedDerived, @Cached(value="cls") Object cachedCls, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Shared @Cached AbstractObjectGetBasesNode getBasesNode, @Cached AbstractObjectIsSubclassNode isSubclassNode, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
        CompilerAsserts.partialEvaluationConstant((int)depth);
        PTuple bases = getBasesNode.execute(frame, cachedDerived);
        if (bases == null || AbstractObjectIsSubclassNode.isEmpty(bases)) {
            return false;
        }
        Object[] basesAry = getObjectArrayNode.execute(inliningTarget, bases);
        if (observedSizeArray[0] == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            observedSizeArray[0] = basesAry.length;
        }
        if (observedSizeArray[0] > 0 && observedSizeArray[0] < 32 >> depth && observedSizeArray[0] == basesAry.length) {
            return AbstractObjectIsSubclassNode.loopBases(frame, cachedCls, basesAry, isSubclassNode, depth);
        }
        if (observedSizeArray[0] > 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            observedSizeArray[0] = -1;
        }
        return AbstractObjectIsSubclassNode.loopUnexploded(frame, cachedCls, isSubclassNode, basesAry, depth);
    }

    private static boolean loopUnexploded(VirtualFrame frame, Object cachedCls, AbstractObjectIsSubclassNode isSubclassNode, Object[] basesAry, int depth) {
        for (Object baseCls : basesAry) {
            if (!isSubclassNode.executeInternal((Frame)frame, baseCls, cachedCls, depth + 1)) continue;
            return true;
        }
        return false;
    }

    @ExplodeLoop
    private static boolean loopBases(VirtualFrame frame, Object cachedCls, Object[] bases, AbstractObjectIsSubclassNode isSubclassNode, int depth) {
        for (int i = 0; i < bases.length; ++i) {
            if (!isSubclassNode.executeInternal((Frame)frame, bases[i], cachedCls, depth + 1)) continue;
            return true;
        }
        return false;
    }

    @Specialization(replaces={"doSubclass", "doSameClass"})
    static boolean doGeneric(VirtualFrame frame, Object derived, Object cls, int depth, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached AbstractObjectGetBasesNode getBasesNode, @Cached(value="createRecursive(depth)") AbstractObjectIsSubclassNode isSubclassNode, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Shared @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode) {
        CompilerAsserts.partialEvaluationConstant((int)depth);
        if (AbstractObjectIsSubclassNode.isSameMetaObject(inliningTarget, isSameTypeNode, derived, cls)) {
            return true;
        }
        PTuple bases = getBasesNode.execute(frame, derived);
        if (bases == null || AbstractObjectIsSubclassNode.isEmpty(bases)) {
            return false;
        }
        for (Object baseCls : getObjectArrayNode.execute(inliningTarget, bases)) {
            if (!isSubclassNode.executeInternal((Frame)frame, baseCls, cls, depth + 1)) continue;
            return true;
        }
        return false;
    }

    @NeverDefault
    protected AbstractObjectIsSubclassNode createRecursive(int depth) {
        if (depth >= 3) {
            return AbstractObjectIsSubclassNodeGen.getUncached();
        }
        return AbstractObjectIsSubclassNodeGen.create();
    }

    private static boolean isEmpty(PTuple bases) {
        return bases.getSequenceStorage().length() == 0;
    }

    static boolean isSameMetaObject(Node inliningTarget, TypeNodes.IsSameTypeNode isSameTypeNode, Object derived, Object cls) {
        return derived == cls || isSameTypeNode.execute(inliningTarget, derived, cls);
    }
}

