/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.builtins;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.builtins.TupleNodesFactory;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public abstract class TupleNodes {

    @GenerateInline(value=false)
    public static abstract class GetNativeTupleStorage
    extends Node {
        public abstract NativeObjectSequenceStorage execute(PythonAbstractNativeObject var1);

        @Specialization
        NativeObjectSequenceStorage getNative(PythonAbstractNativeObject tuple, @Cached CStructAccess.ReadPointerNode getContents, @Cached CStructAccess.ReadI64Node readI64Node) {
            assert (PyTupleCheckNode.executeUncached(tuple));
            Object array = getContents.readFromObj(tuple, CFields.PyTupleObject__ob_item);
            int size = (int)readI64Node.readFromObj(tuple, CFields.PyVarObject__ob_size);
            return NativeObjectSequenceStorage.create(array, size, size, false);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetTupleStorage
    extends Node {
        public abstract SequenceStorage execute(Node var1, Object var2);

        @Specialization
        SequenceStorage getManaged(PTuple tuple) {
            return tuple.getSequenceStorage();
        }

        @Specialization
        SequenceStorage getNative(PythonAbstractNativeObject tuple, @Cached(inline=false) GetNativeTupleStorage getNativeTupleStorage) {
            return getNativeTupleStorage.execute(tuple);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class ConstructTupleNode
    extends PNodeWithContext {
        public final PTuple execute(VirtualFrame frame, Object value) {
            return this.execute((Frame)frame, (Object)PythonBuiltinClassType.PTuple, value);
        }

        public abstract PTuple execute(Frame var1, Object var2, Object var3);

        @Specialization(guards={"isNoValue(none)"})
        static PTuple tuple(Object cls, PNone none, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createEmptyTuple(cls);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static PTuple tuple(Object cls, TruffleString arg, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            return factory.createTuple(cls, StringUtils.toCharacterArray(arg, codePointLengthNode, createCodePointIteratorNode, nextNode, fromCodePointNode));
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static PTuple tuple(Object cls, PString arg, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached CastToTruffleStringNode castToStringNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached.Shared @Cached TruffleStringIterator.NextNode nextNode, @Cached.Shared @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            return ConstructTupleNode.tuple(cls, castToStringNode.execute(inliningTarget, arg), factory, codePointLengthNode, createCodePointIteratorNode, nextNode, fromCodePointNode);
        }

        @Specialization(guards={"cannotBeOverridden(cls)", "cannotBeOverridden(iterable, this, getClassNode)"}, limit="1")
        static PTuple tuple(Object cls, PTuple iterable, @Cached.Exclusive @Cached GetClassNode getClassNode) {
            return iterable;
        }

        @Specialization(guards={"!isNoValue(iterable)", "createNewTuple(this, cls, iterable, getClassNode)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static PTuple tuple(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory, @Cached SequenceStorageNodes.CreateStorageFromIteratorNode storageNode, @Cached PyObjectGetIter getIter) {
            Object iterObj = getIter.execute((Frame)frame, inliningTarget, iterable);
            return factory.createTuple(cls, storageNode.execute(frame, iterObj));
        }

        @Fallback
        static PTuple tuple(Object cls, Object value) {
            CompilerDirectives.transferToInterpreter();
            throw new RuntimeException("tuple does not support iterable object " + String.valueOf(value));
        }

        protected boolean createNewTuple(Node inliningTarget, Object cls, Object iterable, GetClassNode getClassNode) {
            if (iterable instanceof PTuple) {
                return !PGuards.cannotBeOverridden(cls) || !PGuards.cannotBeOverridden(getClassNode.execute(inliningTarget, iterable));
            }
            return true;
        }

        @NeverDefault
        public static ConstructTupleNode create() {
            return TupleNodesFactory.ConstructTupleNodeGen.create();
        }

        public static ConstructTupleNode getUncached() {
            return TupleNodesFactory.ConstructTupleNodeGen.getUncached();
        }
    }
}

