/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@ImportStatic(value={PGuards.class, SpecialMethodSlot.class, ExternalFunctionNodes.PExternalFunctionWrapper.class})
@GenerateInline(value=false)
public abstract class PySequenceGetItemNode
extends Node {
    public abstract Object execute(Frame var1, Object var2, int var3);

    @Specialization(guards={"!isNativeObject(object)"})
    static Object doGenericManaged(VirtualFrame frame, Object object, int index, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PySequenceCheckNode sequenceCheckNode, @Cached PyMappingCheckNode mappingCheckNode, @Cached(parameters={"GetItem"}) LookupSpecialMethodSlotNode lookupGetItem, @Cached CallBinaryMethodNode callGetItem, @Cached PRaiseNode.Lazy raise) {
        if (sequenceCheckNode.execute(inliningTarget, object)) {
            Object type = getClassNode.execute(inliningTarget, object);
            Object getItem = lookupGetItem.execute((Frame)frame, type, object);
            assert (getItem != PNone.NO_VALUE);
            return callGetItem.executeObject((Frame)frame, getItem, object, index);
        }
        if (mappingCheckNode.execute(inliningTarget, object)) {
            throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_SEQUENCE, object);
        }
        throw raise.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_INDEXING, object);
    }

    @Specialization
    static Object doNative(VirtualFrame frame, PythonAbstractNativeObject object, int index, @Bind(value="this") Node inliningTarget, @Cached CApiTransitions.PythonToNativeNode toNativeNode, @Cached CExtCommonNodes.ImportCExtSymbolNode importCExtSymbolNode, @Cached(parameters={"GETITEM"}) ExternalFunctionNodes.ExternalFunctionInvokeNode invokeNode2) {
        NativeCAPISymbol symbol = NativeCAPISymbol.FUN_PY_TRUFFLE_PY_SEQUENCE_GET_ITEM;
        Object executable = importCExtSymbolNode.execute(inliningTarget, PythonContext.get(inliningTarget).getCApiContext(), symbol);
        return invokeNode2.execute(frame, symbol.getTsName(), executable, new Object[]{toNativeNode.execute(object), index});
    }
}

