/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.str;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.IndexConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.SliceIndexConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterWithDefaultValueNode;

public class StringBuiltinsClinicProviders {

    public static final class SplitNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final SplitNodeClinicProviderGen INSTANCE = new SplitNodeClinicProviderGen();

        private SplitNodeClinicProviderGen() {
            super(0, 4, 0, 0, 7);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return TruffleStringConverterNode.create("split");
                }
                case 1: {
                    return TruffleStringConverterWithDefaultValueNode.create("split", PNone.NONE, true);
                }
                case 2: {
                    return IndexConversionNode.create(-1, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RFindNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RFindNodeClinicProviderGen INSTANCE = new RFindNodeClinicProviderGen();

        private RFindNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class CountNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final CountNodeClinicProviderGen INSTANCE = new CountNodeClinicProviderGen();

        private CountNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class EncodeNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final EncodeNodeClinicProviderGen INSTANCE = new EncodeNodeClinicProviderGen();

        private EncodeNodeClinicProviderGen() {
            super(1, 1, 1, 1, 6);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 1: {
                    return TruffleStringConverterWithDefaultValueNode.create("encode", StringLiterals.T_UTF8, true);
                }
                case 2: {
                    return TruffleStringConverterWithDefaultValueNode.create("encode", StringLiterals.T_STRICT, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class FindNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FindNodeClinicProviderGen INSTANCE = new FindNodeClinicProviderGen();

        private FindNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class FormatNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FormatNodeClinicProviderGen INSTANCE = new FormatNodeClinicProviderGen();

        private FormatNodeClinicProviderGen() {
            super(1, 1, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return TruffleStringConverterNode.create("__format__");
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class EndsWithNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final EndsWithNodeClinicProviderGen INSTANCE = new EndsWithNodeClinicProviderGen();

        private EndsWithNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class IndexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final IndexNodeClinicProviderGen INSTANCE = new IndexNodeClinicProviderGen();

        private IndexNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RIndexNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RIndexNodeClinicProviderGen INSTANCE = new RIndexNodeClinicProviderGen();

        private RIndexNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class ExpandTabsNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ExpandTabsNodeClinicProviderGen INSTANCE = new ExpandTabsNodeClinicProviderGen();

        private ExpandTabsNodeClinicProviderGen() {
            super(0, 2, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return TruffleStringConverterNode.create("expandtabs");
                }
                case 1: {
                    return JavaIntConversionNode.create(8, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RSplitNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RSplitNodeClinicProviderGen INSTANCE = new RSplitNodeClinicProviderGen();

        private RSplitNodeClinicProviderGen() {
            super(0, 4, 0, 0, 7);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return TruffleStringConverterNode.create("rsplit");
                }
                case 1: {
                    return TruffleStringConverterWithDefaultValueNode.create("rsplit", PNone.NONE, true);
                }
                case 2: {
                    return IndexConversionNode.create(-1, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RemoveSuffixNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RemoveSuffixNodeClinicProviderGen INSTANCE = new RemoveSuffixNodeClinicProviderGen();

        private RemoveSuffixNodeClinicProviderGen() {
            super(0, 0, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return TruffleStringConverterNode.create("removesuffix");
                }
                case 1: {
                    return TruffleStringConverterNode.create("removesuffix");
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class FormatMapNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final FormatMapNodeClinicProviderGen INSTANCE = new FormatMapNodeClinicProviderGen();

        private FormatMapNodeClinicProviderGen() {
            super(2, 2, 2, 2, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return TruffleStringConverterNode.create("format_map");
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class TitleNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final TitleNodeClinicProviderGen INSTANCE = new TitleNodeClinicProviderGen();

        private TitleNodeClinicProviderGen() {
            super(0, 0, 0, 0, 1);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 0) {
                return TruffleStringConverterNode.create("title");
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class StartsWithNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final StartsWithNodeClinicProviderGen INSTANCE = new StartsWithNodeClinicProviderGen();

        private StartsWithNodeClinicProviderGen() {
            super(3, 15, 3, 3, 12);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return SliceIndexConversionNode.create(0, true);
                }
                case 3: {
                    return SliceIndexConversionNode.create(Integer.MAX_VALUE, true);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class RemovePrefixNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final RemovePrefixNodeClinicProviderGen INSTANCE = new RemovePrefixNodeClinicProviderGen();

        private RemovePrefixNodeClinicProviderGen() {
            super(0, 0, 0, 0, 3);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 0: {
                    return TruffleStringConverterNode.create("removeprefix");
                }
                case 1: {
                    return TruffleStringConverterNode.create("removeprefix");
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }
}

