/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.socket;

import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.socket.PSocket;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.graal.python.util.TimeUtils;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;

public class SocketUtils {
    public static <T> T callSocketFunctionWithRetry(Frame frame, Node inliningTarget, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PosixSupportLibrary posixLib, Object posixSupport, GilNode gil, PSocket socket, SocketFunction<T> function, boolean writing, boolean connect) throws PosixSupportLibrary.PosixException {
        return SocketUtils.callSocketFunctionWithRetry(frame, inliningTarget, constructAndRaiseNode, posixLib, posixSupport, gil, socket, function, writing, connect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T callSocketFunctionWithRetry(Frame frame, Node inliningTarget, PConstructAndRaiseNode.Lazy constructAndRaiseNode, PosixSupportLibrary posixLib, Object posixSupport, GilNode gil, PSocket socket, SocketFunction<T> function, boolean writing, boolean connect, TimeoutHelper timeoutHelperIn) throws PosixSupportLibrary.PosixException {
        TimeoutHelper timeoutHelper = timeoutHelperIn;
        if (timeoutHelper == null && socket.getTimeoutNs() > 0L) {
            timeoutHelper = new TimeoutHelper(socket.getTimeoutNs());
        }
        block10: while (true) {
            PosixSupportLibrary.Timeval selectTimeout = null;
            if (timeoutHelper != null) {
                selectTimeout = timeoutHelper.checkAndGetRemainingTimeval(frame, inliningTarget, constructAndRaiseNode);
            }
            if ((timeoutHelper != null || connect) && socket.getFd() != -1) {
                try {
                    gil.release(true);
                    try {
                        int[] fds = new int[]{socket.getFd()};
                        int[] readfds = writing ? PythonUtils.EMPTY_INT_ARRAY : fds;
                        int[] writefds = writing ? fds : PythonUtils.EMPTY_INT_ARRAY;
                        PosixSupportLibrary.SelectResult selectResult = posixLib.select(posixSupport, readfds, writefds, PythonUtils.EMPTY_INT_ARRAY, selectTimeout);
                        boolean[] resultFds = writing ? selectResult.getWriteFds() : selectResult.getReadFds();
                        if (resultFds.length == 0) throw constructAndRaiseNode.get(inliningTarget).raiseTimeoutError(frame, ErrorMessages.TIMED_OUT);
                        if (!resultFds[0]) {
                            throw constructAndRaiseNode.get(inliningTarget).raiseTimeoutError(frame, ErrorMessages.TIMED_OUT);
                        }
                    }
                    finally {
                        gil.acquire();
                    }
                }
                catch (PosixSupportLibrary.PosixException e) {
                    if (e.getErrorCode() != OSErrorEnum.EINTR.getNumber()) throw e;
                    PythonContext.triggerAsyncActions(constructAndRaiseNode);
                    continue;
                }
            }
            while (true) {
                try {
                    gil.release(true);
                    try {
                        T e = function.run(posixLib, posixSupport);
                        return e;
                    }
                    finally {
                        gil.acquire();
                    }
                }
                catch (PosixSupportLibrary.PosixException e2) {
                    if (e2.getErrorCode() == OSErrorEnum.EINTR.getNumber()) {
                        PythonContext.triggerAsyncActions(constructAndRaiseNode);
                        continue;
                    }
                    if (timeoutHelper == null) throw e2;
                    if (e2.getErrorCode() == OSErrorEnum.EWOULDBLOCK.getNumber()) continue block10;
                    if (e2.getErrorCode() != OSErrorEnum.EAGAIN.getNumber()) throw e2;
                    continue block10;
                }
                break;
            }
            break;
        }
    }

    @FunctionalInterface
    public static interface SocketFunction<T> {
        public T run(PosixSupportLibrary var1, Object var2) throws PosixSupportLibrary.PosixException;
    }

    public static class TimeoutHelper {
        long startNano;
        long initialTimeoutNs;

        public TimeoutHelper(long initialTimeoutNs) {
            this.initialTimeoutNs = initialTimeoutNs;
        }

        public long checkAndGetRemainingTimeoutNs(Frame frame, Node inliningTaget, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            if (this.startNano == 0L) {
                this.startNano = System.nanoTime();
                return this.initialTimeoutNs;
            }
            long remainingNs = this.initialTimeoutNs - (System.nanoTime() - this.startNano);
            if (remainingNs <= 0L) {
                throw constructAndRaiseNode.get(inliningTaget).raiseTimeoutError(frame, ErrorMessages.TIMED_OUT);
            }
            return remainingNs;
        }

        public PosixSupportLibrary.Timeval checkAndGetRemainingTimeval(Frame frame, Node inliningTarget, PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            return TimeUtils.pyTimeAsTimeval(this.checkAndGetRemainingTimeoutNs(frame, inliningTarget, constructAndRaiseNode));
        }
    }
}

