/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.set;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSet})
public final class SetBuiltins
extends PythonBuiltins {
    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialMethodNames.T___HASH__, (Object)PNone.NONE);
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SetBuiltinsFactory.getFactories();
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class PopNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object remove(VirtualFrame frame, PSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageGetIterator getIter, @Cached HashingStorageNodes.HashingStorageIteratorNext iterNext, @Cached HashingStorageNodes.HashingStorageIteratorKey iterKey, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached PRaiseNode.Lazy raiseNode) {
            HashingStorageNodes.HashingStorageIterator it;
            HashingStorage storage = self.getDictStorage();
            if (iterNext.execute(inliningTarget, storage, it = getIter.execute(inliningTarget, storage))) {
                Object key = iterKey.execute(inliningTarget, storage, it);
                delItem.execute((Frame)frame, inliningTarget, storage, key, self);
                return key;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, ErrorMessages.POP_FROM_EMPTY_SET);
        }
    }

    @Builtin(name="discard", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DiscardNode
    extends PythonBinaryBuiltinNode {
        DiscardNode() {
        }

        @Specialization
        static Object discard(VirtualFrame frame, PSet self, Object key, @Cached SetNodes.DiscardNode discardNode) {
            discardNode.execute(frame, self, key);
            return PNone.NONE;
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RemoveNode
    extends PythonBinaryBuiltinNode {
        RemoveNode() {
        }

        @Specialization
        static Object remove(VirtualFrame frame, PSet self, Object key, @Bind(value="this") Node inliningTarget, @Cached SetNodes.DiscardNode discardNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!discardNode.execute(frame, self, key)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.KeyError, new Object[]{key});
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="difference_update", minNumOfPositionalArgs=1, takesVarArgs=true, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class DifferenceUpdateNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PNone doNone(VirtualFrame frame, PSet self, PNone other) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PNone doCached(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage result = self.getDictStorage();
            for (int i = 0; i < len; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getHashingStorage.execute(frame, inliningTarget, args[i]));
            }
            self.setDictStorage(result);
            return PNone.NONE;
        }

        @Specialization(replaces={"doCached"})
        static PNone doSet(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage result = self.getDictStorage();
            for (Object o : args) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getHashingStorage.execute(frame, inliningTarget, o));
            }
            self.setDictStorage(result);
            return PNone.NONE;
        }

        @Specialization
        static PNone doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage result = diffNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorage.execute(frame, inliningTarget, other));
            self.setDictStorage(result);
            return PNone.NONE;
        }
    }

    @Builtin(name="difference", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class DifferenceNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PSet doSet(VirtualFrame frame, PSet self, PNone other, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createSet(self.getDictStorage());
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getHashingStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return factory.createSet(result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = diffNode.execute((Frame)frame, inliningTarget, result, getHashingStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return factory.createSet(result);
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PSet doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageDiff diffNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = diffNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorageNode.execute(frame, inliningTarget, other));
            return factory.createSet(result);
        }
    }

    @Builtin(name="__isub__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ISubNode
    extends PythonBinaryBuiltinNode {
        ISubNode() {
        }

        @Specialization(guards={"canDoSetBinOp(right)"})
        static PBaseSet doPBaseSet(VirtualFrame frame, PSet left, Object right, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageDiff diffNode) {
            HashingStorage storage = diffNode.execute((Frame)frame, inliningTarget, left.getDictStorage(), getHashingStorageNode.execute(frame, inliningTarget, right));
            left.setDictStorage(storage);
            return left;
        }

        @Fallback
        Object doSub(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="symmetric_difference_update", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class SymmetricDifferenceUpdateNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PNone doSet(VirtualFrame frame, PSet self, PNone other) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PNone doCached(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            HashingStorage result = self.getDictStorage();
            for (int i = 0; i < len; ++i) {
                result = xorNode.execute((Frame)frame, inliningTarget, result, getHashingStorage.execute(frame, inliningTarget, args[i]));
            }
            self.setDictStorage(result);
            return PNone.NONE;
        }

        @Specialization(replaces={"doCached"})
        static PNone doSetArgs(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            HashingStorage result = self.getDictStorage();
            for (Object o : args) {
                result = xorNode.execute((Frame)frame, inliningTarget, result, getHashingStorage.execute(frame, inliningTarget, o));
            }
            self.setDictStorage(result);
            return PNone.NONE;
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PNone doSetOther(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached.Shared @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            HashingStorage result = xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorage.execute(frame, inliningTarget, other));
            self.setDictStorage(result);
            return PNone.NONE;
        }
    }

    @Builtin(name="symmetric_difference", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SymmetricDifferenceNode
    extends PythonBuiltinNode {
        @Specialization
        static PSet doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached HashingStorageNodes.HashingStorageXor xorNode, @Cached PythonObjectFactory factory) {
            HashingStorage result = xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorage.execute(frame, inliningTarget, other));
            return factory.createSet(result);
        }
    }

    @Builtin(name="__ixor__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IXorNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"canDoSetBinOp(other)"})
        static Object doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageXor xorNode) {
            self.setDictStorage(xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorageNode.execute(frame, inliningTarget, other)));
            return self;
        }

        @Fallback
        Object doOr(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__xor__", minNumOfPositionalArgs=2), @Builtin(name="__rxor__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class XorNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"canDoSetBinOp(other)"})
        static Object doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageXor xorNode, @Cached PythonObjectFactory factory) {
            return factory.createSet(xorNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), getHashingStorageNode.execute(frame, inliningTarget, other)));
        }

        @Fallback
        Object doOr(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="intersection_update", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class IntersectUpdateNode
    extends IntersectNode {
        @Override
        protected Object createResult(PSet self, HashingStorage result, PythonObjectFactory factory) {
            self.setDictStorage(result);
            return PNone.NONE;
        }
    }

    @Builtin(name="intersection", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class IntersectNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        Object doSet(VirtualFrame frame, PSet self, PNone other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            return this.createResult(self, result, factory);
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        Object doCached(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = intersectNode.execute((Frame)frame, inliningTarget, result, getHashingStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return this.createResult(self, result, factory);
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = intersectNode.execute((Frame)frame, inliningTarget, result, getHashingStorageNode.execute(frame, inliningTarget, args[i]));
            }
            return this.createResult(self, result, factory);
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        Object doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            result = intersectNode.execute((Frame)frame, inliningTarget, result, getHashingStorageNode.execute(frame, inliningTarget, other));
            return this.createResult(self, result, factory);
        }

        protected Object createResult(PSet self, HashingStorage result, PythonObjectFactory factory) {
            return factory.createSet(result);
        }
    }

    @Builtin(name="__iand__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IAndNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"canDoSetBinOp(right)"})
        static PBaseSet doPBaseSet(VirtualFrame frame, PSet left, Object right, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageIntersect intersectNode) {
            HashingStorage storage = intersectNode.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, right), left.getDictStorage());
            left.setDictStorage(storage);
            return left;
        }

        @Fallback
        Object doAnd(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__and__", minNumOfPositionalArgs=2), @Builtin(name="__rand__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class AndNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"canDoSetBinOp(right)"})
        static PBaseSet doPBaseSet(VirtualFrame frame, PSet left, Object right, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageIntersect intersectNode, @Cached PythonObjectFactory factory) {
            HashingStorage storage = intersectNode.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, right), left.getDictStorage());
            return factory.createSet(storage);
        }

        @Fallback
        Object doAnd(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="update", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class UpdateNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(other)"})
        static PNone doSet(VirtualFrame frame, PSet self, PNone other) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 1"})
        static PNone doCached(VirtualFrame frame, PSet self, Object[] args, @Cached UpdateSingleNode update) {
            update.execute(frame, self, args[0]);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PNone doCached(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            HashingStorage storage = self.getDictStorage();
            for (int i = 0; i < len; ++i) {
                storage = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, args[i]), storage);
            }
            self.setDictStorage(storage);
            return PNone.NONE;
        }

        @Specialization(replaces={"doCached"})
        static PNone doSet(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            HashingStorage storage = self.getDictStorage();
            for (Object o : args) {
                storage = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, o), storage);
            }
            self.setDictStorage(storage);
            return PNone.NONE;
        }

        static boolean isOther(Object arg) {
            return !PGuards.isNoValue(arg) && !(arg instanceof Object[]);
        }

        @Specialization(guards={"isOther(other)"})
        static PNone doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, other), self);
            return PNone.NONE;
        }
    }

    @ImportStatic(value={PGuards.class, PythonOptions.class})
    @GenerateUncached
    public static abstract class UpdateSingleNode
    extends Node {
        public abstract void execute(VirtualFrame var1, PHashingCollection var2, Object var3);

        @Specialization
        static void update(VirtualFrame frame, PHashingCollection collection, PHashingCollection other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            HashingStorage dictStorage = other.getDictStorage();
            addAllToOther.execute((Frame)frame, inliningTarget, dictStorage, collection);
        }

        @Specialization
        static void update(VirtualFrame frame, PHashingCollection collection, PDictView.PDictKeysView other, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="addAll") @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            HashingStorage dictStorage = other.getWrappedDict().getDictStorage();
            addAllToOther.execute((Frame)frame, inliningTarget, dictStorage, collection);
        }

        @Idempotent
        static boolean isBuiltinSequence(Node inliningTarget, Object other, GetClassNode.GetPythonObjectClassNode getClassNode) {
            return other instanceof PSequence && !(other instanceof PString) && getClassNode.execute(inliningTarget, (PSequence)other) instanceof PythonBuiltinClassType;
        }

        @Specialization(guards={"isBuiltinSequence(inliningTarget, other, getClassNode)"}, limit="1")
        static void doBuiltin(VirtualFrame frame, PHashingCollection collection, PSequence other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setStorageItem) {
            SequenceStorage sequenceStorage = getSequenceStorageNode.execute(inliningTarget, other);
            int length = sequenceStorage.length();
            HashingStorage curStorage = collection.getDictStorage();
            for (int i = 0; i < length; ++i) {
                Object key = getItemScalarNode.execute(inliningTarget, sequenceStorage, i);
                curStorage = setStorageItem.execute((Frame)frame, inliningTarget, curStorage, key, PNone.NONE);
            }
            collection.setDictStorage(curStorage);
        }

        @Specialization(guards={"!isPHashingCollection(other)", "!isDictKeysView(other)", "!isBuiltinSequence(inliningTarget, other, getClassNode)"}, limit="1")
        static void doIterable(VirtualFrame frame, PHashingCollection collection, Object other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setStorageItem) {
            HashingStorage curStorage = collection.getDictStorage();
            Object iterator = getIter.execute((Frame)frame, inliningTarget, other);
            while (true) {
                Object key;
                try {
                    key = nextNode.execute((Frame)frame, iterator);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    collection.setDictStorage(curStorage);
                    return;
                }
                curStorage = setStorageItem.execute((Frame)frame, inliningTarget, curStorage, key, PNone.NONE);
            }
        }

        @NeverDefault
        public static UpdateSingleNode create() {
            return SetBuiltinsFactory.UpdateSingleNodeGen.create();
        }

        public static UpdateSingleNode getUncached() {
            return SetBuiltinsFactory.UpdateSingleNodeGen.getUncached();
        }
    }

    @Builtin(name="union", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class UnionNode
    extends PythonBuiltinNode {
        UnionNode() {
        }

        @Specialization(guards={"args.length == len", "args.length < 32"}, limit="3")
        static PBaseSet doCached(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached(value="args.length") int len, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < len; ++i) {
                result = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, args[i]), result);
            }
            return factory.createSet(result);
        }

        @Specialization(replaces={"doCached"})
        static PBaseSet doGeneric(VirtualFrame frame, PSet self, Object[] args, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached.Shared @Cached PythonObjectFactory factory) {
            HashingStorage result = copyNode.execute(inliningTarget, self.getDictStorage());
            for (int i = 0; i < args.length; ++i) {
                result = addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, args[i]), result);
            }
            return factory.createSet(result);
        }
    }

    @Builtin(name="__ior__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IOrNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"canDoSetBinOp(other)"})
        Object doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorageNode, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther) {
            addAllToOther.execute((Frame)frame, inliningTarget, getHashingStorageNode.execute(frame, inliningTarget, other), self);
            return self;
        }

        @Fallback
        Object doOr(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__or__", minNumOfPositionalArgs=2), @Builtin(name="__ror__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"canDoSetBinOp(other)"})
        static Object doSet(VirtualFrame frame, PSet self, Object other, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetHashingStorageNode getHashingStorage, @Cached HashingStorageNodes.HashingStorageCopy copyStorage, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOther, @Cached PythonObjectFactory factory) {
            HashingStorage otherStorage = getHashingStorage.execute(frame, inliningTarget, other);
            HashingStorage resultStorage = copyStorage.execute(inliningTarget, self.getDictStorage());
            PSet result = factory.createSet(resultStorage);
            addAllToOther.execute((Frame)frame, inliningTarget, otherStorage, result);
            return result;
        }

        @Fallback
        Object doOr(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="add", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public static Object add(VirtualFrame frame, PSet self, Object o, @Cached SetNodes.AddNode addNode) {
            addNode.execute((Frame)frame, self, o);
            return PNone.NONE;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static Object clear(PSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageClear clearNode) {
            HashingStorage newStorage = clearNode.execute(inliningTarget, self.getDictStorage());
            self.setDictStorage(newStorage);
            return PNone.NONE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonBuiltinNode {
        @Specialization
        static PSet doSet(PSet self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached PythonObjectFactory factory) {
            return factory.createSet(copyNode.execute(inliningTarget, self.getDictStorage()));
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class InitNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(iterable)"})
        static PNone doNoValue(PSet self, PNone iterable, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageClear clearNode) {
            HashingStorage newStorage = clearNode.execute(inliningTarget, self.getDictStorage());
            self.setDictStorage(newStorage);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(iterable)"})
        static PNone doGeneric(VirtualFrame frame, PSet self, Object iterable, @Bind(value="this") Node inliningTarget, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode) {
            HashingStorage storage = getHashingStorageNode.doNoValue(frame, inliningTarget, iterable);
            self.setDictStorage(storage);
            return PNone.NONE;
        }

        @Fallback
        static PNone fail(VirtualFrame frame, Object self, Object iterable, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.SET_DOES_NOT_SUPPORT_ITERABLE_OBJ, iterable);
        }
    }
}

