/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.range;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.range.PBigRange;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.range.PRange;
import com.oracle.graal.python.builtins.objects.range.RangeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.range.RangeNodes;
import com.oracle.graal.python.builtins.objects.slice.PObjectSlice;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PRange})
public final class RangeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return RangeBuiltinsFactory.getFactories();
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class CountNode
    extends PythonBinaryBuiltinNode {
        CountNode() {
        }

        @Specialization
        int doInt(PIntRange self, int elem) {
            int normalized;
            assert (self.getIntStep() != 0);
            if (elem >= self.getIntStart() && elem < self.getIntStop() && (normalized = elem - self.getIntStart()) % self.getIntStep() == 0) {
                return 1;
            }
            return 0;
        }

        @Specialization
        int doInt(PIntRange self, long elem) {
            long normalized;
            assert (self.getIntStep() != 0);
            if (elem >= (long)self.getIntStart() && elem < (long)self.getIntStop() && (normalized = elem - (long)self.getIntStart()) % (long)self.getIntStep() == 0L) {
                return 1;
            }
            return 0;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doInt(PIntRange self, PInt elem) {
            BigInteger normalized;
            assert (self.getIntStep() != 0);
            BigInteger value = elem.getValue();
            BigInteger start = BigInteger.valueOf(self.getIntStart());
            BigInteger stop = BigInteger.valueOf(self.getIntStop());
            BigInteger step = BigInteger.valueOf(self.getIntStep());
            if (value.compareTo(start) >= 0 && value.compareTo(stop) < 0 && (normalized = value.subtract(start)).remainder(step).equals(BigInteger.ZERO)) {
                return 1;
            }
            return 0;
        }

        @Specialization(guards={"isInteger(elem)"})
        @CompilerDirectives.TruffleBoundary
        int doInt(PBigRange self, Object elem, @Bind(value="this") Node inliningTarget, @Cached CastToJavaBigIntegerNode castToBigInt) {
            BigInteger normalized;
            BigInteger start = self.getBigIntegerStart();
            BigInteger stop = self.getBigIntegerStop();
            BigInteger step = self.getBigIntegerStep();
            BigInteger value = castToBigInt.execute(inliningTarget, elem);
            if (value.compareTo(start) >= 0 && value.compareTo(stop) < 0 && (normalized = value.subtract(start)).remainder(step).equals(BigInteger.ZERO)) {
                return 1;
            }
            return 0;
        }

        static boolean isInteger(Object value) {
            return value instanceof Integer || value instanceof Long || value instanceof PInt;
        }

        static boolean isFallback(Object value) {
            return !CountNode.isInteger(value);
        }

        @Specialization(guards={"isFallback(elem)"})
        static int doGeneric(VirtualFrame frame, PRange self, Object elem, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PRaiseNode.Lazy raiseNode) {
            int count = 0;
            Object iter = getIter.execute((Frame)frame, inliningTarget, self);
            try {
                while (true) {
                    Object item;
                    if (!eqNode.compare((Frame)frame, inliningTarget, elem, item = nextNode.execute((Frame)frame, iter))) {
                        continue;
                    }
                    if (count == Integer.MAX_VALUE) {
                        throw raiseNode.get(inliningTarget).raiseOverflow();
                    }
                    ++count;
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return count;
            }
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    static abstract class IndexNode
    extends PythonBinaryBuiltinNode {
        IndexNode() {
        }

        private static int fastIntIndex(PIntRange self, int elem) {
            int normalized = elem - self.getIntStart();
            if (normalized % self.getIntStep() == 0) {
                return normalized / self.getIntStep();
            }
            return -1;
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger slowIntIndex(Node inliningTarget, PBigRange self, Object elem, CastToJavaBigIntegerNode castToBigInt) {
            BigInteger start = self.getBigIntegerStart();
            BigInteger step = self.getBigIntegerStep();
            BigInteger value = castToBigInt.execute(inliningTarget, elem);
            BigInteger normalized = value.subtract(start);
            if (normalized.remainder(step).equals(BigInteger.ZERO)) {
                return normalized.divide(step);
            }
            return null;
        }

        @Specialization
        static int doFastRange(VirtualFrame frame, PIntRange self, int elem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ContainsNode containsNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int index;
            if (containsNode.execute(frame, self, (Object)elem) && (index = IndexNode.fastIntIndex(self, elem)) != -1) {
                return index;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.D_IS_NOT_IN_RANGE, elem);
        }

        @Specialization(guards={"canBeInteger(elem)"})
        static Object doFastRangeGeneric(VirtualFrame frame, PIntRange self, Object elem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ContainsNode containsNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int value;
            int index;
            if (containsNode.execute(frame, self, elem) && (index = IndexNode.fastIntIndex(self, value = asSizeNode.executeExact((Frame)frame, inliningTarget, elem))) != -1) {
                return index;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.IS_NOT_IN_RANGE, elem);
        }

        @Specialization(guards={"canBeInteger(elem)"})
        static Object doLongRange(VirtualFrame frame, PBigRange self, Object elem, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached ContainsNode containsNode, @Cached CastToJavaBigIntegerNode castToBigInt, @Cached PythonObjectFactory factory, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            BigInteger index;
            if (containsNode.execute(frame, self, elem) && (index = IndexNode.slowIntIndex(inliningTarget, self, elem, castToBigInt)) != null) {
                return factory.createInt(index);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.D_IS_NOT_IN_RANGE, elem);
        }

        @Specialization(guards={"!canBeInteger(elem)"})
        static Object containsIterator(VirtualFrame frame, PIntRange self, Object elem, @Bind(value="this") Node inliningTarget, @Cached GetNextNode nextNode, @Cached PyObjectGetIter getIter, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int idx = 0;
            Object iter = getIter.execute((Frame)frame, inliningTarget, self);
            while (true) {
                try {
                    Object item = nextNode.execute((Frame)frame, iter);
                    if (eqNode.compare((Frame)frame, inliningTarget, elem, item)) {
                        return idx;
                    }
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    break;
                }
                if (idx == Integer.MAX_VALUE) {
                    throw raiseNode.get(inliningTarget).raiseOverflow();
                }
                ++idx;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.D_IS_NOT_IN_RANGE, elem);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        private static final BigInteger MINUS_ONE = BigInteger.ONE.negate();

        ContainsNode() {
        }

        public abstract boolean execute(VirtualFrame var1, PRange var2, Object var3);

        private static boolean containsInt(Node inliningTarget, PIntRange self, int other, InlinedConditionProfile stepOneProfile, InlinedConditionProfile stepMinusOneProfile) {
            boolean cmp3;
            boolean cmp2;
            int step = self.getIntStep();
            int start = self.getIntStart();
            int stop = self.getIntStop();
            if (stepOneProfile.profile(inliningTarget, step == 1)) {
                return other >= start && other < stop;
            }
            if (stepMinusOneProfile.profile(inliningTarget, step == -1)) {
                return other <= start && other > stop;
            }
            assert (step != 0);
            if (step > 0) {
                cmp2 = start <= other;
                cmp3 = other < stop;
            } else {
                cmp2 = stop < other;
                boolean bl = cmp3 = other <= start;
            }
            if (!cmp2 || !cmp3) {
                return false;
            }
            return (other - start) % step == 0;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean containsBigInt(PBigRange self, long other) {
            return ContainsNode.containsBigInt(self, BigInteger.valueOf(other));
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean containsBigInt(PBigRange self, BigInteger other) {
            boolean cmp3;
            boolean cmp2;
            BigInteger step = self.getBigIntegerStep();
            BigInteger start = self.getBigIntegerStart();
            BigInteger stop = self.getBigIntegerStop();
            if (step.compareTo(BigInteger.ONE) == 0) {
                return other.compareTo(start) >= 0 && other.compareTo(stop) < 0;
            }
            if (step.compareTo(MINUS_ONE) == 0) {
                return other.compareTo(start) <= 0 && other.compareTo(stop) > 0;
            }
            assert (step.compareTo(BigInteger.ZERO) != 0);
            if (step.compareTo(BigInteger.ZERO) > 0) {
                cmp2 = start.compareTo(other) <= 0;
                cmp3 = other.compareTo(stop) < 0;
            } else {
                cmp2 = stop.compareTo(other) < 0;
                boolean bl = cmp3 = other.compareTo(start) <= 0;
            }
            if (!cmp2 || !cmp3) {
                return false;
            }
            BigInteger tmp1 = other.subtract(start);
            if (tmp1.compareTo(BigInteger.ZERO) == 0) {
                return true;
            }
            return tmp1.mod(step).compareTo(BigInteger.ZERO) == 0;
        }

        protected boolean doubleIsExactInteger(double value) {
            return value % 1.0 == 0.0;
        }

        @Specialization
        boolean containsFastNumInt(PIntRange self, int other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile stepOneProfile, @Cached.Shared @Cached InlinedConditionProfile stepMinusOneProfile) {
            return ContainsNode.containsInt(inliningTarget, self, other, stepOneProfile, stepMinusOneProfile);
        }

        @Specialization
        boolean containsFastNumLong(PIntRange self, long other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile stepOneProfile, @Cached.Shared @Cached InlinedConditionProfile stepMinusOneProfile) {
            try {
                return ContainsNode.containsInt(inliningTarget, self, PInt.intValueExact(other), stepOneProfile, stepMinusOneProfile);
            }
            catch (OverflowException e) {
                return false;
            }
        }

        protected static boolean isBuiltinPInt(Node inliningTarget, Object value, PyLongCheckExactNode isBuiltin) {
            return isBuiltin.execute(inliningTarget, value);
        }

        @Specialization(guards={"isBuiltinPInt(this, other, isBuiltin)"}, limit="1")
        static boolean containsFastNumPInt(PIntRange self, PInt other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile stepOneProfile, @Cached.Exclusive @Cached InlinedConditionProfile stepMinusOneProfile, @Cached.Exclusive @Cached PyLongCheckExactNode isBuiltin) {
            try {
                return ContainsNode.containsInt(inliningTarget, self, other.intValueExact(), stepOneProfile, stepMinusOneProfile);
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization(guards={"doubleIsExactInteger(other)"})
        static boolean containsFastNum(PIntRange self, double other, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile stepOneProfile, @Cached.Shared @Cached InlinedConditionProfile stepMinusOneProfile) {
            return ContainsNode.containsInt(inliningTarget, self, (int)other, stepOneProfile, stepMinusOneProfile);
        }

        @Specialization
        boolean containsSlowNum(PBigRange self, int other) {
            return this.containsBigInt(self, other);
        }

        @Specialization
        boolean containsSlowNum(PBigRange self, long other) {
            return this.containsBigInt(self, other);
        }

        @Specialization(guards={"doubleIsExactInteger(other)"})
        boolean containsSlowNum(PBigRange self, double other) {
            return this.containsBigInt(self, (long)other);
        }

        @Specialization(guards={"isBuiltinPInt(inliningTarget, other, isBuiltin)"}, limit="1")
        static boolean containsSlowNum(PBigRange self, PInt other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyLongCheckExactNode isBuiltin) {
            return ContainsNode.containsBigInt(self, other.getValue());
        }

        @Specialization(guards={"!canBeInteger(elem) || !isBuiltinPInt(inliningTarget, elem, isBuiltin)"}, limit="1")
        static boolean containsIterator(VirtualFrame frame, PRange self, Object elem, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached GetNextNode nextNode, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached PyLongCheckExactNode isBuiltin) {
            Object iter = getIter.execute((Frame)frame, inliningTarget, self);
            try {
                Object item;
                while (!eqNode.compare((Frame)frame, inliningTarget, elem, item = nextNode.execute((Frame)frame, iter))) {
                }
                return true;
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, errorProfile);
                return false;
            }
        }

        @NeverDefault
        public static ContainsNode create() {
            return RangeBuiltinsFactory.ContainsNodeFactory.create();
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    static abstract class GetItemNode
    extends PythonBinaryBuiltinNode {
        GetItemNode() {
        }

        protected static boolean allNone(PObjectSlice slice) {
            return slice.getStart() == PNone.NONE && slice.getStop() == PNone.NONE && slice.getStep() == PNone.NONE;
        }

        protected static boolean canBeIndex(Node inliningTarget, Object idx, PyIndexCheckNode indexCheckNode) {
            return indexCheckNode.execute(inliningTarget, idx);
        }

        @Specialization(guards={"allNone(slice)"})
        Object doPRangeObj(PRange self, PObjectSlice slice) {
            return self;
        }

        @Specialization(guards={"canBeIndex(this, idx, indexCheckNode)"})
        static Object doPRange(VirtualFrame frame, PIntRange self, Object idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached(value="forRange()") IndexNodes.NormalizeIndexNode normalize) {
            return self.getIntItemNormalized(normalize.execute(asSizeNode.executeExact((Frame)frame, inliningTarget, idx), self.getIntLength()));
        }

        @Specialization(guards={"canBeIndex(this, idx, indexCheckNode)"})
        static Object doPRange(PBigRange self, Object idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CastToJavaBigIntegerNode toBigInt, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(self.getBigIntItemNormalized(GetItemNode.computeBigRangeItem(inliningTarget, self, idx, toBigInt)));
        }

        @Specialization(guards={"!canBeIndex(this, slice, indexCheckNode)"})
        @HostCompilerDirectives.InliningCutoff
        static Object doPRangeSliceSlowPath(VirtualFrame frame, PIntRange self, PSlice slice, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileError, @Cached.Shared @Cached RangeNodes.CoerceToBigRange toBigIntRange, @Cached.Shared @Cached SliceNodes.CoerceToObjectSlice toBigIntSlice, @Cached.Shared @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared @Cached RangeNodes.LenOfRangeNode lenOfRangeNode, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                int rStart = self.getIntStart();
                int rStep = self.getIntStep();
                PSlice.SliceInfo info = compute.execute((Frame)frame, slice, self.getIntLength());
                return GetItemNode.createRange(inliningTarget, info, rStart, rStep, lenOfRangeNodeExact, factory);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonBuiltinClassType.OverflowError, profileError);
            }
            catch (CannotCastException | OverflowException pe) {
                // empty catch block
            }
            PBigRange rangeBI = toBigIntRange.execute(inliningTarget, self);
            BigInteger rangeStart = rangeBI.getBigIntegerStart();
            BigInteger rangeStep = rangeBI.getBigIntegerStep();
            PObjectSlice.SliceObjectInfo info = PObjectSlice.computeIndicesSlowPath(toBigIntSlice.execute(slice), rangeBI.getBigIntegerLength(), null);
            return GetItemNode.createRange(inliningTarget, info, rangeStart, rangeStep, lenOfRangeNode);
        }

        @Specialization(guards={"!canBeIndex(this, slice, indexCheckNode)"})
        static Object doPRangeSliceSlowPath(VirtualFrame frame, PBigRange self, PSlice slice, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile isNumIndexProfile, @Cached.Shared @Cached InlinedConditionProfile isSliceIndexProfile, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileError, @Cached.Shared @Cached RangeNodes.CoerceToBigRange toBigIntRange, @Cached.Shared @Cached SliceNodes.CoerceToObjectSlice toBigIntSlice, @Cached.Shared @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared @Cached RangeNodes.LenOfRangeNode lenOfRangeNode, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int rStart = asSizeNode.executeExact((Frame)frame, inliningTarget, self.getStart());
                int rStep = asSizeNode.executeExact((Frame)frame, inliningTarget, self.getStep());
                PSlice.SliceInfo info = compute.execute((Frame)frame, slice, asSizeNode.executeExact((Frame)frame, inliningTarget, self.getLength()));
                return GetItemNode.createRange(inliningTarget, info, rStart, rStep, lenOfRangeNodeExact, factory);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonBuiltinClassType.OverflowError, profileError);
            }
            catch (CannotCastException | OverflowException pe) {
                // empty catch block
            }
            PBigRange rangeBI = toBigIntRange.execute(inliningTarget, self);
            BigInteger rangeStart = rangeBI.getBigIntegerStart();
            BigInteger rangeStep = rangeBI.getBigIntegerStep();
            PObjectSlice.SliceObjectInfo info = PObjectSlice.computeIndicesSlowPath(toBigIntSlice.execute(slice), rangeBI.getBigIntegerLength(), null);
            return GetItemNode.createRange(inliningTarget, info, rangeStart, rangeStep, lenOfRangeNode);
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object doGeneric(VirtualFrame frame, PRange self, Object idx, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile isNumIndexProfile, @Cached.Shared @Cached InlinedConditionProfile isSliceIndexProfile, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached.Shared @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileError, @Cached.Shared @Cached RangeNodes.CoerceToBigRange toBigIntRange, @Cached.Shared @Cached SliceNodes.CoerceToObjectSlice toBigIntSlice, @Cached.Shared @Cached RangeNodes.LenOfIntRangeNodeExact lenOfRangeNodeExact, @Cached.Shared @Cached RangeNodes.LenOfRangeNode lenOfRangeNode, @Cached.Shared @Cached CastToJavaBigIntegerNode toBigInt, @Cached.Shared @Cached PyIndexCheckNode indexCheckNode, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached(value="forRange()") IndexNodes.NormalizeIndexNode normalize, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            if (isNumIndexProfile.profile(inliningTarget, GetItemNode.canBeIndex(inliningTarget, idx, indexCheckNode))) {
                if (self instanceof PIntRange) {
                    return GetItemNode.doPRange(frame, (PIntRange)self, idx, inliningTarget, indexCheckNode, asSizeNode, normalize);
                }
                return GetItemNode.doPRange((PBigRange)self, idx, inliningTarget, toBigInt, indexCheckNode, factory);
            }
            if (isSliceIndexProfile.profile(inliningTarget, idx instanceof PSlice)) {
                PSlice slice = (PSlice)idx;
                if (self instanceof PIntRange) {
                    return GetItemNode.doPRangeSliceSlowPath(frame, (PIntRange)self, slice, inliningTarget, compute, profileError, toBigIntRange, toBigIntSlice, lenOfRangeNodeExact, lenOfRangeNode, indexCheckNode, factory);
                }
                return GetItemNode.doPRangeSliceSlowPath(frame, (PBigRange)self, slice, inliningTarget, isNumIndexProfile, isSliceIndexProfile, compute, profileError, toBigIntRange, toBigIntSlice, lenOfRangeNodeExact, lenOfRangeNode, indexCheckNode, asSizeNode, factory, raiseNode);
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "range", idx);
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger computeBigRangeItem(Node inliningTarget, PBigRange range, Object idx, CastToJavaBigIntegerNode toBigInt) {
            BigInteger index = toBigInt.execute(inliningTarget, idx);
            BigInteger length = range.getBigIntegerLength();
            BigInteger i = index.compareTo(BigInteger.ZERO) < 0 ? length.add(index) : index;
            if (i.compareTo(BigInteger.ZERO) < 0 || i.compareTo(length) >= 0) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.RANGE_OBJ_IDX_OUT_OF_RANGE);
            }
            return i;
        }

        private static PIntRange createRange(Node inliningTarget, PSlice.SliceInfo info, int rStart, int rStep, RangeNodes.LenOfIntRangeNodeExact lenOfRangeNode, PythonObjectFactory factory) throws OverflowException {
            int newStep = rStep * info.step;
            int newStart = rStart + info.start * rStep;
            int newStop = rStart + info.stop * rStep;
            int len = lenOfRangeNode.executeInt(inliningTarget, newStart, newStop, newStep);
            return factory.createIntRange(newStart, newStop, newStep, len);
        }

        @CompilerDirectives.TruffleBoundary
        private static PBigRange createRange(Node inliningTarget, PObjectSlice.SliceObjectInfo info, BigInteger rStart, BigInteger rStep, RangeNodes.LenOfRangeNode lenOfRangeNode) {
            BigInteger sliceStart = (BigInteger)info.start;
            BigInteger sliceStop = (BigInteger)info.stop;
            BigInteger sliceStep = (BigInteger)info.step;
            BigInteger step = rStep.multiply(sliceStep);
            BigInteger start = rStart.add(sliceStart.multiply(rStep));
            BigInteger stop = rStart.add(sliceStop.multiply(rStep));
            BigInteger len = lenOfRangeNode.execute(inliningTarget, start, stop, step);
            PythonObjectFactory factory = PythonObjectFactory.getUncached();
            return factory.createBigRange(factory.createInt(start), factory.createInt(stop), factory.createInt(step), factory.createInt(len));
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        private static boolean eqInt(PIntRange range, int len, int start, int step) {
            return EqNode.eqInt(range.getIntLength(), range.getIntStart(), range.getIntStep(), len, start, step);
        }

        private static boolean eqInt(int llen, int lstart, int lstep, int rlen, int rstart, int rstep) {
            if (llen != rlen) {
                return false;
            }
            if (llen == 0) {
                return true;
            }
            if (lstart != rstart) {
                return false;
            }
            if (llen == 1) {
                return true;
            }
            return lstep == rstep;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean eqBigInt(BigInteger llen, BigInteger lstart, BigInteger lstep, BigInteger rlen, BigInteger rstart, BigInteger rstep) {
            if (llen.compareTo(rlen) != 0) {
                return false;
            }
            if (llen.compareTo(BigInteger.ZERO) == 0) {
                return true;
            }
            if (lstart.compareTo(rstart) != 0) {
                return false;
            }
            if (llen.compareTo(BigInteger.ONE) == 0) {
                return true;
            }
            return lstep.compareTo(rstep) == 0;
        }

        @Specialization
        static boolean eqIntInt(PIntRange left, PIntRange right) {
            if (left == right) {
                return true;
            }
            return EqNode.eqInt(left.getIntLength(), left.getIntStart(), left.getIntStep(), right.getIntLength(), right.getIntStart(), right.getIntStep());
        }

        @Specialization
        static boolean eqIntBig(VirtualFrame frame, PIntRange left, PBigRange right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RangeNodes.CoerceToBigRange intToBigRange, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            try {
                int rlen = asSizeNode.executeExact((Frame)frame, inliningTarget, right.getPIntLength());
                int rstart = asSizeNode.executeExact((Frame)frame, inliningTarget, right.getPIntStart());
                int rstep = asSizeNode.executeExact((Frame)frame, inliningTarget, right.getPIntStep());
                return EqNode.eqInt(left, rlen, rstart, rstep);
            }
            catch (PException e) {
                return EqNode.eqBigInt(intToBigRange.execute(inliningTarget, left), right);
            }
        }

        @Specialization
        static boolean eqIntBig(VirtualFrame frame, PBigRange left, PIntRange right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RangeNodes.CoerceToBigRange intToBigRange, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            try {
                int llen = asSizeNode.executeExact((Frame)frame, inliningTarget, left.getPIntLength());
                int lstart = asSizeNode.executeExact((Frame)frame, inliningTarget, left.getPIntStart());
                int lstep = asSizeNode.executeExact((Frame)frame, inliningTarget, left.getPIntStep());
                return EqNode.eqInt(right, llen, lstart, lstep);
            }
            catch (PException e) {
                return EqNode.eqBigInt(left, intToBigRange.execute(inliningTarget, right));
            }
        }

        @Specialization
        static boolean eqBigInt(PBigRange left, PBigRange right) {
            if (left == right) {
                return true;
            }
            return EqNode.eqBigInt(left.getBigIntegerLength(), left.getBigIntegerStart(), left.getBigIntegerStep(), right.getBigIntegerLength(), right.getBigIntegerStart(), right.getBigIntegerStep());
        }

        @Fallback
        static Object doOther(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PRange self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            PTuple args = factory.createTuple(new Object[]{self.getStart(), self.getStop(), self.getStep()});
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }

    @Builtin(name="stop", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StopNode
    extends PythonUnaryBuiltinNode {
        StopNode() {
        }

        @Specialization
        Object stop(PRange self, @Bind(value="this") Node inliningTarget, @Cached RangeNodes.PRangeStopNode get) {
            return get.execute(inliningTarget, self);
        }
    }

    @Builtin(name="step", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StepNode
    extends PythonUnaryBuiltinNode {
        StepNode() {
        }

        @Specialization
        Object step(PRange self, @Bind(value="this") Node inliningTarget, @Cached RangeNodes.PRangeStepNode get) {
            return get.execute(inliningTarget, self);
        }
    }

    @Builtin(name="start", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StartNode
    extends PythonUnaryBuiltinNode {
        StartNode() {
        }

        @Specialization
        Object start(PRange self, @Bind(value="this") Node inliningTarget, @Cached RangeNodes.PRangeStartNode get) {
            return get.execute(inliningTarget, self);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object doPIntRange(PIntRange self, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createIntRangeIterator(self);
        }

        @Specialization
        static Object doPIntRange(PBigRange self, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createBigRangeIterator(self);
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BoolNode
    extends PythonUnaryBuiltinNode {
        BoolNode() {
        }

        @Specialization
        boolean doPIntRange(PIntRange self) {
            return self.getIntLength() != 0;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        boolean doPBigRange(PBigRange self) {
            return self.getBigIntegerLength().compareTo(BigInteger.ZERO) != 0;
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        LenNode() {
        }

        @Specialization
        static int doPIntRange(PIntRange self) {
            return self.getIntLength();
        }

        @Specialization
        static int doPBigRange(VirtualFrame frame, PBigRange self, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object length = self.getLength();
            if (indexCheckNode.execute(inliningTarget, length)) {
                return asSizeNode.executeExact((Frame)frame, inliningTarget, length);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, length);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonBuiltinNode {
        ReprNode() {
        }

        @Specialization
        public static TruffleString repr(PRange self, @Bind(value="this") Node inliningTarget, @Cached PyObjectReprAsTruffleStringNode repr, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString start = repr.execute(null, inliningTarget, self.getStart());
            TruffleString stop = repr.execute(null, inliningTarget, self.getStop());
            if (self.withStep()) {
                return simpleTruffleStringFormatNode.format("range(%s, %s, %s)", start, stop, repr.execute(null, inliningTarget, self.getStep()));
            }
            return simpleTruffleStringFormatNode.format("range(%s, %s)", start, stop);
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonBuiltinNode {
        @Specialization
        static long hash(VirtualFrame frame, PIntRange self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="hashNode") @Cached PyObjectHashNode hashNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object[] content = new Object[3];
            int intLength = self.getIntLength();
            content[0] = intLength;
            if (intLength == 0) {
                content[1] = PNone.NONE;
                content[2] = PNone.NONE;
            } else if (intLength == 1) {
                content[1] = self.getIntStart();
                content[2] = PNone.NONE;
            } else {
                content[1] = self.getIntStart();
                content[2] = self.getIntStep();
            }
            return hashNode.execute((Frame)frame, inliningTarget, factory.createTuple(content));
        }

        @Specialization
        static long hash(VirtualFrame frame, PBigRange self, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="hashNode") @Cached PyObjectHashNode hashNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object[] content = new Object[3];
            PInt length = self.getPIntLength();
            content[0] = length;
            if (length.compareTo(BigInteger.ZERO) == 0) {
                content[1] = PNone.NONE;
                content[2] = PNone.NONE;
            } else if (length.compareTo(BigInteger.ONE) == 0) {
                content[1] = self.getStart();
                content[2] = PNone.NONE;
            } else {
                content[1] = self.getStart();
                content[2] = self.getStep();
            }
            return hashNode.execute((Frame)frame, inliningTarget, factory.createTuple(content));
        }
    }
}

