/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.module;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class ModuleGetNameNode
extends Node {
    public abstract TruffleString execute(Node var1, Object var2);

    @Specialization
    static TruffleString doPythonModule(Node inliningTarget, PythonModule module, @Cached(inline=false) ReadAttributeFromObjectNode readNameNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PRaiseNode.Lazy raiseNode) {
        try {
            Object name = readNameNode.execute(module, SpecialAttributeNames.T___NAME__);
            return castToTruffleStringNode.execute(inliningTarget, name);
        }
        catch (CannotCastException e) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.NAMELESS_MODULE);
        }
    }
}

