/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodesFactory;
import com.oracle.graal.python.builtins.objects.iterator.PArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PBuiltinIterator;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntRangeIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.util.CastBuiltinStringToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.ArrayList;
import java.util.List;

public abstract class IteratorNodes {

    @ImportStatic(value={PGuards.class})
    public static abstract class ToArrayNode
    extends Node {
        public abstract Object[] execute(VirtualFrame var1, Object var2);

        @Specialization(guards={"isString(iterableObj)"})
        public static Object[] doIt(Object iterableObj, @Bind(value="this") Node inliningTarget, @Cached CastBuiltinStringToTruffleStringNode castToStringNode, @Cached InlinedLoopConditionProfile loopProfile, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.FromCodePointNode fromCodePointNode) {
            TruffleString iterable = castToStringNode.execute(inliningTarget, iterableObj);
            Object[] result = new Object[codePointLengthNode.execute((AbstractTruffleString)iterable, PythonUtils.TS_ENCODING)];
            loopProfile.profileCounted(inliningTarget, (long)result.length);
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)iterable, PythonUtils.TS_ENCODING);
            int i = 0;
            while (loopProfile.inject(inliningTarget, it.hasNext())) {
                result[i++] = fromCodePointNode.execute(nextNode.execute(it), PythonUtils.TS_ENCODING, true);
            }
            return result;
        }

        @Specialization
        public static Object[] doIt(PSequence iterable, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getStorageNode, @Cached SequenceStorageNodes.ToArrayNode toArrayNode) {
            SequenceStorage storage = getStorageNode.execute(inliningTarget, iterable);
            return toArrayNode.execute(inliningTarget, storage);
        }

        @Fallback
        public static Object[] doIt(VirtualFrame frame, Object iterable, @Bind(value="this") Node inliningTarget, @Cached GetNextNode getNextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached PyObjectGetIter getIter) {
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            List<Object> result = ToArrayNode.createlist();
            try {
                while (true) {
                    result.add(getNextNode.execute((Frame)frame, it));
                }
            }
            catch (PException e) {
                e.expectStopIteration(inliningTarget, stopIterationProfile);
                return result.toArray(new Object[result.size()]);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static List<Object> createlist() {
            return new ArrayList<Object>();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    public static abstract class BuiltinIteratorLengthHint
    extends Node {
        public final int execute(Node inliningTarget, PBuiltinIterator iterator) {
            assert (GetClassNode.GetPythonObjectClassNode.executeUncached(iterator) == PythonBuiltinClassType.PIterator);
            return this.executeInternal(inliningTarget, iterator);
        }

        protected abstract int executeInternal(Node var1, PBuiltinIterator var2);

        protected static SequenceStorage getStorage(Node inliningTarget, GetInternalIteratorSequenceStorage getSeqStorage, PBuiltinIterator it) {
            return it.index != 0 || it.isExhausted() ? null : getSeqStorage.execute(inliningTarget, it);
        }

        @Specialization(guards={"storage != null"}, limit="3")
        static int doSeqStorage(Node inliningTarget, PBuiltinIterator it, @Cached GetInternalIteratorSequenceStorage getSeqStorage, @Bind(value="getStorage(inliningTarget, getSeqStorage, it)") SequenceStorage storage) {
            return BuiltinIteratorLengthHint.ensurePositive(storage.length());
        }

        @Specialization
        static int doString(PStringIterator it, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode) {
            return BuiltinIteratorLengthHint.ensurePositive(codePointLengthNode.execute((AbstractTruffleString)it.value, PythonUtils.TS_ENCODING));
        }

        @Specialization
        static int doSequenceArr(PArrayIterator it) {
            return BuiltinIteratorLengthHint.ensurePositive(it.array.getLength());
        }

        @Specialization
        static int doSequenceIntRange(PIntRangeIterator it) {
            return BuiltinIteratorLengthHint.ensurePositive(it.getRemainingLength());
        }

        @Specialization(replaces={"doSeqStorage", "doString", "doSequenceArr", "doSequenceIntRange"})
        static int doGeneric(PBuiltinIterator it) {
            return -1;
        }

        static int ensurePositive(int len) {
            if (len < 0) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return len;
        }
    }

    @ImportStatic(value={PGuards.class})
    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class GetInternalIteratorSequenceStorage
    extends Node {
        public static SequenceStorage executeUncached(PBuiltinIterator iterator) {
            return IteratorNodesFactory.GetInternalIteratorSequenceStorageNodeGen.getUncached().execute(null, iterator);
        }

        public final SequenceStorage execute(Node inliningTarget, PBuiltinIterator iterator) {
            assert (GetClassNode.GetPythonObjectClassNode.executeUncached(iterator) == PythonBuiltinClassType.PIterator);
            assert (iterator.index == 0 && !iterator.isExhausted());
            return this.executeInternal(inliningTarget, iterator);
        }

        protected abstract SequenceStorage executeInternal(Node var1, PBuiltinIterator var2);

        @Specialization(guards={"isList(it.sequence)"})
        static SequenceStorage doSequenceList(PSequenceIterator it) {
            return ((PList)it.sequence).getSequenceStorage();
        }

        @Specialization
        static SequenceStorage doSequenceLong(PLongSequenceIterator it) {
            return it.sequence;
        }

        @Specialization
        static SequenceStorage doSequenceDouble(PDoubleSequenceIterator it) {
            return it.sequence;
        }

        @Specialization
        static SequenceStorage doSequenceObj(PObjectSequenceIterator it) {
            return it.sequence;
        }

        @Specialization
        static SequenceStorage doSequenceIntSeq(PIntegerSequenceIterator it) {
            return it.sequence;
        }

        @Specialization(guards={"isPTuple(it.sequence)"})
        static SequenceStorage doSequenceTuple(PSequenceIterator it) {
            return ((PTuple)it.sequence).getSequenceStorage();
        }

        @Fallback
        static SequenceStorage doOthers(PBuiltinIterator it) {
            return null;
        }
    }

    @GenerateInline(value=false)
    public static abstract class GetLengthForeign
    extends PNodeWithContext {
        public abstract int execute(Object var1);

        @Specialization
        static int doIt(Object foreign, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isString, @CachedLibrary(limit="3") InteropLibrary iLib, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached GilNode gil) {
            if (isString.profile(inliningTarget, iLib.isString(foreign))) {
                gil.release(true);
                try {
                    int n = codePointLengthNode.execute((AbstractTruffleString)switchEncodingNode.execute((AbstractTruffleString)iLib.asTruffleString(foreign), PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
                    return n;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                finally {
                    gil.acquire();
                }
            }
            return -1;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class, SpecialMethodNames.class, SpecialMethodSlot.class})
    public static abstract class GetLength
    extends PNodeWithContext {
        public abstract int execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static int doTruffleString(TruffleString str, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode) {
            return codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
        static int doList(PList object) {
            return object.getSequenceStorage().length();
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
        static int doTuple(PTuple object) {
            return object.getSequenceStorage().length();
        }

        @Specialization(guards={"cannotBeOverriddenForImmutableType(object)"})
        static int doDict(Node inliningTarget, PDict object, @Cached.Shared(value="hashingStorageLen") @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, object.getDictStorage());
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static int doSet(Node inliningTarget, PSet object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached.Shared(value="hashingStorageLen") @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, object.getDictStorage());
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static int doPString(Node inliningTarget, PString object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached(inline=false) StringNodes.StringLenNode lenNode) {
            return lenNode.execute(object);
        }

        @Specialization(guards={"cannotBeOverridden(object, inliningTarget, getClassNode)"})
        static int doPBytes(Node inliningTarget, PBytesLike object, @Cached.Shared(value="getClass") @Cached GetClassNode.GetPythonObjectClassNode getClassNode) {
            return object.getSequenceStorage().length();
        }

        @Specialization(guards={"isNoValue(iterable)"})
        static int length(PNone iterable) {
            return -1;
        }

        @HostCompilerDirectives.InliningCutoff
        @Fallback
        static int length(VirtualFrame frame, Node inliningTarget, Object iterable, @Cached IsForeignObjectNode isForeignObjectNode, @Cached(inline=false) GetLengthForeign getLengthForeign, @Cached GetClassNode getClassNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached(value="create(Len)", inline=false) LookupCallableSlotInMRONode lenNode, @Cached(value="create(LengthHint)", inline=false) LookupSpecialMethodSlotNode lenHintNode, @Cached(inline=false) CallUnaryMethodNode dispatchLenOrLenHint, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached InlinedConditionProfile hasLenProfile, @Cached InlinedConditionProfile hasLengthHintProfile, @Cached PRaiseNode.Lazy raiseNode) {
            Object attrLenHintObj;
            int foreignLen;
            if (isForeignObjectNode.execute(inliningTarget, iterable) && (foreignLen = getLengthForeign.execute(iterable)) != -1) {
                return foreignLen;
            }
            Object clazz = getClassNode.execute(inliningTarget, iterable);
            Object attrLenObj = lenNode.execute(clazz);
            if (hasLenProfile.profile(inliningTarget, attrLenObj != PNone.NO_VALUE)) {
                Object len = null;
                try {
                    len = dispatchLenOrLenHint.executeObject((Frame)frame, attrLenObj, iterable);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
                }
                if (len != null && len != PNotImplemented.NOT_IMPLEMENTED) {
                    if (indexCheckNode.execute(inliningTarget, len)) {
                        int intLen = asSizeNode.executeExact((Frame)frame, inliningTarget, len);
                        if (intLen < 0) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.LEN_SHOULD_RETURN_GT_ZERO);
                        }
                        return intLen;
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_INTEGER_NOT_P, SpecialMethodNames.T___LEN__, len);
                }
            }
            if (hasLengthHintProfile.profile(inliningTarget, (attrLenHintObj = lenHintNode.execute((Frame)frame, clazz, iterable)) != PNone.NO_VALUE)) {
                Object len = null;
                try {
                    len = dispatchLenOrLenHint.executeObject((Frame)frame, attrLenHintObj, iterable);
                }
                catch (PException e) {
                    e.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
                }
                if (len != null && len != PNotImplemented.NOT_IMPLEMENTED) {
                    if (indexCheckNode.execute(inliningTarget, len)) {
                        int intLen = asSizeNode.executeExact((Frame)frame, inliningTarget, len);
                        if (intLen < 0) {
                            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.LENGTH_HINT_SHOULD_RETURN_MT_ZERO);
                        }
                        return intLen;
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_INTEGER_NOT_P, SpecialMethodNames.T___LENGTH_HINT__, len);
                }
            }
            return -1;
        }
    }
}

