/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.foreign;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.foreign.AccessForeignItemNodes;
import com.oracle.graal.python.builtins.objects.foreign.ForeignObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.iterator.PForeignArrayIterator;
import com.oracle.graal.python.builtins.objects.iterator.PStringIterator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.CastToListExpressionNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.interop.PForeignToPTypeNode;
import com.oracle.graal.python.nodes.object.IsForeignObjectNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ForeignObject})
public final class ForeignObjectBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ForeignObjectBuiltinsFactory.getFactories();
    }

    static Object[] unpackForeignArray(Object left, InteropLibrary lib, PForeignToPTypeNode convert) {
        try {
            long sizeObj = lib.getArraySize(left);
            if (sizeObj < Integer.MAX_VALUE) {
                int size = (int)sizeObj;
                Object[] data = new Object[size];
                for (int i = 0; i < size; ++i) {
                    data[i] = convert.executeConvert(lib.readArrayElement(left, (long)i));
                }
                return data;
            }
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("object does not unpack to array as it claims to");
        }
        return null;
    }

    @Builtins(value={@Builtin(name="__rxor__", minNumOfPositionalArgs=2), @Builtin(name="__xor__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class XorNode
    extends PythonBinaryBuiltinNode {
        XorNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        protected static Object op(VirtualFrame frame, Object left, Object right, @Cached BinaryArithmetic.BitXorNode xorNode, @CachedLibrary(value="left") InteropLibrary lib, @Cached GilNode gil) {
            if (lib.isNumber(left) && lib.fitsInLong(left)) {
                try {
                    long leftLong;
                    gil.release(true);
                    try {
                        leftLong = lib.asLong(left);
                    }
                    finally {
                        gil.acquire();
                    }
                    return xorNode.executeObject(frame, leftLong, right);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__ror__", minNumOfPositionalArgs=2), @Builtin(name="__or__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class OrNode
    extends PythonBinaryBuiltinNode {
        OrNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        protected static Object op(VirtualFrame frame, Object left, Object right, @Cached BinaryArithmetic.BitOrNode orNode, @CachedLibrary(value="left") InteropLibrary lib, @Cached GilNode gil) {
            if (lib.isNumber(left) && lib.fitsInLong(left)) {
                try {
                    long leftLong;
                    gil.release(true);
                    try {
                        leftLong = lib.asLong(left);
                    }
                    finally {
                        gil.acquire();
                    }
                    return orNode.executeObject(frame, leftLong, right);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rand__", minNumOfPositionalArgs=2), @Builtin(name="__and__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    static abstract class AndNode
    extends PythonBinaryBuiltinNode {
        AndNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        protected static Object op(VirtualFrame frame, Object left, Object right, @Cached BinaryArithmetic.BitAndNode andNode, @CachedLibrary(value="left") InteropLibrary lib, @Cached GilNode gil) {
            if (lib.isNumber(left) && lib.fitsInLong(left)) {
                try {
                    long leftLong;
                    gil.release(true);
                    try {
                        leftLong = lib.asLong(left);
                    }
                    finally {
                        gil.acquire();
                    }
                    return andNode.executeObject(frame, leftLong, right);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__instancecheck__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    static abstract class InstancecheckNode
    extends PythonBinaryBuiltinNode {
        InstancecheckNode() {
        }

        @Specialization(limit="3")
        static Object check(Object self, Object instance, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="self") InteropLibrary lib, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            if (lib.isMetaObject(self)) {
                gil.release(true);
                try {
                    Boolean bl = lib.isMetaInstance(self, instance);
                    return bl;
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
                finally {
                    gil.acquire();
                }
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, SpecialMethodNames.T___INSTANCECHECK__);
        }
    }

    @Builtin(name="__bases__", minNumOfPositionalArgs=1, isGetter=true, isSetter=false)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    static abstract class BasesNode
    extends PythonUnaryBuiltinNode {
        BasesNode() {
        }

        @Specialization(limit="3")
        static Object getBases(Object self, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="self") InteropLibrary lib, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (lib.isMetaObject(self)) {
                return factory.createTuple(PythonUtils.EMPTY_OBJECT_ARRAY);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, SpecialAttributeNames.T___BASES__);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        @Node.Child
        private ObjectNodes.DefaultObjectReprNode defaultReprNode;

        ReprNode() {
        }

        @Override
        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                if (this.getContext().getEnv().isHostObject(object)) {
                    boolean isMetaObject = lib.isMetaObject(object);
                    Object metaObject = null;
                    if (isMetaObject) {
                        metaObject = object;
                    } else if (lib.hasMetaObject(object)) {
                        metaObject = lib.getMetaObject(object);
                    }
                    if (metaObject != null) {
                        TruffleString displayName = this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(metaObject)), PythonUtils.TS_ENCODING);
                        return StringUtils.simpleTruffleStringFormatUncached("<%s[%s] at 0x%s>", isMetaObject ? "JavaClass" : "JavaObject", displayName, PythonAbstractObject.systemHashCodeAsHexString(object));
                    }
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
            if (this.defaultReprNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.defaultReprNode = (ObjectNodes.DefaultObjectReprNode)this.insert(ObjectNodes.DefaultObjectReprNode.create());
            }
            return this.defaultReprNode.executeCached((Frame)frame, object);
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        @Node.Child
        private LookupAndCallUnaryNode callStrNode;
        @Node.Child
        private CastToListExpressionNode.CastToListNode castToListNode;
        @Node.Child
        private TruffleString.SwitchEncodingNode switchEncodingNode;

        StrNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object str(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached GilNode gil, @Cached InlinedBranchProfile isNull, @Cached InlinedBranchProfile isBoolean, @Cached InlinedBranchProfile isString, @Cached InlinedBranchProfile isLong, @Cached InlinedBranchProfile isDouble, @Cached InlinedBranchProfile isArray, @Cached InlinedBranchProfile defaultCase, @Cached PythonObjectFactory.Lazy factory) {
            block27: {
                try {
                    long size;
                    if (lib.isNull(object)) {
                        isNull.enter(inliningTarget);
                        return this.getCallStrNode().executeObject(frame, PNone.NONE);
                    }
                    if (lib.isBoolean(object)) {
                        boolean value;
                        isBoolean.enter(inliningTarget);
                        gil.release(true);
                        try {
                            value = lib.asBoolean(object);
                        }
                        finally {
                            gil.acquire();
                        }
                        return this.getCallStrNode().executeObject(frame, value);
                    }
                    if (lib.isString(object)) {
                        TruffleString value;
                        isString.enter(inliningTarget);
                        gil.release(true);
                        try {
                            value = lib.asTruffleString(object);
                        }
                        finally {
                            gil.acquire();
                        }
                        return this.getCallStrNode().executeObject(frame, this.getSwitchEncodingNode().execute((AbstractTruffleString)value, PythonUtils.TS_ENCODING));
                    }
                    if (lib.fitsInLong(object)) {
                        long value;
                        isLong.enter(inliningTarget);
                        gil.release(true);
                        try {
                            value = lib.asLong(object);
                        }
                        finally {
                            gil.acquire();
                        }
                        return this.getCallStrNode().executeObject(frame, value);
                    }
                    if (lib.fitsInDouble(object)) {
                        double value;
                        isDouble.enter(inliningTarget);
                        gil.release(true);
                        try {
                            value = lib.asDouble(object);
                        }
                        finally {
                            gil.acquire();
                        }
                        return this.getCallStrNode().executeObject(frame, value);
                    }
                    if (!lib.hasArrayElements(object)) break block27;
                    isArray.enter(inliningTarget);
                    gil.release(true);
                    try {
                        size = lib.getArraySize(object);
                    }
                    finally {
                        gil.acquire();
                    }
                    if (size <= Integer.MAX_VALUE && size >= 0L) {
                        PForeignArrayIterator iterable = factory.get(inliningTarget).createForeignArrayIterator(object);
                        return this.getCallStrNode().executeObject(frame, this.getCastToListNode().execute(frame, iterable));
                    }
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            defaultCase.enter(inliningTarget);
            return this.defaultConversion(frame, lib, object);
        }

        private LookupAndCallUnaryNode getCallStrNode() {
            if (this.callStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callStrNode = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodSlot.Str));
            }
            return this.callStrNode;
        }

        private CastToListExpressionNode.CastToListNode getCastToListNode() {
            if (this.castToListNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.castToListNode = (CastToListExpressionNode.CastToListNode)this.insert(CastToListExpressionNode.CastToListNode.create());
            }
            return this.castToListNode;
        }

        protected TruffleString.SwitchEncodingNode getSwitchEncodingNode() {
            if (this.switchEncodingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.switchEncodingNode = (TruffleString.SwitchEncodingNode)this.insert((Node)TruffleString.SwitchEncodingNode.create());
            }
            return this.switchEncodingNode;
        }

        protected TruffleString defaultConversion(VirtualFrame frame, InteropLibrary lib, Object object) {
            try {
                return this.getSwitchEncodingNode().execute((AbstractTruffleString)lib.asTruffleString(lib.toDisplayString(object)), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((String)"toDisplayString result not convertible to String");
            }
        }
    }

    @Builtin(name="__index__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IndexNode
    extends PythonUnaryBuiltinNode {
        IndexNode() {
        }

        @Specialization(limit="3")
        protected static Object doIt(Object object, @Cached PRaiseNode raiseNode, @CachedLibrary(value="object") InteropLibrary lib, @Cached GilNode gil, @Cached PythonObjectFactory factory) {
            block18: {
                gil.release(true);
                if (lib.isBoolean(object)) {
                    try {
                        Integer n = PInt.intValue(lib.asBoolean(object));
                        return n;
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        throw new IllegalStateException("foreign value claims to be a boolean but isn't");
                    }
                }
                if (!lib.fitsInInt(object)) break block18;
                try {
                    Integer e = lib.asInt(object);
                    return e;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign value claims it fits into index-sized int, but doesn't");
                }
            }
            if (lib.fitsInLong(object)) {
                try {
                    Long e = lib.asLong(object);
                    return e;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign value claims it fits into index-sized long, but doesn't");
                }
            }
            if (lib.fitsInBigInteger(object)) {
                try {
                    BigInteger big = lib.asBigInteger(object);
                    PInt pInt = factory.createInt(big);
                    return pInt;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign value claims to be a big integer but isn't");
                }
            }
            throw raiseNode.raiseIntegerInterpretationError(object);
            finally {
                gil.acquire();
            }
        }
    }

    @Builtin(name="__dir__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class DirNode
    extends PythonUnaryBuiltinNode {
        DirNode() {
        }

        @Specialization
        protected Object doIt(Object object, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached GilNode gil, @Cached PythonObjectFactory.Lazy factory) {
            if (lib.hasMembers(object)) {
                gil.release(true);
                try {
                    Object object2 = lib.getMembers(object);
                    return object2;
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("foreign object claims to have members, but does not return them");
                }
                finally {
                    gil.acquire();
                }
            }
            return factory.get(inliningTarget).createList();
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DelitemNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private AccessForeignItemNodes.RemoveForeignItemNode delForeignItemNode = AccessForeignItemNodes.RemoveForeignItemNode.create();

        DelitemNode() {
        }

        @Specialization
        PNone doit(VirtualFrame frame, Object object, Object key) {
            this.delForeignItemNode.execute(frame, object, key);
            return PNone.NONE;
        }
    }

    @Builtin(name="__delattr__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DelattrNode
    extends PythonBinaryBuiltinNode {
        DelattrNode() {
        }

        @Specialization
        static PNone doIt(Object object, Object key, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CastToJavaStringNode castToString, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                lib.removeMember(object, castToString.execute(key));
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, key);
            }
            finally {
                gil.acquire();
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class SetitemNode
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private AccessForeignItemNodes.SetForeignItemNode setForeignItemNode = AccessForeignItemNodes.SetForeignItemNode.create();

        SetitemNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, Object object, Object key, Object value) {
            this.setForeignItemNode.execute(frame, object, key, value);
            return PNone.NONE;
        }
    }

    @Builtin(name="__setattr__", minNumOfPositionalArgs=3)
    @ImportStatic(value={PGuards.class})
    @GenerateNodeFactory
    static abstract class SetattrNode
    extends PythonTernaryBuiltinNode {
        SetattrNode() {
        }

        @Specialization
        static PNone doIt(Object object, Object key, Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CastToJavaStringNode castToString, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                lib.writeMember(object, castToString.execute(key), value);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, key);
            }
            finally {
                gil.acquire();
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__getattr__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetattrNode
    extends PythonBinaryBuiltinNode {
        GetattrNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object doIt(Object object, Object memberObj, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") InteropLibrary read, @Cached CastToJavaStringNode castToString, @Cached GilNode gil, @Cached PForeignToPTypeNode toPythonNode, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                String member = castToString.execute(memberObj);
                if (read.isMemberReadable(object, member)) {
                    Object object2 = toPythonNode.executeConvert(read.readMember(object, member));
                    return object2;
                }
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, memberObj);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException throwable) {
            }
            finally {
                gil.acquire();
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, memberObj);
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetitemNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private AccessForeignItemNodes.GetForeignItemNode getForeignItemNode = AccessForeignItemNodes.GetForeignItemNode.create();

        GetitemNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, Object object, Object key) {
            return this.getForeignItemNode.execute(frame, object, key);
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonBuiltinNode {
        public final Object executeWithArgs(VirtualFrame frame, Object callee, Object[] arguments) {
            return this.execute(frame, callee, arguments, PKeyword.EMPTY_KEYWORDS);
        }

        public abstract Object execute(VirtualFrame var1, Object var2, Object[] var3, PKeyword[] var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, callee)", "!isNoValue(callee)", "keywords.length == 0"}, limit="1")
        static Object doInteropCall(VirtualFrame frame, Object callee, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="4") InteropLibrary lib, @Cached PForeignToPTypeNode toPTypeNode, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            PythonContext context = PythonContext.get(inliningTarget);
            try {
                Object state = ExecutionContext.IndirectCallContext.enter(frame, language, context, indirectCallData);
                gil.release(true);
                try {
                    if (lib.isExecutable(callee)) {
                        Object object = toPTypeNode.executeConvert(lib.execute(callee, arguments));
                        return object;
                    }
                    Object object = toPTypeNode.executeConvert(lib.instantiate(callee, arguments));
                    return object;
                }
                finally {
                    gil.acquire();
                    ExecutionContext.IndirectCallContext.exit(frame, language, context, state);
                }
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
            }
        }

        @Fallback
        static Object doGeneric(Object callee, Object arguments, Object keywords, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
        }

        @NeverDefault
        public static CallNode create() {
            return ForeignObjectBuiltinsFactory.CallNodeFactory.create(null);
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class NewNode
    extends PythonBuiltinNode {
        NewNode() {
        }

        @Specialization(guards={"isForeignObjectNode.execute(inliningTarget, callee)", "!isNoValue(callee)", "keywords.length == 0"}, limit="1")
        static Object doInteropCall(Object callee, Object[] arguments, PKeyword[] keywords, @Bind(value="this") Node inliningTarget, @Cached IsForeignObjectNode isForeignObjectNode, @CachedLibrary(limit="3") InteropLibrary lib, @Cached PForeignToPTypeNode toPTypeNode, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                Object res = lib.instantiate(callee, arguments);
                Object object = toPTypeNode.executeConvert(res);
                return object;
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
            }
            finally {
                gil.acquire();
            }
        }

        @Fallback
        static Object doGeneric(Object callee, Object arguments, Object keywords, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INVALID_INSTANTIATION_OF_FOREIGN_OBJ);
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static Object doForeignArray(Object iterator, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile notIterator, @Cached PRaiseNode raiseNode, @CachedLibrary(value="iterator") InteropLibrary lib, @Cached PForeignToPTypeNode convertNode, @Cached GilNode gil) {
            if (notIterator.profile(inliningTarget, lib.isIterator(iterator))) {
                gil.release(true);
                try {
                    Object object = convertNode.executeConvert(lib.getIteratorNextElement(iterator));
                    return object;
                }
                catch (StopIterationException e) {
                    throw raiseNode.raiseStopIteration();
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)"iterator claimed to be iterator but wasn't");
                }
                finally {
                    gil.acquire();
                }
            }
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, SpecialMethodNames.T___NEXT__);
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization(limit="3")
        static Object doGeneric(Object object, @Cached PythonObjectFactory factory, @Cached PRaiseNode raiseNode, @CachedLibrary(value="object") InteropLibrary lib, @Cached PForeignToPTypeNode convertNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached GilNode gil) {
            gil.release(true);
            try {
                if (lib.isIterator(object)) {
                    Object object2 = convertNode.executeConvert(object);
                    return object2;
                }
                if (lib.hasIterator(object)) {
                    Object object3 = convertNode.executeConvert(lib.getIterator(object));
                    return object3;
                }
                if (lib.hasArrayElements(object)) {
                    long size = lib.getArraySize(object);
                    if (size < Integer.MAX_VALUE) {
                        PForeignArrayIterator pForeignArrayIterator = factory.createForeignArrayIterator(object);
                        return pForeignArrayIterator;
                    }
                    throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.FOREIGN_OBJ_ISNT_ITERABLE);
                }
                if (lib.isString(object)) {
                    PStringIterator size = factory.createStringIterator(switchEncodingNode.execute((AbstractTruffleString)lib.asTruffleString(object), PythonUtils.TS_ENCODING));
                    return size;
                }
                if (lib.hasHashEntries(object)) {
                    Object size = convertNode.executeConvert(lib.getHashKeysIterator(object));
                    return size;
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.FOREIGN_OBJ_ISNT_ITERABLE);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        static Object contains(VirtualFrame frame, Object self, Object arg, @CachedLibrary(limit="3") InteropLibrary library, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached StringBuiltins.ContainsNode containsNode, @Cached PForeignToPTypeNode convertNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                if (library.isString(self)) {
                    TruffleString selfStr = switchEncodingNode.execute((AbstractTruffleString)library.asTruffleString(self), PythonUtils.TS_ENCODING);
                    return containsNode.execute(frame, selfStr, arg);
                }
                if (library.hasArrayElements(self)) {
                    int i = 0;
                    while ((long)i < library.getArraySize(self)) {
                        Object element;
                        if (library.isArrayElementReadable(self, (long)i) && eqNode.compare((Frame)frame, inliningTarget, arg, element = convertNode.executeConvert(library.readArrayElement(self, (long)i)))) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                Object iterator = null;
                if (library.isIterator(self)) {
                    iterator = self;
                } else if (library.hasHashEntries(self)) {
                    iterator = library.getHashKeysIterator(self);
                } else if (library.hasIterator(self)) {
                    iterator = library.getIterator(self);
                }
                if (iterator != null) {
                    try {
                        while (library.hasIteratorNextElement(iterator)) {
                            Object next = convertNode.executeConvert(library.getIteratorNextElement(iterator));
                            if (!eqNode.compare((Frame)frame, inliningTarget, arg, next)) continue;
                            return true;
                        }
                    }
                    catch (StopIterationException stopIterationException) {
                        // empty catch block
                    }
                    return false;
                }
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.FOREIGN_OBJ_ISNT_ITERABLE);
            }
            catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static int hash(Object self, @CachedLibrary(value="self") InteropLibrary library) {
            if (library.hasIdentity(self)) {
                try {
                    return library.identityHashCode(self);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return HashNode.hashCodeBoundary(self);
        }

        @CompilerDirectives.TruffleBoundary
        private static int hashCodeBoundary(Object self) {
            return self.hashCode();
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends ForeignBinaryComparisonNode {
        protected EqNode() {
            super(BinaryComparisonNode.EqNode.create());
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GeNode
    extends ForeignBinaryComparisonNode {
        protected GeNode() {
            super(BinaryComparisonNode.GeNode.create());
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GtNode
    extends ForeignBinaryComparisonNode {
        protected GtNode() {
            super(BinaryComparisonNode.GtNode.create());
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LeNode
    extends ForeignBinaryComparisonNode {
        protected LeNode() {
            super(BinaryComparisonNode.LeNode.create());
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LtNode
    extends ForeignBinaryComparisonNode {
        protected LtNode() {
            super(BinaryComparisonNode.LtNode.create());
        }
    }

    public static abstract class ForeignBinaryComparisonNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private BinaryComparisonNode comparisonNode;

        protected ForeignBinaryComparisonNode(BinaryComparisonNode op) {
            this.comparisonNode = op;
        }

        @Specialization(guards={"lib.isBoolean(left)"})
        Object doComparisonBool(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            boolean leftBoolean;
            gil.release(true);
            try {
                leftBoolean = lib.asBoolean(left);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to boolean for comparison as it claims to");
            }
            finally {
                gil.acquire();
            }
            return this.comparisonNode.executeObject(frame, leftBoolean, right);
        }

        @Specialization(guards={"lib.fitsInLong(left)"})
        Object doComparisonLong(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            long leftLong;
            gil.release(true);
            try {
                leftLong = lib.asLong(left);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to long for comparison as it claims to");
            }
            finally {
                gil.acquire();
            }
            return this.comparisonNode.executeObject(frame, leftLong, right);
        }

        @Specialization(guards={"!lib.fitsInLong(left)", "lib.fitsInBigInteger(left)"})
        Object doComparisonBigInt(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil, @Cached PythonObjectFactory factory) {
            PInt leftInt;
            gil.release(true);
            try {
                BigInteger leftBigInteger = lib.asBigInteger(left);
                leftInt = factory.createInt(leftBigInteger);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to BigInteger as it claims to");
            }
            finally {
                gil.acquire();
            }
            return this.comparisonNode.executeObject(frame, leftInt, right);
        }

        @Specialization(guards={"lib.fitsInDouble(left)"})
        Object doComparisonDouble(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            double leftDouble;
            gil.release(true);
            try {
                leftDouble = lib.asDouble(left);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to double for comparison as it claims to");
            }
            finally {
                gil.acquire();
            }
            return this.comparisonNode.executeObject(frame, leftDouble, right);
        }

        @Specialization(guards={"lib.isNull(left)"})
        Object doComparison(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib) {
            return this.comparisonNode.executeObject(frame, PNone.NONE, right);
        }

        @Specialization(guards={"lib.isString(left)"})
        Object doComparisonString(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            TruffleString leftString;
            gil.release(true);
            try {
                leftString = switchEncodingNode.execute((AbstractTruffleString)lib.asTruffleString(left), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to string for comparison as it claims to");
            }
            finally {
                gil.acquire();
            }
            return this.comparisonNode.executeObject(frame, leftString, right);
        }

        @Fallback
        public static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__rdivmod__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RDivModNode
    extends ForeignBinaryNode {
        RDivModNode() {
            super(BinaryArithmetic.DivMod.create(), true);
        }
    }

    @Builtin(name="__divmod__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DivModNode
    extends ForeignBinaryNode {
        DivModNode() {
            super(BinaryArithmetic.DivMod.create(), false);
        }
    }

    @Builtin(name="__rfloordiv__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RFloorDivNode
    extends ForeignBinaryNode {
        RFloorDivNode() {
            super(BinaryArithmetic.FloorDiv.create(), true);
        }
    }

    @Builtin(name="__floordiv__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class FloorDivNode
    extends ForeignBinaryNode {
        FloorDivNode() {
            super(BinaryArithmetic.FloorDiv.create(), false);
        }
    }

    @Builtin(name="__rtruediv__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RTrueDivNode
    extends ForeignBinaryNode {
        RTrueDivNode() {
            super(BinaryArithmetic.TrueDiv.create(), true);
        }
    }

    @Builtin(name="__truediv__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class TrueDivNode
    extends ForeignBinaryNode {
        TrueDivNode() {
            super(BinaryArithmetic.TrueDiv.create(), false);
        }
    }

    @Builtin(name="__rsub__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RSubNode
    extends ForeignBinaryNode {
        RSubNode() {
            super(BinaryArithmetic.Sub.create(), true);
        }
    }

    @Builtin(name="__sub__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SubNode
    extends ForeignBinaryNode {
        SubNode() {
            super(BinaryArithmetic.Sub.create(), false);
        }
    }

    @Builtin(name="__rmul__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RMulNode
    extends MulNode {
        RMulNode() {
        }
    }

    @Builtin(name="__mul__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class MulNode
    extends ForeignBinaryNode {
        MulNode() {
            super(BinaryArithmetic.Mul.create(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(insertBefore="doComparisonBool", guards={"!lib.isBoolean(left)", "!lib.isNumber(left)", "!lib.isString(left)", "lib.hasArrayElements(left)", "lib.fitsInLong(right)"})
        static Object doForeignArray(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PForeignToPTypeNode convert, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached CastToJavaIntExactNode cast, @Cached.Shared @Cached GilNode gil) {
            gil.release(true);
            try {
                long rightLong;
                try {
                    rightLong = lib.asLong(right);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("object does not unpack to index-sized int as it claims to");
                }
                PythonAbstractObject pythonAbstractObject = MulNode.doMulArray(left, cast.execute(inliningTarget, rightLong), raise, factory, convert, lib);
                return pythonAbstractObject;
            }
            finally {
                gil.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(insertBefore="doComparisonBool", guards={"!lib.isBoolean(left)", "!lib.isNumber(left)", "!lib.isString(left)", "lib.hasArrayElements(left)", "lib.isBoolean(right)"})
        static Object doForeignArrayForeignBoolean(Object left, Object right, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached PythonObjectFactory factory, @Cached.Shared @Cached PForeignToPTypeNode convert, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            gil.release(true);
            try {
                boolean rightBoolean;
                try {
                    rightBoolean = lib.asBoolean(right);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("object does not unpack to boolean (to be used as index) as it claims to");
                }
                PythonAbstractObject pythonAbstractObject = MulNode.doMulArray(left, rightBoolean ? 1 : 0, raise, factory, convert, lib);
                return pythonAbstractObject;
            }
            finally {
                gil.acquire();
            }
        }

        private static PythonAbstractObject doMulArray(Object left, int rightInt, PRaiseNode raise, PythonObjectFactory factory, PForeignToPTypeNode convert, InteropLibrary lib) {
            try {
                Object[] unpackForeignArray = ForeignObjectBuiltins.unpackForeignArray(left, lib, convert);
                if (unpackForeignArray != null) {
                    if (rightInt < 0) {
                        return factory.createList();
                    }
                    Object[] repeatedData = new Object[Math.multiplyExact(unpackForeignArray.length, rightInt)];
                    for (int i = 0; i < rightInt; ++i) {
                        System.arraycopy(unpackForeignArray, 0, repeatedData, i * unpackForeignArray.length, unpackForeignArray.length);
                    }
                    return factory.createList(repeatedData);
                }
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            catch (ArithmeticException e) {
                throw raise.raise(PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @Builtin(name="__radd__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RAddNode
    extends AddNode {
        RAddNode() {
            super(true);
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AddNode
    extends ForeignBinaryNode {
        AddNode() {
            super(BinaryArithmetic.Add.create(), false);
        }

        AddNode(boolean reverse) {
            super(BinaryArithmetic.Add.create(), reverse);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(insertBefore="doGeneric", guards={"lib.hasArrayElements(left)", "lib.hasArrayElements(right)"})
        static Object doForeignArray(Object left, Object right, @Cached PythonObjectFactory factory, @CachedLibrary(limit="3") InteropLibrary lib, @Cached PForeignToPTypeNode convert, @Cached GilNode gil) {
            gil.release(true);
            try {
                Object[] unpackedLeft = ForeignObjectBuiltins.unpackForeignArray(left, lib, convert);
                Object[] unpackedRight = ForeignObjectBuiltins.unpackForeignArray(right, lib, convert);
                if (unpackedLeft != null && unpackedRight != null) {
                    Object[] result = Arrays.copyOf(unpackedLeft, unpackedLeft.length + unpackedRight.length);
                    System.arraycopy(unpackedRight, 0, result, unpackedLeft.length, unpackedRight.length);
                    PList pList = factory.createList(result);
                    return pList;
                }
            }
            finally {
                gil.acquire();
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    static abstract class ForeignBinaryNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private BinaryOpNode op;
        protected final boolean reverse;

        protected ForeignBinaryNode(BinaryOpNode op, boolean reverse) {
            this.op = op;
            this.reverse = reverse;
        }

        @Specialization(guards={"lib.isBoolean(left)"})
        Object doComparisonBool(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            boolean leftBoolean;
            gil.release(true);
            try {
                leftBoolean = lib.asBoolean(left);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to boolean as it claims to");
            }
            finally {
                gil.acquire();
            }
            if (!this.reverse) {
                return this.op.executeObject(frame, leftBoolean, right);
            }
            return this.op.executeObject(frame, right, leftBoolean);
        }

        @Specialization(guards={"lib.fitsInLong(left)"})
        Object doComparisonLong(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            long leftLong;
            assert (!lib.isBoolean(left));
            gil.release(true);
            try {
                leftLong = lib.asLong(left);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to long as it claims to");
            }
            finally {
                gil.acquire();
            }
            if (!this.reverse) {
                return this.op.executeObject(frame, leftLong, right);
            }
            return this.op.executeObject(frame, right, leftLong);
        }

        @Specialization(guards={"!lib.fitsInLong(left)", "lib.fitsInBigInteger(left)"})
        Object doComparisonBigInt(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil, @Cached.Exclusive @Cached PythonObjectFactory factory) {
            PInt leftInt;
            assert (!lib.isBoolean(left));
            gil.release(true);
            try {
                BigInteger leftBigInteger = lib.asBigInteger(left);
                leftInt = factory.createInt(leftBigInteger);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to BigInteger as it claims to");
            }
            finally {
                gil.acquire();
            }
            if (!this.reverse) {
                return this.op.executeObject(frame, leftInt, right);
            }
            return this.op.executeObject(frame, right, leftInt);
        }

        @Specialization(guards={"!lib.fitsInLong(left)", "!lib.fitsInBigInteger(left)", "lib.fitsInDouble(left)"})
        Object doComparisonDouble(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached.Shared @Cached GilNode gil) {
            double leftDouble;
            assert (!lib.isBoolean(left));
            gil.release(true);
            try {
                leftDouble = lib.asDouble(left);
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("object does not unpack to double as it claims to");
            }
            finally {
                gil.acquire();
            }
            if (!this.reverse) {
                return this.op.executeObject(frame, leftDouble, right);
            }
            return this.op.executeObject(frame, right, leftDouble);
        }

        @Specialization(guards={"!lib.fitsInLong(left)", "!lib.fitsInBigInteger(left)", "!lib.fitsInDouble(left)", "lib.isString(left)"})
        Object doComparisonString(VirtualFrame frame, Object left, Object right, @Cached.Shared @CachedLibrary(limit="3") InteropLibrary lib, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached.Shared @Cached GilNode gil) {
            TruffleString leftString;
            assert (!lib.isBoolean(left));
            gil.release(true);
            try {
                leftString = switchEncodingNode.execute((AbstractTruffleString)lib.asTruffleString(left), PythonUtils.TS_ENCODING);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
            if (!this.reverse) {
                return this.op.executeObject(frame, leftString, right);
            }
            return this.op.executeObject(frame, right, leftString);
        }

        @Fallback
        public static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__len__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class LenNode
    extends PythonUnaryBuiltinNode {
        LenNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static long len(Object self, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached GilNode gil, @Cached PRaiseNode.Lazy raiseNode) {
            gil.release(true);
            try {
                if (lib.hasArrayElements(self)) {
                    long l = lib.getArraySize(self);
                    return l;
                }
                if (lib.isIterator(self) || lib.hasIterator(self)) {
                    long l = 0L;
                    return l;
                }
                if (lib.hasHashEntries(self)) {
                    long l = lib.getHashSize(self);
                    return l;
                }
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
            }
            finally {
                gil.acquire();
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.FOREIGN_OBJ_HAS_NO_ATTR_S, SpecialMethodNames.T___LEN__);
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BoolNode
    extends PythonUnaryBuiltinNode {
        BoolNode() {
        }

        @Specialization(limit="getCallSiteInlineCacheMaxDepth()")
        static boolean bool(Object receiver, @CachedLibrary(value="receiver") InteropLibrary lib, @Cached GilNode gil) {
            gil.release(true);
            try {
                if (lib.isBoolean(receiver)) {
                    boolean bl = lib.asBoolean(receiver);
                    return bl;
                }
                if (lib.fitsInLong(receiver)) {
                    boolean bl = lib.asLong(receiver) != 0L;
                    return bl;
                }
                if (lib.fitsInBigInteger(receiver)) {
                    boolean bl = !BoolNode.isBigIntegerZero(lib.asBigInteger(receiver));
                    return bl;
                }
                if (lib.fitsInDouble(receiver)) {
                    boolean bl = lib.asDouble(receiver) != 0.0;
                    return bl;
                }
                if (lib.hasArrayElements(receiver)) {
                    boolean bl = lib.getArraySize(receiver) != 0L;
                    return bl;
                }
                if (lib.hasHashEntries(receiver)) {
                    boolean bl = lib.getHashSize(receiver) != 0L;
                    return bl;
                }
                if (lib.isString(receiver)) {
                    boolean bl = !lib.asTruffleString(receiver).isEmpty();
                    return bl;
                }
                boolean bl = !lib.isNull(receiver);
                return bl;
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            finally {
                gil.acquire();
            }
        }

        @CompilerDirectives.TruffleBoundary
        static boolean isBigIntegerZero(BigInteger number) {
            return number.compareTo(BigInteger.ZERO) == 0;
        }
    }
}

