/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.SystemExitBuiltinsFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.SystemExit})
public final class SystemExitBuiltins
extends PythonBuiltins {
    public static final BaseExceptionAttrNode.StorageFactory SYSTEM_EXIT_ATTR_FACTORY = (args, factory) -> new Object[]{switch (args.length) {
        case 0 -> PNone.NONE;
        case 1 -> args[0];
        default -> factory.createTuple(args);
    }};

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SystemExitBuiltinsFactory.getFactories();
    }

    @Builtin(name="code", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception code")
    @GenerateNodeFactory
    public static abstract class CodeNode
    extends PythonBuiltinNode {
        @Specialization
        static Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, SYSTEM_EXIT_ATTR_FACTORY);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBuiltinNode {
        @Specialization
        static Object initNoArgs(PBaseException self, Object[] args, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseExceptionInitNode, @Cached PythonObjectFactory factory) {
            baseExceptionInitNode.execute(self, args);
            self.setExceptionAttributes(SYSTEM_EXIT_ATTR_FACTORY.create(args, factory));
            return PNone.NONE;
        }
    }
}

