/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.formatting.ErrorMessageFormatter;
import com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PBaseException
extends PythonObject {
    public static final TruffleString T_CODE = PythonUtils.tsLiteral("code");
    private PTuple args;
    private final boolean hasMessageFormat;
    private final TruffleString messageFormat;
    private final Object[] messageArgs;
    private PException exception;
    private LazyTraceback traceback;
    private Object context;
    private Object cause;
    private boolean suppressContext = false;
    private Object[] exceptionAttributes;

    public PBaseException(Object cls, Shape instanceShape, Object[] exceptionAttributes, PTuple args) {
        super(cls, instanceShape);
        assert (!TypeNodes.NeedsNativeAllocationNode.executeUncached(cls));
        this.exceptionAttributes = exceptionAttributes;
        this.args = args;
        this.hasMessageFormat = false;
        this.messageFormat = null;
        this.messageArgs = null;
    }

    public PBaseException(Object cls, Shape instanceShape, Object[] exceptionAttributes) {
        super(cls, instanceShape);
        assert (!TypeNodes.NeedsNativeAllocationNode.executeUncached(cls));
        assert (!(cls instanceof PythonNativeClass));
        this.exceptionAttributes = exceptionAttributes;
        this.args = null;
        this.hasMessageFormat = false;
        this.messageFormat = null;
        this.messageArgs = null;
    }

    public PBaseException(Object cls, Shape instanceShape, Object[] exceptionAttributes, TruffleString format, Object[] formatArgs) {
        super(cls, instanceShape);
        assert (!TypeNodes.NeedsNativeAllocationNode.executeUncached(cls));
        this.exceptionAttributes = exceptionAttributes;
        this.args = null;
        this.hasMessageFormat = true;
        this.messageFormat = format;
        this.messageArgs = formatArgs;
    }

    public Object getExceptionAttribute(int idx) {
        assert (this.exceptionAttributes != null) : "PBaseException internal attributes are null";
        assert (idx >= 0 && idx < this.exceptionAttributes.length) : "index to access PBaseException internal attributes is out of range";
        return this.exceptionAttributes[idx];
    }

    public Object[] getExceptionAttributes() {
        return this.exceptionAttributes;
    }

    public void setExceptionAttributes(Object[] exceptionAttributes) {
        TruffleStringMigrationHelpers.assertContainsNoJavaString(exceptionAttributes);
        this.exceptionAttributes = exceptionAttributes;
    }

    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        assert (context == null || PyExceptionInstanceCheckNode.executeUncached(context));
        this.context = context;
    }

    public Object getCause() {
        return this.cause;
    }

    public void setCause(Object cause) {
        assert (cause == null || PyExceptionInstanceCheckNode.executeUncached(cause));
        this.cause = cause;
        this.suppressContext = true;
    }

    public boolean getSuppressContext() {
        return this.suppressContext;
    }

    public void setSuppressContext(boolean suppressContext) {
        this.suppressContext = suppressContext;
    }

    public PException getException() {
        return this.exception;
    }

    public void setException(PException exception) {
        this.ensureReified();
        this.exception = exception;
    }

    private void ensureReified() {
        if (this.exception != null) {
            this.exception.ensureReified();
        }
    }

    public LazyTraceback getTraceback() {
        this.ensureReified();
        return this.traceback;
    }

    public void setTraceback(LazyTraceback traceback) {
        this.ensureReified();
        this.traceback = traceback;
    }

    public void setTraceback(PTraceback traceback) {
        this.setTraceback(new LazyTraceback(traceback));
    }

    public void clearTraceback() {
        this.traceback = null;
    }

    public PTuple getArgs() {
        return this.args;
    }

    public void setArgs(PTuple args) {
        this.args = args;
    }

    public TruffleString getMessageFormat() {
        return this.messageFormat;
    }

    public boolean hasMessageFormat() {
        return this.hasMessageFormat;
    }

    public Object[] getMessageArgs() {
        return this.messageArgs != null ? (Object[])this.messageArgs.clone() : PythonUtils.EMPTY_OBJECT_ARRAY;
    }

    @CompilerDirectives.TruffleBoundary
    public String getFormattedMessage() {
        Object clazz = GetClassNode.GetPythonObjectClassNode.executeUncached(this);
        String typeName = TypeNodes.GetNameNode.doSlowPath(clazz).toJavaStringUncached();
        if (this.args == null) {
            if (this.messageArgs != null && this.messageArgs.length > 0) {
                return typeName + ": " + ErrorMessageFormatter.format(this.messageFormat.toJavaStringUncached(), this.getMessageArgs());
            }
            if (this.hasMessageFormat) {
                return typeName + ": " + this.messageFormat.toJavaStringUncached();
            }
            return typeName;
        }
        if (this.args.getSequenceStorage().length() == 0) {
            return typeName;
        }
        if (this.args.getSequenceStorage().length() == 1) {
            SequenceStorage store = this.args.getSequenceStorage();
            String item = store instanceof BasicSequenceStorage ? store.getItemNormalized(0) : "<unknown>";
            return typeName + ": " + item.toString();
        }
        return typeName + ": " + this.args.toString();
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder sb = new StringBuilder(this.getInitialPythonClass().toString());
        if (this.messageArgs != null && this.messageArgs.length > 0) {
            sb.append("(fmt=\"").append(this.messageFormat.toJavaStringUncached()).append("\", args = (");
            for (Object arg : this.messageArgs) {
                if (arg instanceof TruffleString) {
                    sb.append('\"').append(arg).append('\"');
                } else if (arg instanceof PythonObject) {
                    sb.append(arg);
                } else {
                    String fqn = arg.getClass().getName();
                    if (fqn.startsWith("java.lang.")) {
                        sb.append(arg);
                    } else {
                        sb.append("a ").append(fqn);
                    }
                }
                sb.append(", ");
            }
            sb.append(") )");
        } else if (this.hasMessageFormat) {
            sb.append("(\"").append(this.messageFormat.toJavaStringUncached()).append("\")");
        }
        return sb.toString();
    }

    public LazyTraceback internalReifyException(PFrame.Reference curFrameInfo) {
        assert (curFrameInfo != PFrame.Reference.EMPTY);
        this.traceback = new LazyTraceback(curFrameInfo, this.exception, this.traceback);
        return this.traceback;
    }

    public PException getExceptionForReraise(LazyTraceback reraiseTraceback) {
        this.setTraceback(reraiseTraceback);
        return PException.fromObject((Object)this, this.exception.getLocation(), false);
    }

    @ExportMessage
    boolean isException() {
        return true;
    }

    @ExportMessage
    RuntimeException throwException(@Cached PRaiseNode raiseNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            throw raiseNode.raiseExceptionObject(this);
        }
        catch (Throwable throwable) {
            gil.release(mustRelease);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    ExceptionType getExceptionType(@Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            Object clazz = getClassNode.execute(inliningTarget, this);
            if (clazz instanceof PythonBuiltinClass) {
                clazz = ((PythonBuiltinClass)clazz).getType();
            }
            if (clazz == PythonBuiltinClassType.SyntaxError || clazz == PythonBuiltinClassType.IndentationError || clazz == PythonBuiltinClassType.TabError) {
                ExceptionType exceptionType = ExceptionType.PARSE_ERROR;
                return exceptionType;
            }
            if (clazz == PythonBuiltinClassType.SystemExit) {
                ExceptionType exceptionType = ExceptionType.EXIT;
                return exceptionType;
            }
            ExceptionType exceptionType = ExceptionType.RUNTIME_ERROR;
            return exceptionType;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    boolean isExceptionIncompleteSource() {
        return false;
    }

    @ExportMessage
    boolean hasExceptionMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    String getExceptionMessage(@Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            String string = this.getFormattedMessage();
            return string;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    int getExceptionExitStatus(@Cached CastToJavaIntExactNode castToInt, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached ReadAttributeFromDynamicObjectNode readNode, @Cached.Exclusive @Cached InlinedBranchProfile unsupportedProfile, @Cached.Shared(value="gil") @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (this.getExceptionType(inliningTarget, getClassNode, gil) == ExceptionType.EXIT) {
                Object code;
                block11: {
                    try {
                        code = readNode.execute((Object)this, T_CODE);
                        if (code != PNone.NO_VALUE) break block11;
                        int n = 1;
                        return n;
                    }
                    catch (PException e) {
                        int n = 1;
                        return n;
                    }
                }
                int n = castToInt.execute(inliningTarget, code);
                return n;
            }
            unsupportedProfile.enter(inliningTarget);
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    boolean hasExceptionCause(@Cached.Shared(value="gil") @Cached GilNode gil) {
        boolean mustRelease = gil.acquire();
        try {
            boolean bl = this.cause != null || !this.suppressContext && this.context != null;
            return bl;
        }
        finally {
            gil.release(mustRelease);
        }
    }

    @ExportMessage
    Object getExceptionCause(@Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedBranchProfile unsupportedProfile, @Cached.Shared(value="gil") @Cached GilNode gil) throws UnsupportedMessageException {
        boolean mustRelease = gil.acquire();
        try {
            if (this.cause != null) {
                Object object = this.cause;
                return object;
            }
            if (!this.suppressContext && this.context != null) {
                Object object = this.context;
                return object;
            }
            unsupportedProfile.enter(inliningTarget);
            throw UnsupportedMessageException.create();
        }
        finally {
            gil.release(mustRelease);
        }
    }
}

