/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMapFactory;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public final class ObjectHashMap {
    private static final int INITIAL_INDICES_SIZE = 8;
    private static final int MAX_PREALLOCATED_INDICES_SIZE = 0x100000;
    private static final int COLLISION_MASK = Integer.MIN_VALUE;
    private static final int DUMMY_INDEX = -2;
    private static final int EMPTY_INDEX = -1;
    private static final int GROWTH_RATE = 4;
    private static final long PERTURB_SHIFT = 5L;
    private static final int PERTURB_SHIFTS_COUT = 13;
    private int[] indices;
    long[] hashes;
    Object[] keysAndValues;
    int size;
    int usedHashes;
    int usedIndices;
    boolean hasSideEffectingKeys;

    private static void markCollision(int[] indices, int compactIndex) {
        assert (indices[compactIndex] != -1);
        indices[compactIndex] = indices[compactIndex] | Integer.MIN_VALUE;
    }

    private static boolean isCollision(int index) {
        return (index & Integer.MIN_VALUE) != 0;
    }

    private static int unwrapIndex(int value) {
        return value & Integer.MAX_VALUE;
    }

    public ObjectHashMap(int capacity, boolean hasSideEffects) {
        if (capacity <= 8) {
            this.allocateData(8);
        } else {
            int indicesCapacity = capacity + capacity / 3;
            if (indicesCapacity < 0 || indicesCapacity > 0x100000) {
                this.allocateData(0x100000);
            } else {
                int pow2 = ObjectHashMap.getNextPow2(indicesCapacity);
                assert (pow2 > 8);
                this.allocateData(pow2);
            }
        }
        this.hasSideEffectingKeys = hasSideEffects;
    }

    public ObjectHashMap() {
        this.allocateData(8);
    }

    public ObjectHashMap(boolean hasSideEffects) {
        this.allocateData(8);
        this.hasSideEffectingKeys = hasSideEffects;
    }

    private void allocateData(int newSize) {
        assert (ObjectHashMap.isPow2(newSize));
        this.indices = new int[newSize];
        Arrays.fill(this.indices, -1);
        int quarter = newSize >> 2;
        int usableSize = 3 * quarter + 2;
        this.hashes = new long[usableSize];
        this.keysAndValues = new Object[usableSize * 2];
    }

    public void setSideEffectingKeysFlag() {
        this.hasSideEffectingKeys = true;
    }

    public void clear() {
        this.size = 0;
        this.usedHashes = 0;
        this.usedIndices = 0;
        this.allocateData(8);
    }

    public ObjectHashMap copy() {
        ObjectHashMap result = new ObjectHashMap();
        result.size = this.size;
        result.usedHashes = this.usedHashes;
        result.usedIndices = this.usedIndices;
        result.hashes = PythonUtils.arrayCopyOf(this.hashes, this.hashes.length);
        result.indices = PythonUtils.arrayCopyOf(this.indices, this.indices.length);
        result.keysAndValues = PythonUtils.arrayCopyOf(this.keysAndValues, this.keysAndValues.length);
        result.hasSideEffectingKeys = this.hasSideEffectingKeys;
        return result;
    }

    public MapCursor getEntries() {
        return new MapCursor();
    }

    public boolean hasSideEffect() {
        return this.hasSideEffectingKeys;
    }

    private static int getBucketsCount(int[] indices) {
        return indices.length;
    }

    private boolean needsResize(int[] localIndices) {
        int bucketsCount = ObjectHashMap.getBucketsCount(localIndices);
        int bucketsCntQuarter = Math.max(1, bucketsCount >> 2);
        return this.usedIndices + bucketsCntQuarter > bucketsCount;
    }

    public int size() {
        return this.size;
    }

    private void insertNewKey(int[] localIndices, Object key, long keyHash, Object value) {
        assert (localIndices == this.indices);
        int compactIndex = ObjectHashMap.getIndex(localIndices.length, keyHash);
        int index = localIndices[compactIndex];
        if (index == -1) {
            this.putInNewSlot(localIndices, key, keyHash, value, compactIndex);
            return;
        }
        ObjectHashMap.markCollision(localIndices, compactIndex);
        long perturb = keyHash;
        int searchLimit = ObjectHashMap.getBucketsCount(localIndices) + 13;
        for (int i = 0; i < searchLimit; ++i) {
            index = localIndices[compactIndex = ObjectHashMap.nextIndex(localIndices.length, compactIndex, perturb >>>= 5)];
            if (index == -1) {
                this.putInNewSlot(localIndices, key, keyHash, value, compactIndex);
                return;
            }
            ObjectHashMap.markCollision(localIndices, compactIndex);
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private void putInNewSlot(int[] localIndices, Node inliningTarget, InlinedBranchProfile rehashProfile, Object key, long keyHash, Object value, int compactIndex) {
        assert (this.indices == localIndices);
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (boolean)this.needsResize(localIndices))) {
            rehashProfile.enter(inliningTarget);
            this.rehashAndPut(key, keyHash, value);
            return;
        }
        this.putInNewSlot(localIndices, key, keyHash, value, compactIndex);
    }

    private void putInNewSlot(int[] localIndices, Object key, long keyHash, Object value, int compactIndex) {
        int newIndex;
        ++this.size;
        ++this.usedIndices;
        localIndices[compactIndex] = newIndex = this.usedHashes++;
        this.setValue(newIndex, value);
        this.setKey(newIndex, key);
        this.hashes[newIndex] = keyHash;
    }

    private boolean needsCompaction() {
        int dummyCnt = this.usedHashes - this.size;
        int quarterOfUsable = this.hashes.length >> 2;
        return dummyCnt > quarterOfUsable;
    }

    private boolean keysEqual(int[] originalIndices, Frame frame, Node inliningTarget, int index, Object key, long keyHash, PyObjectRichCompareBool.EqNode eqNode) throws RestartLookupException {
        if (this.hashes[index] != keyHash) {
            return false;
        }
        Object originalKey = this.getKey(index);
        if (originalKey == key) {
            return true;
        }
        if (CompilerDirectives.inInterpreter() && eqNode == null) {
            return ObjectHashMap.javaEquals(originalKey, key);
        }
        boolean result = eqNode.compare(frame, inliningTarget, originalKey, key);
        if (this.getKey(index) != originalKey || this.indices != originalIndices) {
            throw RestartLookupException.INSTANCE;
        }
        return result;
    }

    private static boolean javaEquals(Object a, Object b) {
        CompilerAsserts.neverPartOfCompilation();
        assert (ObjectHashMap.isJavaEqualsAllowed(a)) : a;
        assert (ObjectHashMap.isJavaEqualsAllowed(b)) : b;
        return a.equals(b);
    }

    private static boolean isJavaEqualsAllowed(Object o) {
        return o instanceof PythonManagedClass || o instanceof PythonBuiltinClassType || o instanceof PythonNativeClass || o instanceof Number || o instanceof TruffleString;
    }

    @CompilerDirectives.TruffleBoundary
    private void rehashAndPut(Object newKey, long newKeyHash, Object newValue) {
        int requiredIndicesSize = this.usedHashes * 4;
        int indicesCapacity = requiredIndicesSize + requiredIndicesSize / 3;
        if (indicesCapacity < 8) {
            indicesCapacity = 8;
        } else if ((indicesCapacity = ObjectHashMap.getNextPow2(indicesCapacity)) << 1 < 0) {
            throw new OutOfMemoryError();
        }
        long[] oldHashes = this.hashes;
        Object[] oldKeysAndValues = this.keysAndValues;
        int oldUsedSize = this.usedHashes;
        int oldSize = this.size;
        this.allocateData(indicesCapacity);
        this.size = 0;
        this.usedHashes = 0;
        this.usedIndices = 0;
        int[] localIndices = this.indices;
        for (int i = 0; i < oldUsedSize; ++i) {
            if (ObjectHashMap.getValue(i, oldKeysAndValues) == null) continue;
            Object key = ObjectHashMap.getKey(i, oldKeysAndValues);
            this.insertNewKey(localIndices, key, oldHashes[i], ObjectHashMap.getValue(i, oldKeysAndValues));
        }
        assert (this.size == oldSize) : String.format("size=%d, oldSize=%d, oldUsedSize=%d, usedHashes=%d, usedIndices=%d", this.size, oldSize, oldUsedSize, this.usedHashes, this.usedIndices);
        this.insertNewKey(localIndices, newKey, newKeyHash, newValue);
    }

    @CompilerDirectives.TruffleBoundary
    private void compact() {
        int[] shuffle = new int[this.hashes.length];
        int currentShuffle = 0;
        int dummyCount = 0;
        for (int i = 0; i < this.usedHashes; ++i) {
            Object value = this.getValue(i);
            if (value == null) {
                ++currentShuffle;
                ++dummyCount;
                continue;
            }
            if (currentShuffle <= 0) continue;
            assert (this.getValue(i - currentShuffle) == null);
            assert (this.getKey(i - currentShuffle) == null);
            this.setValue(i - currentShuffle, value);
            this.setKey(i - currentShuffle, this.getKey(i));
            this.setValue(i, null);
            this.setKey(i, null);
            this.hashes[i - currentShuffle] = this.hashes[i];
            shuffle[i] = currentShuffle;
        }
        this.usedHashes -= dummyCount;
        int[] localIndices = this.indices;
        for (int i = 0; i < localIndices.length; ++i) {
            int index = localIndices[i];
            if (index != -1 && index != -2) {
                int newIndex;
                boolean collision = ObjectHashMap.isCollision(index);
                int unwrapped = ObjectHashMap.unwrapIndex(index);
                localIndices[i] = newIndex = unwrapped - shuffle[unwrapped];
                if (!collision) continue;
                ObjectHashMap.markCollision(localIndices, i);
                continue;
            }
            if (index != -2) continue;
            --dummyCount;
        }
        assert (dummyCount <= 0);
    }

    private static int nextIndex(int indicesLen, int i, long perturb) {
        return ObjectHashMap.getIndex(indicesLen, (long)i * 5L + perturb + 1L);
    }

    private static int getIndex(int indicesLen, long hash) {
        return (int)(hash & (long)(indicesLen - 1));
    }

    public static Object getKey(int index, Object[] keysAndValues) {
        return keysAndValues[index << 1];
    }

    public static Object getValue(int index, Object[] keysAndValues) {
        return keysAndValues[(index << 1) + 1];
    }

    public Object getKey(int index) {
        return ObjectHashMap.getKey(index, this.keysAndValues);
    }

    public Object getValue(int index) {
        return ObjectHashMap.getValue(index, this.keysAndValues);
    }

    public void setValue(int index, Object value) {
        this.keysAndValues[(index << 1) + 1] = value;
    }

    public void setKey(int index, Object key) {
        this.keysAndValues[index << 1] = key;
    }

    private boolean checkInternalState() {
        assert (this.usedIndices < this.indices.length) : this.usedIndices;
        return true;
    }

    private static int getNextPow2(int n) {
        if (ObjectHashMap.isPow2(n)) {
            return n;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n);
    }

    private static boolean isPow2(int n) {
        return Integer.bitCount(n) == 1;
    }

    public final class MapCursor {
        private int index = -1;

        private void moveToNextValue() {
            while (this.index < ObjectHashMap.this.usedHashes && ObjectHashMap.this.getValue(this.index) == null) {
                ++this.index;
            }
        }

        public boolean advance() {
            ++this.index;
            this.moveToNextValue();
            return this.index < ObjectHashMap.this.usedHashes;
        }

        public DictKey getKey() {
            return new DictKey(ObjectHashMap.this.getKey(this.index), ObjectHashMap.this.hashes[this.index]);
        }

        public Object getValue() {
            return ObjectHashMap.this.getValue(this.index);
        }
    }

    private static final class RestartLookupException
    extends Exception {
        private static final long serialVersionUID = -5517471989238569331L;
        private static final RestartLookupException INSTANCE = new RestartLookupException();

        public RestartLookupException() {
            super(null, null);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class RemoveNode
    extends Node {
        public abstract Object execute(Frame var1, Node var2, ObjectHashMap var3, Object var4, long var5);

        @Specialization
        public static Object doRemoveWithRestart(Frame frame, Node inliningTarget, ObjectHashMap map, Object key, long keyHash, @Cached InlinedBranchProfile lookupRestart, @Cached InlinedCountingConditionProfile foundNullKey, @Cached InlinedCountingConditionProfile foundEqKey, @Cached InlinedCountingConditionProfile collisionFoundNoValue, @Cached InlinedCountingConditionProfile collisionFoundEqKey, @Cached InlinedBranchProfile compactProfile, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            while (true) {
                try {
                    return RemoveNode.doRemove(frame, inliningTarget, map, key, keyHash, foundNullKey, foundEqKey, collisionFoundNoValue, collisionFoundEqKey, compactProfile, eqNode);
                }
                catch (RestartLookupException ignore) {
                    lookupRestart.enter(inliningTarget);
                    continue;
                }
                break;
            }
        }

        static Object doRemove(Frame frame, Node inliningTarget, ObjectHashMap map, Object key, long keyHash, InlinedCountingConditionProfile foundNullKey, InlinedCountingConditionProfile foundEqKey, InlinedCountingConditionProfile collisionFoundNoValue, InlinedCountingConditionProfile collisionFoundEqKey, InlinedBranchProfile compactProfile, PyObjectRichCompareBool.EqNode eqNode) throws RestartLookupException {
            int indicesLen;
            int compactIndex;
            int[] indices;
            int index;
            assert (map.checkInternalState());
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (boolean)map.needsCompaction())) {
                compactProfile.enter(inliningTarget);
                map.compact();
            }
            if (foundNullKey.profile(inliningTarget, (index = (indices = map.indices)[compactIndex = ObjectHashMap.getIndex(indicesLen = indices.length, keyHash)]) == -1)) {
                return null;
            }
            int unwrappedIndex = ObjectHashMap.unwrapIndex(index);
            if (foundEqKey.profile(inliningTarget, index != -2 && map.keysEqual(indices, frame, inliningTarget, unwrappedIndex, key, keyHash, eqNode))) {
                Object result = map.getValue(unwrappedIndex);
                indices[compactIndex] = -2;
                map.setValue(unwrappedIndex, null);
                map.setKey(unwrappedIndex, null);
                --map.size;
                return result;
            }
            return RemoveNode.removeCollision(frame, inliningTarget, map, key, keyHash, collisionFoundNoValue, collisionFoundEqKey, eqNode, indices, indicesLen, compactIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @HostCompilerDirectives.InliningCutoff
        private static Object removeCollision(Frame frame, Node inliningTarget, ObjectHashMap map, Object key, long keyHash, InlinedCountingConditionProfile collisionFoundNoValue, InlinedCountingConditionProfile collisionFoundEqKey, PyObjectRichCompareBool.EqNode eqNode, int[] indices, int indicesLen, int compactIndex) throws RestartLookupException {
            int i;
            long perturb = keyHash;
            int searchLimit = ObjectHashMap.getBucketsCount(indices) + 13;
            try {
                for (i = 0; i < searchLimit; ++i) {
                    if (indices != map.indices) {
                        throw RestartLookupException.INSTANCE;
                    }
                    int index = indices[compactIndex = ObjectHashMap.nextIndex(indicesLen, compactIndex, perturb >>>= 5)];
                    if (collisionFoundNoValue.profile(inliningTarget, index == -1)) {
                        Object var18_16 = null;
                        return var18_16;
                    }
                    int unwrappedIndex = ObjectHashMap.unwrapIndex(index);
                    if (!collisionFoundEqKey.profile(inliningTarget, index != -2 && map.keysEqual(indices, frame, inliningTarget, unwrappedIndex, key, keyHash, eqNode))) continue;
                    Object result = map.getValue(unwrappedIndex);
                    indices[compactIndex] = -2;
                    map.setValue(unwrappedIndex, null);
                    map.setKey(unwrappedIndex, null);
                    --map.size;
                    Object object = result;
                    return object;
                }
            }
            finally {
                LoopNode.reportLoopCount((Node)eqNode, (int)i);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PutNode
    extends Node {
        public final void put(Frame frame, Node inliningTarget, ObjectHashMap map, DictKey key, Object value) {
            this.execute(frame, inliningTarget, map, key.getValue(), key.getPythonHash(), value);
        }

        public final void put(Frame frame, Node inliningTarget, ObjectHashMap map, Object key, long keyHash, Object value) {
            this.execute(frame, inliningTarget, map, key, keyHash, value);
        }

        public static void putUncached(ObjectHashMap map, Object key, long keyHash, Object value) {
            ObjectHashMapFactory.PutNodeGen.getUncached().execute(null, null, map, key, keyHash, value);
        }

        abstract void execute(Frame var1, Node var2, ObjectHashMap var3, Object var4, long var5, Object var7);

        static void putUncachedWithJavaEq(ObjectHashMap map, Object key, long keyHash, Object value) {
            assert (ObjectHashMap.isJavaEqualsAllowed(key)) : key;
            PutNode.doPutWithRestart(null, null, map, key, keyHash, value, InlinedBranchProfile.getUncached(), InlinedCountingConditionProfile.getUncached(), InlinedCountingConditionProfile.getUncached(), InlinedCountingConditionProfile.getUncached(), InlinedCountingConditionProfile.getUncached(), InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached(), null);
        }

        @Specialization
        public static void doPutWithRestart(Frame frame, Node inliningTarget, ObjectHashMap map, Object key, long keyHash, Object value, @Cached InlinedBranchProfile lookupRestart, @Cached InlinedCountingConditionProfile foundNullKey, @Cached InlinedCountingConditionProfile foundEqKey, @Cached InlinedCountingConditionProfile collisionFoundNoValue, @Cached InlinedCountingConditionProfile collisionFoundEqKey, @Cached InlinedBranchProfile rehash1Profile, @Cached InlinedBranchProfile rehash2Profile, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            assert (map.size == 0 || SpecialMethodSlot.areBuiltinSlotsInitialized() || eqNode == null);
            while (true) {
                try {
                    PutNode.doPut(frame, map, key, keyHash, value, inliningTarget, foundNullKey, foundEqKey, collisionFoundNoValue, collisionFoundEqKey, rehash1Profile, rehash2Profile, eqNode);
                    return;
                }
                catch (RestartLookupException ignore) {
                    lookupRestart.enter(inliningTarget);
                    continue;
                }
                break;
            }
        }

        static void doPut(Frame frame, ObjectHashMap map, Object key, long keyHash, Object value, Node inliningTarget, InlinedCountingConditionProfile foundNullKey, InlinedCountingConditionProfile foundEqKey, InlinedCountingConditionProfile collisionFoundNoValue, InlinedCountingConditionProfile collisionFoundEqKey, InlinedBranchProfile rehash1Profile, InlinedBranchProfile rehash2Profile, PyObjectRichCompareBool.EqNode eqNode) throws RestartLookupException {
            assert (map.checkInternalState());
            int[] indices = map.indices;
            int indicesLen = indices.length;
            int compactIndex = ObjectHashMap.getIndex(indicesLen, keyHash);
            int index = indices[compactIndex];
            if (foundNullKey.profile(inliningTarget, index == -1)) {
                map.putInNewSlot(indices, inliningTarget, rehash1Profile, key, keyHash, value, compactIndex);
                return;
            }
            if (foundEqKey.profile(inliningTarget, index != -2 && map.keysEqual(indices, frame, inliningTarget, ObjectHashMap.unwrapIndex(index), key, keyHash, eqNode))) {
                map.setValue(ObjectHashMap.unwrapIndex(index), value);
                return;
            }
            PutNode.putCollision(frame, map, key, keyHash, value, inliningTarget, collisionFoundNoValue, collisionFoundEqKey, rehash2Profile, eqNode, indices, indicesLen, compactIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @HostCompilerDirectives.InliningCutoff
        private static void putCollision(Frame frame, ObjectHashMap map, Object key, long keyHash, Object value, Node inliningTarget, InlinedCountingConditionProfile collisionFoundNoValue, InlinedCountingConditionProfile collisionFoundEqKey, InlinedBranchProfile rehash2Profile, PyObjectRichCompareBool.EqNode eqNode, int[] indices, int indicesLen, int compactIndex) throws RestartLookupException {
            int i;
            ObjectHashMap.markCollision(indices, compactIndex);
            long perturb = keyHash;
            int searchLimit = ObjectHashMap.getBucketsCount(indices) + 13;
            try {
                for (i = 0; i < searchLimit; ++i) {
                    if (indices != map.indices) {
                        throw RestartLookupException.INSTANCE;
                    }
                    int index = indices[compactIndex = ObjectHashMap.nextIndex(indicesLen, compactIndex, perturb >>>= 5)];
                    if (collisionFoundNoValue.profile(inliningTarget, index == -1)) {
                        map.putInNewSlot(indices, inliningTarget, rehash2Profile, key, keyHash, value, compactIndex);
                        return;
                    }
                    if (collisionFoundEqKey.profile(inliningTarget, index != -2 && map.keysEqual(indices, frame, inliningTarget, ObjectHashMap.unwrapIndex(index), key, keyHash, eqNode))) {
                        map.setValue(ObjectHashMap.unwrapIndex(index), value);
                        return;
                    }
                    ObjectHashMap.markCollision(indices, compactIndex);
                }
            }
            finally {
                LoopNode.reportLoopCount((Node)eqNode, (int)i);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetNode
    extends Node {
        public abstract Object execute(Frame var1, Node var2, ObjectHashMap var3, Object var4, long var5);

        @Specialization
        public static Object doGetWithRestart(Frame frame, Node inliningTarget, ObjectHashMap map, Object key, long keyHash, @Cached InlinedBranchProfile lookupRestart, @Cached InlinedCountingConditionProfile foundNullKey, @Cached InlinedCountingConditionProfile foundSameHashKey, @Cached InlinedCountingConditionProfile foundEqKey, @Cached InlinedCountingConditionProfile collisionFoundNoValue, @Cached InlinedCountingConditionProfile collisionFoundEqKey, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            assert (map.size == 0 || SpecialMethodSlot.areBuiltinSlotsInitialized());
            while (true) {
                try {
                    return GetNode.doGet(frame, map, key, keyHash, inliningTarget, foundNullKey, foundSameHashKey, foundEqKey, collisionFoundNoValue, collisionFoundEqKey, eqNode);
                }
                catch (RestartLookupException ignore) {
                    lookupRestart.enter(inliningTarget);
                    continue;
                }
                break;
            }
        }

        static Object doGet(Frame frame, ObjectHashMap map, Object key, long keyHash, Node inliningTarget, InlinedCountingConditionProfile foundNullKey, InlinedCountingConditionProfile foundSameHashKey, InlinedCountingConditionProfile foundEqKey, InlinedCountingConditionProfile collisionFoundNoValue, InlinedCountingConditionProfile collisionFoundEqKey, PyObjectRichCompareBool.EqNode eqNode) throws RestartLookupException {
            assert (map.checkInternalState());
            int[] indices = map.indices;
            int indicesLen = indices.length;
            int compactIndex = ObjectHashMap.getIndex(indicesLen, keyHash);
            int index = indices[compactIndex];
            if (foundNullKey.profile(inliningTarget, index == -1)) {
                return null;
            }
            if (foundSameHashKey.profile(inliningTarget, index != -2)) {
                int unwrappedIndex = ObjectHashMap.unwrapIndex(index);
                if (foundEqKey.profile(inliningTarget, map.keysEqual(indices, frame, inliningTarget, unwrappedIndex, key, keyHash, eqNode))) {
                    return map.getValue(unwrappedIndex);
                }
                if (!ObjectHashMap.isCollision(indices[compactIndex])) {
                    return null;
                }
            }
            return GetNode.getCollision(frame, map, key, keyHash, inliningTarget, collisionFoundNoValue, collisionFoundEqKey, eqNode, indices, indicesLen, compactIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @HostCompilerDirectives.InliningCutoff
        private static Object getCollision(Frame frame, ObjectHashMap map, Object key, long keyHash, Node inliningTarget, InlinedCountingConditionProfile collisionFoundNoValue, InlinedCountingConditionProfile collisionFoundEqKey, PyObjectRichCompareBool.EqNode eqNode, int[] indices, int indicesLen, int compactIndex) throws RestartLookupException {
            int i;
            long perturb = keyHash;
            int searchLimit = ObjectHashMap.getBucketsCount(indices) + 13;
            try {
                for (i = 0; i < searchLimit; ++i) {
                    if (indices != map.indices) {
                        throw RestartLookupException.INSTANCE;
                    }
                    int index = map.indices[compactIndex = ObjectHashMap.nextIndex(indicesLen, compactIndex, perturb >>>= 5)];
                    if (collisionFoundNoValue.profile(inliningTarget, index == -1)) {
                        Object var17_16 = null;
                        return var17_16;
                    }
                    if (index == -2) continue;
                    int unwrappedIndex = ObjectHashMap.unwrapIndex(index);
                    if (collisionFoundEqKey.profile(inliningTarget, map.keysEqual(indices, frame, inliningTarget, unwrappedIndex, key, keyHash, eqNode))) {
                        Object object = map.getValue(unwrappedIndex);
                        return object;
                    }
                    if (ObjectHashMap.isCollision(indices[compactIndex])) continue;
                    Object var18_18 = null;
                    return var18_18;
                }
            }
            finally {
                LoopNode.reportLoopCount((Node)eqNode, (int)i);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @CompilerDirectives.ValueType
    public static final class DictKey {
        private final Object value;
        private final long hash;

        DictKey(Object value, long hash) {
            this.value = value;
            this.hash = hash;
        }

        public Object getValue() {
            return this.value;
        }

        public long getPythonHash() {
            return this.hash;
        }
    }
}

