/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ManagedMethodWrappers;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.SlotMethodDef;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.LookupNativeSlotNode;
import com.oracle.graal.python.nodes.attributes.LookupNativeSlotNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.HiddenKey;

public abstract class ToNativeTypeNode {
    private static Object getValue(PythonManagedClass obj, SlotMethodDef slot) {
        return LookupNativeSlotNode.executeUncached(obj, slot);
    }

    private static Object allocatePyMappingMethods(PythonManagedClass obj) {
        Object mem = CStructAccess.AllocateNode.getUncached().alloc(CStructs.PyMappingMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        writePointerNode.write(mem, CFields.PyMappingMethods__mp_length, ToNativeTypeNode.getValue(obj, SlotMethodDef.MP_LENGTH));
        writePointerNode.write(mem, CFields.PyMappingMethods__mp_subscript, ToNativeTypeNode.getValue(obj, SlotMethodDef.MP_SUBSCRIPT));
        writePointerNode.write(mem, CFields.PyMappingMethods__mp_ass_subscript, ToNativeTypeNode.getValue(obj, SlotMethodDef.MP_ASS_SUBSCRIPT));
        return mem;
    }

    private static Object allocatePyNumberMethods(PythonManagedClass obj, Object nullValue) {
        Object mem = CStructAccess.AllocateNode.getUncached().alloc(CStructs.PyNumberMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_absolute, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_ABSOLUTE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_add, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_ADD));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_and, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_AND));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_bool, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_BOOL));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_divmod, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_DIVMOD));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_float, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_FLOAT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_floor_divide, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_FLOOR_DIVIDE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_index, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INDEX));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_add, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_ADD));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_and, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_AND));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_floor_divide, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_FLOOR_DIVIDE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_lshift, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_LSHIFT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_matrix_multiply, nullValue);
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_multiply, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_MULTIPLY));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_or, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_OR));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_power, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_POWER));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_remainder, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_REMAINDER));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_rshift, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_RSHIFT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_subtract, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_SUBTRACT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_true_divide, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_TRUE_DIVIDE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_inplace_xor, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INPLACE_XOR));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_int, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_invert, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_INVERT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_lshift, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_LSHIFT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_matrix_multiply, nullValue);
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_multiply, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_MULTIPLY));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_negative, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_NEGATIVE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_or, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_OR));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_positive, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_POSITIVE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_power, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_POWER));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_remainder, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_REMAINDER));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_reserved, nullValue);
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_rshift, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_RSHIFT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_subtract, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_SUBTRACT));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_true_divide, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_TRUE_DIVIDE));
        writePointerNode.write(mem, CFields.PyNumberMethods__nb_xor, ToNativeTypeNode.getValue(obj, SlotMethodDef.NB_XOR));
        return mem;
    }

    private static Object allocatePySequenceMethods(PythonManagedClass obj, Object nullValue) {
        Object mem = CStructAccess.AllocateNode.getUncached().alloc(CStructs.PyNumberMethods);
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_length, ToNativeTypeNode.getValue(obj, SlotMethodDef.SQ_LENGTH));
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_concat, ToNativeTypeNode.getValue(obj, SlotMethodDef.SQ_CONCAT));
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_repeat, ToNativeTypeNode.getValue(obj, SlotMethodDef.SQ_REPEAT));
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_item, ToNativeTypeNode.getValue(obj, SlotMethodDef.SQ_ITEM));
        writePointerNode.write(mem, CFields.PySequenceMethods__was_sq_slice, nullValue);
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_ass_item, nullValue);
        writePointerNode.write(mem, CFields.PySequenceMethods__was_sq_ass_slice, nullValue);
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_contains, nullValue);
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_inplace_concat, nullValue);
        writePointerNode.write(mem, CFields.PySequenceMethods__sq_inplace_repeat, nullValue);
        return mem;
    }

    private static Object lookup(PythonManagedClass clazz, CFields member, HiddenKey hiddenName) {
        Object result = CExtNodesFactory.LookupNativeMemberInMRONodeGen.getUncached().execute(clazz, member, hiddenName);
        if (result == PNone.NO_VALUE) {
            return PythonContext.get(null).getNativeNull().getPtr();
        }
        return result;
    }

    private static long lookupSize(PythonManagedClass clazz, CFields member, HiddenKey hiddenName) {
        return CExtNodesFactory.LookupNativeI64MemberInMRONodeGen.getUncached().execute(clazz, member, hiddenName);
    }

    private static Object lookup(PythonManagedClass obj, SlotMethodDef slot) {
        return LookupNativeSlotNode.executeUncached(obj, slot);
    }

    private static boolean hasSlot(PythonManagedClass clazz, SlotMethodDef slot) {
        return LookupNativeSlotNode.executeUncached(clazz, slot) != PythonContext.get(null).getNativeNull().getPtr();
    }

    static void initializeType(PythonClassNativeWrapper obj, Object mem) {
        HashingStorage dictStorage;
        PDict dict;
        long weaklistoffset;
        CompilerAsserts.neverPartOfCompilation();
        PythonManagedClass clazz = (PythonManagedClass)obj.getDelegate();
        boolean isType = BuiltinClassProfiles.IsBuiltinClassExactProfile.profileClassSlowPath(clazz, PythonBuiltinClassType.PythonClass);
        CApiTransitions.PythonToNativeNode toNative = CApiTransitionsFactory.PythonToNativeNodeGen.getUncached();
        CApiTransitions.PythonToNativeNewRefNode toNativeNewRef = CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached();
        CStructAccess.WritePointerNode writePtrNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        CStructAccess.WriteLongNode writeI64Node = CStructAccessFactory.WriteLongNodeGen.getUncached();
        CStructAccess.WriteIntNode writeI32Node = CStructAccessFactory.WriteIntNodeGen.getUncached();
        TypeNodes.GetTypeFlagsNode getTypeFlagsNode = TypeNodesFactory.GetTypeFlagsNodeGen.getUncached();
        PythonContext ctx = PythonContext.get(null);
        PythonObjectSlowPathFactory factory = ctx.factory();
        Object nullValue = ctx.getNativeNull().getPtr();
        writeI64Node.write(mem, CFields.PyObject__ob_refcnt, 0x3FFFFFFFFFFFFFFFL);
        if (isType) {
            writePtrNode.write(mem, CFields.PyObject__ob_type, mem);
        } else {
            writePtrNode.write(mem, CFields.PyObject__ob_type, toNative.execute(GetClassNode.executeUncached(clazz)));
        }
        Object base = TypeNodes.GetBaseClassNode.executeUncached(clazz);
        if (base == null) {
            base = ctx.getNativeNull();
        } else if (base instanceof PythonBuiltinClassType) {
            PythonBuiltinClassType builtinClass = (PythonBuiltinClassType)((Object)base);
            base = ctx.lookupType(builtinClass);
        }
        writeI64Node.write(mem, CFields.PyVarObject__ob_size, 0L);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_name, clazz.getClassNativeWrapper().getNameWrapper());
        writeI64Node.write(mem, CFields.PyTypeObject__tp_basicsize, TypeNodes.GetBasicSizeNode.executeUncached(clazz));
        writeI64Node.write(mem, CFields.PyTypeObject__tp_itemsize, TypeNodes.GetItemSizeNode.executeUncached(clazz));
        if (clazz instanceof PythonBuiltinClass) {
            PythonBuiltinClass builtin = (PythonBuiltinClass)clazz;
            weaklistoffset = builtin.getType().getWeaklistoffset();
        } else {
            weaklistoffset = CExtNodesFactory.LookupNativeI64MemberInMRONodeGen.getUncached().execute(clazz, CFields.PyTypeObject__tp_weaklistoffset, SpecialAttributeNames.T___WEAKLISTOFFSET__);
        }
        writeI64Node.write(mem, CFields.PyTypeObject__tp_weaklistoffset, weaklistoffset);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_dealloc, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_dealloc, TypeBuiltins.TYPE_DEALLOC));
        writeI64Node.write(mem, CFields.PyTypeObject__tp_vectorcall_offset, ToNativeTypeNode.lookupSize(clazz, CFields.PyTypeObject__tp_vectorcall_offset, TypeBuiltins.TYPE_VECTORCALL_OFFSET));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_getattr, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_setattr, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_async, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_repr, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_REPR));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_number, BuiltinClassProfiles.IsBuiltinClassExactProfile.profileClassSlowPath(clazz, PythonBuiltinClassType.PythonObject) ? nullValue : ToNativeTypeNode.allocatePyNumberMethods(clazz, nullValue));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_sequence, ToNativeTypeNode.hasSlot(clazz, SlotMethodDef.SQ_LENGTH) ? ToNativeTypeNode.allocatePySequenceMethods(clazz, nullValue) : nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_mapping, ToNativeTypeNode.hasSlot(clazz, SlotMethodDef.MP_LENGTH) ? ToNativeTypeNode.allocatePyMappingMethods(clazz) : nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_hash, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_HASH));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_call, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_CALL));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_str, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_STR));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_getattro, LookupNativeSlotNodeGen.LookupNativeGetattroSlotNodeGen.getUncached().execute(clazz));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_setattro, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_SETATTRO));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_as_buffer, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_as_buffer, TypeBuiltins.TYPE_AS_BUFFER));
        writeI64Node.write(mem, CFields.PyTypeObject__tp_flags, getTypeFlagsNode.execute(clazz));
        Object docObj = clazz.getAttribute(SpecialAttributeNames.T___DOC__);
        try {
            docObj = new CArrayWrappers.CStringWrapper(CastToTruffleStringNode.executeUncached(docObj));
        }
        catch (CannotCastException e) {
            docObj = ctx.getNativeNull().getPtr();
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_doc, docObj);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_traverse, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_richcompare, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_RICHCOMPARE));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_iter, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_ITER));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_iternext, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_ITERNEXT));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_methods, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_members, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_getset, nullValue);
        if (!isType) {
            writePtrNode.write(mem, CFields.PyTypeObject__tp_base, toNative.execute(base));
        }
        if (!((dict = GetOrCreateDictNode.executeUncached(clazz)) instanceof StgDictObject) && !((dictStorage = dict.getDictStorage()) instanceof DynamicObjectStorage)) {
            DynamicObjectStorage storage = new DynamicObjectStorage(clazz.getStorage());
            dict.setDictStorage(storage);
            if (dictStorage != null) {
                HashingStorageNodes.HashingStorageAddAllToOther.executeUncached(dictStorage, dict);
            }
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_dict, toNative.execute(dict));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_descr_get, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_DESCR_GET));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_descr_set, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_DESCR_SET));
        writeI64Node.write(mem, CFields.PyTypeObject__tp_dictoffset, TypeNodesFactory.GetDictOffsetNodeGen.getUncached().execute(null, clazz));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_init, ToNativeTypeNode.lookup(clazz, SlotMethodDef.TP_INIT));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_alloc, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_alloc, TypeBuiltins.TYPE_ALLOC));
        Object newFunction = LookupCallableSlotInMRONode.getUncached(SpecialMethodSlot.New).execute(clazz);
        if (newFunction instanceof PDecoratedMethod) {
            newFunction = ((PDecoratedMethod)newFunction).getCallable();
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_new, ManagedMethodWrappers.createKeywords(newFunction));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_free, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_free, TypeBuiltins.TYPE_FREE));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_clear, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_clear, TypeBuiltins.TYPE_CLEAR));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_is_gc, nullValue);
        if (clazz.basesTuple == null) {
            clazz.basesTuple = factory.createTuple(TypeNodes.GetBaseClassesNode.executeUncached(clazz));
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_bases, toNative.execute(clazz.basesTuple));
        if (clazz.mroStore == null) {
            clazz.mroStore = factory.createTuple(TypeNodes.GetMroStorageNode.executeUncached(clazz));
        }
        writePtrNode.write(mem, CFields.PyTypeObject__tp_mro, toNative.execute(clazz.mroStore));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_cache, nullValue);
        PDict subclasses = TypeNodes.GetSubclassesNode.executeUncached(clazz);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_subclasses, toNativeNewRef.execute(subclasses));
        writePtrNode.write(mem, CFields.PyTypeObject__tp_weaklist, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_del, ToNativeTypeNode.lookup(clazz, CFields.PyTypeObject__tp_del, TypeBuiltins.TYPE_DEL));
        writeI32Node.write(mem, CFields.PyTypeObject__tp_version_tag, 0);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_finalize, nullValue);
        writePtrNode.write(mem, CFields.PyTypeObject__tp_vectorcall, nullValue);
    }
}

