/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
public final class PyMemoryViewWrapper
extends PythonNativeWrapper.PythonAbstractObjectNativeWrapper {
    private Object replacement;

    public PyMemoryViewWrapper(PythonObject delegate) {
        super(delegate, true);
        assert (delegate instanceof PMemoryView);
    }

    private static Object intArrayToNativePySSizeArray(int[] intArray) {
        Object mem = CStructAccess.AllocateNode.getUncached().alloc(intArray.length * 8);
        CStructAccess.WriteLongNode.getUncached().writeIntArray(mem, intArray);
        return mem;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object allocate(PMemoryView object) {
        Object buf;
        if (object.isReleased()) {
            throw PRaiseNode.raiseUncached(null, PythonBuiltinClassType.ValueError, ErrorMessages.MEMORYVIEW_FORBIDDEN_RELEASED);
        }
        CStructAccess.GetElementPtrNode getElementNode = CStructAccess.GetElementPtrNode.getUncached();
        CStructAccess.WritePointerNode writePointerNode = CStructAccess.WritePointerNode.getUncached();
        CStructAccess.WriteLongNode writeI64Node = CStructAccess.WriteLongNode.getUncached();
        CStructAccess.WriteIntNode writeI32Node = CStructAccess.WriteIntNode.getUncached();
        CExtNodes.AsCharPointerNode asCharPointerNode = CExtNodes.AsCharPointerNode.getUncached();
        Object mem = CStructAccess.AllocateNode.getUncached().alloc(CStructs.PyMemoryViewObject);
        writeI64Node.write(mem, CFields.PyObject__ob_refcnt, 0x3FFFFFFFFFFFFFFFL);
        writePointerNode.write(mem, CFields.PyObject__ob_type, CApiTransitions.PythonToNativeNewRefNode.executeUncached(GetClassNode.executeUncached(object)));
        writeI32Node.write(mem, CFields.PyMemoryViewObject__flags, object.getFlags());
        writeI64Node.write(mem, CFields.PyMemoryViewObject__exports, object.getExports().get());
        Object view = getElementNode.getElementPtr(mem, CFields.PyMemoryViewObject__view);
        if (object.getBufferPointer() == null) {
            NativeSequenceStorage nativeStorage;
            Object object2 = object.getOwner();
            if (object2 instanceof PSequence) {
                PSequence owner = (PSequence)object2;
                nativeStorage = PySequenceArrayWrapper.ToNativeStorageNode.executeUncached(SequenceNodes.GetSequenceStorageNode.executeUncached(owner), owner instanceof PBytesLike);
                SequenceNodes.SetSequenceStorageNode.executeUncached(owner, nativeStorage);
            } else {
                object2 = object.getOwner();
                if (object2 instanceof PArray) {
                    PArray owner = (PArray)object2;
                    nativeStorage = PySequenceArrayWrapper.ToNativeStorageNode.executeUncached(owner.getSequenceStorage(), true);
                    owner.setSequenceStorage(nativeStorage);
                } else {
                    throw CompilerDirectives.shouldNotReachHere((String)"Cannot convert managed object to native storage");
                }
            }
            Object pointer = nativeStorage.getPtr();
            buf = object.getOffset() == 0 ? pointer : CExtNodes.pointerAdd(pointer, object.getOffset());
        } else {
            buf = object.getOffset() == 0 ? object.getBufferPointer() : CExtNodes.pointerAdd(object.getBufferPointer(), object.getOffset());
        }
        writePointerNode.write(view, CFields.Py_buffer__buf, buf);
        if (object.getOwner() != null) {
            writePointerNode.write(view, CFields.Py_buffer__obj, CApiTransitions.PythonToNativeNewRefNode.executeUncached(object.getOwner()));
        }
        writeI64Node.write(view, CFields.Py_buffer__len, object.getLength());
        writeI64Node.write(view, CFields.Py_buffer__itemsize, object.getItemSize());
        writeI32Node.write(view, CFields.Py_buffer__readonly, PInt.intValue(object.isReadOnly()));
        writeI32Node.write(view, CFields.Py_buffer__ndim, object.getDimensions());
        if (object.getFormatString() != null) {
            writePointerNode.write(view, CFields.Py_buffer__format, asCharPointerNode.execute(object.getFormatString()));
        }
        if (object.getBufferShape() != null) {
            writePointerNode.write(view, CFields.Py_buffer__shape, PyMemoryViewWrapper.intArrayToNativePySSizeArray(object.getBufferShape()));
        }
        if (object.getBufferStrides() != null) {
            writePointerNode.write(view, CFields.Py_buffer__strides, PyMemoryViewWrapper.intArrayToNativePySSizeArray(object.getBufferStrides()));
        }
        if (object.getBufferSuboffsets() != null) {
            writePointerNode.write(view, CFields.Py_buffer__suboffsets, PyMemoryViewWrapper.intArrayToNativePySSizeArray(object.getBufferSuboffsets()));
        }
        return mem;
    }

    @Override
    public Object getReplacement(InteropLibrary lib) {
        if (this.replacement == null) {
            Object pointerObject = PyMemoryViewWrapper.allocate((PMemoryView)this.getDelegate());
            this.replacement = this.registerReplacement(pointerObject, lib);
        }
        return this.replacement;
    }

    @ExportMessage
    boolean isPointer() {
        return this.isNative();
    }

    @ExportMessage
    long asPointer() throws UnsupportedMessageException {
        if (!this.isNative()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedMessageException.create();
        }
        return this.getNativePointer();
    }

    @ExportMessage
    void toNative() {
        if (!this.isNative()) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

