/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.array;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.common.BufferStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

public abstract class ArrayNodes {

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class EnsureNativeStorageNode
    extends Node {
        public abstract NativeByteSequenceStorage execute(Node var1, PArray var2);

        @Specialization
        NativeByteSequenceStorage toNative(PArray array, @Cached(inline=false) SequenceStorageNodes.StorageToNativeNode storageToNativeNode) {
            SequenceStorage sequenceStorage = array.getSequenceStorage();
            if (sequenceStorage instanceof NativeByteSequenceStorage) {
                NativeByteSequenceStorage storage = (NativeByteSequenceStorage)sequenceStorage;
                return storage;
            }
            sequenceStorage = array.getSequenceStorage();
            if (sequenceStorage instanceof ByteSequenceStorage) {
                ByteSequenceStorage storage = (ByteSequenceStorage)sequenceStorage;
                NativeByteSequenceStorage nativeStorage = (NativeByteSequenceStorage)storageToNativeNode.execute(storage.getInternalByteArray(), storage.length());
                array.setSequenceStorage(nativeStorage);
                return nativeStorage;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid storage for PArray");
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ShiftNode
    extends Node {
        public abstract void execute(Node var1, PArray var2, int var3, int var4);

        @Specialization
        static void shift(Node inliningTarget, PArray array, int from, int by, @Cached EnsureCapacityNode ensureCapacityNode, @Cached SetLengthNode setLengthNode, @Cached SequenceStorageNodes.MemMoveNode memMoveNode) {
            try {
                int newLength = PythonUtils.addExact(array.getLength(), by);
                ensureCapacityNode.execute(inliningTarget, array, newLength);
                int itemShift = array.getItemSizeShift();
                int internalFrom = from << itemShift;
                int internalBy = by << itemShift;
                int internalLength = array.getSequenceStorage().length();
                memMoveNode.execute(inliningTarget, array.getSequenceStorage(), internalFrom + internalBy, internalFrom, internalLength - internalFrom);
                setLengthNode.execute(inliningTarget, array, newLength);
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class DeleteArraySliceNode
    extends Node {
        public abstract void execute(Node var1, PArray var2, int var3, int var4);

        @Specialization
        static void del(Node inliningTarget, PArray array, int from, int length, @Cached SequenceStorageNodes.DeleteSliceNode deleteSliceNode) {
            assert (from + length <= array.getLength());
            PSlice.SliceInfo info = new PSlice.SliceInfo(from << array.getItemSizeShift(), from + length << array.getItemSizeShift(), 1);
            deleteSliceNode.execute(inliningTarget, array.getSequenceStorage(), info);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class SetLengthNode
    extends Node {
        public abstract void execute(Node var1, PArray var2, int var3);

        @Specialization
        static void set(Node inliningTarget, PArray array, int newLength, @Cached SequenceStorageNodes.SetLenNode setLenNode) {
            try {
                int internalLength = PythonUtils.multiplyExact(newLength, array.getItemSize());
                setLenNode.execute(inliningTarget, array.getSequenceStorage(), internalLength);
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class EnsureCapacityNode
    extends Node {
        public abstract void execute(Node var1, PArray var2, int var3);

        @Specialization
        static void ensure(Node inliningTarget, PArray array, int newCapacity, @Cached SequenceStorageNodes.EnsureCapacityNode ensureCapacityNode, @Cached InlinedBranchProfile updateProfile) {
            try {
                int internalCapacity = PythonUtils.multiplyExact(newCapacity, array.getItemSize());
                SequenceStorage newStorage = ensureCapacityNode.execute(inliningTarget, array.getSequenceStorage(), internalCapacity);
                if (array.getSequenceStorage() != newStorage) {
                    updateProfile.enter(inliningTarget);
                    array.setSequenceStorage(newStorage);
                }
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @GenerateInline
    @GenerateUncached(value=false)
    @GenerateCached(value=false)
    public static abstract class CheckValueNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, PArray var3, Object var4);

        @Specialization
        static void check(VirtualFrame frame, Node inliningTarget, PArray array, Object value, @Cached BufferStorageNodes.PackValueNode packValueNode) {
            packValueNode.execute(frame, inliningTarget, array.getFormat(), value, new ByteSequenceStorage(new byte[8]), 0);
        }
    }

    @GenerateInline
    @GenerateUncached(value=false)
    @GenerateCached(value=false)
    public static abstract class PutValueNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, PArray var3, int var4, Object var5);

        @Specialization
        static void put(VirtualFrame frame, Node inliningTarget, PArray array, int index, Object value, @Cached BufferStorageNodes.PackValueNode packValueNode) {
            packValueNode.execute(frame, inliningTarget, array.getFormat(), value, array.getBuffer(), index << array.getItemSizeShift());
        }
    }

    @GenerateInline
    @GenerateUncached(value=false)
    @GenerateCached(value=false)
    public static abstract class GetValueNode
    extends Node {
        public abstract Object execute(Node var1, PArray var2, int var3);

        @Specialization
        static Object get(Node inliningTarget, PArray array, int index, @Cached BufferStorageNodes.UnpackValueNode unpackValueNode) {
            return unpackValueNode.execute(inliningTarget, array.getFormat(), array.getBuffer(), index << array.getItemSizeShift());
        }
    }
}

