/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.NoneBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.GetSetDescriptor;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PNone})
public final class NoneBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return NoneBuiltinsFactory.getFactories();
    }

    @Builtin(name="__getattribute__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GetAttributeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, Object object, Object keyObj, @Bind(value="this") Node inliningTarget, @Cached LookupAttributeInMRONode.Dynamic lookup, @Cached CallUnaryMethodNode callGet, @Cached CastToTruffleStringNode castKeyToStringNode, @Cached PythonObjectFactory.Lazy factory, @Cached ObjectBuiltins.GetAttributeNode getAttributeNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString key;
            assert (object == PNone.NONE);
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObj);
            }
            catch (CannotCastException e) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObj);
            }
            Object descr = lookup.execute((Object)PythonBuiltinClassType.PNone, key);
            if (descr == PNone.NO_VALUE) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, PNone.NONE, key);
            }
            if (descr instanceof GetSetDescriptor) {
                GetSetDescriptor getSetDescriptor = (GetSetDescriptor)descr;
                assert (getSetDescriptor.getGet() != null);
                return callGet.executeObject((Frame)frame, getSetDescriptor.getGet(), PNone.NONE);
            }
            if (descr instanceof PBuiltinFunction) {
                PBuiltinFunction function = (PBuiltinFunction)descr;
                assert (!function.needsDeclaringType());
                return factory.get(inliningTarget).createBuiltinMethod((Object)PNone.NONE, function);
            }
            return getAttributeNode.execute(frame, PNone.NONE, key);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static Object doNone(PNone none) {
            assert (none == PNone.NONE);
            return StringLiterals.T_NONE;
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BoolNode
    extends PythonUnaryBuiltinNode {
        BoolNode() {
        }

        @Specialization
        static boolean doNone(PNone none) {
            assert (none == PNone.NONE);
            return false;
        }
    }
}

