/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cjkcodecs;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecObject;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecState;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteCodecUtil;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteDecodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteEncodeBuffer;
import com.oracle.graal.python.builtins.modules.cjkcodecs.MultibyteStreamWriterBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.MultibyteCodec})
public final class MultibyteCodecBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return MultibyteStreamWriterBuiltinsFactory.getFactories();
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"$self", "input", "errors"}, doc="decode($self, /, input, errors=None)\n--\n\nDecodes 'input'.\n\n'errors' may be given to set a different error handling scheme. Default is\n'strict' meaning that encoding errors raise a UnicodeDecodeError. Other possible\nvalues are 'ignore' and 'replace' as well as any other name registered with\ncodecs.register_error that is able to handle UnicodeDecodeErrors.\"")
    @ArgumentsClinic(value={@ArgumentClinic(name="input", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class DecodeNode
    extends PythonTernaryClinicBuiltinNode {
        DecodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteCodecBuiltinsClinicProviders.DecodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object decode(VirtualFrame frame, MultibyteCodecObject self, byte[] input, TruffleString errors, @Cached MultibyteCodecUtil.DecodeErrorNode decodeErrorNode, @Cached TruffleString.EqualNode isEqual, @Cached PythonObjectFactory factory) {
            int r;
            int datalen = input.length;
            TruffleString errorcb = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            if (datalen == 0) {
                return factory.createTuple(new Object[]{StringLiterals.T_EMPTY_STRING, 0});
            }
            MultibyteDecodeBuffer buf = new MultibyteDecodeBuffer(input);
            MultibyteCodecState state = self.codec.decinit(errorcb);
            while (!buf.isFull() && (r = self.codec.decode(state, buf, this)) != 0) {
                decodeErrorNode.execute(frame, self.codec, buf, errorcb, r);
            }
            return factory.createTuple(new Object[]{buf.toTString(), datalen});
        }
    }

    @Builtin(name="encode", minNumOfPositionalArgs=1, parameterNames={"$self", "errors"}, doc="encode($self, /, input, errors=None)\n--\n\nReturn an encoded string version of `input'.\n\n'errors' may be given to set a different error handling scheme. Default is\n'strict' meaning that encoding errors raise a UnicodeEncodeError. Other possible\nvalues are 'ignore', 'replace' and 'xmlcharrefreplace' as well as any other name\nregistered with codecs.register_error that can handle UnicodeEncodeErrors.")
    @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class EncodeNode
    extends PythonTernaryClinicBuiltinNode {
        EncodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return MultibyteCodecBuiltinsClinicProviders.EncodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object ts(VirtualFrame frame, MultibyteCodecObject self, TruffleString ucvt, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached MultibyteCodecUtil.EncodeNode encodeNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.EqualNode isEqual, @Cached.Shared @Cached PythonObjectFactory factory) {
            TruffleString errorcb = MultibyteCodecUtil.internalErrorCallback(errors, isEqual);
            MultibyteCodecState state = self.codec.encinit(errorcb);
            int datalen = codePointLengthNode.execute((AbstractTruffleString)ucvt, PythonUtils.TS_ENCODING);
            PBytes r = MultibyteCodecUtil.encodeEmptyInput(datalen, 3, factory);
            if (r == null) {
                MultibyteEncodeBuffer buf = new MultibyteEncodeBuffer(ucvt);
                r = encodeNode.execute(frame, inliningTarget, self.codec, state, buf, errorcb, 3, factory);
            }
            return factory.createTuple(new Object[]{r, datalen});
        }

        @Specialization(guards={"!isTruffleString(input)"})
        static Object notTS(VirtualFrame frame, MultibyteCodecObject self, Object input, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeCheckNode unicodeCheck, @Cached PyObjectStrAsObjectNode strNode, @Cached CastToTruffleStringNode toTruffleStringNode, @Cached.Exclusive @Cached MultibyteCodecUtil.EncodeNode encodeNode, @Cached.Shared @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached TruffleString.EqualNode isEqual, @Cached.Shared @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object ucvt = input;
            if (!unicodeCheck.execute(inliningTarget, input) && !unicodeCheck.execute(inliningTarget, ucvt = strNode.execute((Frame)frame, inliningTarget, input))) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.COULDN_T_CONVERT_THE_OBJECT_TO_UNICODE);
            }
            TruffleString str = toTruffleStringNode.execute(inliningTarget, ucvt);
            return EncodeNode.ts(frame, self, str, errors, inliningTarget, encodeNode, codePointLengthNode, isEqual, factory);
        }
    }
}

