/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.Arrays;

public final class PythonCextListBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_Reverse
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_Reverse() {
        }

        @Specialization
        static int reverse(PList self, @Cached ListBuiltins.ListReverseNode reverseNode) {
            reverseNode.execute(null, self);
            return 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyList_SET_ITEM
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        _PyList_SET_ITEM() {
        }

        @Specialization
        static int doManaged(PList list, long index, Object element, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.ListGeneralizationNode generalizationNode, @Cached SequenceStorageNodes.InitializeItemScalarNode setItemNode, @Cached InlinedConditionProfile generalizedProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage sequenceStorage = list.getSequenceStorage();
            _PyList_SET_ITEM.checkBounds(inliningTarget, sequenceStorage, index, raiseNode);
            SequenceStorage newStorage = generalizationNode.execute(inliningTarget, sequenceStorage, element);
            setItemNode.execute(inliningTarget, newStorage, (int)index, element);
            if (generalizedProfile.profile(inliningTarget, list.getSequenceStorage() != newStorage)) {
                list.setSequenceStorage(newStorage);
            }
            return 0;
        }

        @Specialization
        static int doNative(PythonAbstractNativeObject list, long index, Object element, @Bind(value="this") Node inliningTarget, @Cached ListNodes.GetNativeListStorage asNativeStorage, @Cached SequenceStorageNodes.InitializeNativeItemScalarNode setItemNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            NativeSequenceStorage sequenceStorage = asNativeStorage.execute(list);
            _PyList_SET_ITEM.checkBounds(inliningTarget, sequenceStorage, index, raiseNode);
            setItemNode.execute(sequenceStorage, (int)index, element);
            return 0;
        }

        @Fallback
        Object fallback(Object list, Object index, Object element) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }

        private static void checkBounds(Node inliningTarget, SequenceStorage sequenceStorage, long index, PRaiseNode.Lazy raiseNode) {
            if (index < 0L || index >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.INDEX_OUT_OF_BOUNDS);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObjectTransfer}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_SetItem
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyList_SetItem() {
        }

        @Specialization
        int doManaged(PList list, Object position, Object element, @Bind(value="this") Node inliningTarget, @Cached(value="createForList()") SequenceStorageNodes.SetItemNode setItemNode, @Cached InlinedConditionProfile generalizedProfile) {
            SequenceStorage newStorage = setItemNode.execute(null, list.getSequenceStorage(), position, element);
            if (generalizedProfile.profile(inliningTarget, list.getSequenceStorage() != newStorage)) {
                list.setSequenceStorage(newStorage);
            }
            return 0;
        }

        @Fallback
        int fallback(Object list, Object i, Object item) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_Insert
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyList_Insert() {
        }

        @Specialization
        static int insert(PList list, Object i, Object item, @Cached ListBuiltins.ListInsertNode insertNode) {
            insertNode.execute(null, list, i, item);
            return 0;
        }

        @Fallback
        int fallback(Object list, Object i, Object item) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_Sort
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_Sort() {
        }

        @Specialization
        static int append(PList list, @Cached ListBuiltins.ListSortNode sortNode) {
            sortNode.execute(null, list);
            return 0;
        }

        @Fallback
        int fallback(Object list) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_Size() {
        }

        @Specialization
        static int size(PList list) {
            return list.getSequenceStorage().length();
        }

        @Fallback
        int fallback(Object list) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyListObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyList_Extend
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyList_Extend() {
        }

        @Specialization
        Object extend(PList list, Object iterable, @Cached ListBuiltins.ListExtendNode extendNode) {
            extendNode.execute(null, list, iterable);
            return PNone.NONE;
        }

        @Fallback
        Object fallback(Object list, Object iterable) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_SetSlice
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyList_SetSlice() {
        }

        @Specialization
        static int getSlice(PList list, Object iLow, Object iHigh, Object s, @Bind(value="this") Node inliningTarget, @Cached ListBuiltins.SetItemNode setItemNode, @Cached PySliceNew sliceNode) {
            setItemNode.execute(null, list, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE), s);
            return 0;
        }

        @Fallback
        int fallback(Object list, Object iLow, Object iHigh, Object s) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_GetSlice
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyList_GetSlice() {
        }

        @Specialization
        Object getSlice(PList list, Object iLow, Object iHigh, @Bind(value="this") Node inliningTarget, @Cached ListBuiltins.GetItemNode getItemNode, @Cached PySliceNew sliceNode) {
            return getItemNode.execute(null, list, sliceNode.execute(inliningTarget, iLow, iHigh, PNone.NONE));
        }

        @Fallback
        Object fallback(Object list, Object iLow, Object iHigh) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_AsTuple
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_AsTuple() {
        }

        @Specialization
        Object append(PList list, @Cached TupleNodes.ConstructTupleNode constructTupleNode) {
            return constructTupleNode.execute(null, list);
        }

        @Fallback
        Object fallback(Object list) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_Append
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyList_Append() {
        }

        @Specialization
        int append(PList list, Object newItem, @Cached ListNodes.AppendNode appendNode) {
            if (newItem == PNone.NO_VALUE) {
                throw this.badInternalCall("newitem");
            }
            appendNode.execute(list, newItem);
            return 0;
        }

        @Fallback
        int fallback(Object list, Object newItem) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_GetItem
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyList_GetItem() {
        }

        @Specialization
        static Object doPList(PList list, long key, @Bind(value="this") Node inliningTarget, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached SequenceStorageNodes.ListGeneralizationNode generalizationNode, @Cached SequenceStorageNodes.SetItemScalarNode setItemNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage sequenceStorage = list.getSequenceStorage();
            if (key < 0L || key >= (long)sequenceStorage.length()) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.LIST_INDEX_OUT_OF_RANGE);
            }
            Object result = getItemNode.execute(inliningTarget, sequenceStorage, (int)key);
            Object promotedValue = promoteNode.execute(inliningTarget, result);
            if (promotedValue != null) {
                sequenceStorage = generalizationNode.execute(inliningTarget, sequenceStorage, promotedValue);
                list.setSequenceStorage(sequenceStorage);
                setItemNode.execute(inliningTarget, sequenceStorage, (int)key, promotedValue);
                return promotedValue;
            }
            return result;
        }

        @Fallback
        Object fallback(Object list, Object pos) {
            throw this.raiseFallback(list, PythonBuiltinClassType.PList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyList_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyList_New() {
        }

        @Specialization(guards={"size < 0"})
        static Object newListError(long size, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, size);
        }

        @Specialization(guards={"size == 0"})
        static Object newEmptyList(long size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createList(PythonUtils.EMPTY_OBJECT_ARRAY);
        }

        @Specialization(guards={"size > 0"})
        static Object newList(long size, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createList(PyList_New.array(size));
        }

        private static Object[] array(long size) {
            Object[] a = new Object[(int)size];
            Arrays.fill(a, PNone.NO_VALUE);
            return a;
        }
    }
}

